<?php
class TopRatedSeller {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->reqSlug = $reqSlug;
		$this->pageNo = issetor($pageNo,1);
		$this->catSlug = issetor($catSlug);

	}
	public function getPageContent() {
		$sellerList = $this->getTopRatedSeller();

		$replaceArr = array('%USER_LIST%'=>$sellerList['data']['html'],'%USER_PAGINATION%'=>$sellerList['data']['pagination']);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}

	public function getTopRatedSeller(){
		$whrCondition = $content = "";
		$returnResponse = array();
		if($this->catSlug != ""){
			$whrCondition =  " AND c.slug = ?";
			$whrArr[] = $this->catSlug;
		}

		$qry = "SELECT AVG(r.rating) AS avgRating,r.userTo,u.userName,u.aboutMe,u.profileImage FROM tbl_reviews AS r INNER JOIN tbl_users AS u ON u.id = r.userTo WHERE u.isActive = 'y' GROUP BY u.id ORDER BY avgRating DESC";

		$whrArr[] = $this->reqSlug;
		$seller = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $seller->affectedRows();


		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$sellerQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $sellerQuery->affectedRows();
		if($NoOfrows > 0){
			$sellerList = $sellerQuery ->results();
			foreach ($sellerList as $key => $sellerValue) {
				$avgRating = $sellerValue['avgRating'];
				$userName = filtering($sellerValue['userName']);
				$aboutMe = filtering($sellerValue['aboutMe'],'text');
				$userId = $sellerValue['userTo'];
				$profileImage = checkImage($sellerValue['profileImage'],9,$userId);
				$serviceCount = $this->db->pdoQuery("SELECT * FROM tbl_services AS s WHERE userId = ? AND  s.status = 'a' AND s.isActive = 'y' ",array($userId))->affectedRows();
				if($this->sessRequestType == 'web'){

					$replace = array(
									 '%STAR_RATTING%'=>$avgRating,
									 '%TOTAL_SERVICES%'=>$serviceCount,
									 '%USER_IMAGE%'=>$profileImage,
									 '%USER_NAME%'=>$userName,
									 '%ABOUT_ME%'=>myTruncate($aboutMe,150),
									 '%PROFILE_URL%'=>SITE_URL,
									);
					$content .= get_view(DIR_TMPL . $this->module . "/single-top-rated-seller-nct.tpl.php",$replace);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}else{
					/*app data*/
				}
			}
		}else{
			$retData['html'] = $content;
			if($this->pageNo == 1){
				$retData['html'] =getNoRecordFoundContent();
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => false,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

}

?>
