<?php
class SellerRequestNotification {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->pageNo = issetor($pageNo,1);
		$this->catSlug = issetor($catSlug);

	}
	public function getPageContent() {
		$myRequestList = $this->getRequestNotificationList();
		$cateList = $this->getCategoryList();

		$replaceArr = array('%REQUEST_NOTIFICATION_LIST%'=>$myRequestList['data']['html'],'%REQUEST_NOTIFICATION_PAGINATION%'=>$myRequestList['data']['pagination'],
			'%CATEGORY_LIST%'=>$cateList);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}
	public function getCategoryList($catId = 0) {
		$cateHtml = "";
		$getCat =  $this->db->select("tbl_categories",array('*'),array('isActive'=>'y'));
		if($this->sessRequestType == 'web'){

			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$cateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);

		}
		if($getCat->affectedRows() > 0){
			$getCatResult = $getCat->results();
			foreach ($getCatResult as $key => $catData) {
				$id = $catData['id'];
				$cateName = filtering($catData['cateName_'.$this->lId]);
				$cateSlug = filtering($catData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$cateSlug,
							'%OPT_TEXT%'=>ucwords($cateName),
							'%EXTRA%'=>'',
							'%SELECTED%'=>($id == $catId) ? 'selected' : NULL,
						);
					$cateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}
			}
		}
		return $cateHtml;
	}
	public function getRequestNotificationList() {
		$whrCondition = $content = "";
		$returnResponse = array();
		if($this->catSlug != ""){
			$whrCondition =  " AND c.slug = ?";
			$whrArr[] = $this->catSlug;
		}

		$qry ="SELECT sr.id AS serviceRequestId, sr.description AS offerDesc,sr.deliveryDate,sr.requestStatusByCustomer,sr.offerAmount,sr.buyerPaid,r.*,u.profileImage,u.userName,c.cateName_".$this->lId." AS catName,sc.subCategoryName_".$this->lId." AS subCategoryName FROM tbl_seller_request_notification AS sr INNER JOIN tbl_request AS r ON sr.requestId = r.id INNER JOIN  tbl_users AS u ON u.id = r.userId INNER JOIN tbl_categories AS c ON c.id = r.catId INNER JOIN tbl_subcategories AS sc ON sc.id = r.subCatId WHERE  r.isActive = 'y' $whrCondition AND r.requStatus = 'a' AND sr.userId = ?  ORDER BY sr.createdDate DESC";
		$whrArr[] = $this->sessUserId;
		$request = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $request->affectedRows();


		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$requestQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $requestQuery->affectedRows();

		if($NoOfrows > 0){
			$requestList = $requestQuery ->results();

			foreach ($requestList as $key => $requestData) {
				$id = filtering($requestData['id']);
				$serviceRequestId = filtering($requestData['serviceRequestId']);
				$slug = filtering($requestData['slug']);
				$userId = filtering($requestData['userId']);
				$description = filtering($requestData['description']);
				$budget = $requestData['budget'];
				$userName = filtering($requestData['userName']);
				$profileImage = checkImage($requestData['profileImage'],9,$userId);
				$createdDate = convertDate($requestData['createdDate']);
				$durationType = ($requestData['durationType'] == 'h' ? HOURS : DAYS);
				$duration = $requestData['duration'].' '.$durationType;
				$requestDoc = $requestData['requestDoc'];
				$originalName = $requestData['originalName'];
				$attName = issetor($originalName,$requestDoc);
				$attHiddenClass = 'hidden';
				$attDownloadLink = 'javascript:void(0)';
				$requestStatusByCustomer = $requestData['requestStatusByCustomer'];
				$offerDesc = $requestData['offerDesc'];
				$deliveryDate = $requestData['deliveryDate'];
				$offerAmount = $requestData['offerAmount'];
				$buyerPaid = $requestData['buyerPaid'];

				$catName = ucwords(filtering($requestData['catName']));
				$subCategoryName = ucwords(filtering($requestData['subCategoryName']));

				$totalAccepted = $this->db->pdoQuery("SELECT id FROM tbl_seller_request_notification WHERE requestStatusByCustomer = 'a' AND requestId = ? ",array($id))->affectedRows();
				if(is_file(DIR_UPD.'request/'.$id.'/'.$requestDoc)){
					$attHiddenClass = '';
					$attDownloadLink = SITE_URL.'download/request-attachment/'.base64_encode($id).'/';
				}


				if($this->sessRequestType == 'web'){

					$offerData = "";
					/*echo $serviceRequestId.'--'.$requestStatusByCustomer.'--'.$offerAmount.'--<BR>';*/
					if($requestStatusByCustomer != 'n' && $offerAmount > 0){
						$status = ucwords(PENDING);
						$statusClass = '';
						if($requestStatusByCustomer == 'r'){
							$status = ucwords(REJECTED);
							$statusClass = 'danger-label';
						}else if($totalAccepted > 0 && $requestStatusByCustomer == 'a' && $buyerPaid != 'y'){
							$status = ucwords(ACCEPTED);
						}else if($totalAccepted > 0 && $requestStatusByCustomer == 'r'){
							$status = ucwords(REJECTED);
							$statusClass = 'danger-label';
						}else if($requestStatusByCustomer == 'a' && $buyerPaid == 'y'){
							$status = ucwords(HIRED);
							$statusClass = 'btn_hired';
							/*$adminCommission = getTableValue('tbl_payment_history','adminCommission',array('entityId'=>$id,'txnTypeId'=>4,'userId'=>$userId));
							if($adminCommission > 0){
								$offerAmount = $offerAmount - $adminCommission;
							}*/
						}
						/*multi currency change*/
			            $offerAmount = exchange($offerAmount,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceRequestId,'o');
			            /*multi currency change*/
						$arrReplce = array(
											'%OFFER_DESC%'=>$offerDesc,
											'%OFFER_DELIVERY_DATE%'=>convertDate($deliveryDate),
											'%OFFER_BUDGET%'=>CURRENCY_SIGN.$offerAmount,
											'%OFFER_STATUS%'=> $status,
											'%EXTRA_STATUS_CLASS%'=>$statusClass
										);
						$offerData = get_view(DIR_TMPL . $this->module . "/after-sent-offer-nct.tpl.php",$arrReplce);

					}else if($totalAccepted == 0){
						$offerData = get_view(DIR_TMPL . $this->module . "/before-sent-offer-nct.tpl.php");
					}
					$totalOffer = $this->db->pdoQuery("SELECT so.* FROM tbl_seller_request_notification AS so INNER JOIN tbl_users AS u ON u.id = so.userId WHERE so.requestStatusByCustomer != 'n' AND u.isActive = 'y' AND so.requestId = ?",array($id))->affectedRows();


					/*multi currency change*/
		            $budget = exchange($budget,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'r');
		            /*multi currency change*/
		            $viewReviewHideShow = 'hide';
		            $reviewModalContent = "";
	       			$checkReview = $this->db->pdoQuery("SELECT r.id,r.orderId,r.userFrom,r.userTo,r.review,r.rating,r.createdDate,uf.slug AS userFromslug,uf.userName AS userFromName,uf.profileImage As userFromprofileImage FROM tbl_reviews AS r INNER JOIN tbl_orders AS o ON o.id = r.orderId INNER JOIN tbl_users AS uf ON uf.id = r.userFrom WHERE o.entityId = ? AND o.orderType = 'r' AND r.userTo = ? AND r.isActive = 'y' ",array($id,$this->sessUserId));
	       			$checkReviewAff = $checkReview->affectedRows();
	       			if($checkReviewAff > 0){
	       				$viewReviewHideShow = '';
	       				$reviewResult = $checkReview->result();
	       				$id = $reviewResult['id'];
						$userFromName = filtering(ucwords($reviewResult['userFromName']));
						$userFromslug = filtering($reviewResult['userFromslug']);
						$review = filtering($reviewResult['review'],'output','text');
						$rating = filtering($reviewResult['rating'],'output','float');
						$userFromprofileImage = checkImage($reviewResult['userFromprofileImage'],9,$reviewResult['userFrom']);
		            	$replaceReviewRatingArr = array(
							'%FROM_USER_URL%'=>SITE_URL.'profile/'.$userFromslug,
							'%FROM_USER_NAME%'=>$userFromName,
							'%FROM_USER_IMG%'=>$userFromprofileImage,
							'%RATING%'=>$rating,
							'%REQ_SLUG%' => $slug,
							'%REVIEW%'=>$review,
						);
						$reviewModalContent= get_view(DIR_TMPL . $this->module . "/show-review-modal-nct.tpl.php",$replaceReviewRatingArr);

	       			}

					$replaceArr = array(
							'%USER_PROFILE_PHOTO%' => $profileImage,
							'%USER_NAME%' => $userName,
							'%REQUEST_CREATED_DATE%' => $createdDate,
							'%REQUEST_DESC%' => $description,
							'%ATT_HIDDEN_CLASS%' => $attHiddenClass,
							'%ATTACHMENT_DOWNLOAD_LINK%' => $attDownloadLink,
							'%ATTACH_FILE_NAME%' => $attName,
							'%REQUEST_BUDGET%' => CURRENCY_SIGN.$budget,
							'%DURATION%' => $duration,
							'%TOTAL_OFFER%' => $totalOffer,
							'%REQ_SLUG%' => $slug,
							'%OFFER_DATA%' => $offerData,
							'%CATE_NAME%' => $catName,
							'%SUB_CATE_NAME%' => $subCategoryName,
							'%VIEW_REVIEW_HIDE_SHOW%'=>$viewReviewHideShow,
							'%REVIEW_MODAL%'=>$reviewModalContent
						);
					$content .= get_view(DIR_TMPL . $this->module . "/single-request-nct.tpl.php",$replaceArr);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}
			}
		}else{
			$retData['html'] = $content;
			if($this->pageNo == 1){
				$retData['html'] =getNoRecordFoundContent();
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	public function checkOfferStatus($request = array()) {
		extract($request);
		$list = $this->db->pdoQuery("SELECT sr.id AS serviceRequestId,sr.description AS offerDesc,sr.deliveryDate,sr.requestStatusByCustomer,sr.offerAmount,r.*,u.profileImage,u.userName  FROM tbl_seller_request_notification AS sr INNER JOIN tbl_request AS r ON sr.requestId = r.id INNER JOIN  tbl_users AS u ON u.id = r.userId INNER JOIN tbl_categories AS c ON c.id = r.catId WHERE  r.isActive = 'y' AND r.requStatus = 'a' AND sr.userId = ? AND r.slug = ?  ORDER BY sr.createdDate DESC",array($this->sessUserId,$reqSlug));
		if($list->affectedRows() > 0){
			$offerData = $list->result();

			$requestStatusByCustomer = filtering($offerData['requestStatusByCustomer']);
			$id = filtering($offerData['id']);
			$serviceRequestId = filtering($offerData['serviceRequestId']);

			$offerDesc = filtering($offerData['offerDesc']);
			$deliveryDate = filtering($offerData['deliveryDate']);
			$offerAmount = filtering($offerData['offerAmount']);
			$totalAccepted = $this->db->pdoQuery("SELECT id FROM tbl_seller_request_notification WHERE requestStatusByCustomer = 'a' AND requestId = ? ",array($id))->affectedRows();
			if($requestStatusByCustomer != 'n' && $offerAmount > 0){
				if($this->sessRequestType == 'web'){
					$status = ucwords(PENDING);

					if($totalAccepted > 0 && $requestStatusByCustomer == 'a'){
						$status = ucwords(ACCEPTED);
					}else if($totalAccepted > 0 && $requestStatusByCustomer == 'r'){
						$status = ucwords(REJECTED);
					}
					/*multi currency change*/
		            $offerAmount = exchange($offerAmount,DEFAULT_CURRENCY_CODE,$this->cCode,$serviceRequestId,'o');
		            /*multi currency change*/

					$arrReplce = array(
										'%OFFER_DESC%'=>$offerDesc,
										'%OFFER_DELIVERY_DATE%'=>convertDate($deliveryDate),
										'%OFFER_BUDGET%'=>CURRENCY_SIGN.$offerAmount,
										'%OFFER_STATUS%'=> $status
									);
					$retData = get_view(DIR_TMPL . $this->module . "/after-sent-offer-nct.tpl.php",$arrReplce);
				}else{
					$retData = array();
				}

				$returnResponse = array(
								'status' => true,
								'showModal' => false,
								'message'=> MSG_ALREADY_OFFER_SENT,
								'pageReload'=>'n',
								'data'=> $retData,
							);
			}else{

				$returnResponse = array(
								'status' => true,
								'showModal' => true,
								'message'=> '',
								'pageReload'=>'n',
								'data'=> array(),
							);
			}
		}else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
			$returnResponse = array(
							'status' => true,
							'message'=> MSG_SOMETHING_WRONG,
							'showModal' => false,
							'pageReload'=>'y',
							'data'=> array(),
						);
		}
		return $returnResponse;
	}

	public function postOffer($request = array()) {
		extract($request);
		$description = issetor($description);
		$deliveryDate = issetor($deliveryDate);
		$offerAmount = issetor($offerAmount);
		if($description != "" && $deliveryDate != "" && $offerAmount != "" && $offerAmount > 0 && $requestSlug != ""){
			$getReqId = getTableValue('tbl_request','id',array('slug'=>$requestSlug,'requStatus'=>'a','isActive'=>'y'));
			if($getReqId > 0){
				$isPosted = $this->db->select('tbl_seller_request_notification',array('id'),array('userId'=>$this->sessUserId,'requestId'=>$getReqId,'requestStatusByCustomer'=>'n'))->result();

				if($isPosted > 0){
					$createdDate = date('Y-m-d H:i:s');
		            $offerAmount_db = exchange($offerAmount,$this->cCode,DEFAULT_CURRENCY_CODE,$getReqId,'o','insert');

					$updArr['description'] = filtering($description);
					$updArr['deliveryDate'] = filtering($deliveryDate);
					$updArr['offerAmount'] = strval($offerAmount_db);
					$updArr['requestStatusByCustomer'] = 'p';
					$updArr['offerDate'] = $createdDate;
					$updArr['ipAddress'] = get_ip_address();
					$this->db->update('tbl_seller_request_notification',$updArr,array('userId'=>$this->sessUserId,'requestId'=>$getReqId));


		            /*Multi Currency Conversation*/
		            $qryCur = $this->db->pdoQuery("SELECT * FROM tbl_currency WHERE isActive = 'y' ")->results();

		            $insArrCurr['cId'] = $this->cId;
		            $insArrCurr['entityId'] = $isPosted['id'];
		            $insArrCurr['type'] = 'o';
		            foreach ($qryCur as $curVal) {
		                $insArrCurr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
		            }
		            $this->db->insert('tbl_currency_past_rates',$insArrCurr);

		            /*Multi Currency Conversation*/

					$buyerId = getTableValue('tbl_request','userId',array('id'=>$getReqId));

					//send notification
					$notification_type = 'seller_sent_offer';
					$data_array = array(
						'receiverId'=>$buyerId,
						'senderId'=>$this->sessUserId,
						'buyerId' => $buyerId,
						'sellerId' => $this->sessUserId,
						'notifyId'=>$notification_type,
						'entityId'=>$isPosted['id']//request notification id
					);
					addNewNotificationForUser($notification_type,$data_array);
					//send notification
					$msg = MSG_OFFER_POSTED_SUC;
				}else{
					$msg = MSG_ALREADY_OFFER_SENT;
				}

				if($this->sessRequestType == 'web'){
					$arrReplce = array(
										'%OFFER_DESC%'=>$description,
										'%OFFER_DELIVERY_DATE%'=>convertDate($deliveryDate),
										'%OFFER_BUDGET%'=>CURRENCY_SIGN.$offerAmount,
										'%OFFER_STATUS%'=> ucwords(PENDING)
									);
					$retData = get_view(DIR_TMPL . $this->module . "/after-sent-offer-nct.tpl.php",$arrReplce);
				}else{
					$retData = array();
				}
				$returnResponse = array(
									'status' => true,
									'message'=> $msg,
									'data'=> $retData,
								);
			}else{
					$returnResponse = array(
							'status' => false,
							'message'=> MSG_SOMETHING_WRONG,
							'data'=> array(),
						);
			}
		}else{
			$returnResponse = array(
							'status' => false,
							'message'=> MSG_FILL_ALL_VALUE,
							'data'=> array(),
						);
		}
		return $returnResponse;
	}

	public function removeRequestNoti($request) {
		extract($request);
		if($requestSlug != ""){
			$getReqId = getTableValue('tbl_request','id',array('slug'=>$requestSlug,'requStatus'=>'a','isActive'=>'y'));
			$this->db->delete('tbl_seller_request_notification',array('userId'=>$this->sessUserId,'requestId'=>$getReqId));
			$returnResponse = array(
							'status' => true,
							'message'=> MSG_REQ_NOTI_REMOVED,
							'data'=> array(),
						);
		}else{
			$returnResponse = array(
							'status' => true,
							'message'=> MSG_SOMETHING_WRONG,
							'data'=> array(),
						);
		}
		return $returnResponse;
	}
}

?>
