<?php
class Registration {
	function __construct($module = "", $id = 0, $token = "",$reffToken="") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->id = $id;
		$this->activecode = isset($_REQUEST['activecode']) ? $_REQUEST['activecode'] : ''; 
		$this->referral_code = isset($_REQUEST['referral_code']) ? $_REQUEST['referral_code'] : ''; 
	}
	public function getPageContent() {
		$replace = array(
			'%REFERRAL_CODE%'=>$this->referral_code
		);
		return get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
	}

	public function doRegistration($data = array()){
		extract($data);
		$returnArray = array();
		$returnArray['status'] = false;
		$email    		= isset($email)? filtering($email,'input') : '' ;
		$password 		= isset($password)? filtering($password,'input') : '' ;
		$cpassword    	= isset($cpassword)? filtering($cpassword,'input') : '' ;
		$userName    	= isset($userName)? filtering($userName,'input') : '' ;
		$date     		= date('Y-m-d H:i:s');
		$ip       		= get_ip_address();

		if($email != '' && $password != '' && $cpassword != '' && $userName != ''){
			$isExist = $this->db->select('tbl_users',array('id'),array('email'=>$email), ' LIMIT 1');
			if($isExist->affectedRows() > 0){
				$returnArray['msg'] = REGISTER_MSG_EMAIL_EXISTS;
			}
			else{
				if($password != $cpassword){
					$returnArray['msg'] = REGISTER_ERR_PASS_NOT_MATCH;
				}
				else{
					$emailVerifyCode = md5(time());
					$insertarray = array(
						"userName"			=>$userName,
						"email"				=>$email,
						"password"			=>md5($password),
						"emailVerifyCode"	=>$emailVerifyCode,
						"referralCode"		=>genrateRandom(15,'alphanum'),
						"ipAddress"			=>$ip,
						"loginWith"			=>'e',
						"createdDate"		=>$date,
						"updatedDate"		=>$date
					);

					//referral code
					if($this->referral_code != ''){
						$check_ref_q =$this->db->pdoQuery("SELECT id FROM tbl_users WHERE referralCode = ? LIMIT 1 ",array($this->referral_code));
						if($check_ref_q->affectedRows() > 0){
							$check_ref_data = $check_ref_q->result();
							$insertarray['referralUserId']  =  $check_ref_data['id'];
						}

						//updating referrs record
						$this->db->update('tbl_users_refers',array('isRegister'=>'y','registerDate'=>date('Y-m-d H:i:s'),'updatedDate'=>date('Y-m-d Hi:i:s')),array('userId'=>$check_ref_data['id'],'email'=>$email));
						//updating referrs record
					}
					//referral code

					$insertarray['slug']  = makeSlug($userName,'tbl_users','id','slug','url');
					$insert_id=$this->db->insert('tbl_users',$insertarray)->getLastInsertId();

					$activationLink = SITE_URL.'activation/'.$emailVerifyCode.'/';
					$arrayCont = array('greetings'=>ucfirst($userName),'activationLink'=>$activationLink);

					$array = generateEmailTemplate('user_register',$arrayCont);
					sendEmailAddress($email,$array['subject'],$array['message']);
					$returnArray['status'] = true;
					$returnArray['msg'] = REGISTER_MSG_REGISTERED_SUC;
				}
		   }
		}else{
			$returnArray['msg'] = LOGIN_MSG_FILL_ALL_VALUE;
		}
		return $returnArray;
	}

	public function verifyEmailActivation(){
		$returnArray = array();
		$q = $this->db->pdoQuery("SELECT id,email,referralCode,referralUserId FROM tbl_users WHERE emailVerifyCode = ? AND isEmailVerify = ? LIMIT 1",array($this->activecode,'n'));
		if($q->affectedRows() > 0){
			$data = $q->result();
			$update_array = array(
				'isEmailVerify'=>'y',
				'emailVerifyCode'=>''
			);
			//entry into default all tables
			$this->db->insert('tbl_wallet',array('userId'=>$data['id'],'createdDate'=>date('Y-m-d H:i:s'),'updatedDate'=>date('Y-m-d H:i:s')));
			$this->db->insert('tbl_user_billing_detail',array('userId'=>$data['id'],'createdDate'=>date('Y-m-d H:i:s'),'ipAddress'=>get_ip_address()));
			$this->db->insert('tbl_user_security_question_answer',array('userId'=>$data['id'],'createdDate'=>date('Y-m-d H:i:s'),'ipAddress'=>get_ip_address()));
			//entry into default all tables

			//give referral bonus to user who has reffered user
			if($data['referralUserId'] > 0 && REFERRAL_AMOUNT > 0){
				$walletData = $this->db->pdoQuery("SELECT amount,earnedAmount,referralAmount FROM tbl_wallet WHERE userId = ? LIMIT 1 ",array($data['referralUserId']))->result();
				$updatearray = array(
					'amount'		=>strval(REFERRAL_AMOUNT + $walletData['amount']),
					'referralAmount'=>strval(REFERRAL_AMOUNT + $walletData['referralAmount'])
				);
				$this->db->update('tbl_wallet',$updatearray,array('userId'=>$data['referralUserId']));

				//notification for referral code credited to wallet
				$data_array = array(
					'receiverId'		=>$data['referralUserId'],
					'senderId'			=>$data['id'],
					'entityId'			=>$data['id'],
					'referral_amount'	=>REFERRAL_AMOUNT,
					'referal_email'		=>$data['email']
				);
				addNewNotificationForUser('referral_bonus_credited',$data_array);
				//notification for referral code credited to wallet

			}
			//give referral bonus to user who has reffered user


			$this->db->update('tbl_users',$update_array,array('id'=>$data['id']));
			$returnArray['status'] = true;
			$returnArray['msg'] = REGISTER_MSG_EMAIL_VERIFIED;
		}
		else{
			$returnArray['status'] = false;
			$returnArray['msg'] = REGISTER_MSG_INVALID_LINK;
		}
		return $returnArray;
	}

	public function checkEmailRegister($data = array()){
		extract($data);
		$email    		= isset($email)? filtering($email,'input') : '' ;
		if($email != ''){
			$isExist = $this->db->select('tbl_users',array('id'),array('email'=>$email), ' LIMIT 1');
			if($isExist->affectedRows() > 0){
				return 'false';
			}
			else{
				return 'true';
			}
		}
		else{
			return '';
		}
	}

}

?>
