<?php
class PromoteBusiness {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
	}

	public function getPageContent(){
		$content = "";
        $data = $this->getEmbedCodeContent();
        $replace = array();
        if($data['status'] == true){
            $replace = array(
                '%SHARE_LINK%'      =>$data['data']['share_link'],
                '%SERVICE_URL%'     =>$data['data']['service_url'],
                '%USER_URL%'        =>$data['data']['user_url'],
                '%SHARE_IMAGE%'     =>$data['data']['share_img'],
                '%USER_NAME%'       =>$data['data']['user_name'],
                '%NAME%'            =>$data['data']['name'],
                '%CAPTION%'         =>$data['data']['caption'],
                '%DESCRIPTION%'     =>$data['data']['description'],
                '%CHARGE%'          =>$data['data']['charge'],
                '%DELIVERY_DAYS%'   =>$data['data']['delivery_days'],
                '%EXPIRY_DATE%'     =>convertDate($data['data']['expiry_date'])
            );
        }
        $replace['%SERVICE_LIST%'] = $this->getServiceList();
		$content .= get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
		return $content;
	}

    public function getServiceList(){
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $content = '';

        $c_q= $this->db->pdoQuery("SELECT s.id,s.userId,s.title,s.slug,s.status,s.isActive 
            FROM tbl_services AS s 
            WHERE s.userId = ? AND s.status = ? AND s.isActive  = ? ",array($this->sessUserId,'a','y'));
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {
                $selected = '';
                if($this->sessRequestType == 'web'){
                    $replace = array(
                        '%OPT_VALUE%'=>$value['id'],
                        '%EXTRA%'=>'',
                        '%SELECTED%'=>$selected,
                        '%OPT_TEXT%'=>$value['title']
                    );
                    $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
                }
                else{
                    $return['data'][] = array(
                        'id'        =>$value['id'],
                        'userId'    =>$value['userId'],
                        'title'     =>filtering($value['title'],'output'),
                        'slug'      =>$value['slug'],
                        'status'    =>$value['status'],
                        'isActive'  =>$value['isActive'],
                    );
                }
            }
            $return['status'] = true;
        }
        return getreturnType($return,$content);
    }

    public function submitPromoteBusiness($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['embedCode'] = '';
        $return['data'] = array();

        $objPost = new stdClass();
        $objPost->description           = filtering(issetor($description,''),'input','text');
        $objPost->serviceId             = filtering(issetor($serviceId,0),'input','int');
        $objPost->charge                = filtering(issetor($charge,0),'input');
        $objPost->deliveryDays          = filtering(issetor($deliveryDays,0),'input');
        $objPost->expiryDate            = filtering(issetor($expiryDate,''),'input');
        //$objPost->badge                 = filtering(issetor($badge,''),'input','text');
        $objPost->updatedDate           = date('Y-m-d H:i:s');

        if($objPost->description != '' && $objPost->serviceId > 0 && $objPost->charge > 0 && $objPost->deliveryDays > 0 && $objPost->expiryDate != '' /*&& $objPost->badge != '' */){
            $multi_id = 0;
            $q = $this->db->pdoQuery("SELECT p.id
            FROM tbl_promote_business AS p 
            WHERE p.userId = ?  LIMIT 1 ",array($this->sessUserId));

            if($q->affectedRows() > 0){
                $q_res = $q->result();
                $objPost->embedCode = '';
                //$objPost->embedUrlCode = genrateRandom(15,'alphanum');
                $objPost->ipAddress    = get_ip_address();
                $objPost->charge = strval($objPost->charge);
                $this->db->update('tbl_promote_business',(array)$objPost,array('id'=>$q_res['id']));
                $multi_id = $q_res['id'];
            }
            else{
                $objPost->embedCode = '';
                $objPost->embedUrlCode = genrateRandom(15,'alphanum');
                $objPost->createdDate  = date('Y-m-d H:i:s');
                $objPost->ipAddress    = get_ip_address();
                $objPost->userId = $this->sessUserId;
                $objPost->charge = strval($objPost->charge);
                $multi_id = $this->db->insert('tbl_promote_business',(array)$objPost)->getLastInsertId(); 
            }

            /*multi currency change*/
            $objPost->charge  = exchange($objPost->charge,$this->cCode,DEFAULT_CURRENCY_CODE,$multi_id,'p','insert');
            $this->db->update('tbl_promote_business',array('charge'=>strval($objPost->charge)),array('id'=>$multi_id));
            /*multi currency change*/



            /*Multi Currency Conversation*/
            $qryCur = $this->db->pdoQuery("SELECT * FROM tbl_currency WHERE isActive = 'y' ")->results();
            $check_c_q = $this->db->pdoQuery("SELECT id FROM tbl_currency_past_rates WHERE entityId = ? AND type = ? LIMIT 1 ",array($multi_id,'p'));
            if($check_c_q->affectedRows() > 0){
                $insArr = array();
                $insArr['cId'] = $this->cId;
                foreach ($qryCur as $curVal){
                    $insArr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
                }
                $this->db->update('tbl_currency_past_rates',$insArr,array('entityId' => $multi_id,'type'=>'p'));
            }
            else{
                $insArr['cId'] = $this->cId;
                $insArr['entityId'] = $multi_id;
                $insArr['type'] = 'p';
                foreach ($qryCur as $curVal) {
                    $insArr[$curVal['currencyCode']] = $curVal['rate_to_usd'];
                }
                $this->db->insert('tbl_currency_past_rates',$insArr);
            }
            /*Multi Currency Conversation*/

            //gerratin embed code
            $data = $this->getEmbedCodeContent();
            $replace = array(
                '%SHARE_LINK%'      =>$data['data']['share_link'],
                '%SERVICE_URL%'     =>$data['data']['service_url'],
                '%USER_URL%'        =>$data['data']['user_url'],
                '%SHARE_IMAGE%'     =>$data['data']['share_img'],
                '%USER_NAME%'       =>$data['data']['user_name'],
                '%NAME%'            =>$data['data']['name'],
                '%CAPTION%'         =>$data['data']['caption'],
                '%DESCRIPTION%'     =>$data['data']['description'],
                '%CHARGE%'          =>$data['data']['charge'],
                '%DELIVERY_DAYS%'   =>$data['data']['delivery_days'],
                '%EXPIRY_DATE%'     =>convertDate($data['data']['expiry_date'])
            );
            $embedCode = get_view(DIR_TMPL . $this->module . "/embed-code-nct.tpl.php",$replace);
            $this->db->update('tbl_promote_business',array('embedCode'=>$embedCode),array('userId'=>$this->sessUserId));
            //gerratin embed code
            $return['message'] = PROMOTE_BUSINESS_PAGE_MSG_ADDED_PROMOTE_CODE;
            $return['status'] = true;
        }
        else{
            $return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
    }

    public function getEmbededCodeForUser($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();
        
        $q = $this->db->pdoQuery("SELECT p.id,p.embedCode,p.embedUrlCode
            FROM tbl_promote_business AS p 
            WHERE p.userId = ?  LIMIT 1 ",array($this->sessUserId));

        if($this->sessUserId > 0){
            if($q->affectedRows() > 0){
                $q_res = $q->result();

                $return['data'] = array(
                    'id'            =>$q_res['id'],
                    'embedCode'     =>$q_res['embedCode'],
                    'embedUrlCode'  =>SITE_URL.'promote-business/'.$q_res['embedUrlCode'].'/'
                );
                $return['status'] = true;
            }   
            else{
                $return['message'] = PROMOTE_BUSINESS_PAGE_MSG_NO_EMBED_CODE_FOUND;
                $return['status'] = false;
            }
        }
        else{
            $return['message'] = SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
        }
        return $return;
    }

    public function getEmbedCodeContent($data=array()){
        extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $q = $this->db->pdoQuery("SELECT p.id,p.embedCode,p.embedUrlCode,s.id as sid,s.title,s.slug,p.description,sg.fileName,p.charge,p.deliveryDays,p.expiryDate,u.slug as user_slug
            FROM tbl_promote_business AS p 
            INNER JOIN tbl_services AS s ON s.id = p.serviceId 
            INNER JOIN tbl_users As u ON u.id = s.userId
            LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i') 
            WHERE p.userId = ?  LIMIT 1 ",array($this->sessUserId));
        if($q->affectedRows() > 0){
            $data = $q->result();
            $sImg = checkImage($data['fileName'],8,$data['sid']);
            $service_slug = filtering($data['slug']);
            $description = filtering($data['description'],'output','text');
            $title = filtering(ucwords($data['title']));

            $charge = 0;
            if($this->sessRequestType == 'web'){
                /*multi currency change*/
                $charge = exchange($data['charge'],DEFAULT_CURRENCY_CODE,$this->cCode,$data['id'],'p');
                /*multi currency change*/
            }
            else{
                $charge = $data['charge'];
            }

            $return['data'] = array(
                'id'                =>$data['id'],
                'service_image'     =>$sImg,
                'share_link'        =>SITE_URL.'promote-business/'.$data['embedUrlCode'].'/',
                'service_url'       =>SITE_URL.'service-details/'.$service_slug.'/',
                'user_url'          =>SITE_URL.'profile/'.$data['user_slug'].'/',
                'share_img'         =>$sImg,
                'user_name'         =>ucfirst($_SESSION["sessUserName"]),
                'name'              =>$title,
                'caption'           =>$title.' - '.SITE_NM,
                'description'       =>$description,
                'charge'            =>$charge,
                'delivery_days'     =>$data['deliveryDays'],
                'expiry_date'       =>convertDate($data['expiryDate'])
            );
            $return['status'] = true;
        }
        return $return;
    }
}

?>
