<?php
class NotificationList {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->db->pdoQuery("UPDATE tbl_site_notification SET readStatus = 'y' WHERE receiverId = ?",array($this->sessUserId));
	}
	public function getPageContent(){
		$content = '';
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array();
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getNotificationList($data=array()){
		extract($data);
		$buyerId = (isset($buyerId) && $buyerId > 0) ? $buyerId : '';
		$keyword = (isset($keyword) && $keyword != '') ? $keyword : '';

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$sWhere = '  WHERE ( n.receiverId = ? AND n.isActive = ?   ) ';
		$aWhere = array($this->sessUserId,'y');

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;

		$sorting = ' n.id DESC  ';

		$totalRowCount = $this->db->pdoQuery("SELECT n.id
        		FROM tbl_site_notification AS n
        		LEFT JOIN tbl_users AS u ON u.id = n.senderId
                $sWhere GROUP BY n.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT n.id,n.senderId,n.receiverId,n.notifyId,n.entityId,n.notification,n.createdDate,u.slug,u.userName,u.profileImage
    		FROM tbl_site_notification AS n
    		LEFT JOIN tbl_users AS u ON u.id = n.senderId
			$sWhere  GROUP BY n.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){

			foreach ($q->results() as $key => $value){

				$notification = filtering(ucwords($value['notification']));
				$userName = filtering(ucwords($value['userName']));
				$profileImage = checkImage($value['profileImage'],9,$value['senderId']);
				/*if(defined($value['notification'])){
					$value['notification'] = constant($value['notification']);
				} */
				$notify_data = getNotificationText($value['id'],$value['notification']);
				$notificationMsg = $notify_data['notification_text'];
				$notificationURL = $notify_data['notification_url'];
				if($this->sessRequestType == 'web'){

					$replace = array(
						'%USER_URL%'			=>($value['senderId'] > 0 ? SITE_URL.'profile/'.$value['slug'].'/' : 'javascript:void(0);'),
						'%USER_IMG%'			=>($value['senderId'] > 0 ? $profileImage : SITE_IMG.SITE_LOGO),
						'%USER_NAME%'			=>($value['senderId'] > 0 ? $userName : SITE_NM),
						'%NOTIFICATION_TEXT%'	=>$notificationMsg,
						'%NOTIFICATION_URL%'	=>$notificationURL,
						'%DATE%'				=>convertDate($value['createdDate'])
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/notification-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'senderId'			=>$value['senderId'],
						'receiverId'		=>$value['receiverId'],
						'notifyId'			=>$value['notifyId'],
						'entityId'			=>$value['entityId'],
						'notification'		=>$notificationMsg,
						'user_img'			=>$profileImage,
						'user_name'			=>$userName,
						'date'				=>convertDate($value['createdDate'])
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = NOTIFICTION_LIST_PAGE_NRF;
			$content['html'].=getNoRecordFoundContent(NOTIFICTION_LIST_PAGE_NRF,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
}

?>
