<?php
class MyCollectionDetails {
	function __construct($module = "", $id = 0, $token = "",$reffToken="",$slug='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->slug = $slug;
		$this->id = $id;
	}
	public function getPageContent(){
		$content = array();
		$data = $this->getBuyerCollectionList();
		if($data['status'] == true){
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
			$replace = array(
				'%NAME%'				=>$data['data']['name'],
				'%DESCRIPTION%'			=>$data['data']['description'],
				'%NO_OF_SERVICES%'		=>$data['data']['no_of_service'],
				'%COLLECTION_IMG%'		=>$data['data']['image'],
				'%CAPTION%'				=>$data['data']['name'].' - '.SITE_NM
			);
			$content = get_view($tplUrl,$replace);

		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
		return $content;
	}

	public function getBuyerCollectionList($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

        $q = $this->db->pdoQuery("SELECT bc.id,bc.slug,bc.name,bc.image,bc.createdDate,bc.description
        	FROM tbl_buyer_collections AS bc
        	WHERE slug = ? AND bc.isActive = ? LIMIT 1 ",array($slug,'y'));

		if($q->affectedRows() > 0){
			$q_res = $q->result();

			$noOfService = $this->db->pdoQuery("SELECT bcs.* FROM tbl_buyer_collections_services AS bcs INNER JOIN tbl_services AS s ON s.id = bcs.serviceId INNER JOIN tbl_users AS u ON u.id = s.userId WHERE u.isActive = ? AND bcs.collectionId = ?",array('y',$q_res['id']))->affectedRows();
			$return['data'] = array(
				'id'				=>$q_res['id'],
				'name'				=>filtering($q_res['name']),
				'description'		=>filtering($q_res['description'],'output','text'),
				'slug'				=>filtering($q_res['slug']),
				'no_of_service'		=>$noOfService,
				'image'				=>checkImage($q_res['image'],11,$q_res['id']),
				'createdDate'		=>convertDate($q_res['createdDate'],true)
			);
			$return['status'] = true;
		}
		else{
			$return['message'] = COLLECTION_DETAIL_NOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	public function getCollectionServiceList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$sWhere = ' WHERE bc.slug = ? AND s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,'a','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' bcs.id DESC ';

		$qry = "SELECT bcs.id AS buyColSerId,s.title,s.id,u.userName,u.slug as user_slug,s.isFeatured,s.slug as service_slug,u.profileImage,sg.fileName,s.userId,u.userLevel,
			(SELECT MIN(price) FROM tbl_service_packages WHERE serviceId = s.id) as price
			FROM tbl_buyer_collections_services AS bcs
			INNER JOIN tbl_buyer_collections AS bc ON bc.id = bcs.collectionId
			INNER JOIN tbl_services AS s ON s.id = bcs.serviceId
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			$sWhere GROUP BY bcs.id";

		$totalRow = $this->db->pdoQuery($qry, $aWhere)->affectedRows();



		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery($qry."   ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$buyColSerId = $value['buyColSerId'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];

				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.paymentStatus = 's' AND o.status = 'c'",array($id))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$totalSales = $this->db->pdoQuery("SELECT id FROM tbl_orders WHERE paymentStatus = ? AND entityId = ? AND
					status NOT IN (?,?) ",array('s',$value['id'],'e','ca'))->affectedRows();

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');
				$user_level = ($value['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($value['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
				$user_level_class = ($value['userLevel'] == 'b' ? 'begginer-tag' : ($value['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));

				$isSocialVerified =  isSocialVerified($userId);
				$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);
				if($this->sessRequestType == 'web'){
					$delteUrl = SITE_URL.'delete-collection-service/'.$buyColSerId.'/';
					$feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

	            	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
					$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL,
						'%SELLER_NAME%'			=>$userName,
						'%TOTAL_SALES%'			=>$totalSales,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%DELETE_SERVICE%'		=>$delteUrl,
						'%FEATURE_TAGS%'		=>$feature_tag,
						'%USER_LEVEL_CLASS%'	=>$user_level_class,
						'%USER_LEVEL%'			=>$user_level,
						 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
						 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/service-list-nct.tpl.php",$replace);

					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL,
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = COLLECTION_DETAIL_NRF;
			$content['html'].=getNoRecordFoundContent(COLLECTION_DETAIL_NRF);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function deleteCollectionService($data = array()){
		extract($data);
		if($bcsId > 0){
			$bcsData = $this->db->pdoQuery("SELECT bc.userId,bc.slug FROM tbl_buyer_collections AS bc INNER JOIN tbl_buyer_collections_services AS bcs ON bcs.collectionId = bc.id WHERE bcs.id = ? ",array($bcsId));
			if($bcsData->affectedRows() > 0){
				$result = $bcsData->result();
				$ownerId = $result['userId'];
				$slug = $result['slug'];
				if($ownerId == $this->sessUserId){
					$this->db->delete('tbl_buyer_collections_services',array('id'=>$bcsId));
					$_SESSION["msgType"] = disMessage(array('type'=>'suc','var'=>MSG_SERVICE_COLLECTION_DELETED_SUC));
					$returnResponse = array(
					'redirectLink' 	=> SITE_URL.'my-collection-details/'.$slug.'/',
					'status'		=> true,
					'message'   	=> MSG_SERVICE_COLLECTION_DELETED_SUC,
					'data'  		=> array());
				}else{
					$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_PERMISSION_DENIED));
					$returnResponse = array(
					'redirectLink' 	=> SITE_URL.'my-collections/',
					'status'		=> true,
					'message'   	=> MSG_PERMISSION_DENIED,
					'data'  		=> array());
				}
			}else{
				$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_PERMISSION_DENIED));
					$returnResponse = array(
					'redirectLink' 	=> SITE_URL.'my-collections/',
					'status'		=> true,
					'message'   	=> MSG_PERMISSION_DENIED,
					'data'  		=> array());
			}

		}else{
			$_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
				$returnResponse = array(
				'redirectLink' 	=> SITE_URL.'my-collections/',
				'status'		=> true,
				'message'   	=> MSG_SOMETHING_WRONG,
				'data'  		=> array());
		}
		return $returnResponse;
	}
}

?>
