<?php
class ManageSales {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
	}
	public function getPageContent(){
		$content = '';
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array(
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function getSalesList($data=array()){
		extract($data);

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['sales_list'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$sWhere = '  WHERE o.sellerId = ?  ';
		$aWhere = array($this->sessUserId);

		//filters
		$keyword 	= issetor($keyword,'');
		$type 		= issetor($type,'');
		$status 	= issetor($status,'');

		if($keyword != ''){
			$keyword = str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $keyword);

			$sWhere .= " AND ( s.title LIKE ? OR r.description LIKE ?  ) ";
            $aWhere[] = "%$keyword%";
            $aWhere[] = "%$keyword%";
		}

		if($type != ''){
			$sWhere .= " AND o.orderType =  ? ";
			$aWhere[] = $type;
		}

		if($status != ''){
			$sWhere .= " AND o.status =  ? ";
			$aWhere[] = $status;
		}
		//filters

		$page =  isset($_REQUEST['page']) ? (int) $_REQUEST['page'] : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;
        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;

		$sorting = ' o.id DESC  ';

		$totalRowCount = $this->db->pdoQuery("SELECT o.id
        		FROM tbl_orders AS o
				LEFT JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
				LEFT JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
				LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
				INNER JOIN tbl_users AS u ON u.id = o.userId
                $sWhere GROUP BY o.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT o.id,o.txnId,o.userId as buyerId,o.sellerId,o.entityId,o.orderType,o.amount,o.extraAmount,o.deliveryDate,o.status,o.createdDate,u.userName,u.profileImage,s.title,s.slug AS serviceSlug,r.description,sg.fileName,u.slug as user_slug
        	FROM tbl_orders AS o
			LEFT JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
			LEFT JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_users AS u ON u.id = o.userId
			$sWhere  GROUP BY o.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$orderId = $value['id']; //orderId
				$buyerId = $value['buyerId'];
				$sellerId = $value['sellerId'];
				$txnId = $value['txnId'];
				$amount = $value['amount'];
				$extraAmount = $value['extraAmount'];
				$deliveryDate = convertdate($value['deliveryDate']);
				$userName = filtering($value['userName']);
				$orderType = filtering($value['orderType']);
				$serviceSlug = filtering($value['serviceSlug']);
				$title = filtering($value['title']);
				$title = issetor($title);
				$description = filtering($value['description']);
				$description = issetor($description);
				$profileImage = checkImage($value['profileImage'],9,$buyerId);
				$status = filtering($value['status']);
				$createdDate = convertdate($value['createdDate']);
				$dispStatus = LBL_NEW;

				$descDetail = '';
				$is_active_now = 'n';
				$is_active_now_content = '';
				$generate_invoice = 'n';
				$generate_invoice_content = '';
				$sImg = checkImage($value['profileImage'],9,$buyerId);
				if($orderType == 'r'){
					$url = 'javascript:void(0);';
					$dispOrderType = LBL_REQUEST;
					$descDetail = myTruncate($description,50);
				}else{
					$dispOrderType = LBL_SERVICE;
					$url = SITE_URL.'service-details/'.$serviceSlug.'/';
					$descDetail = myTruncate($title,50);
					$sImg = checkImage($value['fileName'],8,$value['entityId']);
				}

				switch ($status) {
					case 'n':
						$dispStatus = LBL_NEW;
						$is_active_now = 'y';
						break;
					case 'a':
						$dispStatus = ACTIVE;
						break;
					case 'c':
						$dispStatus = COMPLETED;
						$generate_invoice = 'y';
						break;
					case 'ca':
						$dispStatus = CANCELLED;
						break;
					case 'l':
						$dispStatus = LATE;
						break;
					case 'e':
						$dispStatus = EXPIRED;
						break;
					default:
						$dispStatus = LBL_NEW;
						break;
				}

				if($this->sessRequestType == 'web'){

					//active btn content
					$is_active_now_content = ($is_active_now == 'y' ? get_view(DIR_TMPL . $this->module . "/active-nct.tpl.php",array('%ORDER_ID%'=>$orderId)) : '' );

					//generate invoice btn
					$requireInvoice = getTableValue('tbl_user_billing_detail','requireInvoice',array('userId'=>$this->sessUserId));
					if($requireInvoice == 'y' && $generate_invoice == 'y'){
						$replace = array(
							'%INVOICE_CLASS%'=>'btn-info',
							'%INVOICE_ATTR%'=>'',
							'%INVOICE_URL%'=>SITE_URL.'generate-sales-invoice/'.$txnId.'/',
						 );
						$generate_invoice_content = get_view(DIR_TMPL . $this->module . "/generate-invoice-nct.tpl.php",$replace);
					}

					/*multi currency change*/
	            	$amount = exchange($amount,DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
	            	/*multi currency change*/

					$replace = array(
						'%SERVICE_PHOTO%'	=>$sImg,
						'%SERVICE_TITLE%'	=>$descDetail,
						'%SERVICE_URL%'		=>$url,
						'%AMOUNT%'			=>$amount,
						'%DATE%'			=>$deliveryDate,
						'%ORDER_TYPE%'		=>$dispOrderType,
						'%BUYER_PHOTO%'		=>$profileImage,
						'%BUYER_NAME%'		=>$userName,
						'%BUYER_URL%'		=>SITE_URL.'profile/'.$value['user_slug'].'/',
						'%STATUS%'			=>$dispStatus,
						'%OPERATION%'		=>($is_active_now_content.$generate_invoice_content)
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/sales-list-nct.tpl.php",$replace);
					$content['pagination'] = pagination($pager, $page, $totalRow);
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'service_photo'		=>$sImg,
						'service_title'		=>$descDetail,
						'amount'			=>$amount,
						'order_type'		=>$dispOrderType,
						'buyer_photo'		=>$profileImage,
						'buyer_name'		=>$userName,
						'status'			=>$dispStatus
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SALES_HISTORY_PAGE_NRF;
			$content['html'].=getNoRecordFoundContent(SALES_HISTORY_PAGE_NRF,DIR_TMPL . $this->module . "/no-record-nct.tpl.php");
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function generateInvoice($txnId = 0) {
        $final_result = NULL;

        $qry = "SELECT o.*,seller.userName AS sellerUserName,seller.profileImage AS sellerImg,buyer.userName AS buyerUserName,buyer.profileImage AS buyerImg,s.title,s.slug AS serviceSlug,r.description,payment.adminCommission
        	FROM tbl_orders AS o
        	LEFT JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r')
        	LEFT JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
        	INNER JOIN tbl_users AS seller ON seller.id = o.sellerId
        	INNER JOIN tbl_users AS buyer ON buyer.id = o.userId
        	INNER JOIN tbl_payment_history AS payment ON payment.id = o.paymentId
        	WHERE o.status = 'c' AND o.sellerId = ? AND o.txnId = ? ";

        $fetchRes = $this->db->pdoQuery($qry,array($this->sessUserId,$txnId));

       	if($fetchRes->affectedRows() > 0){
       		$result = $fetchRes->result();
       		$txnId = $result['txnId'];
       		$buyerId = $result['userId'];
       		$sellerId = $result['sellerId'];
       		$amount = $result['amount'];
       		$extraAmount = $result['extraAmount'];
       		$final_amount = $orderTotalPrice = $amount;

       		$couponCode = issetor($result['couponCode'],"");
       		$discountPercentage = issetor($result['discountPercentage'],0);
       		$couponeDiscount = issetor($result['discount'],0);
       		$discountHideShow = 'n';
       		$otherFields = "";
       		if($couponCode != "" && $discountPercentage > 0 && $couponeDiscount > 0){
       			$discountHideShow = 'y';
       			$DiscountFields = array(
						            "%COUPON_CODE%" => $couponCode,
									"%DISCOUNT_PERCENTAGE%" => $discountPercentage,
									"%COUPON_DISCOUNT%" => DEFAULT_CURRENCY_CODE.$couponeDiscount,
								);
	        	$otherFields .= get_view(DIR_TMPL . "discount-invoice-field-nct.tpl.php",$DiscountFields);
	        	$orderTotalPrice += $couponeDiscount;
       		}
       		$orderType = $result['orderType'] == 'r' ? LBL_REQUEST : LBL_SERVICE ;
       		$deliveryDate = convertDate($result['deliveryDate']);

       		$buyerUserName = ucwords(filtering($result['buyerUserName']));
       		$sellerUserName = ucwords(filtering($result['sellerUserName']));
			$buyerImg = checkImage($result['buyerImg'],9,$buyerId);
			$sellerImg = checkImage($result['sellerImg'],9,$sellerId);
       		$adminCommission = $result['adminCommission'];


	        /*"%INVOICE_LBL%"=>($this->sessRequestType != 'app') ? INVOICE : $_REQUEST['invoice'],
	            "%BOOKING_ID_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_ID : $_REQUEST['booking_id'],
	            "%SERVICE_START_TIME_LBL%"=>($this->sessRequestType != 'app') ? SERVICE_START_TIME : $_REQUEST['service_start_time'],
	            "%SERVICE_END_TIME_LBL%"=>($this->sessRequestType != 'app') ? SERVICE_END_TIME : $_REQUEST['service_end_time'],
	            "%BOOKING_DETAILS_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_DETAILS : $_REQUEST['booking_details'],
	            "%BOOKING_AMOUNT_LBL%"=>($this->sessRequestType != 'app') ? BOOKING_AMOUNT : $_REQUEST['booking_amount'],
	            "%ADMIN_FEES_LBL%"=>($this->sessRequestType != 'app') ? ADMIN_FEES : $_REQUEST['admin_fees'],
	            "%PAYMENT_TYPE_LBL%"=>($this->sessRequestType != 'app') ? PAYMENT_TYPE : $_REQUEST['payment_type'],
	            "%COMPLETED_LBL%"=>($this->sessRequestType != 'app') ? COMPLETED : $_REQUEST['complete'],*/

	        /*multi currency change*/
        	$orderTotalPrice = exchange($orderTotalPrice,DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
        	$final_amount = exchange($final_amount,DEFAULT_CURRENCY_CODE,$this->cCode,null,'','display');
        	/*multi currency change*/
        	global $cCode;
	        $fields = array(
	            "%ORDER_ID%" => $txnId,
	            "%BUYER_IMAGE%" => $buyerImg,
	            "%BUYER_NAME%" => $buyerUserName,
	            "%SELLER_IMAGE%" => $sellerImg,
	            "%SELLER_NAME%" => $sellerUserName,
	            "%ORDER_PRICE%" => $cCode.' '.$orderTotalPrice,
	            "%TYPE%" => $orderType,
	            "%DELIVERY_DATE%" => $deliveryDate,
	            "%FINAL_AMOUNT%" => $cCode.' '.$final_amount,
	            "%OTHER_FIELDS%" => $otherFields,
	        );
	        /* $message = "<pre>" . print_r($fields, TRUE);
	        sendEmailAddress('gaurav.chavda@ncrypted.com', 'Service Details' . ' - ' . SITE_NM, $message);*/

	        $html = get_view(DIR_TMPL . "invoice-nct.tpl.php",$fields);

	        if ($txnId != "") {
	            $data_array = array(
	                "html" => $html,
	                "output_file_name" => $txnId . "-invoice.pdf",
	                "download" => ($this->sessRequestType == "app") ? "false" : "true",
	            );
	            $file_name = generatePdfFile($data_array);
	        }
	        $final_result["data"] = array("file_name" => $file_name);
	        $final_result["message"] = "";
	        $final_result["type"] = "success";
	        $final_result["status"] = true;
	        echo json_encode($final_result);
	        exit;
	    }else{

			$msgType = $_SESSION["msgType"] = disMessage(array('type'=>'err','var'=>MSG_SOMETHING_WRONG));
			redirectPage(SITE_URL.'manage-purchase/');
	    }
    }

    public function activeOrderForSeller($data=array()){
    	extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $orderId 	= filtering(issetor($orderId,''),'input','int');

        if($orderId > 0){
        	$check_q =$this->db->pdoQuery("SELECT o.id,o.userId,o.txnId
        			FROM tbl_orders AS o
        			WHERE o.id = ? AND o.sellerId = ? AND o.status = ? ",array($orderId,$this->sessUserId,'n'));
        	if($check_q->affectedRows() > 0){
        		$check_data = $check_q->result();
        		$this->db->update('tbl_orders',array('status'=>'a','sellerUpdatedDate'=>date('Y-m-d H:i:s'),'updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$orderId,'sellerId'=>$this->sessUserId));

        		//notification for change status
				$data_array = array(
					'receiverId'=>$check_data['userId'],
					'senderId'	=>$this->sessUserId,
					'entityId'	=>$orderId,
					'buyerId' 	=> $check_data['userId'],
					'sellerId' 	=> $this->sessUserId,
					'txnId'		=>$check_data['txnId']
				);
				addNewNotificationForUser('order_activated',$data_array);
				//notification for change status

        		$return['message'] = MANAGE_SALES_PAGE_ORDER_STATUS_CHANGED;
        		$return['status'] = true;
        	}
        	else{
        		$return['message'] = MANAGE_SALES_PAGE_ORDER_NOT_FOUND;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
    }
}

?>
