<?php
class ForgotPassword {
	function __construct($module = "", $id = 0, $token = "",$reffToken="",$objCookie=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		$this->module = $module;
		$this->id = $id;

	}
	public function getPageContent(){
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$replace = array(
			'%LIST_QUESTION%'=>$this->getSecurityQuestionsHtml()
		);
		$content = get_view($tplUrl,$replace);
		return $content;
	}

	public function doForgotPasswordViaEmail($data = array()){
		extract($data);
		$returnArray = array();
		$returnArray['msg'] = '';
		$returnArray['callBack'] = SITE_URL.'forgot-password/';
		$returnArray['status'] = false;
		$email = isset($email) ? filtering($email, 'input', 'string', '')  : '';
		if($email != ''){
			$selQuery  = $this->db->pdoQuery("SELECT u.id,u.userName,u.email,u.isEmailVerify,u.isActive
				FROM tbl_users AS u
				WHERE u.email = ? ",array($email));
			if($selQuery->affectedRows()){
				$result = $selQuery->result();
				extract($result);
				if($isEmailVerify == "n"){
					$returnArray['msg'] = LOGIN_MSG_ACTIVATE_ACC;
				}
				else if ($isActive == "d"){
					$returnArray['msg'] = LOGIN_MSG_ACCOUNT_DELETED;
				}
				else if ($isActive == "n"){
					$returnArray['msg'] = LOGIN_MSG_ACCOUNT_DEACTIVATED_BY_ADMIN;
				}
				else{
					$emailVerifyCode = md5(time());
					$this->db->update('tbl_users',array('emailVerifyCode'=>$emailVerifyCode,'updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$id));
					$activationLink = SITE_URL.'reset-password/'.$emailVerifyCode.'/';
					$arrayCont = array('greetings'=>ucfirst($userName),'activationLink'=>$activationLink);

					$array = generateEmailTemplate('reset_password_link',$arrayCont);
					sendEmailAddress($email,$array['subject'],$array['message']);
					$returnArray['msg'] = FORGOT_PASS_MSG_RESEND_LINK_SENT;
					$returnArray['status'] = true;
				}
			}
			else{
				$returnArray['msg'] = FORGOT_PASS_MSG_EMAIL_NOT_FOUND;
			}
		}
		else{
			$returnArray['msg'] = LOGIN_MSG_FILL_ALL_VALUE;
		}
		return $returnArray;
	}

	public function doLoginViaSecurityQuestion($data = array()){
		extract($data);
		$returnArray = array();
		$returnArray['msg'] = '';
		$returnArray['callBack'] = SITE_URL.'forgot-password/';
		$returnArray['status'] = false;
		$email = isset($email) ? filtering($email, 'input', 'string', '')  : '';
		$que_id = isset($que_id) ? filtering($que_id, 'input', 'int', '') : '';
		$answer = isset($answer) ? filtering($answer, 'input', 'string', '') : '';
		if($email != '' && $que_id != '' && $answer != '' ){
			$selQuery  = $this->db->pdoQuery("SELECT u.id,u.userName,u.email,u.isEmailVerify,u.isActive
				FROM tbl_users AS u
				INNER JOIN tbl_user_security_question_answer AS uq ON uq.userId = u.id
				WHERE u.email = ? AND uq.questionId = ? AND uq.answer = ? ",array($email,$que_id,$answer));
			if($selQuery->affectedRows() >= 1){
				$result = $selQuery->result();
				extract($result);
				if($isEmailVerify == "n") {
					$returnArray['msg'] = LOGIN_MSG_ACTIVATE_ACC;
				}
				else if ($isActive == "d") {
					$returnArray['msg'] = LOGIN_MSG_ACCOUNT_DELETED;
				}
				else if ($isActive == "n") {
					$returnArray['msg'] = LOGIN_MSG_ACCOUNT_DEACTIVATED_BY_ADMIN;
				}
				else{
					$_SESSION["user_id"] = $id;
					$_SESSION["sessUserName"] = filtering($userName);
					$returnArray['msg'] = LOGIN_MSG_LOGIN_SUCCESS;
					$returnArray['status'] = true;
				}
			}
			else{
				$returnArray['msg'] = FORGOT_PASS_MSG_INVALID_DETAILS;
			}
		}
		else{
			$returnArray['msg'] = FORGOT_PASS_MSG_INVALID_DETAILS;
		}
		return $returnArray;
	}

	public function getSecurityQuestions(){
		$data = array();
		$q = $this->db->pdoQuery("SELECT id,question_$this->lId FROM tbl_security_questions WHERE isActive = ? ORDER BY question_$this->lId ASC ",array('y'));
		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value) {
				$data[] = array(
					'id'		=>$value['id'],
					'question'	=>$value['question_'.$this->lId]
				);
			}
		}
		return $data;
	}

	public function getSecurityQuestionsHtml(){
		$content = '';
		$que_list = $this->getSecurityQuestions();
		if(count($que_list) > 0){
			foreach ($que_list as $key => $value){
				$replace = array(
					'%OPT_VALUE%'	=>$value['id'],
					'%EXTRA%' 		=>'',
					'%OPT_TEXT%' 	=>$value['question'],
					'%SELECTED%' 	=>''
				);
				$content .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);
			}
		}
		return $content;
	}
}

?>
