<?php
class BuyerRequest {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->pageNo = issetor($pageNo,1);
		$this->catSlug = issetor($catSlug);

	}
	public function getPageContent() {
		$myRequestList = $this->getMyRequestList();

		$cateList = $this->getCategoryList();

		$replaceArr = array('%REQUEST_LIST%'=>$myRequestList['data']['html'],'%REQUEST_PAGINATION%'=>$myRequestList['data']['pagination'],'%CATEGORY_LIST%'=>$cateList);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}

	public function getCategoryList($catId = 0) {
		$cateHtml = "";
		$getCat =  $this->db->select("tbl_categories",array('*'),array('isActive'=>'y'));
		if($this->sessRequestType == 'web'){

			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$cateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);

		}
		if($getCat->affectedRows() > 0){
			$getCatResult = $getCat->results();
			foreach ($getCatResult as $key => $catData) {
				$id = $catData['id'];
				$cateName = filtering($catData['cateName_'.$this->lId]);
				$cateSlug = filtering($catData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$cateSlug,
							'%OPT_TEXT%'=>ucwords($cateName),
							'%EXTRA%'=>'',
							'%SELECTED%'=>($id == $catId) ? 'selected' : NULL,
						);
					$cateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}
			}
		}
		return $cateHtml;
	}
	public function getMyRequestList()
	{
		$whrCondition = $content = "";
		$returnResponse = array();
		if($this->catSlug != ""){
			$whrCondition =  " AND c.slug = ?";
			$whrArr[] = $this->catSlug;
		}

		$qry ="SELECT r.*,u.profileImage,u.userName,c.cateName_".$this->lId." AS catName,sc.subCategoryName_".$this->lId." AS subCategoryName FROM tbl_request AS r INNER JOIN  tbl_users AS u ON u.id = r.userId INNER JOIN tbl_categories AS c ON c.id = r.catId INNER JOIN tbl_subcategories AS sc ON sc.id = r.subCatId WHERE  r.isActive = 'y' $whrCondition AND r.requStatus = 'a' AND r.userId = ?  ORDER BY r.createdDate DESC";
		$whrArr[] = $this->sessUserId;
		$request = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $request->affectedRows();

		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$requestQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $requestQuery->affectedRows();

		if($NoOfrows > 0){
			$requestList = $requestQuery ->results();
			foreach ($requestList as $key => $requestData) {
				$id = filtering($requestData['id']);
				$slug = filtering($requestData['slug']);
				$userId = filtering($requestData['userId']);
				$description = filtering($requestData['description']);
				$budget = $requestData['budget'];

				$userName = filtering($requestData['userName']);
				$profileImage = checkImage($requestData['profileImage'],9,$userId);
				$createdDate = convertDate($requestData['createdDate']);
				$durationType = ($requestData['durationType'] == 'h' ? HOURS : DAYS);

				$duration = $requestData['duration'].' '.$durationType;
				$requestDoc = $requestData['requestDoc'];
				$catName = ucwords(filtering($requestData['catName']));
				$subCategoryName = ucwords(filtering($requestData['subCategoryName']));
				$originalName = $requestData['originalName'];
				$attName = issetor($originalName,$requestDoc);
				$attHiddenClass = 'hidden';
				$attDownloadLink = 'javascript:void(0)';
				if(is_file(DIR_UPD.'request/'.$id.'/'.$requestDoc)){
					$attHiddenClass = '';
					$attDownloadLink = SITE_URL.'download/request-attachment/'.base64_encode($id).'/';
				}
				$url = SITE_URL.'view-request-offer/'.$slug;

				$totalOffer = $this->db->pdoQuery("SELECT so.* FROM tbl_seller_request_notification AS so INNER JOIN tbl_users AS u ON u.id = so.userId WHERE so.requestStatusByCustomer != 'n' AND u.isActive = 'y' AND so.offerAmount > 0 AND so.requestId = ?",array($id))->affectedRows();


				if($this->sessRequestType == 'web'){
					$hiredHtml = "";
					$isPaid = getTableValue('tbl_seller_request_notification','id',array('requestId'=>$id,'buyerPaid'=>'y'));
					if($isPaid > 0){

						$arrReplce = array('%LABEL%'=>HIRED,'%EXTRA_CLASS%'=>'label-success','%EXTRA_ATTR%'=>'');
						$hiredHtml = get_view(DIR_TMPL . $this->module . "/hired-btn-nct.tpl.php",$arrReplce);
					}
					/*multi currency change*/
		            $budget = exchange($budget,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'r');
		            /*multi currency change*/
		            $reviewContent = $tplPostReview = "";

	       			$checkReview = $this->db->pdoQuery("SELECT r.id,r.rating,r.review,r.isActive FROM tbl_reviews AS r INNER JOIN tbl_orders AS o ON o.id = r.orderId WHERE o.entityId = ? AND o.orderType = 'r' AND r.userFrom = ?",array($id,$this->sessUserId));
	       			$chkReivewAff = $checkReview->affectedRows();
	            	$chkReivewResult = $checkReview->result();

		            $getStatus = $this->db->pdoQuery("SELECT txnId FROM tbl_orders WHERE orderType = 'r' AND entityId = ? AND (status = 'c' OR status = 'l')",array($id));
		            $getStatusAff = $getStatus->affectedRows();
			        $txn = $getStatus->result();

		            if($getStatusAff > 0 ){
		            	if($chkReivewAff <= 0){
			            	$arrReviewReplce = array('%REQUEST_SLUG%'=>$slug);
			            	$tplPostReview = get_view(DIR_TMPL . $this->module . "/post-review-nct.tpl.php",$arrReviewReplce);
			            }else{
			            	if($chkReivewResult['isActive'] == 'y'){
				            	$review = filtering($chkReivewResult['review'],'output','text');
				            	$rating = filtering($chkReivewResult['rating'],'output','float');
				            	$arrRatingReplce = array('%STAR_RATTING%'=>$rating,'%REVIEW%'=>$review);
				            	$reviewContent = get_view(DIR_TMPL . $this->module . "/rating-html-nct.tpl.php",$arrRatingReplce);
				            }
			            }
		            }

					$replaceArr = array(
							'%USER_PROFILE_PHOTO%' => $profileImage,
							'%USER_NAME%' => $userName,
							'%REQUEST_CREATED_DATE%' => $createdDate,
							'%REQUEST_DESC%' => $description,
							'%ATT_HIDDEN_CLASS%' => $attHiddenClass,
							'%ATTACHMENT_DOWNLOAD_LINK%' => $attDownloadLink,
							'%ATTACH_FILE_NAME%' => $attName,
							'%REQUEST_BUDGET%' => CURRENCY_SIGN.$budget,
							'%TOTAL_OFFER%' => $totalOffer,
							'%HIDE_SHOW_CLASS%' => ($totalOffer > 0 ? '' : 'hide'),
							'%DURATION%' => $duration,
							'%VIEW_OFFER_URL%' => $url,
							'%HIRED_LBL%' => $hiredHtml,
							'%CATE_NAME%' => $catName,
							'%SUB_CATE_NAME%' => $subCategoryName,
							'%POST_REVIEW%'=>$tplPostReview,
							'%REQUEST_SLUG%'=>$slug,
							'%REVIEW_CONTENT%'=>$reviewContent

						);
					$content .= get_view(DIR_TMPL . $this->module . "/single-request-nct.tpl.php",$replaceArr);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}
			}
		}else{
			$retData['html'] = $content;
			if($this->pageNo == 1){
				$retData['html'] =getNoRecordFoundContent();
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	/*Post Review Popup*/
	public function getPostReviewPopup($data=array()){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';

		//checking whether any review is pending from user(buyer)
		if($this->sessUserId > 0){
			$order_array = array();
			$review_q = $this->db->pdoQuery("SELECT o.id,o.txnId,r.slug
				FROM tbl_orders AS o
				INNER JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
				WHERE o.userId = ? AND ( o.status = ? OR o.status = ? ) AND o.orderType = ? AND r.slug = ?  ORDER BY o.id DESC ",
				array($this->sessUserId,'c','l','r',$data['reqSlug']));

			if($review_q->affectedRows() > 0){
				$review_r = $review_q->result();

				$replace = array(
					'%ORDER_ID%'=>$review_r['txnId'],
					'%REQUEST_SLUG%'=>$review_r['slug']
				);
				$return['data'] = get_view(DIR_TMPL.$this->module."/post-review-modal-nct.tpl.php",$replace);
				$return['status'] = true;
			}
			else{
				$return['message'] =  REQUEST_PAGE_MSG_NO_ORDERS_FOR_REVIEW;
			}
		}
		else{
			$return['message'] =  REQUEST_PAGE_MSG_LOGIN_REQUIRED;
		}
		//checking whether any review is pending from user(buyer)

		return $return;
	}
	public function postReviewForRequest($data=array())
	{
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $orderId 	= filtering(issetor($orderId,""),'input','string');
        $rating 	= filtering(issetor($rating,0),'input','float');
        $review 	= filtering(issetor($review,''),'input','text');
        $slug 	= filtering(issetor($slug,''),'input','string');

        if($orderId  != "" && $rating  > 0 && $review != '' && $slug != ''){
        	$q = $this->db->pdoQuery("SELECT o.id,o.txnId,o.sellerId
				FROM tbl_orders AS o
				INNER JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r' )
				WHERE o.txnId = ? AND o.userId = ? AND ( o.status = ? OR o.status = ? ) AND o.orderType = ? AND r.slug = ?  LIMIT 1 ",
				array($orderId,$this->sessUserId,'c','l','r',$slug));

        	if($q->affectedRows() > 0){
        		$q_res = $q->result();
        		$check = $this->db->pdoQuery("SELECT id FROM tbl_reviews WHERE orderId = ? AND userFrom = ? ",array($q_res['id'],$this->sessUserId))->affectedRows();
        		if($check <= 0){
        			$orderId = $q_res['id'];
        			$insertArray = array(
        				'orderId'		=>$orderId,
        				'userFrom'		=>$this->sessUserId,
        				'userTo'		=>$q_res['sellerId'],
        				'review'		=>$review,
        				'rating'		=>strval($rating),
        				'ipAddress'		=>get_ip_address(),
        				'createdDate'	=>date('Y-m-d H:i:s'),
        				'updatedDate'	=>date('Y-m-d H:i:s')
        			);
        			$rid = $this->db->insert('tbl_reviews',$insertArray)->getLastInsertId();
        			//send notification
					$notification_type = 'review_posted_for_request';
					$data_array = array(
						'receiverId'	=>$q_res['sellerId'],
						'senderId'		=>$this->sessUserId,
						'notifyId'		=>$notification_type,
						'entityId'		=>$rid,
						'orderId'		=>$orderId,
						'rating'		=>$rating,
						'review'		=>$review,
						'txnId'			=>$q_res['txnId'],
					);
					addNewNotificationForUser($notification_type,$data_array);
					//send notification
					if($this->sessRequestType == 'web'){
        				$review 	= filtering(issetor($review,''),'output','text');

						$replaceArr = array('%STAR_RATTING%' => $rating,'%REVIEW%'=>$review);
						$content = get_view(DIR_TMPL . $this->module . "/rating-html-nct.tpl.php",$replaceArr);
						$return['data'] = $content;
					}
					$return['status'] = true;
					$return['message'] =  REQUEST_PAGE_MSG_POST_REVIEW_SUCCESS;
        		}
        		else{
        			$return['message'] =  REQUEST_PAGE_MSG_ALREADY_POST_REVIEW;
        		}
        	}
        	else{
        		$return['message'] =  REQUEST_PAGE_MSG_NO_ORDERS_FOR_REVIEW;
        	}
        }
        else{
        	$return['message'] =  MSG_FILL_ALL_VALUE;
        }
        return $return;
	}
}

?>
