<?php
class Blogs {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		extract($contentArray);
		$this->module = $module;
		$this->slug = issetor($slug);
		$this->keyword = issetor($keyword);

	}
	public function getPageContent($request = array()) {

		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$slug = issetor($request['slug']);
		$keyword = issetor($request['keyword']);
		$blogCatList = $this->getBlogCategoryList($slug);
		$blogList = $this->getBlogList($request);
		$popularBlogList = $this->getPopularBlogList();
		$popularBloCategoryList = $this->getPopularBlogCategoryList();
		$replaceArr = array(
							'%KEYWORD%'=>filtering($keyword),
							'%BLOG_CATEGORY_LIST%' => $blogCatList,
							'%BLOG_LIST%' => $blogList['data']['html'],
							'%BLOG_PAGINATION%' => $blogList['data']['pagination'],
							'%POPULAR_BLOG_LIST%' => $popularBlogList,
							'%POPULAR_BLOG_CATEGORY_LIST%' => $popularBloCategoryList,
							'%HIDE_SHOW_CLASS%'=>$this->sessUserId > 0 ? '' : 'hide'
						);
		$content = get_view($tplUrl,$replaceArr);
		$returnContent['html'] = $content;
		$returnContent['ogData'] = $blogList['data']['ogData'];
		return $returnContent;
	}

	public function getBlogCategoryList($slug = "") {
		$cateHtml = "";
		$getCat =  $this->db->select("tbl_blog_category",array('*'),array('isActive'=>'y'));
		if($this->sessRequestType == 'web'){

			$replace = array(
							'%OPT_VALUE%'=> "",
							'%OPT_TEXT%'=> CATEGORY,
							'%EXTRA%'=>'',
							'%SELECTED%'=>'',
						);
			$cateHtml .= get_view(DIR_TMPL . "/option-nct.tpl.php",$replace);

		}
		if($getCat->affectedRows() > 0){
			$getCatResult = $getCat->results();
			foreach ($getCatResult as $key => $catData) {
				$id = $catData['id'];
				$blogCateName = filtering($catData['blogCateName_'.$this->lId]);
				$cateSlug = filtering($catData['slug']);
				if($this->sessRequestType == 'web'){
					$replace = array(
							'%OPT_VALUE%'=>$id,
							'%OPT_TEXT%'=>$blogCateName,
							'%EXTRA%'=>'data-slug = "'.$cateSlug.'"',
							'%SELECTED%'=>$slug == $cateSlug ? "selected" : NULL,
						);
					$cateHtml .= get_view(DIR_TMPL . "option-nct.tpl.php",$replace);
				}
			}
		}
		return $cateHtml;
	}

	public function getBlogList($request = array()) {
		$whrCondition = $content = "";
		$returnResponse = array();
		extract($request);

		$slug = issetor($slug,$this->slug);
		$keyword = issetor($keyword,$this->keyword);
		$this->pageNo = issetor($this->pageNo,1);
		$whrArr = array();
		if($slug != ""){
			$whrCondition .= " AND bc.slug = ? ";
			$whrArr[] = $slug;
		}
		if($keyword != ""){
			$whrCondition .= " AND (b.title_".$this->lId."  LIKE ? OR b.detail_".$this->lId." LIKE ? OR bc.blogCateName_".$this->lId." LIKE ? )";
			$whrArr[] = "%$keyword%";
			$whrArr[] = "%$keyword%";
			$whrArr[] = "%$keyword%";
		}
		$qry ="SELECT b.* FROM tbl_blog AS b INNER JOIN tbl_blog_category AS bc ON bc.id = b.blogCateId WHERE b.isActive = 'y' AND bc.isActive = 'y' ".$whrCondition." ORDER BY b.createdDate DESC";

		$blog = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $blog->affectedRows();

		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$blogQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $blogQuery->affectedRows();

		if($NoOfrows > 0){
			$blogList = $blogQuery ->results();
			foreach ($blogList as $key => $blogData) {

				$id = $blogData['id'];
				$title = filtering($blogData['title_'.$this->lId]);
				$detail = ($blogData['detail_'.$this->lId]);
				$blogImg = checkImage($blogData['blogImage'],10,$id);
				$createdDate = convertDate($blogData['createdDate']);
				$slug = filtering($blogData['slug']);
				$url = SITE_URL.'blog-detail/'.$slug;
				$blogDetail = myTruncate(filtering($detail),150);
				if($this->sessRequestType == 'web'){


					if($key == 0){
						$tplUrl = "first-blog-list-nct.tpl.php";
						$retData['ogData']['blogImage'] = $blogImg;
						$retData['ogData']['title'] = $title;
						$retData['ogData']['detail'] = $blogDetail;
						$blogDetail = myTruncate(filtering($detail),1000);
						/*$blogDetail = nl2br($blogDetail);*/

					}else{
						$tplUrl = "single-blog-list-nct.tpl.php";
					}
					$replaceArr = array(
							'%BLOG_LINK%' => $url,
							'%BLOG_TITILE_FULL%' => $title,
							'%BLOG_TITILE%' => myTruncate($title,30),
							'%BLOG_DATE%' => $createdDate,
							'%BLOG_IMG%' => $blogImg,
							'%BLOG_CONTENT%' => $blogDetail,
						);
					$content .= get_view(DIR_TMPL . $this->module . "/" .$tplUrl,$replaceArr);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}
			}
		}else{
			$retData['html'] = $content;
			$retData['ogData'] = "";
			if($this->sessRequestType == 'web'){
				$retData['html'] = getNoRecordFoundContent();
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	public function getPopularBlogList(){
		$content = "";

	    $date = date('Y-m-d H:i:s');
		$back30days = date('Y-m-d H:i:s', strtotime('-30 days'));

		$blog = $this->db->pdoQuery("SELECT b.*,COUNT(bv.id) AS view FROM tbl_blog AS b INNER JOIN tbl_blog_view AS bv ON bv.blogId = b.id WHERE b.isActive = 'y' AND bv.createdDate > ? GROUP BY b.id ORDER BY view DESC LIMIT 0,5",array($back30days));

		if($blog->affectedRows() >  0){
			$blog = $blog->results();
			foreach ($blog as $key => $blogData) {
				$id = $blogData['id'];
				$title = filtering($blogData['title_'.$this->lId]);
				$detail = filtering($blogData['detail_'.$this->lId]);
				$blogImg = checkImage($blogData['blogImage'],10,$id);
				$createdDate = convertDate($blogData['createdDate']);
				$slug = filtering($blogData['slug']);
				$url = SITE_URL.'blog-detail/'.$slug;
				if($this->sessRequestType == 'web'){
					$replaceArr = array(
							'%BLOG_URL%' => $url,
							'%BLOG_TITILE_FULL%' => $title,
							'%BLOG_TITILE%' => myTruncate($title,30),
							'%BLOG_DATE%' => $createdDate,
							'%BLOG_IMG%' => $blogImg,
						);
					$content .= get_view(DIR_TMPL . $this->module . "/single-popular-blog-nct.tpl.php" ,$replaceArr);

				}
			}
		}else{
			$content = getNoRecordFoundContent();
		}

		return $content;
	}

	public function getPopularBlogCategoryList(){
		$content = "";

	    $date = date('Y-m-d H:i:s');
		$back30days = date('Y-m-d H:i:s', strtotime('-30 days'));

		$blogCat = $this->db->pdoQuery("SELECT bc.*,COUNT(bv.id) AS view FROM tbl_blog AS b LEFT JOIN tbl_blog_category AS bc ON bc.id = b.blogCateId LEFT JOIN tbl_blog_view AS bv ON bv.blogId = b.id WHERE b.isActive = 'y' AND bv.createdDate > ? AND bc.isActive = 'y' GROUP BY b.blogCateId ORDER BY view DESC  LIMIT 0,5",array($back30days));

		if($blogCat->affectedRows() >  0){
			$blogCat = $blogCat->results();
			foreach ($blogCat as $key => $blogCatData) {
				$blogCateName = filtering($blogCatData['blogCateName_'.$this->lId]);
				$createdDate = convertDate($blogCatData['createdDate']);
				$slug = filtering($blogCatData['slug']);
				$url = $slug;
				if($this->sessRequestType == 'web'){
					$replaceArr = array(
							'%BLOG_CAT_LINK%' => $url,
							'%BLOG_CAT_TITLE_FULL%' => $blogCateName,
							'%BLOG_CAT_TITLE%' => myTruncate($blogCateName,30),
						);
					$content .= get_view(DIR_TMPL . $this->module . "/single-popular-blog-category-nct.tpl.php" ,$replaceArr);

				}
			}
		}else{
			$content = getNoRecordFoundContent();
		}

		return $content;
	}

}

?>
