function scrollToTop(argument) {
    $("html, body").animate({
        scrollTop: 0
    }, "slow");
}

function scrollToElement(e) {
    $('html, body').animate({
        scrollTop: $(e).offset().top
    }, 1000);
}

function changeLanguage(languageId) {
	$.post(SITE_URL, {
		"language": languageId
	}, function(e) {
		window.location.reload();
	});
	return;
}

function changeCurrency(e){
	showLoader();
	$.post(SITE_URL,{
		currency:e , action : 'changeCurrency'
	},function(e){
		window.location.reload();
	});
}

$(document).ready(function($) {
	$(document).on("change", "#language", function() {
		changeLanguage($(this).val());
	});

	$(document).on("change", "#currency", function() {
		changeCurrency($(this).val());
	});
});

$(document).on('click', '#subscribe', function() {
	if ($("#subscribe_frm").valid()) {
		newsletterFunction();
	}
});
$(document).on('submit', '#subscribe_frm', function(e) {
	e.preventDefault();
	newsletterFunction();
})

function newsletterFunction() {
	var emailSub = $(".emailSub").val();
	$.ajax({
		url: SITE_URL ,
		dataType: 'json',
		type: 'post',
		data: {
			email: emailSub,
			action: 'subscribeNewsletter'
		},
		beforeSend: function() {
			showLoader();
		},
		complete: function() {
			//scrollToTop();
			hideLoader();
		},
		success: function(response) {
			$("#emailSub").val('');
			$(function() {
				toastr[response.type](response.message);
			});
		},
		error: function(response) {
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
	});
}
$subscribe_frm = "#subscribe_frm"; {
	$($subscribe_frm).validate({
		rules: {
			email: {
				required: true,
				email: true
			}
		},
		messages: {
			email: {
				required: lang.MSG_EMAIL_REQ
			}
		}
	});
}

function showLoader(argument) {
	$("#loading_ajax").removeClass('loaded');
}
function hideLoader(argument) {
	$("#loading_ajax").addClass('loaded');
}

function exchangeRateJs(amount){
	/*defaultCurrencyRate and selectedCurrencyRate stored in footer panel*/
	amount = (amount && amount !== null && amount !== undefined && amount > 0) ? amount : 0;

	var from = defaultCurrencyRate;
	var to = selectedCurrencyRate;
	if (from) {
		conversion_rate  = from / to;
		value = amount / conversion_rate;
	} else {
		value = 0;
	}
	return value;
}

function refreshSelect(name){
	name = (name && name !== null && name !== undefined && name != "") ? name : '.selectpicker';
	$(name).selectpicker('refresh');
}

function dispRatting(){
	$('.disp-rating').raty({
		readOnly: true,
		score: function() {return $(this).attr('data-score');}
	});
}

function initilizeRaty(control_name, score) {
    $(control_name).raty({
        scoreName: 'star_ratings',
        score: score,
        half: true,
        starHalf: SITE_PLUGIN+'raty/images/star-half.png',
        starOff: SITE_PLUGIN+'raty/images/star-off.png',
        starOn: SITE_PLUGIN+'raty/images/star-on.png',
        hints: [lang.SERVICE_DETAILS_PAGE_LBL_RATING_BAD,lang.SERVICE_DETAILS_PAGE_LBL_RATING_POOR,lang.SERVICE_DETAILS_PAGE_LBL_RATING_REGULAR, lang.SERVICE_DETAILS_PAGE_LBL_RATING_GOOD, lang.SERVICE_DETAILS_PAGE_LBL_RATING_EXCELLENT]
    });
}

function manageFavourite(serviceId,obj) {
	if(serviceId > 0){
		$.ajax({
				method: 'POST',
				url: SITE_URL ,
				data: {
					action: 'manageFavourite',
					serviceId: serviceId,
				},
				dataType: 'json',
				beforeSend: function() {
					showLoader();
				},
				complete: function() {
					hideLoader();
				},
				success: function(data) {
					if(data.type == 'success'){
						obj.find('span').removeAttr('class').addClass(data.clsName);
					}
					toastr[data.type](data.message);
				}
			});
	}
}
function manageBuyerCollections(serviceId,obj) {
	if(serviceId > 0){
		$.ajax({
			method: 'POST',
			url: SITE_URL ,
			data: {
				action: 'getBuyerCollectionList',
				serviceId: serviceId,
			},
			dataType: 'json',
			beforeSend: function() {
				showLoader();
			},
			complete: function() {
				hideLoader();
			},
			success: function(data) {
				if(data.type == 'error'){
					toastr[data.type](data.message);
				}else{

					$("#collectionModalContent").html(data.collectionForm);

					refreshSelect();
					$('#collectionModal').modal('show');

					/*manage validations*/
					$frmAddRemoveCollection = "#frmAddRemoveCollection"; {
						$($frmAddRemoveCollection).validate({
							ignore: "",
							rules: {
								"collections[]": {
									required: true
								},
							},
							messages: {
								"collections[]": {
									required: lang.MSG_SELECT_COLLECTIONS
								},
							}
						});
					}
				}
			}
		});
	}
}

$(document).ready(function() {
	dispRatting();
	$(document).on('click', '.fav_service', function(event) {
		event.preventDefault();
		var $this = $(this);
		var serviceId = $this.attr('data-id');
		manageFavourite(serviceId,$this)
	});
	$(document).on('click', '.collection_service', function(event) {
		event.preventDefault();
		var $this = $(this);
		var serviceId = $this.attr('data-id');
		manageBuyerCollections(serviceId,$this);
	});
	$(document).on('submit', '#frmAddRemoveCollection', function(event) {
		event.preventDefault();
		var formData = new FormData(this);
		formData.append('action', 'submitBuyerCollection');
		$.ajax({
			url: SITE_URL,
			type: 'post',
			data: formData,
			dataType: 'json',
			contentType: false,
			processData: false,
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				toastr[response.type](response.message);
				$('#collectionModalContent').html('');
				$('#collectionModal').modal('hide');
				hideLoader();

			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	});

	$(document).on('click', '.view_pass', function(event) {

		var x = $(this).next('input').attr('type');
		var classNm = $(this).attr('class');

	    if (x === "password") {
	        attrType = "text";
	        $(this).removeClass('fa-eye').addClass('fa-eye-slash');
	    } else {
	        attrType = "password";
	        $(this).removeClass('fa-eye-slash').addClass('fa-eye');
	    }
	    $(this).next('input').attr('type', attrType);
	});
});

$(document).on('hidden.bs.select', '.selectpicker', function(e, clickedIndex, isSelected, previousValue){
	var id = $(this).attr('id');
	if($(this).hasClass('custom_select_change')){
		$(this).valid();
	}
});

// Facebook Share
function shareOnFB(getlink,getpicture,getname,getcaption) {
	var e = {
		method: "feed",
		link: getlink,
		picture:getpicture,
		name: getname,
		caption: getcaption
	};
	FB.ui(e, function(t) {
	});
}
(function(d, s, id) {
var js, fjs = d.getElementsByTagName(s)[0];
if (d.getElementById(id)) return;
js = d.createElement(s); js.id = id;
js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&appId="+FB_APP_ID+"&version=v2.9";

fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));

// Google Share
function googlePlusShare(url){
	window.open("https://plus.google.com/share?url="+url,"","height=550,width=525,left=100,top=100,menubar=0");
	return false;
}

// Twitter Share
function shareTwitter(text,link){
	window.open("http://twitter.com/share?text="+text+"&url="+link,"", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600");
}

// LinkedIn Share
function ldShare(url,title,submitted_image_url,winWidth, winHeight){
  if (typeof(winWidth)==='undefined') winWidth = 525;
  if (typeof(winHeight)==='undefined') winHeight = 550;
    window.open('http://www.linkedin.com/shareArticle?title='+title+'&submitted-image-url='+submitted_image_url+'&url=' + url, 'sharer',"height="+winHeight+",width="+winWidth+",left=100,top=100,toolbar=0,status=0");
}

//submit form via ajax with call back function
function ajaxFormSubmit(form_element,callbabk_fun) {
    var sub_btn = $(form_element).find('button[type=submit]').attr('name');
    var add_btn = 'y';
    if ($('input[name="'+sub_btn+'"]').length > 0){
    	if($('input[name="'+sub_btn+'"]').attr('type') == 'hidden') add_btn = 'n';
    }
    if(add_btn =='y'){
    	$('<input>').attr({
	        type: 'hidden',
	        id: sub_btn,
	        name: sub_btn,
	        value: sub_btn
	    }).appendTo(form_element);
    }
    $(form_element).ajaxSubmit({
        beforeSend: function () {
            showLoader();
        },
        uploadProgress: function (event, position, total, percentComplete) {
        },
        success: function (html, statusText, xhr, $form){
            obj = $.parseJSON(html);
            if (obj.status) {
            	if(obj.message && obj.message !== undefined && obj.message != ''){
            		toastr["success"](obj.message);
            	}
                if(callbabk_fun && callbabk_fun !== undefined  && typeof (eval(callbabk_fun)) === 'function'){
                    if (typeof window[(callbabk_fun)] === 'function') {
                        window[(callbabk_fun)](obj);
                    } else {
                        callbabk_fun(obj);
                    }
                }
            } else {
            	if(obj.redirectLink && obj.redirectLink !== null && obj.redirectLink !== undefined && obj.redirectLink != ''){
					window.location.href = obj.redirectLink;
				}
            	if(obj.message && obj.message !== undefined && obj.message != ''){
            		toastr["error"](obj.message);
            	}
            }
            return false;
        },
        complete: function (xhr) {
            hideLoader();
            return false;
        }
    });
}
//submit form via ajax with call back function

//after login header form submit
$(document).on('submit','#headerformSearch',function(e){
	var keyword = $("#headerformSearch #headerkeyword").val();
	var q = '';
	q += (q != '' ? "&keyword="+keyword+"" : "keyword="+keyword+"");
	$("#headerformSearch").attr('action',SITE_URL+"search-services/?"+q);
	return true;
});
$(document).on('submit','#headerformSearchRes',function(e){
	var keyword = $("#headerformSearchRes #headerkeywordRes").val();
	var q = '';
	q += (q != '' ? "&keyword="+keyword+"" : "keyword="+keyword+"");
	$("#headerformSearchRes").attr('action',SITE_URL+"search-services/?"+q);
	return true;
});
//after login header form submit