var offerUrl = SITE_URL+'ajax-view-offer/';
$(document).ready(function($) {
   	readMore();
   	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$('#pageNo').val(pageNo);
	    getOfferList();
	});
	$(document).on('click', '.acceptReject', function(event) {
		var $this = $(this);
		var notiId = $this.attr('data-id');
		var actionType = $this.attr('data-type');
		$.ajax({
	        url: offerUrl,
	        type: 'POST',
	        data: {
				    actionType: actionType,
				    notiId: notiId,
				    action: 'acceptReject'
			    },
	        dataType: 'json',
	        beforeSend: function() {
				showLoader();
			},
			success: function(response) {

				if(response.status){
					
					$this.closest('.offer_detail').html(response.data);
					if(actionType == 'accept'){
						$(".acceptReject").remove();
					}
					toastr['success'](response.message);
				}else{
					toastr['error'](response.message);

				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
	    });
	});
	
	$(document).on('click', '.payNow', function(event) {
		event.preventDefault();
		$this = $(this);
		var offerId = $this.attr('data-id');
		if(offerId > 0){
			$.ajax({
		        url: $this.attr('href'),
		        type: 'POST',
		        data: {
		        		offerId:offerId,
				    },
		        dataType: 'json',
		        beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					/*if (typeof (history.pushState) != "undefined") {
				        var obj = { Title: 'search', Url: dataurl };
				        history.pushState(obj, obj.Title, obj.Url);
				    }*/
					if(response.type == 'success'){
						location.href = response.url;
					}else{
						hideLoader();
						toastr['error'](response.message);
					}
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
		    });
		}else{
			toastr['error'](lang.MSG_SOMETHING_WRONG);

		}
	});
});
function readMore() {
	$(".requestDetail").shorten({
        "showChars" : 200,
        "moreText"  : VIEW_MORE,
        "lessText"  : VIEW_LESS,
    });
}

function getOfferList() {
	var catSlug = $('#reqCategory').val();
	var pageNo = $('#pageNo').val();
	var slug = $('#slug').val();
	/*dataurl = SITE_URL + 'my-requests/?action=getOfferList&' +'catSlug='+catSlug+'&keyword='+keyword+'&pageNo='+pageNo; */
	$.ajax({
        url: offerUrl,
        type: 'POST',
        data: {
			    catSlug: catSlug,
			    pageNo: pageNo,
			    slug: slug,
			    action: 'getOfferList'
		    },
        dataType: 'json',
        beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			/*if (typeof (history.pushState) != "undefined") {
		        var obj = { Title: 'search', Url: dataurl };
		        history.pushState(obj, obj.Title, obj.Url);
		    }*/
			if(response.status){
				$('#offer_content_list').html(response.data.html);
				$('.pagination_div').html(response.data.pagination);
			}
			readMore();
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
    });
}