var reqNotiUrl = SITE_URL+'request-notification/';
$(document).ready(function($) {
   	readMore();
    $(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$('#pageNo').val(pageNo);
	    getRequestNotificationList();

	});
	$(document).on('change', '#reqCategory', function(event) {
		getRequestNotificationList();
		$('#pageNo').val(1);

	});

    $("#deliveryDate").datetimepicker({
		startDate: new Date(),
       	format: "yyyy-mm-dd",
       	minView : 2,
       	pickTime: false,
       	autoclose:true
   });


	$(document).on('click', '.sendOffer', function(event) {
		var $this = $(this);
		var reqSlug = $this.siblings('.requestSlug').val();
		$.ajax({
	        url: reqNotiUrl,
	        type: 'POST',
	        data: {
				    reqSlug: reqSlug,
				    action: 'checkOfferStatus'
			    },
	        dataType: 'json',
	        beforeSend: function() {
				showLoader();
			},
			success: function(response) {

				if(response.status){
					if(response.showModal){
						$("#requestSlug").val(reqSlug);
						$('#postOfferModal').modal('show');
					}else{
						toastr['info'](response.message);
						$this.closest('.offer_detail').html(response.data);
					}
					/*$this.closest('.offer_detail').html(response.data);*/
				}else if(response.pageReload == 'y'){
					window.location.reload();
				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
	    });
	});
	$(document).on('hidden.bs.modal', '#postOfferModal', function(event) {
		$('#offerForm')[0].reset();
		$('#offerForm').valid();
		$('#requestSlug').val('');
	});

	$(document).on('submit', '#offerForm', function(event) {
		if($(this).valid()){
			var dataString = $(this).serialize();
			var slugClass = $('#requestSlug').val();
			$.ajax({
				url: reqNotiUrl,
				dataType: 'json',
				type: 'post',
				data: dataString,
				beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$('#postOfferModal').modal('hide');
						$('.'+slugClass).html(response.data);
						toastr['success'](response.message);
						readMore();
					}else{
						toastr['error'](response.message);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
			});
		}else{
		}
	});

	$("#offerForm").validate({
		rules: {
			description: {
				required: true,
				customvalidation:true
			},
			deliveryDate: {
				required: true
			},
			offerAmount: {
				required: true,
				number:true,
                min:1,
			},
		},
		messages: {
			description: {
				required: lang.MSG_DESC_REQ
			},
			deliveryDate: {
				required: lang.MSG_DELE_DATE_REQ
			},
			offerAmount: {
				required: lang.MSG_OFFER_AMOUNT_REQ,
				number: lang.MSG_ENTER_VALID_AMOUNT,
				min: lang.MSG_ENTER_VALID_AMOUNT,
			},
		}
	});

	$.validator.addMethod('customvalidation',function (value, element) {
		if(this.optional(element) || /<\/?[^>]+(>|$)/g.test(value)){
	        return false;
	    } else {
	        return true;
	    }
		},lang.INVALID_VALUE_ENTERED
	);
	$(document).on('click', '.removeRequest', function(event) {
		event.preventDefault();
		var $this = $(this);
		var requestSlug = $this.siblings('.requestSlug').val();
		if(confirm(lang.MSG_CONFIRM_REMOVE_REQ_NOTI)) {

			$.ajax({
		        url: reqNotiUrl,
		        type: 'POST',
		        data: {
					    requestSlug: requestSlug,
					    action: 'removeRequestNoti'
				    },
		        dataType: 'json',
		        beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$this.closest('.request_listing').remove();
						toastr['success'](response.message);
					}else{
						toastr['error'](response.message);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
		    });
		}
	});
});
function readMore() {
	$(".requestDetail").shorten({
        "showChars" : 200,
        "moreText"  : VIEW_MORE,
        "lessText"  : VIEW_LESS,
    });
}

function getRequestNotificationList() {
	var catSlug = $('#reqCategory').val();
	var pageNo = $('#pageNo').val();
	/*dataurl = SITE_URL + 'my-requests/?action=getRequestNotificationList&' +'catSlug='+catSlug+'&keyword='+keyword+'&pageNo='+pageNo; */
	 $.ajax({
        url: reqNotiUrl,
        type: 'POST',
        data: {
			    catSlug: catSlug,
			    pageNo: pageNo,
			    action: 'getRequestNotificationList'
		    },
        dataType: 'json',
        beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			/*if (typeof (history.pushState) != "undefined") {
		        var obj = { Title: 'search', Url: dataurl };
		        history.pushState(obj, obj.Title, obj.Url);
		    }*/
			if(response.status){
				$('#request_content_list').html(response.data.html);
				$('.pagination_div').html(response.data.pagination);
			}
			readMore();
			dispRatting();
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
    });
}