$(document).ready(function($) {
	var oldName = $('#fileName').text();
     $.validator.addMethod('customvalidation',function (value, element) {
        if(this.optional(element) || /<\/?[^>]+(>|$)/g.test(value)){
            return false;
        } else {
            return true;
        }
        },lang.INVALID_VALUE_ENTERED
    );
	$(document).on('change','input[type="file"]',function(e){
		if(e.target.files[0] === undefined){
                $('#fileName').html(oldName);

		}else{
			var fileName = e.target.files[0].name;
			if(fileName.length > 0){
				$('#fileName').html(fileName);
            }
		}
        $("#requestDoc").valid();

	})

	$(document).on('change','#category',function(e){
		var catSlug = $(this).val();
        var catId = $("option[value=" + catSlug + "]", this).attr('data-id');

		$.ajax({
			url: SITE_URL+'post-a-request/',
			dataType: 'json',
			type: 'post',
			data: {
				action: 'getSubCategoryList',
				catId: catId,
			},
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				$('#subcategory').html(response.retData);
				refreshSelect();
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});

	});

	$("#frmPostRequest").validate({
        ignore:"",
            rules: {
                description: {
                    required: true,
                    customvalidation:true,
                },
                requestDoc: {
                    required: true,
                    extension: "docx|doc|pdf"
                },
                catId: {
                    required: true,
                },
                subCatId: {
                    required: true,
                },
                duration: {
                    required: true,
                    min:1
                },
                budget: {
                    required: true,
                    number : true,
                }
            },
            messages: {
                description: {
                    required: lang.MSG_DESC_REQ,
                },
                requestDoc: {
                    required: lang.MSG_DOC_REQ,
                    extension: lang.MSG_SELECT_VALID_FILE
                },
                catId: {
                    required: lang.MSG_CAT_REQ,
                    /*min: lang.MSG_CAT_REQ,*/
                },
                subCatId: {
                    required: lang.MSG_SUB_CAT_REQ,
                    /*min: lang.MSG_SUB_CAT_REQ,*/
                },
                duration: {
                    required: lang.MSG_DURATION_REQ,
                    min: lang.MSG_DURATION_REQ,
                },
                budget: {
                    required: lang.MSG_BUDGET_REQ,
                    number: lang.MSG_VALID_BUDGET
                },
            },
            errorPlacement: function (error, element) {
                if (element.attr("data-error-container")) {
                  error.appendTo(element.attr("data-error-container"));
                } else {
                  error.insertAfter(element);
                }
            }
        });
		jQuery.validator.addMethod("extension", function (value, element, param) {
                param = typeof param === "string" ? param.replace(/,/g, '|') : "png|jpe?g|gif";
                return this.optional(element) || value.match(new RegExp(".(" + param + ")$", "i"));
            }, jQuery.format("Please enter a value with a valid extension."));

});
