function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	var buyerId = $("#buyerId").val();
	var keyword = $("#keyword").val();
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
			buyerId:buyerId,
			keyword:keyword
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".contact-table .inner_loader").remove();
			$(".contact-table .tbody").remove();
			$(".search_contacts_div").append(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			scrollToElement(".my-contacts");
			hideLoader();

		}
	});
}

$(document).ready(function() {
	getPaginationData(1);
});
$(document).on("click",".buttonPage",function(){
	var pageNo = $(this).data('page');
	getPaginationData(pageNo);
});

$(document).on('change','#keyword,#buyerId',function(){
	getPaginationData(1);
});