var purchaseUrl = SITE_URL+'manage-purchase/';
$(document).ready(function($) {
   	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$('#pageNo').val(pageNo);
	    getPurchaseList();
	});
   	$(document).on("change","#changeStatus",function(){
		$('#pageNo').val(1);
	    getPurchaseList();
	});
   	$(document).on("change","#changeType",function(){
		$('#pageNo').val(1);
	    getPurchaseList();
	});
	$(document).on('keypress', '.search', function(event) {
		var myVal = $(this).val();
		var keycode = (event.keyCode ? event.keyCode : event.which);
	    if(keycode == '13'){
			$("#keyword").val(myVal);
			$("#pageNo").val(1);
			getPurchaseList();
	    }
	});
   	$(document).on("click",".operation",function(){
   		var $this = $(this);
   		var actionType = $this.attr('data-type');
   		var orderId = $this.closest('.main-tbody-div').attr('data-id');
   		if (confirm(lang.MSG_CONF_CHANGE_STATUS)) {
	   		$.ajax({
		        url: purchaseUrl,
		        type: 'POST',
		        data: {
					    orderId: orderId,
					    actionType: actionType,
					    action: 'changeStatus'
				    },
		        dataType: 'json',
		        beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$this.closest('.main-tbody-div').find('.div-status').find('label').html(response.dispStatus);
						$this.closest('.main-tbody-div').append(response.data);
						$this.closest('.div-operation').remove();
					}else{
						toastr['error'](response.message);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
		    });
	   	}
   	});

});


function getPurchaseList() {
	var keyword = $('#keyword').val();
	var pageNo = $('#pageNo').val();
	var orderStatus = $('#changeStatus').val();
	var orderType = $('#changeType').val();
	$.ajax({
        url: purchaseUrl,
        type: 'POST',
        data: {
			    pageNo: pageNo,
			    orderType: orderType,
			    orderStatus: orderStatus,
			    keyword: keyword,
			    action: 'getPurchaseList'
		    },
        dataType: 'json',
        beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			if(response.status){
				$(".tbody").remove()
				$('.thead').after(response.data.html);
				$('.pagination_div').html(response.data.pagination);
			}
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
    });
}