$(function(e) {
    $(document).on('click', '#btnChangePwd', function(e) {
        e.preventDefault();
        jQuery.validator.addMethod("notSame", function(value, element) {
            return $('#oldPwd').val() != $('#newPwd').val()
        }, 'Current Password and New Password can not be same.');
        $("#frmChngPwd").validate({
            rules: {
                oldPwd: {
                    required: true,
                    maxlength: 32,
                    remote: {
                        url: SITE_URL + 'change-password/',
                        type: "post",
                        async: false,
                        data: {
                            oldPwd: function() {
                                return $("#oldPwd").val();
                            },
                            method: 'checkValidate'
                        }
                    }
                },
                newPwd: {
                    required: true,
                    minlength: 6,
                    maxlength: 32,
                    notSame: true
                },
                cnfNewPwd: {
                    required: true,
                    minlength: 6,
                    equalTo: newPwd,
                    maxlength: 32
                }
            },
            messages: {
                oldPwd: {
                    remote: lang.MSG_CURR_PASS_NOT_MATCH,
                    required: lang.MSG_CURR_PASS_REQ
                },
                newPwd: {
                    required: lang.MSG_NEW_PASS_REQ,
                    minlength: lang.MSG_MIN_LENGTH_6
                },
                cnfNewPwd: {
                    required: lang.MSG_CONF_PASS_REQ,
                    minlength: lang.MSG_MIN_LENGTH_6,
                    equalTo: lang.MSG_PASS_EQUAL
                }
            },
            highlight: function (element, errorClass, validClass) {
                $(element).closest('.form-group').addClass('has-error');
            },            
            unhighlight: function (element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) { 
                //error.css('color',"#00bfa5")
                if (element.attr("data-error-container")) { 
                    error.appendTo(element.attr("data-error-container"));
                } else {
                    error.insertAfter(element);
                }
            }
        });
        if ($("#frmChngPwd").valid()) {
            $.ajax({
                method: 'POST',
                url: SITE_URL + 'change-password',
                data: {
                    action: 'changePassword',
                    newPwd: $("#newPwd").val(),
                    oldPwd: $("#oldPwd").val(),
                    cnfNewPwd: $("#cnfNewPwd").val()
                },
                dataType: 'json',
                beforeSend: function() {
                    showLoader();
                },
                success: function(data) {
                    location.reload();                    
                }
            });
            return true;
        } else {
            return false;
        }
    });
});