<?php

function redirectPage($url) {
    header('Location:' . $url);
    exit;
}

/*
 * returns parsed html if array not provided then returns without replacing variables
 * format for $replace array
 * $replace = array(
 *  '%variable1%' => $value1,
 *  '%variable2%' => $value2,
 *  '%variable3%' => $value3,
 *  '%variable4%' => $value4,
 * );
 */
function get_view($tpl_path, $replace = array()){
    $tpl        = new MainTemplater($tpl_path);
    $parsed_tpl = $tpl->parse();
    if (!empty($replace)) {
        return str_replace(array_keys($replace), array_values($replace), $parsed_tpl);
    } else {
        return $parsed_tpl;
    }
}


/* Santitize Output */

function sanitize_output($buffer) {

    $search  = array('/\>[^\S ]+/s', '/[^\S ]+\</s', '/(\s)+/s', '/<!--.*?-->|\t|(?:\r?\n[ \t]*)+/s');
    $replace = array('>', '<', '\\1', '');
    $buffer  = preg_replace($search, $replace, $buffer);
    return $buffer;
}

/* Use to remove whitespacs,Spaces and make string to lower case. Add '-' where Space. */

function Slug($string) {
    $slug = strtolower(trim(preg_replace('~[^0-9a-z]+~i', '-', html_entity_decode(preg_replace('~&([a-z]{1,2})(?:acute|cedil|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i', '$1', htmlentities($string, ENT_QUOTES, 'UTF-8')), ENT_QUOTES, 'UTF-8')), '-'));
    $slug_exists = slug_exist($slug);

    if($slug_exists) {
        $i = 1; $baseSlug = $slug;
        while(slug_exist($slug)){
            $slug = $baseSlug . "-" . $i++;
        }
    }

    return $slug;
}

function slug_exist($slug) {
    global $db;
    $sql          = "SELECT page_slug FROM tbl_content WHERE page_slug = '".$slug."' ";
    $content_page = $db->pdoQuery($sql)->result();

    if ($content_page) {
        return true;
    }
}

/* Comment Remaining */

function requiredLoginId() {
    global $sessUserType, $sesspUserId, $memberId;
    if (isset($sessUserType) && $sessUserType == 's')
        return $sesspUserId;
    else
        return $memberId;
}

function closetags($html) {
    #put all opened tags into an array
    preg_match_all('#<([a-z]+)(?: .*)?(?<![/|/ ])>#iU', $html, $result);

    $openedtags = $result[1];   #put all closed tags into an array
    preg_match_all('#</([a-z]+)>#iU', $html, $result);
    $closedtags = $result[1];
    $len_opened = count($openedtags);
    # all tags are closed
    if (count($closedtags) == $len_opened) {
        return $html;
    }
    $openedtags = array_reverse($openedtags);
    # close tags
    for ($i = 0; $i < $len_opened; $i++) {

        if (!in_array($openedtags[$i], $closedtags)) {

            $html .= '</' . $openedtags[$i] . '>';
        } else {

            unset($closedtags[array_search($openedtags[$i], $closedtags)]);
        }
    } return $html;
}

/* Get IP Address of current system. */

function get_ip_address() {
    foreach (array(
    'HTTP_CLIENT_IP',
     'HTTP_X_FORWARDED_FOR',
     'HTTP_X_FORWARDED',
     'HTTP_X_CLUSTER_CLIENT_IP',
     'HTTP_FORWARDED_FOR',
     'HTTP_FORWARDED',
     'REMOTE_ADDR'
        ) as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    if (filter_var($ip, FILTER_VALIDATE_IP) !== false) {
                        return $ip;
                    }
                }
            }
        }
}

/* Get Domain name from url */

function GetDomainName($url) {
    $now1   = ereg_replace('www\.', '', $url);
    $now2   = ereg_replace('\.com', '', $now1);
    $domain = parse_url($now2);
    if (!empty($domain["host"])) {
        return $domain["host"];
    } else {
        return $domain["path"];
    }
}

/* Generate Random String as type alpha,nume,alphanumeric,hexidec */

function genrateRandom($length = 8, $seeds = 'alphanum') {
    // Possible seeds
    $seedings['alpha']    = 'abcdefghijklmnopqrstuvwqyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $seedings['numeric']  = '0123456789';
    $seedings['alphanum'] = 'abcdefghijklmnopqrstuvwqyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $seedings['hexidec']  = '0123456789abcdef';
    // Choose seed
    if (isset($seedings[$seeds])) {
        $seeds = $seedings[$seeds];
    }
    // Seed generator
    list($usec, $sec) = explode(' ', microtime());
    $seed = (float) $sec + ((float) $usec * 100000);
    mt_srand($seed);
    // Generate
    $str = '';
    $seeds_count = strlen($seeds);
    for ($i = 0; $length > $i; $i++) {
        $str .= $seeds{mt_rand(0, $seeds_count - 1)};
    }
    return $str;
}
/* Sub admin Check Permission */

function checkPermission($usertype, $pagenm, $permission) {
    if ($usertype == 'a') {
        $flag = 0;
        $sadm_page = array('subadmin');
        if (in_array($pagenm, $sadm_page)) {
            $flag = 1;
        } else {
            $getval = getValFromTbl('id', 'adminrole', 'id IN (' . $permission . ') AND pagenm="' . $pagenm . '"');
            if ($getval == 0)
                $flag = 1;
        }
        if ($flag == 1) {

            $_SESSION['notice'] = NOTPER;
            redirectPage(SITE_URL . get_language_url() . 'admin/dashboard');
            exit;
        }
    }
}

/* Load Css Set directory and give filenname as array */

function load_css($filename = array()) {
    $returnStyle = '';
    $filePath = array();
    if (!empty($filename)) {
        if (domain_details('dir') == 'admin-nct') {
            foreach ($filename as $k => $v) {
                if (is_array($v)) {
                    if (isset($v[1]) && $v[1] != "") {
                        $filePath[] = $v[1] . $v[0];
                    } else {
                        $filePath[] = SITE_ADM_CSS . $v[0];
                    }
                } else {
                    $filePath[] = SITE_ADM_CSS . $v;
                }
            }
        } else {
            foreach ($filename as $k => $v) {
                if (is_array($v)) {
                    if (isset($v[1]) && $v[1] != "") {
                        $filePath[] = $v[1] . $v[0];
                    } else {
                        $filePath[] = SITE_CSS . $v[0];
                    }
                } else {
                    $filePath[] = SITE_CSS . $v;
                }
            }
        }
    }
    foreach ($filePath as $style) {
        $returnStyle .= '<link rel="stylesheet" type="text/css" href="' . $style . '">';
    }
    return $returnStyle;
}


/* Define JS variable */

function load_js_variable($js_variable = NULL) {
     $returnVariable = NULL;
    if($js_variable!=NULL){
            $returnVariable .= '<script type="text/javascript" >'.$js_variable .'</script>';

    }
    return $returnVariable;
}
/* Load JS Set directory and give filenname as array */

function load_js($filename = array()) {
    $returnScripts = '';
    $filePath = array();
    if (!empty($filename)) {
        if (domain_details('dir') == 'admin-nct') {
            foreach ($filename as $k => $v) {
                if (is_array($v)) {
                    if (isset($v[1]) && $v[1] != "") {
                        $filePath[] = $v[1] . $v[0];
                    } else {
                        $filePath[] = SITE_ADM_JS . $v[0];
                    }
                } else {
                    $filePath[] = SITE_ADM_JS . $v;
                }
            }
        } else {
            foreach ($filename as $k => $v) {
                if (is_array($v)) {
                    if (isset($v[1]) && $v[1] != "") {
                        $filePath[] = $v[1] . $v[0];
                    } else {
                        $filePath[] = SITE_JS . $v[0];
                    }
                } else {
                    $filePath[] = SITE_JS . $v;
                }
            }
        }
    }
    foreach ($filePath as $scripts) {
        $returnScripts .= '<script type="text/javascript" src="' . $scripts . '"></script>';
    }

    return $returnScripts;
}

/* Diplay message function */

function disMessage($msgArray, $script = true) {
    if(domain_details('dir') == 'admin-nct'){
        $script = false;
    }
    $message = '';
    $content = '';
    $type = isset($msgArray["type"]) ? $msgArray["type"] : NULL;
    //$message = isset($msgArray["var"]) ? $msgArray["var"] : NULL;
    $var = isset($msgArray["var"]) ? $msgArray["var"] : NULL;
    if (!is_null($var)) {
        switch ($var) {
            case 'loginRequired' : {
                    $message = "Please login to continue";
                    break;
                }
            case 'invaildUsers' : {
                    $message = "Invalid username/email or password";
                    break;
                }
            case 'NRF' : {
                    $message = "No result found";
                    break;
                }
            case 'alreadytaken': {
                    $message = "Username or Email is already taken";
                    break;
                }
            case 'fillAllvalues' : {
                    $message = "Please fill in all the attributes to complete form";
                    break;
                }
            case 'InvalidEmail' : {
                    $message = "Please enter proper email address or multiple email with colon separator";
                    break;
                }
            case 'EnterEmail' : {
                    $message = "Enter email address";
                    break;
                }
            case 'succActivateAccount' : {
                    $message = "You have successfully verified your email. Please wait for administrator approval";
                    break;
                }
            case 'inactivatedUser' : {
                    $message = "You haven't verified your email yet, please check your inbox";
                    break;
                }
            case 'unapprovedUser' : {
                    $message = "Your account has not been approved, please contact support for more details";
                    break;
                }
            case 'succChangePass' : {
                    $message = "You have successfully changed your password";
                    break;
                }
            case 'succLogin' : {
                    $message = "You have successfully login to your account";
                    break;
                }
            case 'incorectActivate' : {
                    $message = "Incorrect account, Problem to activate your account";
                    break;
                }

            ## global admin
            case 'userExist' : {
                    $message = "Username already exists";
                    break;
                }
            case 'emailExist' : {
                    $message = "Email address already exists";
                    break;
                }
            case 'sucNewslater' : {
                    $message = "Your have successfully subscribed to our newsletter";
                    break;
                }
            case 'sucNewslater2' : {
                    $message = "Your have successfully activated your subscription";
                    break;
                }
            case 'userNameExist' : {
                    $message = "Username already exists";
                    break;
                }
            case 'succLogout' : {
                    $message = "You have sucessfully logged out from the site";
                    break;
                }
            case 'succregwithoutact' : {
                    $message = "You have successfully registered, please check your email";
                    break;
                }

            case 'recAdded' : {
                    $message = "Record has been added successfully";
                    break;
                }
            case 'recEdited' : {
                    $message = "Record has been edited successfully";
                    break;
                }
            case 'recActivated' : {
                    $message = "Record has been activated successfully";
                    break;
                }
            case 'recDeActivated' : {
                    $message = "Record has been inactivated successfully";
                    break;
                }
            case 'recDeleted' : {
                    $message = "Record has been deleted successfully";
                    break;
                }
            case 'recExist' : {
                    $message = "Record already exists";
                    break;
                }

            case 'wrongPass' : {
                    $message = "You have entered an incorrect password";
                    break;
                }
            case 'passNotmatch' : {
                    $message = "New password entry and password confirmation doesn't match";
                    break;
                }
            case 'NoPermission' : {
                    $message = "You don't have permission to access this module";
                    break;
                }
            case 'recImported' : {
                    $message = "Record has been imported successfully";
                    break;
                }
            case 'succForgotPass' : {
                    $message = "Your password reminder requested has been accepted, please check your email";
                    break;
                }
            case 'invalidCaptcha' : {
                    $message = "Please enter valid captcha";
                    break;
                }
            case 'BlockedUser' : {
                    $message = "Your account has been blocked. Please contact support";
                    break;
                }
            case 'RemainEmailVerify' : {
                    $message = "Your email verification is not complete. You can login after completing this process";
                    break;
                }
            case 'wrongemail' : {
                    $message = "You have entered the wrong email address";
                    break;
                }
            case 'incorectReset' : {
                    $message = "Incorrect account, Problem to reset your account";
                    break;
                }
            default : {
                    $message = $var;
                    break;
                }
        }
    }
    $type1 = ($type == 'suc' ? 'success' : ($type == 'inf' ? 'info' : ($type == 'war' ? 'warning' : 'error')));
    if ($script) {
        $content = '<script type="text/javascript"> toastr["' . $type1 . '"]("' . $message . '");</script>';
    } else {
        $content = 'toastr["' . $type1 . '"]("' . $message . '");';
    }

    return $content;
}

/* Check Authentication */

function Authentication($reqAuth = false, $redirect = true, $allowedUserType = 'a') {
    $todays_date = date("Y-m-d");
    global $adminUserId, $sessUserId, $db;

    $whichSide = domain_details('dir');
    if ($reqAuth == true) {
        if ($whichSide == 'admin-nct') {

            if ($adminUserId == 0) {
                $_SESSION["msgType"] = disMessage(array('type' => 'err', 'var' => 'loginRequired'));
                $_SESSION['req_uri_adm'] = $_SERVER['REQUEST_URI'];

                if ($redirect) {
                    redirectPage(SITE_ADMIN_URL);
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {

            if ($sessUserId <= 0) {
                $_SESSION["msgType"] = disMessage(array('type' => 'err', 'var' => 'loginRequired'));
                $_SESSION['req_uri'] = $_SERVER['REQUEST_URI'];

                if ($redirect) {
                    redirectPage(SITE_URL);
                } else {
                    return false;
                }
            }
            return true;
        }
    }
}
function getTableValue($table, $field, $wherecon = array()) {
    global $db;
    $qrySel   = $db->select($table, array($field), $wherecon);
    $qrysel1  = $qrySel->result();
    $totalRow = $qrySel->affectedRows();
    $fetchRes = $qrysel1;

    if ($totalRow > 0) {
        return $fetchRes[$field];
    } else {
        return "";
    }
}
function getExt($file) {
    $path_parts = pathinfo($file);
    $ext = $path_parts['extension'];
    return $ext;
}

function GenerateThumbnail($varPhoto, $uploadDir, $tmp_name, $th_arr = array(), $file_nm = '', $addExt = true, $crop_coords = array()) {
    //$ext=strtoupper(substr($varPhoto,strlen($varPhoto)-4));die;
    $ext = '.' . strtoupper(getExt($varPhoto));
    $tot_th = count($th_arr);


    if (($ext == ".JPG" || $ext == ".GIF" || $ext == ".PNG" || $ext == ".BMP" || $ext == ".JPEG" || $ext == ".ICO")) {
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777);
        }

        if ($file_nm == '')
            $imagename = rand() . time();
        else
            $imagename = $file_nm;

        if ($addExt || $file_nm == '')
            $imagename = $imagename . $ext;

        $pathToImages = $uploadDir . $imagename;
        $Photo_Source = copy($tmp_name, $pathToImages);

        if ($Photo_Source) {
            for ($i = 0; $i < $tot_th; $i++) {
                resizeImage($uploadDir . $imagename, $uploadDir . 'th' . ($i + 1) . '_' . $imagename, $th_arr[$i]['width'], $th_arr[$i]['height'], false, $crop_coords);
            }

            return $imagename;
        } else {
            return false;
        }
    } else {
        return false;
    }
}
function resizeThumbnailImage($thumb_image_name, $image, $width, $height, $start_width, $start_height, $scale){
    list($imagewidth, $imageheight, $imageType) = getimagesize($image);
    $imageType = image_type_to_mime_type($imageType);

    $newImageWidth = ceil($width * $scale);
    $newImageHeight = ceil($height * $scale);
    $newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
    switch($imageType) {
        case "image/gif":
            $source=imagecreatefromgif($image);
            break;
        case "image/pjpeg":
        case "image/jpeg":
        case "image/jpg":
            $source=imagecreatefromjpeg($image);
            break;
        case "image/png":
        case "image/x-png":
            $source=imagecreatefrompng($image);
            break;
    }
    imagecopyresampled($newImage,$source,0,0,$start_width,$start_height,$newImageWidth,$newImageHeight,$width,$height);
    switch($imageType) {
        case "image/gif":
            imagegif($newImage,$thumb_image_name);
            break;
        case "image/pjpeg":
        case "image/jpeg":
        case "image/jpg":
            imagejpeg($newImage,$thumb_image_name,100);
            break;
        case "image/png":
        case "image/x-png":
            imagepng($newImage,$thumb_image_name);
            break;
    }
    chmod($thumb_image_name, 0777);
    return $thumb_image_name;
}

function resizeImage($filename, $newfilename = "", $max_width, $max_height = '', $withSampling = true, $crop_coords = array()) {

    if ($newfilename == "") {
        $newfilename = $filename;
    }

    $fileExtension = strtolower(getExt($filename));
    if ($fileExtension == "jpg" || $fileExtension == "jpeg") {
        $img = imagecreatefromjpeg($filename);
    } else if ($fileExtension == "png") {
        $img = imagecreatefrompng($filename);
    } else if ($fileExtension == "gif") {
        $img = imagecreatefromgif($filename);
    } else {
        $img = imagecreatefromjpeg($filename);
    }

    $width = imageSX($img);
    $height = imageSY($img);

    // Build the thumbnail
    $target_width = $max_width;
    $target_height = $max_height;
    $target_ratio = $target_width / $target_height;
    $img_ratio = $width / $height;

    if (empty($crop_coords)) {

        if ($target_ratio > $img_ratio) {
            $new_height = $target_height;
            $new_width = $img_ratio * $target_height;
        } else {
            $new_height = $target_width / $img_ratio;
            $new_width = $target_width;
        }

        if ($new_height > $target_height) {
            $new_height = $target_height;
        }
        if ($new_width > $target_width) {
            $new_height = $target_width;
        }
        $new_img = imagecreatetruecolor($target_width, $target_height);

        $white = imagecolorallocate($new_img, 255, 255, 255);
        imagecolortransparent($new_img);
        @imagefilledrectangle($new_img, 0, 0, $target_width - 1, $target_height - 1, $white);
        @imagecopyresampled($new_img, $img, ($target_width - $new_width) / 2, ($target_height - $new_height) / 2, 0, 0, $new_width, $new_height, $width, $height);

        //$new_img = imagecreatetruecolor($new_width, $new_height);
        //@imagecopyresampled($new_img, $img, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
    } else {
        $new_img = imagecreatetruecolor($target_width, $target_height);
        $white = imagecolorallocate($new_img, 255, 255, 255);
        @imagefilledrectangle($new_img, 0, 0, $target_width - 1, $target_height - 1, $white);
        @imagecopyresampled($new_img, $img, 0, 0, $crop_coords['x1'], $crop_coords['y1'], $target_width, $target_height, $crop_coords['x2'], $crop_coords['y2']);
    }

    if ($fileExtension == "jpg" || $fileExtension == "jpeg") {
        $createImageSave = imagejpeg($new_img, $newfilename, 90);
    } else if ($fileExtension == 'png') {
        $createImageSave = imagepng($new_img, $newfilename, 9);
    } else if ($fileExtension == "gif") {
        $createImageSave = imagegif($new_img, $newfilename, 90);
    } else {
        $createImageSave = imagejpeg($new_img, $newfilename, 90);
    }

}

if (!function_exists('dump')) {
    function dump($var, $label = 'Dump', $exit = false, $echo = TRUE) {
        // Store dump in variable
        ob_start();
        var_dump($var);
        $output = ob_get_clean();

        // Add formatting
        $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
        $output = '<pre style="background: rgba(244, 25, 113, 1);
                    color: #FFFFFF;
                    border: 1px dotted #000;
                    padding: 10px;
                    margin: 10px 0;
                    text-align: left;
                    font-size: 14px;">' . $label . ' => ' . $output . '</pre>';

        // Output
        if ($echo == TRUE) {
            echo $output;
        } else {
            return $output;
        }
        if ($exit) {
            die();
        }
    }
}
function getTotalRows($tableName, $condition = '', $countField = '*'){
    global $db;
    $qSel = "SELECT * from " . $tableName . " WHERE " . $condition;
    $qrysel0   = $db->pdoQuery($qSel);
    $totlaRows = $qrysel0->affectedRows();
    return $totlaRows;
}

function getMetaTags($metaArray) {
    $content = '<meta name="description" content="' . $metaArray["description"]. '" />
        <meta name="keywords" content="' . $metaArray["keywords"] . '" />
        <meta name="author" content="' . $metaArray["author"] . '" />
        <meta name="generator" content="'.(isset($metaArray["generator"]) ? $metaArray["generator"] : SITE_NM).'">';

    $content .= '<meta property="fb:app_id"          content="'.FB_APP_ID.'" />
    <meta property="og:type" content="website" />';
    if($_SERVER['REQUEST_URI'] != '/'){
        $content .= '<meta property="og:url" content="'.SITE_URL.substr($_SERVER['REQUEST_URI'],1).'" />';
    }
    else{
        $content .= '<meta property="og:url" content="'.SITE_URL.'" />';
    }
    if(!isset($metaArray['is_no_meta'])){
        $content .= '<meta property="og:description" content="'.$metaArray["description"].'" />';

        if(isset($metaArray['image']) && $metaArray['image'] != ''){
            $content .= '<meta property="og:image" content="'.$metaArray['image'].'" />';
        }
        else{
            $content .= '<meta property="og:image" content="'.SITE_IMG.SITE_LOGO.'" />';
        }

        if(isset($metaArray['title']) && $metaArray['title'] != ''){
            $content .= '<meta property="og:title" content="'.$metaArray['title'].'" />';
        }
        else{
            $content .= '<meta property="og:title" content="'.SITE_NM.'" />';
        }
    }
    if (isset($metaArray["nocache"]) && $metaArray["nocache"] == true) {
        $content .= '<meta HTTP-EQUIV="CACHE-CONTROL" content="NO-CACHE" />';
    }
    return sanitize_output($content);
}

function issetor(&$var, $default = false) {
    return isset($var) ? trim($var) : $default;
}

/* Send SMTP Mail */
function generateEmailTemplate($type, $arrayCont) {
    global $sessUserId,$lId,$db;
    $currentLangauge = 0;
    $langId = issetor($arrayCont['langId'],0);
    if($langId > 0){
        $currentLangauge = getTableValue('tbl_language','id',array('id'=>$langId));
    }else if(issetor($sessUserId) && $sessUserId > 0){
        $currentLangauge = getTableValue('tbl_language','id',array('id'=>$lId));
    }else{
        $currentLangauge = getTableValue('tbl_language','id',array('default_lan'=>'y'));
    }

    $q = $db->select('tbl_email_templates', array("subject_".$currentLangauge, "templates_".$currentLangauge), array("constant" => $type))->result();

    $subject = trim(stripslashes($q["subject_".$currentLangauge]));
    $subject = str_replace("###SITE_NM###", SITE_NM, $subject);

    $message = trim(stripslashes($q["templates_".$currentLangauge]));
    $message = str_replace("###SITE_LOGO_URL###", SITE_IMG.SITE_LOGO, $message);
    $message = str_replace("###SITE_URL###", SITE_URL, $message);
    $message = str_replace("###SITE_NM###", SITE_NM, $message);
    $message = str_replace("###YEAR###", date('Y'), $message);

    $array_keys = (array_keys($arrayCont));

    for ($i = 0; $i < count($array_keys); $i++) {
        $message = str_replace("###".$array_keys[$i]."###", "".$arrayCont[$array_keys[$i]] . "",$message);
        $subject = str_replace("###" . $array_keys[$i] . "###", "" . $arrayCont[$array_keys[$i]] . "", $subject);
    }

    $data['message'] = $message;
    $data['subject'] = $subject;
    return $data;
}

function sendEmailAddress($to, $subject, $message){
    if(ENVIRONMENT == 'd'){
        return true;
    }
    require_once("class.phpmailer.php");
    require_once("class.smtp.php");

    $mail = new PHPMailer();

    //$mail->SMTPDebug = 3;                               // Enable verbose debug output

    $mail->IsSMTP();                                      // Set mailer to use SMTP
    $mail->SMTPDebug = false;
    $mail->SMTPAuth = true;                               // Enable SMTP authentication
    $mail->Host = SMTP_HOST;  // Specify main and backup SMTP servers
    $mail->Port = SMTP_PORT;
    //$mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
    // TCP port to connect to
    $mail->IsHTML(true);                                  // Set email format to HTML
    $mail->Username = SMTP_USERNAME;                    // SMTP username
    $mail->Password = SMTP_PASSWORD;                           // SMTP password

    $mail->SetFrom(FROM_EMAIL, SITE_NM);
    $mail->AddReplyTo(FROM_EMAIL, SITE_NM);
    $mail->Subject = $subject;
    $mail->Body    = $message;
    $mail->addAddress($to);     // Add a recipient
    /*$mail->addBCC('bcc@example.com');*/
    /*$mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
    $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name*/



    /*$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';*/
    $result = true;
    if(!$mail->send()) {
        /*echo 'Message could not be sent.';
        echo 'Mailer Error: ' . $mail->ErrorInfo;*/
        $result = false;
        $headers = "From: ".SITE_NM."<".FROM_EMAIL.">\r\n";
        $headers .= "Reply-To: ".SITE_NM."<".FROM_EMAIL.">\r\n";
        $headers .= "Return-Path: ".SITE_NM."<".FROM_EMAIL.">\r\n";
        $headers .= "Organization: ".SITE_NM."\r\n";
        $headers .= "X-Priority: 3\r\n";
        $headers .= "X-Mailer: PHP". phpversion() ."\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        mail($to,$subject,$message,$headers);
    }
    return $result;
}
/*Admin Functions*/
function convertDate($date, $time = false, $what = 'default') {
    if ($what == 'wherecond') {
        return date('Y-m-d', strtotime($date));
    } else if ($what == 'display') {
        return date('M d, Y h:i A', strtotime($date));
    } else if ($what == 'onlyDate') {
        return date('M d, Y', strtotime($date));
    } else if ($what == 'gmail') {
        return date('D, M d, Y - h:i A', strtotime($date));
        //Tue, Jul 16, 2013 at 12:14 PM
    } else if ($what == 'default') {
        if (trim($date) != '' && $date != '0000-00-00' && $date != '1970-01-01') {

            if (!$time) {

                $retDt = date('M d, Y', strtotime($date));
                return $retDt == '01-01-1970' ? '' : $retDt;
            } else {
                '1970-01-01 01:00:00';
                '01-01-1970 01:00 AM';
                $retDt = date('M d, Y h:i A', strtotime($date));
                return $retDt == '01-01-1970 01:00 AM' ? '' : $retDt;
            }
        } else {
            return '';
        }

    } else if ($what == 'db') {
        if (trim($date) != '' && $date != '0000-00-00' && $date != '1970-01-01') {
            if (!$time) {
                $retDt = date('Y-m-d', strtotime($date));
                return $retDt == '1970-01-01' ? '' : $retDt;
            } else {
                $retDt = date('Y-m-d H:i:s', strtotime($date));
                return $retDt == '1970-01-01 01:00:00' ? '' : $retDt;
            }
        } else {
            return '';
        }

    }
}
function curPageURL() {
    $pageURL = 'http';

    if (isset($_SERVER["HTTPS"])) {
        $pageURL .= "s";
    }
    $pageURL .= "://";
    if ($_SERVER["SERVER_PORT"] != "80") {
        $pageURL .= $_SERVER["SERVER_NAME"] . ":" . $_SERVER["SERVER_PORT"] . $_SERVER["REQUEST_URI"];
    } else {
        $pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
    }
    define('CURRENT_PAGE_URL', $pageURL);
}

function curPageName() {
    $pageName = substr($_SERVER["SCRIPT_NAME"], strrpos($_SERVER["SCRIPT_NAME"], "/") + 1);
    define('CURRENT_PAGE_NAME', $pageName);
}
function checkIfIsActive() {
    global $db;

    if (isset($_SESSION['user_id']) && '' != $_SESSION['user_id']) {
        $user_details = $db->select("tbl_users", "*", array("id" => $_SESSION['user_id']),' AND isActive != "d"')->result();
        if ($user_details) {
            if ('n' == $user_details['isEmailVerify']) {
                unset($_SESSION['user_id']);
                unset($_SESSION['first_name']);
                unset($_SESSION['last_name']);

                $_SESSION['msgType'] = disMessage(array('type' => 'err', 'var' => "You have not verified the email address that is registered with us. Please try logging in again after verifying your email address."));
                redirectPage(SITE_URL);
                return false;
            } else if ('n' == $user_details['isActive']) {
                unset($_SESSION['user_id']);
                unset($_SESSION['first_name']);
                unset($_SESSION['last_name']);

                $_SESSION['msgType'] = disMessage(array('type' => 'err', 'var' => "Your account has been deactivated by Admin. Please contact Site Admin to re-activate your account."));
                redirectPage(SITE_URL);
                return false;
            } else {
                return true;
            }
        } else {
            unset($_SESSION['user_id']);
            unset($_SESSION['first_name']);
            unset($_SESSION['last_name']);

            $_SESSION['msgType'] = disMessage(array('type' => 'err', 'var' => "There seems to be an issue. Please try logging in again."));
            redirectPage(SITE_URL);
            return false;
        }
    } else {
        return true;
    }
}
/* get domain details, pass module, dir, file or file-module whichever required. */
function domain_details($returnWhat)
{
    $arrScriptName = explode('/', $_SERVER['SCRIPT_NAME']);
    foreach ($arrScriptName as $singleSciptName) {

        if ($singleSciptName == "admin-nct") {
            return $singleSciptName;
            break;
        }
    }
}

function generatePassword($length = 8) {
    // start with a blank password
    $password = "";
    // define possible characters - any character in this string can be
    // picked for use in the password, so if you want to put vowels back in
    // or add special characters such as exclamation marks, this is where
    // you should do it
    $possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";
    // we refer to the length of $possible a few times, so let's grab it now
    $maxlength = strlen($possible);
    // check for length overflow and truncate if necessary
    if ($length > $maxlength) {
        $length = $maxlength;
    }
    // set up a counter for how many characters are in the password so far
    $i = 0;
    // add random characters to $password until $length is reached
    while ($i < $length) {

        // pick a random character from the possible ones
        $char = substr($possible, mt_rand(0, $maxlength - 1), 1);

        // have we already used this character in $password?
        if (!strstr($password, $char)) {
            // no, so it's OK to add it onto the end of whatever we've already got...
            $password .= $char;
            // ... and increase the counter by one
            $i++;
        }
    }
    return $password;
}
function humanTiming($time) {

    $time = time() - $time; // to get the time since that moment

    $tokens = array(
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second',
    );

    foreach ($tokens as $unit => $text) {
        if ($time < $unit) {
            continue;
        }

        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
    }
}
function getTime($date) {
    $time = humanTiming(strtotime($date));
    if ($time == "") {
        $time = "Just Now";
    } else {
        $time .= " ago";
    }

    return $time;
}

function endsWith($haystack, $needle){
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr($haystack, -$length) === $needle);
}
function myTruncate($string, $limit, $break = " ", $pad = "...", $onlyText = true) {
    $string = ($onlyText == true) ? str_replace('&nbsp;', ' ', $string) : $string;
    if (strlen($string) <= $limit)
        return $string;
    if (false !== ($breakpoint = strpos($string, $break, $limit))) {
        if ($breakpoint < strlen($string) - 1) {
            $string = substr($string, 0, $breakpoint) . $pad;
        }
    }
    return $string;
}
function pri($data, $exit=true) {
    print '<pre>'; print_r($data); print '</pre>';
    (($exit)?exit():'');
}
function checkImage($imageName='',$thumb_id=0,$id=''){
    global $db;

    $thumb_q = $db->pdoQuery("SELECT type,folder,thumb FROM tbl_imagethumb WHERE id = ? LIMIT 1 ",array($thumb_id));
    if($thumb_q->affectedRows() > 0){
        $thumb_data = $thumb_q->result();
        $folderDir = $thumb_data['folder'].'/'.($id > 0 ? $id.'/' : '');
        $folder = $thumb_data['folder'].'/'.($id > 0 ? $id.'/' : '');
        //for service video
        if($thumb_data['type'] == 'services' && $imageName == ''){
            $check_v = $db->pdoQuery("SELECT id FROM tbl_service_gallery WHERE serviceId = ? AND fileType = ? LIMIT 1 ",array($id,'v'))->affectedRows();
            return ($check_v > 0 ? SITE_IMG.'player.png' : SITE_IMG . 'no_service_image.png');
        }
        //for service video
        $imageName = ($thumb_data['thumb'] != '' ? $thumb_data['thumb'].$imageName : $imageName);



        if(is_file(DIR_UPD . $folderDir . $imageName)){
            return SITE_UPD.$folder . $imageName;
        } else {
            if($thumb_data['folder'] == 'profile'){
                return SITE_IMG . 'no_image_thumb.png';
            }else{
                if($thumb_data['type'] == 'services' && in_array($thumb_id,array(7))){
                    return SITE_IMG . 'no_service_image_large.png';
                }
                else{
                    return SITE_IMG . 'no_service_image.png';
                }
            }
        }
    }
    else{
        return SITE_IMG . 'no_image_thumb.png';
    }
}

function filtering($value = '', $type = 'output', $valType = 'string', $funcArray = '') {
    global $abuse_array, $abuse_array_value;

    if ($valType != 'int' && $type == 'output') {
        $value = str_ireplace($abuse_array, $abuse_array_value, $value);
    }

    if ($type == 'input' && ($valType == 'string' || $valType == 'text')) {
        //$value = preg_replace('#<script(.*?)>(.*?)</script>#is', '', $value);
        $value = preg_replace('/script.*?\/script/ius', '', $value);
        $value = str_replace('<', '< ', $value);
    }

    $content = $filterValues = '';
    if ($valType == 'int')
        $filterValues = (isset($value) ? (int) strip_tags(trim($value)) : 0);
    else if ($valType == 'float')
        $filterValues = (isset($value) ? (float) strip_tags(trim($value)) : 0);
    else if ($valType == 'double')
        $filterValues = (isset($value) ? (double) strip_tags(trim($value)) : 0);
    else if ($valType == 'string')
        $filterValues = (isset($value) ? (string) strip_tags(trim($value)) : NULL);
    else if ($valType == 'text')
        $filterValues = (isset($value) ? (string) trim($value) : NULL);
    else
        $filterValues = (isset($value) ? trim($value) : NULL);

    if ($type == 'input') {
        //$content = mysql_real_escape_string($filterValues);
        //$content = $filterValues;
        //$value = str_replace('<', '< ', $filterValues);
        $content = addslashes($filterValues);
    } else if ($type == 'output') {
        if ($valType == 'string')
            $filterValues = html_entity_decode($filterValues);

        $value = str_replace(array('\r', '\n', ''), array('', '', ''), $filterValues);
        $content = stripslashes($value);
    }
    else {
        $content = $filterValues;
    }

    if ($funcArray != '') {
        $funcArray = explode(',', $funcArray);
        foreach ($funcArray as $functions) {
            if ($functions != '' && $functions != ' ') {
                if (function_exists($functions)) {
                    $content = $functions($content);
                }
            }
        }
    }

    return $content;
}


function GenerateThumbnailResize($uploadDir = '',$destination = '',$tmpFileName = '',$fileName = '',$heiWidArr = array())
{
    if(!file_exists($uploadDir))
    {
        mkdir($uploadDir,0777);
    }

    move_uploaded_file($tmpFileName, $destination);

    /*$heiWidArr is new height with array*/
    if(!empty($heiWidArr)){
        for($i=0;$i<count($heiWidArr);$i++){

            $copyFileName = $uploadDir.'th'.($i+1).'_'.$fileName;

            if (!copy($destination, $copyFileName)) {
                echo "Failed to Generate New Thumbnail";
                return false;
            }

            $fileExtension = strtolower(getExt($copyFileName));
            $fileInfos = getimagesize($copyFileName);

            if ($fileInfos['mime'] == "image/jpeg" OR $fileInfos['mime'] == "image/jpg") {
                $img = imagecreatefromjpeg($copyFileName);
            } else if ($fileInfos['mime'] == "image/png") {
                $img = imagecreatefrompng($copyFileName);
            } else if ($fileInfos['mime'] == "image/gif") {
                $img = imagecreatefromgif($copyFileName);
            } else {
                $img = imagecreatefromjpeg($copyFileName);
            }

            list($width, $height) = getimagesize($copyFileName);

            $thumb = imagecreatetruecolor($heiWidArr[$i]['newWidth'], $heiWidArr[$i]['newHeight']);

            imagealphablending($thumb, false);
            imagesavealpha($thumb,true);
            $transparent = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
            imagefilledrectangle($thumb, 0, 0, $heiWidArr[$i]['newWidth'], $heiWidArr[$i]['newHeight'], $transparent);

            imagecopyresampled($thumb, $img, 0, 0, 0, 0, $heiWidArr[$i]['newWidth'], $heiWidArr[$i]['newHeight'], $width, $height);

            if ($fileInfos['mime'] == "image/jpeg" OR $fileInfos['mime'] == "image/jpg") {
                $createImageSave = imagejpeg($thumb, $copyFileName, 90);
            } else if ($fileInfos['mime'] == "image/png") {
                $createImageSave = imagepng($thumb, $copyFileName, 9);
            } else if ($fileInfos['mime'] == "image/gif") {
                $createImageSave = imagegif($thumb, $copyFileName, 90);
            } else {
                $createImageSave = imagejpeg($thumb, $copyFileName, 90);
            }
        }
    }
}

function makeSlug($string,$table,$field=null,$whereCol,$extra='url',$id=null){
    global $fb,$db;
    $slug = trim($string); // trim the string

    if ($extra == 'url') {
        $slug = preg_replace('/[^a-zA-Z0-9 -]/', '', $slug);// only take alphanumerical characters, but keep the spaces and dashes too...
        $slug = str_replace(' ', '-', $slug);// replace spaces by dashes
    }
    elseif ($extra == 'name') {
        $slug = preg_replace('/[^a-zA-Z0-9]/', '', $slug);// only take alphanumerical characters, but keep the spaces and dashes too...
    }
    $slug = strtolower($slug);
    //$fb->trace('trace');
    if($id!=null && $field != null){
        //in case edit
        //exist except given id
        $does_exist = getTableValue($table, $field, array("$whereCol"=>$slug,"AND $field <>"=>$id));
        if(isset($does_exist) && $does_exist != ""){
            return $slug.generateRandString(4);
        }else{
            return $slug;
        }
    }
    else{
        $check = $db->pdoQuery("SELECT $field FROM $table WHERE $whereCol = ? ",array($slug))->affectedRows();
        if($check > 0){
            return $slug.generateRandString(4);
        }
        else{
            return $slug;
        }
    }
}

function makeSlugWithId($id =0){
    if($id > 0){
        return generateRandString(4).'-'.$id.'-'.generateRandString(4);
    }
    return '';
}

/* Generate Random String */

function generateRandString($totalString = 10, $type = 'alphanum') {
    if ($type == 'alphanum')
        $alphanum = "AaBbC0cDdEe1FfGgH2hIiJj3KkLlM4mNnOo5PpQqR6rSsTt7UuVvW8wXxYy9Zz";
    else if ($type == 'num')
        $alphanum = "098765432101234567890098765432101234567890098765432101234567890";
    return substr(str_shuffle($alphanum), 0, $totalString);
}

function p($data) {
    echo '<pre>';
    print_r($data);
    die;
}

/*Generate incrementing counter for each and every transaction or payment related things for site*/
function generateZeroFillNo($num = 0){
    $final_result = sprintf("%08s",$num);
    return $final_result;
}

function generateUpdateRedeemRequestCounter($type = 'paypal'){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('redeem_request'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'REDREQ'.($type == 'paypal' ? 'PP' : 'BK').date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'redeem_request'));
        //update counter
    }
    return $trans_id;
}

function generateUpdateRedeemRequestPaymentCounter($type = 'paypal'){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('redeem_payment'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'REDPAY'.($type == 'paypal' ? 'PP' : 'BK').date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'redeem_payment'));
        //update counter
    }
    return $trans_id;
}

function generateUpdateRequestPaymentCounter(){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('request_payment'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'REQPAY'.date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'request_payment'));
        //update counter
    }
    return $trans_id;
}

function generateUpdateOrderPaymentCounter($type='service'){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('order_payment'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'ORD'.($type == 'service' ? 'SRC' : 'REQ').date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'order_payment'));
        //update counter
    }
    return $trans_id;
}

function generateUpdateServicePaymentCounter(){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('service_purchase'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'SRCPAY'.date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'service_purchase'));
        //update counter
    }
    return $trans_id;
}

function generateUpdateServiceFeatureCounter(){
    global $db,$sessUserId;
    $trans_id = '';
    $q = $db->pdoQuery("SELECT value FROM tbl_site_counters WHERE name = ? ",array('service_feature_payment'));
    if($q->affectedRows() > 0){
        $data = $q->result();
        $new_no = generateZeroFillNo($data['value'] + 1);
        $trans_id = 'SRCFETPAY'.date('Ymd').$new_no;
        //update counter
        $db->update('tbl_site_counters',array('value'=>($data['value'] + 1),'updated_date'=>date('Y-m-d H:i:s')),array('name'=>'service_feature_payment'));
        //update counter
    }
    return $trans_id;
}
/*Generate incrementing counter for each and every transaction or payment related things for site*/

/* Upload any image and resize with full scale image including transparency*/
function uploadImagewithResize($uploadDir = '',$fileName = '',$type = ''){
    global $db;

    /* Generate Thumbnail based on Heigth/Width*/
    $thumb_q = $db->pdoQuery("SELECT folder,type,width,height FROM tbl_imagethumb WHERE type = ? ",array($type));
    if($thumb_q->affectedRows() > 0){
        $thumb_data = $thumb_q->results();

        $temp_folder_id = '';
        if($thumb_data[0]['folder'] == 'services' || $thumb_data[0]['folder'] == 'profile'){
            $temp_folder_id = $uploadDir;
        }
        $uploadDir = DIR_UPD .$thumb_data[0]['folder'].'/'.$uploadDir;
        if(!file_exists($uploadDir)){
            mkdir($uploadDir,0777);
        }

        $source = DIR_UPD .$thumb_data[0]['folder'].'/temp_dir/'.$temp_folder_id.$fileName;
        copy($source,$uploadDir.$fileName);
        foreach($thumb_data as $key => $value) {
            $copyFileName = $uploadDir.'th'.($key+1).'_'.$fileName;

            if (!copy($source, $copyFileName)){
                echo "Failed to Generate New Thumbnail";
                return false;
            }

            $fileExtension = strtolower(getExt($copyFileName));
            $fileInfos = getimagesize($copyFileName);

            if ($fileInfos['mime'] == "image/jpeg" OR $fileInfos['mime'] == "image/jpg") {
                $img = imagecreatefromjpeg($copyFileName);
            } else if ($fileInfos['mime'] == "image/png") {
                $img = imagecreatefrompng($copyFileName);
            } else if ($fileInfos['mime'] == "image/gif") {
                $img = imagecreatefromgif($copyFileName);
            } else {
                $img = imagecreatefromjpeg($copyFileName);
            }

            list($width, $height) = getimagesize($copyFileName);

            $thumb = imagecreatetruecolor($value['width'], $value['height']);

            imagealphablending($thumb, false);
            imagesavealpha($thumb,true);
            $transparent = imagecolorallocatealpha($thumb, 255, 255, 255, 127);
            imagefilledrectangle($thumb, 0, 0, $value['width'], $value['height'], $transparent);

            imagecopyresampled($thumb, $img, 0, 0, 0, 0, $value['width'], $value['height'], $width, $height);

            if ($fileInfos['mime'] == "image/jpeg" OR $fileInfos['mime'] == "image/jpg") {
                $createImageSave = imagejpeg($thumb, $copyFileName, 90);
            } else if ($fileInfos['mime'] == "image/png") {
                $createImageSave = imagepng($thumb, $copyFileName, 9);
            } else if ($fileInfos['mime'] == "image/gif") {
                $createImageSave = imagegif($thumb, $copyFileName, 90);
            } else {
                $createImageSave = imagejpeg($thumb, $copyFileName, 90);
            }
        }
    }
}


/* delete useless files of directory */
function deletefile($data_array=array()){
    //deletefile(array($type,$path,$fileName,array()));
    if(count($data_array) >0){
        $filesToKeep = (isset($data_array['filesToKeep']) && count($data_array['filesToKeep']) > 0) ? $data_array['filesToKeep'] : array();
        $fileName = (isset($data_array['fileName']) && $data_array['fileName'] != '') ? $data_array['fileName'] : '';
        extract($data_array);
        $dir = DIR_UPD;
        if($type == 'category'){
            $path = $dir.'category/'.$path;
        }
        else if($type == 'subcategory'){
            $path = $dir.'subcategory/'.$path;
        }
        else if($type == 'trending-collections-image'){
            $path = $dir.'trending-collections/'.$path;
        }
        else if($type == 'trending-collections-back-image'){
            $path = $dir.'trending-collections/'.$path;
        }
        else if($type == 'services'){
            $path = $dir.'services/'.$path;
        }
        else if($type == 'profile'){
            $path = $dir.'profile/'.$path;
        }
        else{
        }
        if(is_dir($path)){
            $dirList = glob($path . '*'.$fileName);
            foreach ($dirList as $file) {
                if(!in_array(basename($file), $filesToKeep)){
                    if(file_exists($file)){
                        @unlink($file);
                    }
                }//END IF
            }
        }
    }
    return true;
}

function display_image($data_array = array()) {
    //$data = array("type"=>"user","file_name"=>$image_name,"prefix"=>"th1_","user_id"=>"21");
    // display_image($data);
    $folder = $no_image_file = "";
    $all_types = $image_dimension = array();
    $folder_url = SITE_UPD;

    if ($data_array['type'] == 'category') {
        $folder = DIR_UPD . "category/";
        $user_folder = $data_array['category_id'] . "/";
        $folder_url .= 'category/';
        $no_image_file = "no_image_thumb.png";
    }

    $image_url = $user_folder . ((isset($data_array['file_name']) && $data_array['file_name'] != '' && file_exists($folder . $user_folder . $data_array['prefix'] . $data_array['file_name'])) ?
                    $data_array['prefix'] . $data_array['file_name'] : $data_array['file_name']);
    $image_url = (file_exists($folder . $image_url) && $data_array['file_name'] != '') ?
            $image_url : $data_array['prefix'] . $no_image_file;

    $image_url = (file_exists($folder . $image_url)) ?
            $image_url : $no_image_file;

    return $folder_url . $image_url;
}


//update currency
function update_currency_rates()
{
    global $db;
    $base = 'USD';

    //START:: to update or insert rates
    $output = json_decode(file_get_contents('https://openexchangerates.org/api/latest.json?app_id='.CURRENCY_API));

    $rates = isset($output->rates) ? $output->rates : array();



    $message = SITE_URL."<BR><BR>";
    $message .= "<pre>" . print_r($rates, TRUE);

    //sendEmailAddress('gaurav.chavda@ncrypted.com', 'update_currency_rates - ' . SITE_NM, $message);

    //dump_exit($rates);
    foreach ($rates as $code => $ex_rate) {
        $does_exist = $db->select('tbl_currency', 'id', array('currencyCode' => $code))->result();
        if ($does_exist) {

            $db->update('tbl_currency', array(
                'currencyCode'   => $code,
                'rate_to_usd'    => (string) $ex_rate,
                'updateDate'     => date('Y-m-d H:i:s'),
                'conversionDate' => date('Y-m-d H:i:s'),
            ), array('currencyCode' => $code));
        } else {

            $db->insert('tbl_currency', array(
                'currencyCode'   => $code,
                'rate_to_usd'    => (string) $ex_rate,
                'updateDate'     => date('Y-m-d H:i:s'),
                'conversionDate' => date('Y-m-d H:i:s'),
                'createdDate'    => date('Y-m-d H:i:s'),
                'isActive'       => 'n'
            ));
        }
    }
    //END:: to update or insert rates

    //START:: to update or insert currency names
    $output = json_decode(file_get_contents('https://openexchangerates.org/api/currencies.json'));

    $names = isset($output) ? $output : array();

    //dump_exit($names);
    foreach ($names as $code => $name) {
        $does_exist = $db->select('tbl_currency', 'id', array('currencyCode' => $code))->result();
        if ($does_exist) {

            $db->update('tbl_currency', array(
                'currencyName' => $name,
            ), array('currencyCode' => $code));
        } else {

            $db->insert('tbl_currency', array(
                'currencyCode' => $code,
                'currencyName' => $name,
            ));
        }
    }
    //END:: to update or insert currency names
}
function exchange($amount, $from = DEFAULT_CURRENCY_CODE, $to = DEFAULT_CURRENCY_CODE, $id=null,$db_type='',$type='display')
{
    global $exchangeRates,$db;
    //$from = DEFAULT_CURRENCY_CODE;
    /*pri($exchangeRates);*/
    $result             = [];
    //  $result['currency'] = $to;
    //get rate from file
    //check if past rate is available

    if($id != null){
        $rate = $db->pdoQuery("SELECT * FROM tbl_currency_past_rates WHERE entityId = ? AND type = ? ",array($id,$db_type))->result();
        if(empty($rate)){
            $rate =  $exchangeRates['rate_to_usd'];
        }
        /*else{
            $rate =  $exchangeRates['rate_to_usd'];
        }*/
    }else{
        $rate =  $exchangeRates['rate_to_usd'];
    }
    //make the exchange
    $to_rate   = issetor($rate[$to], 1);
    $from_rate = issetor($rate[$from], 1);
    if ($from_rate) {
        $conversion_rate  = $from_rate / $to_rate;
        $value = $amount / $conversion_rate;
    } else {
        $value = 0;
    }
    if($type == 'display'){
        $value = round($value,2);
    }
    //return result as asoc array with keys 'value', 'currency'
    //return number_format($value,2);
    //return round($value,2);
    return $value;
}
function renderStarRating($rating, $maxRating = 5, $html5 = false)
{

    if ($html5) {
        $fullStar  = "&#9733;";
        $halfStar  = $fullStar;
        $emptyStar = "&#9734;";
    } else {
        $fullStar  = "<i class = 'fa fa-star'></i>";
        $halfStar  = "<i class = 'fa fa-star-half-full'></i>";
        $emptyStar = "<i class = 'fa fa-star-o'></i>";
    }

    $rating = $rating <= $maxRating ? $rating : $maxRating;

    $fullStarCount  = (int) $rating;
    $halfStarCount  = ceil($rating) - $fullStarCount;
    $emptyStarCount = $maxRating - $fullStarCount - $halfStarCount;
    $html = '<span style="font-size: 16px !important; color:#FFBE26;">';
    $html .= str_repeat($fullStar, $fullStarCount);
    $html .= str_repeat($halfStar, $halfStarCount);
    $html .= str_repeat($emptyStar, $emptyStarCount);
    $html .= '</span> ('.number_format($rating,1).')';

    return $html;
}

function getFileDisplayIcon($dir_path=''){
    if(file_exists($dir_path)){
        $mime_type = get_file_mime_type($dir_path,false);
        return font_awesome_file_icon_class($mime_type);
    }
    return "fa-file-o";
}


function getPagerData($numHits, $limit, $page){
    $numHits  = (int) $numHits;
    $limit    = max((int) $limit, 1);
    $page     = (int) $page;
    $numPages = ceil($numHits / $limit);
    $page = max($page, 1);
    $page = min($page, $numPages);
    $offset = ($page - 1) * $limit;

    $ret = new stdClass;
    $ret->offset   = $offset;
    $ret->limit    = $limit;
    $ret->numPages = $numPages;
    $ret->page     = $page;

    return $ret;
}

function pagination($pager, $page, $totalRow){

    $pagination_container = $page_li_list = $jsFuncVariables = '';
    if($pager->numPages > 1 && $totalRow > 0){
        $adjacents = 1;
        //Here we generates the range of the page numbers which will display.
        if($pager->numPages <= (1+($adjacents * 2))) {
            $startPage = 1;
            $endPage   = $pager->numPages;
        } else {
            if(($page - $adjacents) > 1) {
              if(($page + $adjacents) < $pager->numPages) {
                $startPage = ($page - $adjacents);
                $endPage   = ($page + $adjacents);
              } else {
                $startPage = ($pager->numPages - (1+($adjacents*2)));
                $endPage   = $pager->numPages;
              }
            } else {
              $startPage = 1;
              $endPage   = (1+($adjacents * 2));
            }
        }
        if($page == -1)
            $page = 0;
        $previousPage = $page-1;
        $nextPage = $page+1;
        if ($page == 1 || $page == 0)
            $page_li_list .= '';
        else if ($page > 1)  {
        }
        $li_arr = array("%LI_CLASS%"=>"".($page == 1 ? 'disabled' : ''),
                        "%DATA_PAGE%"=>$startPage,
                        "%LI_A_CLASS%"=>"oBtnSecondary oPageBtn  ".($page == 1 ? 'disabled' : ' buttonPage '),
                        "%DISP_TEXT%"=>FIRST_PAGE);
        $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);

        $li_arr = array("%LI_CLASS%"=>"".($page == 1 ? 'disabled' : ''),
                        "%DATA_PAGE%"=>$previousPage,
                        "%LI_A_CLASS%"=>"oBtnSecondary oPageBtn  ".($page == 1 ? 'disabled' : ' buttonPage '),
                        "%DISP_TEXT%"=>PREVIOUS);
        $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);
        if($endPage > $pager->numPages){
            $dispPageNo = $pager->numPages;
        }else{
            $dispPageNo = $endPage;
        }

        for($i = $startPage; $i <= $dispPageNo ; $i++){
            if ($i == $pager->page){
                $li_arr = array("%LI_CLASS%"=>"active disabled",
                            "%DATA_PAGE%"=>"",
                            "%LI_A_CLASS%"=>"buttonPageActive disabled",
                            "%DISP_TEXT%"=>$i);
                $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);
            }
            else{
                $li_arr = array("%LI_CLASS%"=>"",
                            "%DATA_PAGE%"=>$i,
                            "%LI_A_CLASS%"=>"buttonPage next",
                            "%DISP_TEXT%"=>$i);
                $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);
            }
        }
        if($page == $pager->numPages) // this is the last page - there is no next page
            $page_li_list .= "";
        else{
        }
        $li_arr = array("%LI_CLASS%"=>"".($page == $pager->numPages ? 'disabled' : ''),
                        "%DATA_PAGE%"=>$nextPage,
                        "%LI_A_CLASS%"=>"oBtnSecondary oPageBtn  ".($page == $pager->numPages ? 'disabled' : ' buttonPage '),
                        "%DISP_TEXT%"=>NEXT);
        $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);

        $li_arr = array("%LI_CLASS%"=>"".($page == $pager->numPages ? 'disabled' : ''),
                        "%DATA_PAGE%"=>$pager->numPages,
                        "%LI_A_CLASS%"=>"oBtnSecondary oPageBtn  ".($page == $pager->numPages ? 'disabled' : ' buttonPage '),
                        "%DISP_TEXT%"=>LAST_PAGE);
        $page_li_list .= get_view(DIR_TMPL . "/pagination_li-nct.tpl.php",$li_arr);
        $li_list = array("%LI_PAGE_LIST%"=>$page_li_list);
        $pagination_container = get_view(DIR_TMPL . "/pagination_ul_container-nct.tpl.php",$li_list);
    }
    return $pagination_container;
}


function isPasswordValid($user_id = '',$password = ''){
    global $db;

    $qrySel = $db->pdoQuery('SELECT id FROM tbl_users WHERE id = ? AND password = ?',array($user_id,md5($password)))->affectedRows();

    if($qrySel > 0){
        return true;
    }else{
        return false;
    }
}

function checkNotificationForUser($user_id=0,$notify_id = 0){
    global $db;
    $check = $db->pdoQuery("SELECT id FROM tbl_users_notifications WHERE userId = ? AND notifyId = ? ",array($user_id,$notify_id))->affectedRows();
    return ($check > 0 ? 0 : 1);
}

function addNewNotificationForUser($notification_constant = '',$data_array = array()){
    global $db,$sessUserName;
    extract($data_array);
    if($notification_constant != ''){
        $email_template = '';
        $notifyId = getTableValue('tbl_notifications','id',array('constant'=>$notification_constant));
        $noti_insert_array = array(
            'receiverId'    => $data_array['receiverId'],
            'notifyId'      => $notifyId,
            'createdDate'   => date('Y-m-d H:i:s'),
            'ipAddress'     => get_ip_address()
        );
        $receiver_data = $db->pdoQuery("SELECT u.userName,u.email,u.slug
            FROM tbl_users AS u
            WHERE u.id = ?  LIMIT 1 ",array($data_array['receiverId']))->result();
        $sender_data = array();
        if(isset($data_array['senderId']) && $data_array['senderId'] > 0){
            $noti_insert_array['senderId'] = $data_array['senderId'];

            $sender_data = $db->pdoQuery("SELECT u.userName,u.email,u.slug
                FROM tbl_users AS u
                WHERE u.id = ?  LIMIT 1 ",array($data_array['senderId']))->result();
        }
        if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
            $noti_insert_array['entityId'] = $data_array['entityId'];
        }

        $notification_text = '';
        $mailarray = array();
        switch ($notification_constant) {
            case 'message_sent': //Notification for message received
                $email_template = '';
                if(isset($data_array['is_email_notification']) &&  $data_array['is_email_notification'] == 'y'){
                    $email_template = 'message_sent';
                }
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'user_url'=>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'user_name'=>filtering($sender_data['userName']),
                    'message'=>(isset($data_array['message']) ? $data_array['message'] : '')
                );
                $notification_text = 'MESSAGE_RECEIVED';
                break;
            case 'new_buyer_request_received': //Notification for seller new  buyer request notification received
                $email_template = 'new_buyer_request_received';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'notification_url' => SITE_URL.'request-notification/',
                );
                $notification_text = 'NEW_BUYER_REQUEST_RECEIVED';
                break;
            case 'request_accept_by_admin': //Notification for request accepte by the admin
                $link = '';
                $createdDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT createdDate FROM tbl_request WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $createdDate = filtering($data['createdDate']);
                    }
                }
                $notification_text = 'REQUEST_ACCEPT_BY_ADMIN';
                $email_template = 'request_accept_by_admin';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'posted_date' => convertDate($createdDate,true),
                );
                break;
            case 'request_reject_by_admin': //Notification for request accepte by the admin
                $link = '';
                $createdDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT createdDate FROM tbl_request WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $createdDate = filtering($data['createdDate']);
                    }
                }
                $notification_text = 'REQUEST_REJECTED_BY_ADMIN';
                $email_template = 'request_reject_by_admin';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'posted_date' => convertDate($createdDate,true),
                );
                break;
            case 'seller_sent_offer': //Notification for seller sent offer
                $link = '';
                $createdDate = '';

                $notification_text = 'SELLER_SENT_OFFER';
                $email_template = 'seller_sent_offer';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'user'=> filtering(ucwords($sessUserName))
                );
                break;
            case 'buyer_accept_offer': //Notification for offer accepte by the buyer
                $link = '';
                $acceptRejectDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT acceptRejectDate FROM tbl_seller_request_notification WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $acceptRejectDate = filtering($data['acceptRejectDate']);
                    }
                }
                $notification_text = 'BUYER_ACCEPT_OFFER';
                $email_template = 'buyer_accept_offer';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'created_date' => convertDate($acceptRejectDate,true),
                    'user' => filtering(ucwords($sessUserName)),
                );
                break;
             case 'buyer_reject_offer': //Notification for offer reject by the buyer
                $link = '';
                $acceptRejectDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT acceptRejectDate FROM tbl_seller_request_notification WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $acceptRejectDate = filtering($data['acceptRejectDate']);
                    }
                }
                $notification_text = 'BUYER_REJECT_OFFER';
                $email_template = 'buyer_reject_offer';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'created_date' => convertDate($acceptRejectDate,true),
                    'user' => filtering(ucwords($sessUserName)),
                );
                break;

             case 'buyer_request_payment': //Notification for buyer pay for request offer
                $link = '';
                $acceptRejectDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT offerDate FROM tbl_seller_request_notification WHERE id = ? ",array($data_array['sellerNotiId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $createdDate = filtering($data['offerDate']);
                    }
                }
                $notification_text = 'BUYER_REQUEST_PAYMENT';
                $email_template = 'buyer_request_payment';
                $mailarray = array(
                    'greetings' => filtering($receiver_data['userName']),
                    'user' => filtering(ucwords($sender_data['userName'])),
                    'posted_date'   =>convertDate($createdDate)
                );
                break;

             case 'buyer_purchase_service': //Notification for purchase service
                $link = '';
                $acceptRejectDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT slug,title,createdDate FROM tbl_services WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $link = SITE_URL.'service-details/'.$data['slug'].'/';
                        $service_name = filtering($data['title']);
                        $createdDate = filtering($data['createdDate']);
                    }
                }
                $notification_text = 'BUYER_PURCHASE_SERVICE';
                $email_template = 'buyer_purchase_service';

                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'user' => filtering(ucwords($sender_data['userName'])),
                    'service_name'  =>$service_name,
                    'service_link'  =>$link,
                    'posted_date'   =>convertDate($createdDate)
                );
                break;
            case 'order_lated': //Notification for order status changed to active.
                $notification_text = 'NOTIFICATION_ORDER_STATUS_CHANGED_TO_LATE';
                $email_template = 'order_lated';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'order_id'      =>"#".$data_array['txnId'],
                    'date'          =>convertDate(date('Y-m-d H:i:s'))
                );
                break;
            case 'order_expired': //Notification for order status changed to active.
                $notification_text = 'NOTIFICATION_ORDER_STATUS_CHANGED_TO_EXPIRE';
                $email_template = 'order_expired';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'order_id'      =>"#".$data_array['txnId'],
                    'date'          =>convertDate(date('Y-m-d H:i:s'))
                );
                break;
            case 'service_approved_by_admin': //Notification for service approved by the admin
                $link = '';
                $service_name = '';
                $createdDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT slug,title,createdDate FROM tbl_services WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $link = SITE_URL.'service-details/'.$data['slug'].'/';
                        $service_name = filtering($data['title']);
                        $createdDate = filtering($data['createdDate']);
                    }
                }
                $notification_text = 'NOTIFICATION_SERVICE_APPROVED_BY_ADMIN';
                $email_template = 'service_approved_by_admin';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'service_name'  =>$service_name,
                    'service_link'  =>$link,
                    'posted_date'   =>convertDate($createdDate)
                );
                break;
            case 'service_rejected_by_admin': //Notification for service rejected by the admin
                $service_name = '';
                $createdDate = '';
                if(isset($data_array['entityId']) && $data_array['entityId'] > 0){
                    $q = $db->pdoQuery("SELECT slug,title,createdDate FROM tbl_services WHERE id = ? ",array($data_array['entityId']));
                    if($q->affectedRows() > 0){
                        $data = $q->result();
                        $service_name = filtering($data['title']);
                        $createdDate = filtering($data['createdDate']);
                    }
                }
                $notification_text = 'NOTIFICATION_SERVICE_REJECTED_BY_ADMIN';
                $email_template = 'service_rejected_by_admin';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'service_name'  =>$service_name,
                    'posted_date'   =>$createdDate
                );
                break;
            case 'order_activated': //Notification for order status changed to active.
                $service_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_ORDER_ACTIVATED_BY_SELLER';
                $email_template = 'order_activated_by_seller';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'order_id'      =>"#".$data_array['txnId'],
                    'seller_name'   =>$sender_data['userName'],
                    'seller_url'    =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'date'          =>convertDate(date('Y-m-d H:i:s'))
                );
                break;
            case 'order_completed': //Notification for order status changed to completed.
                $service_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_ORDER_COMPLETED';
                $email_template = 'order_completed';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'order_id'      =>"#".$data_array['txnId'],
                    'buyer_name'   =>$sender_data['userName'],
                    'buyer_url'    =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'date'          =>convertDate(date('Y-m-d H:i:s'))
                );
                break;
            case 'order_cancelled': //Notification for order status changed to cancelled.
                $service_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_ORDER_CANCELLED';
                $email_template = 'order_cancelled';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'order_id'      =>"#".$data_array['txnId'],
                    'buyer_name'   =>$sender_data['userName'],
                    'buyer_url'    =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'date'          =>convertDate(date('Y-m-d H:i:s'))
                );
                break;
            case 'referral_bonus_credited': //Notification for referral bonus credited to wallet.
                $service_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_REFERRAL_BONUS_CREDITED';
                $email_template = 'referral_bonus_credited';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'referral_amount'=>DEFAULT_CURRENCY_CODE.$data_array['referral_amount'],
                    'referal_email'=>$data_array['referal_email']
                );
                break;
            case 'review_posted_for_request': //Notification for review posted for request.
                $request_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_REVIEW_POSTED_FOR_REQUEST';
                $email_template = 'review_posted_for_request';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'user_url'      =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'user_name'     =>$sender_data['userName'],
                    'rating'        =>renderStarRating($data_array['rating']),
                    'review'        =>$data_array['review'],
                );
                break;
            case 'review_posted_for_service': //Notification for review posted for service.
                $service_name = '';
                $createdDate = '';
                $notification_text = 'NOTIFICATION_REVIEW_POSTED_FOR_SERVICE';
                $email_template = 'review_posted_for_service';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'user_url'      =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'user_name'     =>$sender_data['userName'],
                    'rating'        =>renderStarRating($data_array['rating']),
                    'review'        =>$data_array['review'],
                    'service_title'=>$data_array['service_title'],
                );
                break;
            case 'reply_posted_for_service': //Notification for reply posted for service.
                $notification_text = 'NOTIFICATION_REPLY_POSTED_FOR_SERVICE';
                $email_template = 'reply_posted_for_service';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'user_url'      =>SITE_URL.'profile/'.$sender_data['slug'].'/',
                    'user_name'     =>$sender_data['userName'],
                    'reply'         =>$data_array['reply'],
                    'service_title' =>$data_array['service_title'],
                );
                break;
            case 'redeem_payment_done_by_admin': //Notification for payment done for redeem request..
                $notification_text = 'NOTIFICATION_REDEEM_REQUEST_PAID_BY_ADMIN';
                $mailarray = array(
                    'greetings'     =>filtering($receiver_data['userName']),
                    'amount'        =>DEFAULT_CURRENCY_CODE.' '.$data_array['amount'],
                );
                break;
            default:
                $email_template = '';
                $mailarray = array();
                break;
        }
        $noti_insert_array['notification'] = $notification_text;
        $i_id = $db->insert('tbl_site_notification',$noti_insert_array);

        $is_email = checkNotificationForUser($data_array['receiverId'],$notifyId);
        if($is_email > 0 && $email_template != ''){
            $array = generateEmailTemplate($email_template, $mailarray);
            sendEmailAddress($receiver_data['email'], $array['subject'], $array['message']);
        }
    }
    return 1;
}

function getNotificationText($n_id = 0,$constant = ''){
    global $db,$sessUserId;
    $notification_text = '';
    $notification_url = SITE_URL;
    if($n_id > 0 && $constant != ''){
        $data = $db->pdoQuery("SELECT n.entityId,n.senderId,n.receiverId,n.notifyId,sen.userName as sen_userName,rec.userName as rec_userName
            FROM tbl_site_notification AS n
            LEFT JOIN tbl_users AS sen ON sen.id = n.senderId
            LEFT JOIN tbl_users AS rec ON rec.id = n.senderId
            WHERE n.id = ? ",array($n_id))->result();
        if(defined($constant)){
            $notification_text = constant($constant);
        }
        switch ($constant) {
            case 'MESSAGE_RECEIVED':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'message-room/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NEW_BUYER_REQUEST_RECEIVED':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'request-notification/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'REQUEST_ACCEPT_BY_ADMIN':
                $replace = array(
                );
                $notification_url = SITE_URL.'my-requests/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'REQUEST_REJECTED_BY_ADMIN':
                $replace = array(
                );
                $notification_url = SITE_URL.'my-requests/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'SELLER_SENT_OFFER':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'my-requests/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'BUYER_ACCEPT_OFFER':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'request-notification/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'BUYER_REJECT_OFFER':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'request-notification/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'BUYER_REQUEST_PAYMENT':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'request-notification/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
             case 'BUYER_PURCHASE_SERVICE':
                $replace = array(
                    '%USER%'=>$data['sen_userName']
                );
                $notification_url = SITE_URL.'manage-sales/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_ORDER_STATUS_CHANGED_TO_LATE':
                $entityData = $db->pdoQuery("SELECT o.txnId,o.sellerId,u.userName,o.userId
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE o.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%ORDER_ID%'=>$entityData['txnId']
                );
                $notification_url = ($sessUserId == $entityData['userId'] ? SITE_URL.'my-purchase-history/' : SITE_URL.'sales-history/');
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_ORDER_STATUS_CHANGED_TO_EXPIRE':
                $entityData = $db->pdoQuery("SELECT o.txnId,o.sellerId,u.userName,o.userId
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE o.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%ORDER_ID%'=>$entityData['txnId']
                );
                $notification_url = ($sessUserId == $entityData['userId'] ? SITE_URL.'my-purchase-history/' : SITE_URL.'sales-history/');
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_ORDER_COMPLETED':
                $entityData = $db->pdoQuery("SELECT o.txnId,o.sellerId,u.userName
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE o.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%ORDER_ID%'=>$entityData['txnId'],
                    '%USER_NAME%'=>filtering($entityData['userName'])
                );
                $notification_url = SITE_URL.'manage-sales/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_ORDER_CANCELLED':
                $entityData = $db->pdoQuery("SELECT o.txnId,o.sellerId,u.userName
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE o.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%ORDER_ID%'=>$entityData['txnId'],
                    '%USER_NAME%'=>filtering($entityData['userName'])
                );
                $notification_url = SITE_URL.'manage-sales/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_SERVICE_APPROVED_BY_ADMIN':
                $entityData = $db->pdoQuery("SELECT slug,title,createdDate FROM tbl_services WHERE id = ? ",array($data['entityId']))->result();
                $link = SITE_URL.'service-details/'.$entityData['slug'].'/';
                $service_name = filtering($entityData['title']);
                $createdDate = filtering($entityData['createdDate']);
                $replace = array(
                    '%SERVICE_NAME%'=>filtering($service_name)
                );
                $notification_url = SITE_URL.'my-services/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_SERVICE_REJECTED_BY_ADMIN':
                $entityData = $db->pdoQuery("SELECT slug,title,createdDate FROM tbl_services WHERE id = ? ",array($data['entityId']))->result();
                $link = SITE_URL.'service-details/'.$entityData['slug'].'/';
                $service_name = filtering($entityData['title']);
                $createdDate = filtering($entityData['createdDate']);
                $replace = array(
                    '%SERVICE_NAME%'=>filtering($service_name)
                );
                $notification_url = SITE_URL.'my-services/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_ORDER_ACTIVATED_BY_SELLER':
                $entityData = $db->pdoQuery("SELECT o.txnId,o.sellerId,u.userName
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE o.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%ORDER_ID%'=>$entityData['txnId'],
                    '%USER_NAME%'=>filtering($entityData['userName'])
                );
                $notification_url = SITE_URL.'manage-purchase/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_REFERRAL_BONUS_CREDITED':
                $entityData = $db->pdoQuery("SELECT u.userName,u.email
                    FROM tbl_users AS u
                    WHERE u.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%EMAIL%'=>filtering($entityData['email'])
                );
                $notification_url = SITE_URL.'revenue/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_REVIEW_POSTED_FOR_SERVICE':
                $entityData = $db->pdoQuery("SELECT u.userName,s.title,s.slug
                    FROM tbl_reviews AS r
                    INNER JOIN tbl_orders AS o ON o.id = r.orderId
                    INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
                    INNER JOIN tbl_users AS u ON u.id = o.userId
                    WHERE r.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%USER_NAME%'=>filtering($entityData['userName']),
                    '%SERVICE_NAME%'=>filtering($entityData['title'])
                );
                $notification_url = SITE_URL.'service-details/'.$entityData['slug'].'/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_REPLY_POSTED_FOR_SERVICE':
                $entityData = $db->pdoQuery("SELECT u.userName,s.title,s.slug
                    FROM tbl_review_reply AS rl
                    INNER JOIN tbl_reviews AS r ON r.id = rl.reviewId
                    INNER JOIN tbl_orders AS o ON o.id = r.orderId
                    INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE rl.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%USER_NAME%'=>filtering($entityData['userName']),
                    '%SERVICE_NAME%'=>filtering($entityData['title'])
                );
                $notification_url = SITE_URL.'service-details/'.$entityData['slug'].'/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            case 'NOTIFICATION_REDEEM_REQUEST_PAID_BY_ADMIN':
                $entityData = $db->pdoQuery("SELECT r.amount
                    FROM tbl_redeem_request AS r
                    WHERE r.id = ? ",array($data['entityId']))->result();
                $replace = array(
                    '%AMOUNT%'=>DEFAULT_CURRENCY_SIGN.filtering($entityData['amount'],'output','float')
                );
                $notification_url = SITE_URL.'revenue/';
                $notification_text = str_replace(array_keys($replace),array_values($replace),$notification_text);
                break;
            default:
                $notification_text = '';
                break;
        }
    }
    return array('notification_text'=>$notification_text,'notification_url'=>$notification_url);
}

//if app call then return array and if web call then return content
function getreturnType($data=array(),$content=''){
    global $sessRequestType;
    return ($sessRequestType == 'web') ? $content : $data;
}

function getNoRecordFoundContent($message=NRF,$tplPath=''){
    $replace = array(
        "%MESSAGE%"=>$message
    );
    if($tplPath == ''){
        return get_view(DIR_TMPL . "/no-record-found-nct.tpl.php",$replace);
    }
    else{
        return get_view($tplPath,$replace);
    }
}



//get different user Statistics
function getUserStatics($data_array = array()){
    global $sessUserId,$db;
    extract($data_array);
    $returnArray = array();
    if(issetor($type) && $type != ''){
        if($type == 'positive_review_percentag'){
            //The number of 2 or less ratings subtracted from the total number of ratings, divided by the total number of rating into 100
            $total_ratings = $db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    WHERE r.userTo =  ? ",array($userId))->affectedRows();
            if($total_ratings > 0){
                $two_or_less_ratings = $db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    WHERE r.userTo =  ? AND r.rating <=  ? ",array($userId,2))->affectedRows();

                $returnArray['positive_review_percentag'] = (($total_ratings - $two_or_less_ratings) / $total_ratings) * 100;
                $returnArray['positive_review_percentag'] = number_format($returnArray['positive_review_percentag'],2);
            }
            else{
                $returnArray['positive_review_percentag'] = 0;
            }

        }
        else if($type == 'amount_earned_this_month'){
            //The total amount earned in the current month will be displayed
            $total_amount = $db->pdoQuery("SELECT SUM(o.amount) as total_amount
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id = ? AND o.status NOT IN ( ? , ? )
                    AND MONTH(o.createdDate) = MONTH(CURRENT_DATE()) AND YEAR(o.createdDate) = YEAR(CURRENT_DATE()) "
                    ,array($userId,'l','c'))->result();
            if(isset($total_amount['total_amount']) && $total_amount['total_amount'] > 0){
                $returnArray['amount_earned_this_month'] = number_format($total_amount['total_amount'],2);
            }
            else{
                $returnArray['amount_earned_this_month'] = 0;
            }

        }
        else if($type == 'orders_created'){
            // /Number of orders received in this month will be displayed
            $orders_created = $db->pdoQuery("SELECT COUNT(o.id) as orders_created
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE  u.id = ? AND  MONTH(o.createdDate) = MONTH(CURRENT_DATE())  AND YEAR(o.createdDate) = YEAR(CURRENT_DATE()) "
                    ,array($userId))->result();
            if(isset($orders_created['orders_created']) && $orders_created['orders_created'] > 0){
                $returnArray['orders_created'] = $orders_created['orders_created'];
            }
            else{
                $returnArray['orders_created'] = 0;
            }
        }
        else if($type == 'no_of_all_reviews'){
            //The number reviews till date for all the services will be displayed
            $returnArray['no_of_all_reviews'] = $db->pdoQuery("SELECT r.id  FROM tbl_reviews AS r  WHERE r.userTo =  ? ",array($userId))->affectedRows();
        }
        else if($type == 'total_positive_ratings'){
            //All the ratings which have 3 or more stars will be considered in the count of Total positive ratings.
            $returnArray['total_positive_ratings'] = $db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    WHERE r.userTo =  ? AND r.rating >=  ? ",array($userId,3))->affectedRows();
        }
        else if($type == 'no_of_negative_reviews'){
            //The total number of 2 or less ratings
            $returnArray['no_of_negative_reviews'] = $db->pdoQuery("SELECT r.id  FROM tbl_reviews AS r  WHERE r.userTo =  ? AND r.rating <= ? ",array($userId,2))->affectedRows();
        }
        else if($type == 'no_of_orders_not_rated'){
            //no of orders which are not rated yet
            $no_of_orders_not_rated = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id = ? AND (o.status = ?) "
                    ,array($userId,'c'))->affectedRows();
            if($no_of_orders_not_rated > 0){
                $returnArray['no_of_orders_not_rated'] = $db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    WHERE r.userTo =  ?  ",array($userId))->affectedRows();
                $returnArray['no_of_orders_not_rated'] = ($no_of_orders_not_rated - $returnArray['no_of_orders_not_rated']);
            }
            else{
                $returnArray['no_of_orders_not_rated'] = 0;
            }
        }
        else if($type == 'no_of_orders_completed'){
            //no of orders which are completed
            $returnArray['no_of_orders_completed'] = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE  u.id = ? AND o.status = ? "
                    ,array($userId,'c'))->affectedRows();
        }
        else if($type == 'no_of_not_rated'){
            //The number of users who have received the services but not rated the user (seller)
            $user_recieved_services = $db->pdoQuery("SELECT GROUP_CONCAT(DISTINCT o.userId) as user_list
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE  u.id =  ? AND o.status IN ( ?, ? ) ",array($userId,'c','l'))>result();
            if(isset($user_recieved_services['user_list']) && $user_recieved_services['user_list'] != ''){

                $returnArray['no_of_not_rated'] = $db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    WHERE r.userTo =  ? AND r.userFrom NOT IN ( ".$user_recieved_services['user_list']." )  ",
                    array($userId))->affectedRows();
            }
            else{
                $returnArray['no_of_not_rated'] = 0;
            }
        }
        else if($type == 'new_orders_till_today'){
            //Number of new orders till current date
            $returnArray['new_orders_till_today'] = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE  u.id = ? AND o.status = ? "
                    ,array($userId,'n'))->affectedRows();
        }
        else if($type == 'extra_orders_for_services'){
            //Number of orders for the services will be displayed
            $returnArray['extra_orders_for_services'] = 0;
        }
        else if($type == 'delivered_orders'){
            //Number of orders completed for the services will be displayed.
            $returnArray['delivered_orders'] = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE  u.id = ? AND o.status = ? "
                    ,array($userId,'c'))->affectedRows();
        }
        else if($type == 'canceled_order_percentage'){
            //The cancelled order Completion formula is the number of completed orders subtracted from total number of order, divided by the total of orders into 100
            $total_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ? ",array($userId))->affectedRows();
            if($total_orders > 0){
                $total_completed_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ?  AND o.status = ? ",array($userId,'c'))->affectedRows();

                $returnArray['canceled_order_percentage'] = (($total_orders - $total_completed_orders) / $total_orders) * 100;
                $returnArray['canceled_order_percentage'] = number_format($returnArray['canceled_order_percentage'],2);
            }
            else{
                $returnArray['canceled_order_percentage'] = 0;
            }
        }
        else if($type == 'canceled_order_percentage_for_service'){
            //The cancelled order Completion formula is the number of completed orders subtracted from total number of order, divided by the total of orders into 100
            $total_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
                    INNER JOIN tbl_users AS u ON u.id = s.userId
                    WHERE u.id =  ? AND s.id = ? ",array($userId,$serviceId))->affectedRows();
            if($total_orders > 0){
                $total_completed_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
                    INNER JOIN tbl_users AS u ON u.id = s.userId
                    WHERE u.id =  ?  AND o.status = ? AND s.id = ?  ",array($userId,'c',$serviceId))->affectedRows();

                $returnArray['canceled_order_percentage_for_service'] = (($total_orders - $total_completed_orders) / $total_orders) * 100;
                $returnArray['canceled_order_percentage_for_service'] = number_format($returnArray['canceled_order_percentage_for_service'],2);
            }
            else{
                $returnArray['canceled_order_percentage_for_service'] = 0;
            }
        }

        else if($type == 'average_response_time'){
            //Response Time is the average amount of time in hours that it takes for a seller to send a first response.
            $returnArray['average_response_time'] = "0 ".PROFILE_PAGE_LBL_HOUR;
            $msg_q = $db->pdoQuery("SELECT m.createdDate,m.senderId
                FROM tbl_messages AS m
                WHERE m.receiverId = ? AND m.entityId > ? GROUP BY m.entityId ",array($userId,0));
            if($msg_q->affectedRows() > 0){
                $total_row = 0;
                $total_sum = 0;
                foreach ($msg_q->results() as $key => $value){
                    $check_res_q = $db->pdoQuery("SELECT m.createdDate
                        FROM tbl_messages AS m
                        WHERE m.receiverId = ? AND m.senderId = ? AND DATE_FORMAT(m.createdDate,'%Y-%m-%d %H:%i:%s') >= ?
                        ORDER BY m.id ASC LIMIT 1 ",
                        array($value['senderId'],$userId,$value['createdDate']));
                    if($check_res_q->affectedRows() > 0){
                        $check_res_data = $check_res_q->result();
                        $total_row += 1;
                        $date_diff = date_difference($value['createdDate'],$check_res_data['createdDate']);
                        $total_sum += $date_diff['hours_total'];
                    }
                }
                if($total_row > 0 && $total_sum > 0){
                    $returnArray['average_response_time'] = number_format(($total_sum / $total_row),1)." ".PROFILE_PAGE_LBL_HOURS;
                }
            }
        }
        else if($type == 'response_rate'){
            // /Response Rate is the percentage of first responses to new messages that a user (seller) sends within 24 hours. (In % )
            $returnArray['response_rate'] = 0;
            $msg_q = $db->pdoQuery("SELECT m.createdDate,m.senderId
                FROM tbl_messages AS m
                WHERE m.receiverId = ? AND m.entityId > ? GROUP BY m.entityId ",array($userId,0));
            if($msg_q->affectedRows() > 0){
                $total_row = 0;
                $total_sum = 0;
                foreach ($msg_q->results() as $key => $value){
                    $check_res_q = $db->pdoQuery("SELECT m.createdDate
                        FROM tbl_messages AS m
                        WHERE m.receiverId = ? AND m.senderId = ? AND DATE_FORMAT(m.createdDate,'%Y-%m-%d %H:%i:%s') >= ?
                        ORDER BY m.id ASC LIMIT 1 ",
                        array($value['senderId'],$userId,$value['createdDate']));
                    if($check_res_q->affectedRows() > 0){
                        $check_res_data = $check_res_q->result();
                        $total_row += 1;
                        $date_diff = date_difference($value['createdDate'],$check_res_data['createdDate']);
                        if($date_diff['hours_total'] == 24 || $date_diff['hours_total'] == 0){
                            $total_sum += 100;
                        }
                        else if($date_diff['hours_total'] < 24){
                            $date_diff['hours_total'] = (((24 - $date_diff['hours_total']) * 100) / 24);
                            $total_sum += $date_diff['hours_total'];
                        }
                        else if($date_diff['hours_total'] > 24){

                        }else{}
                    }
                }
                if($total_row > 0 && $total_sum > 0){
                    $returnArray['response_rate'] = number_format(($total_sum / $total_row),2);
                }
            }
        }
        else if($type == 'no_of_page_views'){
            //Number of users who have viewed the services
            $returnArray['no_of_negative_reviews'] = $db->pdoQuery("SELECT p.id
                FROM tbl_service_page_views AS p
                INNER JOIN tbl_services AS s ON s.id = p.serviceId
                WHERE s.userId = ? AND p.userId != ? GROUP BY p.userId ",array($userId,$userId))->affectedRows();
        }
        else if($type == 'no_of_active_service'){
            //Number of services which are currently active will be displayed
            $returnArray['no_of_active_service'] = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ?  AND o.status = ? ",array($userId,'a'))->affectedRows();
        }
        else if($type == 'orders_completed'){
            //The Order Completion formula is the number of cancellations subtracted from total number of order, divided by the total of orders into 100 (%)
            $total_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ? ",array($userId))->affectedRows();
            if($total_orders > 0){
                $total_canceled_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ?  AND o.status = ? ",array($userId,'ca'))->affectedRows();

                $returnArray['orders_completed'] = (($total_orders - $total_canceled_orders) / $total_orders) * 100;
                $returnArray['orders_completed'] = number_format($returnArray['orders_completed'],2);
            }
            else{
                $returnArray['orders_completed'] = 0;
            }
        }
        else if($type == 'delivered_on_time'){
            //The delivered on time formula is the number of late deliveries subtracted from total number of orders, divided by the total of orders into 100 (%)
            $total_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ? ",array($userId))->affectedRows();
            if($total_orders > 0){
                $total_late_orders = $db->pdoQuery("SELECT o.id
                    FROM tbl_orders AS o
                    INNER JOIN tbl_users AS u ON u.id = o.sellerId
                    WHERE u.id =  ?  AND o.status = ? ",array($userId,'l'))->affectedRows();

                $returnArray['delivered_on_time'] = (($total_orders - $total_late_orders) / $total_orders) * 100;
                $returnArray['delivered_on_time'] = number_format($returnArray['delivered_on_time'],2);
            }
            else{
                $returnArray['delivered_on_time'] = 0;
            }
        }
        else if($type == 'average_selling_price'){
            //By adding the price of all the packages and by dividing from the total number of packages
            $returnArray['average_selling_price'] = 0;
            $pkg_q = $db->pdoQuery("SELECT sp.price
                FROM tbl_service_packages AS sp
                INNER JOIN tbl_services AS s ON s.id = sp.serviceId
                WHERE s.userId = ? AND s.status = ? AND s.isActive = ? ",array($userId,'a','y'));
            $total_row = $pkg_q->affectedRows();
            if($total_row > 0){
                $total = 0;
                foreach ($pkg_q->results() as $key => $value){
                    $total += $value['price'];
                }
                $returnArray['average_selling_price'] = ($total / $total_row);
            }
        }
        else if($type == 'recent_delivary_time'){
            $returnArray['recent_delivary_time'] = 0;
            $recent_q = $db->pdoQuery("SELECT o.createdDate
                    FROM tbl_orders AS o
                    INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's')
                    INNER JOIN tbl_request AS r ON (r.id = o.entityId AND o.orderType = 'r')
                    WHERE (s.userId =  ? OR r.userId = ?)  AND (o.status = ?  OR o.status = ? ) ORDER BY o.id DESC LIMIT 1 ",array($userId,$userId,'c','l'));
            if($recent_q->affectedRows() > 0){
                $recent_data = $recent_q->result();
                $returnArray['recent_delivary_time'] = getTimeDiffrence($recent_data['createdDate']);
            }
        }
        else if($type == 'profile_completed'){
            //This will depend upon the number of fields filled by the user
            $userData = $db->pdoQuery("SELECT u.aboutMe,u.profileImage,u.education,u.certification,u.portfolio,u.location,
                (SELECT COUNT(id) FROM tbl_users_languages WHERE userId = u.id ) as lang_count,
                (SELECT COUNT(id) FROM tbl_users_skills WHERE userId = u.id ) as skill_count
                FROM tbl_users AS u
                WHERE u.id = ? LIMIT 1 ",array($userId))->result();
            $returnArray['profile_completed'] = 0;
            if($userData['aboutMe'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['profileImage'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['education'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['certification'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['portfolio'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['location'] != '')
                $returnArray['profile_completed'] += 12.5;
            if($userData['lang_count'] > 0)
                $returnArray['profile_completed'] += 12.5;
            if($userData['skill_count'] > 0)
                $returnArray['profile_completed'] += 12.5;
        }
        else{
        }
    }
    return $returnArray;
}

function getTimeDiffrence($data_date=""){
    $format = "N/A";
    if($data_date != ""){
        $notificationDate = new DateTime($data_date);
        $currentDate = new DateTime(date("Y-m-d H:i:s"));
        $difference = $notificationDate->diff($currentDate);

        if($difference->y > 0){
            $format =  $difference->y." ".PROFILE_PAGE_LBL_YEARS;
        }
        else if($difference->m > 0){
            $format =  $difference->m." ".PROFILE_PAGE_LBL_MOTHS;
        }
        else if($difference->d > 0){
            $format =  $difference->d." ".PROFILE_PAGE_LBL_DAYS;
        }
        else if($difference->h > 0){
            $format =  $difference->h." ".PROFILE_PAGE_LBL_HOURS;
        }
        else if($difference->i > 0){
            $format =  $difference->i." ".PROFILE_PAGE_LBL_MINUTES;
        }
        else if($difference->s > 0){
            $format =  $difference->s." ".PROFILE_PAGE_LBL_SECONDS;
        }
        else {
            $format = PROFILE_PAGE_LBL_JUST_NOW;
        }
    }
    return $format;
}

function date_difference($d1, $d2) {
    $d1 = (is_string($d1) ? strtotime($d1) : $d1);
    $d2 = (is_string($d2) ? strtotime($d2) : $d2);

    $diff_secs = abs($d1 - $d2);
    $base_year = min(date("Y", $d1), date("Y", $d2));

    $diff = mktime(0, 0, $diff_secs, 1, 1, $base_year);
    return array(
        "years" => date("Y", $diff) - $base_year,
        "months_total" => (date("Y", $diff) - $base_year) * 12 + date("n", $diff) - 1,
        "months" => date("n", $diff) - 1,
        "days_total" => floor($diff_secs / (3600 * 24)),
        "days" => date("j", $diff) - 1,
        "hours_total" => floor($diff_secs / 3600),
        "hours" => date("G", $diff),
        "minutes_total" => floor($diff_secs / 60),
        "minutes" => (int) date("i", $diff),
        "seconds_total" => $diff_secs,
        "seconds" => (int) date("s", $diff)
    );
}

function genrateTxnRandom($length = 8,$type=""){
    return genrateRandom($length);
}

function generatePdfFile($data_array) {
    //    $data_array = array("html"=>$getInvoicePdfHtml,"output_file_name"=>"invoice.pdf","page_size"=>"A4");
    //    generatePdfFile($data_array);
    //p($data_array);
    error_reporting(0);
    $html = isset($data_array["html"]) ? $data_array["html"] : "";
    $footer = isset($data_array["footer"]) ? $data_array["footer"] : "";
    $file_name = isset($data_array["output_file_name"]) ? $data_array["output_file_name"] : "";
    $download = isset($data_array["download"]) ? $data_array["download"] : "true";
    // array(210, 145)

    require(DIR_INC . "mpdf-master/mpdf.php");
    $mpdf = new mPDF('c', array(210, 250), '', '', 0, 0, 0, 0, 0, 0);
    $mpdf->SetDisplayMode('fullpage');
    $mpdf->setAutoBottomMargin = 'stretch';
    $mpdf->setAutoTopMargin = 'stretch';
    $mpdf->list_indent_first_level = 0;  // 1 or 0 - whether to indent the first level of a list
    //$mpdf->SetFooter($footer);
    $mpdf->WriteHTML($html);
    if ($download == "false") {
        $files = glob(DIR_UPD . 'invoice/*'); // get all file names
        foreach ($files as $file) { // iterate files
            if (is_file($file))
                unlink($file); // delete file
        }
        $mpdf->Output(DIR_UPD . "invoice/" . $file_name, 'F');
        $file_name = SITE_UPD . "invoice/" . $file_name;
    }else {
        $mpdf->Output($file_name, 'D');
    }
    return $file_name;

}

function updateUserLevelViaCompletedOrders($data_array=array()){
    global $sessUserId,$db;
    extract($data_array);
    $userId = issetor($userId,0);
    $sWhere = ' WHERE u.isEmailVerify = ? ';
    $aWhere = array('y');
    if($userId > 0){
        $sWhere .= ' AND u.id = ? ';
        $aWhere[] = $userId;
    }
    $q = $db->pdoQuery("SELECT u.id,u.userLevel
        FROM tbl_users AS u
        $sWhere ",$aWhere);
    if($q->affectedRows() > 0){
        $userData = $q->results();
        $levelData = $db->pdoQuery("SELECT level,value FROM tbl_users_level WHERE 1 = ? ",array(1))->results();
        $beginner_value = 0;
        $intermediate_value = 0;
        $expert_value = 0;
        foreach ($levelData as $value_l){
            if($value_l['level'] == 'b')
                $beginner_value = $value_l['value'];
            else if($value_l['level'] == 'i')
                $intermediate_value = $value_l['value'];
            else if($value_l['level'] == 'e')
                $expert_value = $value_l['value'];
            else{

            }
        }
        foreach ($userData as $key => $value){
            $orders_count = $db->pdoQuery("SELECT id FROM tbl_orders WHERE sellerId = ? AND status = ? ",array($value['id'],'c'))->affectedRows();
            if($orders_count > 0){
                $userLevel = 'b';
                if($orders_count >= $expert_value){
                    $userLevel = 'e';
                }
                else if($orders_count >= $intermediate_value){
                    $userLevel = 'i';
                }
                else if($orders_count >= $beginner_value){
                    $userLevel = 'e';
                }
                else{
                    $userLevel = 'b';
                }
                $db->update('tbl_users',array('userLevel'=>$userLevel,'updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$value['id']));
            }
        }
    }
    return true;
}

function updateOrderStatusForLate($data_array=array()){
    global $sessUserId,$db;
    $q = $db->pdoQuery("SELECT o.id,o.userId,o.sellerId,o.amount,o.txnId,o.orderType,o.discount,o.adminCommission,bw.pendingAmount as b_pendingAmount,bw.spentAmount as b_spentAmount,sw.earningAmount as s_earningAmount,sw.earnedAmount as s_earnedAmount,sw.amount as s_amount
        FROM tbl_orders AS o
        INNER JOIN tbl_users AS b ON b.id = o.userId
        INNER JOIN tbl_wallet AS bw ON bw.userId = b.id
        INNER JOIN tbl_users AS s ON s.id = o.sellerId
        INNER JOIN tbl_wallet AS sw ON sw.userId = s.id
        WHERE o.status = ? AND DATE_FORMAT(o.deliveryDate,'%Y-%m-%d') < '".date('Y-m-d')."' ",array('a'));
    if($q->affectedRows() > 0){
        foreach ($q->results() as $key => $value){

            /*udpate order status*/
            $db->update('tbl_orders',array('status'=>'l','updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$value['id']));
            /*udpate order status*/

            /*udpate buyer wallet*/
            $db->pdoQuery("UPDATE tbl_wallet SET pendingAmount = pendingAmount - ?,spentAmount = spentAmount + ?,updatedDate = ?
                WHERE userId = ?",
                array($value['amount'],$value['amount'],date('Y-m-d H:i:s'),$value['userId']));

            if($value['orderType'] == 's' && $value['discount'] > 0){
                $value['amount'] += $value['discount'];
            }
            /*udpate buyer wallet*/

            //send notification to buyer
            $notification_type = 'order_lated';
            $data_array = array(
                'receiverId'    =>$value['userId'],
                'notifyId'      =>$notification_type,
                'entityId'      =>$value['id'],
                'orderId'       =>$value['id'],
                'txnId'         =>$value['txnId']
            );
            addNewNotificationForUser($notification_type,$data_array);
            //send notification to buyer

            /*udpate seller wallet*/
            $sellerUpdateAmount = $value['amount'] - $value['adminCommission'];
            $db->pdoQuery("UPDATE tbl_wallet SET earningAmount = earningAmount - ?,earnedAmount = earnedAmount + ?,amount = amount + ? ,updatedDate = ? WHERE userId = ? ",array($sellerUpdateAmount,$sellerUpdateAmount,$sellerUpdateAmount,date('Y-m-d H:i:s'),$value['sellerId']));
            /*udpate seller wallet*/

            //send notification to seller
            $notification_type = 'order_lated';
            $data_array = array(
                'receiverId'    =>$value['sellerId'],
                'notifyId'      =>$notification_type,
                'entityId'      =>$value['id'],
                'orderId'       =>$value['id'],
                'txnId'         =>$value['txnId']
            );
            addNewNotificationForUser($notification_type,$data_array);
            //send notification to seller
        }
    }
    return true;
}

function updateOrderStatusForExpired($data_array=array()){
    global $sessUserId,$db;
    $q = $db->pdoQuery("SELECT o.id,o.userId,o.sellerId,o.amount,o.txnId,o.orderType,o.discount,o.adminCommission,bw.pendingAmount as b_pendingAmount,bw.spentAmount as b_spentAmount,sw.earningAmount as s_earningAmount,sw.earnedAmount as s_earnedAmount,sw.amount as s_amount
        FROM tbl_orders AS o
        INNER JOIN tbl_users AS b ON b.id = o.userId
        INNER JOIN tbl_wallet AS bw ON bw.userId = b.id
        INNER JOIN tbl_users AS s ON s.id = o.sellerId
        INNER JOIN tbl_wallet AS sw ON sw.userId = s.id
        WHERE o.status = ? AND DATE_FORMAT(o.deliveryDate,'%Y-%m-%d') < '".date('Y-m-d')."' ",array('n'));
    if($q->affectedRows() > 0){
        foreach ($q->results() as $key => $value){

            /*udpate order status*/
            $db->update('tbl_orders',array('status'=>'e','updatedDate'=>date('Y-m-d H:i:s')),array('id'=>$value['id']));
            /*udpate order status*/

            /*udpate buyer wallet*/
            $db->pdoQuery("UPDATE tbl_wallet SET pendingAmount = pendingAmount - ?,amount = amount + ?,updatedDate = ?
                WHERE userId = ?",
                array($value['amount'],$value['amount'],date('Y-m-d H:i:s'),$value['userId']));

            if($value['orderType'] == 's' && $value['discount'] > 0){
                $value['amount'] += $value['discount'];
            }
            /*udpate buyer wallet*/

            //send notification to buyer
            $notification_type = 'order_expired';
            $data_array = array(
                'receiverId'    =>$value['userId'],
                'notifyId'      =>$notification_type,
                'entityId'      =>$value['id'],
                'orderId'       =>$value['id'],
                'txnId'         =>$value['txnId']
            );
            addNewNotificationForUser($notification_type,$data_array);
            //send notification to buyer

            /*udpate seller wallet*/
            $sellerUpdateAmount = $value['amount'] - $value['adminCommission'];
            $db->pdoQuery("UPDATE tbl_wallet SET earningAmount = earningAmount - ?,updatedDate = ? WHERE userId = ? ",array($sellerUpdateAmount,date('Y-m-d H:i:s'),$value['sellerId']));
            /*udpate seller wallet*/

            //send notification to seller
            $notification_type = 'order_expired';
            $data_array = array(
                'receiverId'    =>$value['sellerId'],
                'notifyId'      =>$notification_type,
                'entityId'      =>$value['id'],
                'orderId'       =>$value['id'],
                'txnId'         =>$value['txnId']
            );
            addNewNotificationForUser($notification_type,$data_array);
            //send notification to seller
        }
    }
    return true;
}

function updateServiceFeaturedExpired($data_array=array()){
    global $sessUserId,$db;
    $date = date('Y-m-d H:i:s');
    $q = $db->pdoQuery("SELECT sfh.*,s.title,s.slug,s.userId,u.userName,u.email FROM `tbl_service_feature_history` AS sfh INNER JOIN tbl_services AS s ON s.id = sfh.serviceId INNER JOIN tbl_users AS u ON u.id = s.userId WHERE DATE_ADD(sfh.createdDate , INTERVAL sfh.days DAY) < ? AND sfh.status = ? AND sfh.featuredBy = ? AND s.isFeatured = ?",array($date,'y','u','y'));
    if($q->affectedRows() > 0){
        foreach ($q->results() as $key => $value){
            $id = $value['id'];
            $serviceId = $value['serviceId'];
            $title = $value['title'];
            $serviceId = $value['serviceId'];
            $slug = $value['slug'];
            $userId = $value['userId'];
            $userName = filtering($value['userName']);
            $email = filtering($value['email']);

            $db->update('tbl_services',array('isFeatured'=>'n'),array('id'=>$serviceId));
            $db->update('tbl_service_feature_history',array('status'=>'n'),array('serviceId'=>$serviceId));

        }
    }
    return true;
}

function getDeliveryDateForCartItem($duration = 0,$durationType='h'){
    $deliveryDate = '';
    if($duration > 0 && ($durationType == 'h' || $durationType == 'd')){
        if($durationType == 'h'){
            $deliveryDate = date("Y-m-d", strtotime('+'.$duration.' hours',strtotime(date('Y-m-d H:i:s'))));
        }
        else{
            $deliveryDate = date('Y-m-d', strtotime('+'.$duration.' day',strtotime(date('Y-m-d H:i:s'))));
        }
    }
    return $deliveryDate;
}

function isSocialVerified($userId = 0){
    global $db;
    $isSocialVerified = 'n';
    if($userId > 0){
        $getUserData = $db->pdoQuery("SELECT fbCode,googleCode,linkdinCode FROM tbl_users WHERE id = ?",array($userId));
        $getUserData_af_row = $getUserData->affectedRows();
        if($getUserData_af_row > 0){
            $getUserData_result = $getUserData->result();
            extract($getUserData_result);
            if($fbCode != NULL && $googleCode != NULL && $linkdinCode != NULL){
                $isSocialVerified = 'y';
            }
        }
    }
    return $isSocialVerified;
}

function isUserConsultHiveCertified($userId = 0){
    global $db;
    $isUserConsultHiveCertified = 'n';
    if($userId > 0){
        $isUserConsultHiveCertified = getTableValue('tbl_users','isCertified',array('id'=>$userId));
    }
    return $isUserConsultHiveCertified;
}

