<?php
$reqAuth = true;
$module  = "trending-collections-nct";
require_once "../../../includes-nct/config-nct.php";
require_once "class.trending-collections-nct.php";

$module = "trending-collections-nct";
$table  = "tbl_trending_collections";

chkPermission($module);
$Permission = chkModulePermission($module);
$styles     = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN),
    array("cropper.min.css", SITE_ADM_CSS),
    array("select-multiple/bootstrap-select.min.css", SITE_ADM_JS));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN),
    array("cropper.min.js", SITE_ADM_JS),
    array("select-multiple/bootstrap-select.min.js", SITE_ADM_JS),
    array("cropper.js", SITE_ADM_JS));

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords"                                 => 'Admin Panel',
    "author"                                   => SITE_NM));
$breadcrumb = array("Manage categories");

$id        = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType  = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type      = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;
$ctypeTxt  = isset($_REQUEST["ctype"]) ? trim($_REQUEST["ctype"]) : "f";
$ctype     = $ctypeTxt == 'pages' ? 't' : ($ctypeTxt == 'messages' ? 'm' : 'f');
$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage ') . ' Trending Collections';
$winTitle  = $headTitle . ' - ' . SITE_NM;


if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $insArr = array();
    extract($_POST);
    $response = array();
    $response['status'] = false;


    $status  = isset($status) ? trim($status) : 'n';
    $name    = isset($name) ? $name : array();
    $descriptionArr = isset($description) ? $description : array();
    $services = isset($services) ? $services : array();

    if ($type == 'edit' && $id > 0) {
        if (in_array('edit', $Permission)) {

            $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
            if(count($services) > 0 && $name[$engLangId] != '' && $descriptionArr[$engLangId] != ''){
                $insArr['isActive'] = $status;
                $insArr['name'] =  filtering($name[$engLangId],'input','text');
                $insArr['description'] =  $descriptionArr[$engLangId];
                $insArr['updatedDate'] =  date('Y-m-d H:i:s');
                $insArr['description'] =  filtering($descriptionArr[$engLangId],'input','text');
                $insArr['slug']     = makeSlug($name[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);

                $db->delete('tbl_trending_collections_services',array('trendingId'=>$id));
                foreach ($services as $key => $value) {
                    $db->insert('tbl_trending_collections_services',array('trendingId'=>$id,'serviceId'=>$value,'creadtedDate'=>date('Y-m-d H:i:s')));
                }

                if($hiddenImgfile != ''){
                    //upoading category image
                    $upload_dir = '';
                    $imagename = getTableValue('tbl_trending_collections','image',array('id'=>$id));
                    $data_array = array('type'=>'trending-collections-image','path'=>'','fileName'=>$imagename); 
                    deletefile($data_array);
                    /* Remove old profile pics of particular user */
                    uploadImagewithResize($upload_dir,$hiddenImgfile,'trending-collections-image');
                    $data_array = array('type'=>'trending-collections-image','path'=>'temp_dir/','filesToKeep'=>array($hiddenImgbackgroundImage)); 
                    deletefile($data_array);
                    $insArr['image'] = $hiddenImgfile;
                }

                if($hiddenImgbackgroundImage != ''){
                    //upoading category image
                    $upload_dir = '';
                    $imagename = getTableValue('tbl_trending_collections','backgroundImage',array('id'=>$id)); 
                    $data_array = array('type'=>'trending-collections-back-image','path'=>'','fileName'=>$imagename); 
                    deletefile($data_array);
                    /* Remove old profile pics of particular user */
                    uploadImagewithResize($upload_dir,$hiddenImgbackgroundImage,'trending-collections-back-image');
                    $data_array = array('type'=>'trending-collections-back-image','path'=>'temp_dir/'); 
                    deletefile($data_array);
                    $insArr['backgroundImage'] = $hiddenImgbackgroundImage;
                }

                $db->update('tbl_trending_collections', $insArr, array('id' => $id));
                //////////////
                $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                foreach ($languages as $key => $value) {
                    $name[$value["id"]] = filtering($name[$value["id"]],'input','text');
                    $description[$value['id']] = filtering($description[$value['id']],'input','text');
                    $db->update($table, array('name_' . $value["id"] => $name[$value["id"]], 'description_' . $value["id"] => $description[$value['id']] ), array("id" => $id));
                }
                //////////////
                $response['status'] = true;
                $response['success'] =  'Record has been updated successfully.';
                echo json_encode($response);
                exit;
            }
            else{
                $response['status'] = false;
                $response['success'] =  'Please fill all values properly.';
                echo json_encode($response);
                exit;
            }

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    } else {
        if (in_array('add', $Permission)) {

            $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
            if(count($services) > 0 && $name[$engLangId] != '' && $descriptionArr[$engLangId] != ''){
                $insArr['isActive'] = $status;
                $insArr['createdDate'] = date('Y-m-d H:i:s');
                $insArr['updatedDate'] = date('Y-m-d H:i:s');
                $insArr['name'] =  filtering($name[$engLangId],'input','text');
                $insArr['description'] =  filtering($descriptionArr[$engLangId],'input','text');

                if($hiddenImgfile != ''){
                    //upoading category image
                    $upload_dir = '';
                    /* Remove old profile pics of particular user */
                    uploadImagewithResize($upload_dir,$hiddenImgfile,'trending-collections-image');
                    $data_array = array('type'=>'trending-collections-image','path'=>'temp_dir/','filesToKeep'=>array($hiddenImgbackgroundImage)); 
                    deletefile($data_array);
                    $insArr['image'] = $hiddenImgfile;
                }

                if($hiddenImgbackgroundImage != ''){
                    //upoading category image
                    $upload_dir = '';
                    /* Remove old profile pics of particular user */
                    uploadImagewithResize($upload_dir,$hiddenImgbackgroundImage,'trending-collections-back-image');
                    $data_array = array('type'=>'trending-collections-back-image','path'=>'temp_dir/'); 
                    deletefile($data_array);
                    $insArr['backgroundImage'] = $hiddenImgbackgroundImage;
                }
                $insertedId  = $db->insert('tbl_trending_collections', $insArr)->getLastInsertId();
                foreach ($services as $key => $value) {
                    $db->insert('tbl_trending_collections_services',array('trendingId'=>$insertedId,'serviceId'=>$value,'creadtedDate'=>date('Y-m-d H:i:s')));
                }

                $slug_update = makeSlug($name[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $insertedId);
                $db->update($table, array('slug'=>$slug_update),array('id'=>$insertedId));

                //////////////
                $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                foreach ($languages as $key => $value) {
                    $name[$value["id"]] = filtering($name[$value["id"]],'input','text');
                    $description[$value['id']] = filtering($description[$value['id']],'input','text');
                    $db->update($table, array('name_' . $value["id"] => $name[$value["id"]], 'description_' . $value["id"] => $description[$value['id']]), array("id" => $insertedId));

                }
                //////////////
                $response['status'] = true;
                $response['success'] =  'Record has been added successfully.';
                echo json_encode($response);
                exit;
            }
            else{
                $response['status'] = false;
                $response['success'] =  'Please fill all values properly.';
                echo json_encode($response);
                exit;
            }

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    }
}
$CatObj = new TrendingCollections($module);

$pageContent = $CatObj->getPageContent();
require_once DIR_ADMIN_TMPL . "parsing-nct.tpl.php";
