<?php
$reqAuth = true;
$module  = "sub-category-nct";
require_once "../../../includes-nct/config-nct.php";
require_once "class.sub-category-nct.php";

$module = "sub-category-nct";
$table  = "tbl_subcategories";

chkPermission($module);
$Permission = chkModulePermission($module);
$styles     = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN),
    array("cropper.min.css", SITE_ADM_CSS),
    array("select-multiple/bootstrap-select.min.css", SITE_ADM_JS));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN),
    array("cropper.min.js", SITE_ADM_JS),
    array("select-multiple/bootstrap-select.min.js", SITE_ADM_JS));

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords"                                 => 'Admin Panel',
    "author"                                   => SITE_NM));
$breadcrumb = array("Manage categories");

$id        = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType  = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type      = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;
$ctypeTxt  = isset($_REQUEST["ctype"]) ? trim($_REQUEST["ctype"]) : "f";
$ctype     = $ctypeTxt == 'pages' ? 't' : ($ctypeTxt == 'messages' ? 'm' : 'f');
$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage ') . ' Sub Categories';
$winTitle  = $headTitle . ' - ' . SITE_NM;


if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $insArr = array();
    extract($_POST);
    $response = array();
    $response['status'] = false;


    $status  = isset($status) ? trim($status) : 'n';
    $subCategoryName    = isset($subCategoryName) ? $subCategoryName : array();
    $descriptionArr = isset($description) ? $description : array();
    $categoryId = isset($categoryId) ? $categoryId : '';

    if ($type == 'edit' && $id > 0) {
        if (in_array('edit', $Permission)) {

            //get eng lang id & generate slug from that
            $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));

            $insArr['isActive'] = $status;
            $insArr['categoryId'] = $categoryId;
            $insArr['subCategoryName'] =  filtering($subCategoryName[$engLangId],'input','string');
            $insArr['description'] =  filtering($descriptionArr[$engLangId],'input','text');
            $insArr['slug']     = makeSlug($subCategoryName[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);

            if($hiddenImg != ''){
                //upoading category image
                $upload_dir = $id . '/';
                $imagename = getTableValue('tbl_subcategories','image',array('id'=>$id)); 
                $data_array = array('type'=>'subcategory','path'=>$id.'/');
                deletefile($data_array);
                /* Remove old profile pics of particular user */
                uploadImagewithResize($upload_dir,$hiddenImg,'subcategory');
                $data_array = array('type'=>'subcategory','path'=>'temp_dir/');
                deletefile($data_array);
                $insArr['image'] = $hiddenImg;
            }

            $db->update('tbl_subcategories', $insArr, array('id' => $id));
            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $subCategoryName[$value["id"]] = filtering($subCategoryName[$value["id"]],'input','string');
                $description[$value['id']] = filtering($description[$value['id']],'input','text');
                $db->update($table, array('subCategoryName_' . $value["id"] => $subCategoryName[$value["id"]], 'description_' . $value["id"] => $description[$value['id']] ), array("id" => $id));
            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been updated successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    } else {
        if (in_array('add', $Permission)) {

            //get eng lang id & generate slug from that
            $engLangId             = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
            $insArr['isActive'] = $status;
            $insArr['createdDate'] = date('Y-m-d H:i:s');
            $insArr['categoryId'] = $categoryId;
            $insArr['subCategoryName'] =  filtering($subCategoryName[$engLangId],'input','string');
            $insArr['image'] = $hiddenImg;
            $insArr['description'] =  filtering($descriptionArr[$engLangId],'input','text');
            $insertedId            = $db->insert('tbl_subcategories', $insArr)->getLastInsertId();

            //upoading category image
            $upload_dir = $insertedId . '/';
            /* Remove old profile pics of particular user */
            uploadImagewithResize($upload_dir,$hiddenImg,'subcategory');
            $data_array = array('type'=>'subcategory','path'=>'temp_dir/');
            deletefile($data_array);

            $slug_update = makeSlug($subCategoryName[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $insertedId);
            $db->update($table, array('slug'=>$slug_update),array('id'=>$insertedId));

            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $subCategoryName[$value["id"]] = filtering($subCategoryName[$value["id"]],'input','string');
                $description[$value['id']] = filtering($description[$value['id']],'input','text');
                $db->update($table, array('subCategoryName_' . $value["id"] => $subCategoryName[$value["id"]], 'description_' . $value["id"] => $description[$value['id']]), array("id" => $insertedId));

            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been added successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    }
}
$CatObj = new SubCategory($module);

$pageContent = $CatObj->getPageContent();
require_once DIR_ADMIN_TMPL . "parsing-nct.tpl.php";
