<?php
$reqAuth = true;
$module  = "site-languages-nct";
require_once "../../../includes-nct/config-nct.php";
require_once "class.site-languages-nct.php";

$module = "site-languages-nct";
$table  = "tbl_site_languages";

chkPermission($module);
$Permission = chkModulePermission($module);
$styles     = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN));

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords"                                 => 'Admin Panel',
    "author"                                   => SITE_NM));
$breadcrumb = array("Manage categories");

$id        = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType  = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type      = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage ') . ' Site Languages';
$winTitle  = $headTitle . ' - ' . SITE_NM;

if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $insArr = array();
    extract($_POST);
    $response = array();
    $response['status'] = false;

    $insArr['languageName'] = $languageName = isset($languageName) ? filtering($languageName,'input','string') : '';
    $insArr['isActive'] =  $isActive  = isset($status) ? trim($status) : 'n';
    $insArr['updatedDate']     = date('Y-m-d H:i:s');

    if ($type == 'edit' && $id > 0 && $languageName != '') {
        if (in_array('edit', $Permission)) {

            $insArr['slug']     = makeSlug($languageName, $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);
            $db->update('tbl_site_languages', $insArr, array('id' => $id));

            $response['status'] = true;
            $response['success'] =  'Record has been updated successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    } else {
        if (in_array('add', $Permission)) {

            $insArr['createdDate']     = date('Y-m-d H:i:s');
            $insArr['slug']     = makeSlug($languageName, $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);

            $insertedId            = $db->insert('tbl_site_languages', $insArr)->getLastInsertId();

            $response['status'] = true;
            $response['success'] =  'Record has been added successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    }
}
$CatObj = new SiteLanguages($module);

$pageContent = $CatObj->getPageContent();
require_once DIR_ADMIN_TMPL . "parsing-nct.tpl.php";
