<?php

$reqAuth = true;
require_once("../../../includes-nct/config-nct.php");
include("class.newsletters-nct.php");
$module = "newsletters-nct";
$table = "tbl_newsletters";
$styles = array(
    array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN),
    array("multiselect/css/multi-select.css", SITE_PLUGIN)
);

$scripts = array(
    "core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN),
    array("multiselect/js/jquery.multi-select.js", SITE_PLUGIN)
);

chkPermission($module);
$Permission = chkModulePermission($module);
$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords" => 'Admin Panel',
    "author" => SITE_NM));

$id = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage') . ' Newsletter';
$winTitle = $headTitle . ' - ' . SITE_NM;
$breadcrumb = array($headTitle);

if (isset($_POST["submitAddFormNL"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $response = array();
    $response['status'] = false;
    extract($_POST);
    $sent_on = date("Y-m-d H:i:s");
    $subscribedUsers = array();
    $subscriberId = array();

    $nl_id = isset($id) ? filtering($id, 'input', 'int') : "";
    $subscribedUsers = isset($subscribers) ? $subscribers : "";
    if (!empty($subscribedUsers)) {
        $flagSend = true;
        $qrySelNL = $db->select('tbl_newsletters','*',array('id'=>$nl_id))->result();
        $arrayCont = array();
        foreach ($subscribedUsers as $single_subscriber_id){
            $userDetails = $db->pdoQuery("SELECT s.id,s.subscribedOn,s.userId,u.email,u.userName
                FROM tbl_subscribers AS s
                INNER JOIN tbl_users AS u ON u.id = s.userId
                WHERE s.id = ?  ",array($single_subscriber_id))->result();
            $valArray = array(
                'nl_id' => $nl_id,
                'subscriber_id' => $single_subscriber_id,
                "sent_on" => date("Y-m-d H:i:s")
            );
            $currentLangauge = getTableValue('tbl_language','id',array('default_lan'=>'y'));
            
            $id = $db->insert("tbl_sent_newsletters", $valArray)->getLastInsertId();

            $arrayCont['subject'] = $qrySelNL['newsletter_subject_'.$currentLangauge];
            $arrayCont['newsletter_content'] = $qrySelNL['newsletter_content_'.$currentLangauge];
            $arrayCont['greetings'] = $userDetails['userName'];
            if ($id > 0) {
                sendEmailAddress($userDetails['email'],$arrayCont['subject'],$arrayCont['newsletter_content']);                
            } else {
                $flagSend = false;
            }
        }
        if ($flagSend == true) {
            $activity_array = array("id" => $id, "module" => $module, "activity" => 'add');
            add_admin_activity($activity_array);
            $response['status'] = true;
            $response['success'] = "Newsletter has been sent successfully";
            echo json_encode($response);
            exit;
        } else {
            $response['status'] = false;
            $response['error'] = "There seems to be some issue while sending the Newsletter.";
            echo json_encode($response);
            exit;
        }
    }else{
        $response['status'] = false;
        $response['error'] = "Please select atleast one subscribed user.";
        echo json_encode($response);
        exit;
    }
}

if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    extract($_POST);

    $objPost->newsletter_name = isset($newsletter_name) ? filtering($newsletter_name, 'input') : '';
    $newsletter_subject = isset($newsletter_subject) ? $newsletter_subject : array();
    $newsletter_content = isset($newsletter_content) ? $newsletter_content: array();
    $objPost->status = isset($status) && $status == 'a' ? 'a' : 'd';
    $objPost->added_on = date("Y-m-d H:i:s");
    $objPost->updated_on = date("Y-m-d H:i:s");

    if ($objPost->newsletter_name != "" ) {
        //get eng lang id & generate slug from that
        $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
        if ($type == 'edit' && $id > 0) {
            if (in_array('edit', $Permission)) {            	
                if ($type == 'edit' && $id > 0) {
                    $db->update($table, array(
                        'newsletter_name' => filtering($newsletter_name,'input','string'),
                        'newsletter_subject'=>filtering($newsletter_subject[$engLangId],'input','string'),
                        'newsletter_content'=>filtering($newsletter_content[$engLangId],'input','string'),
                        'status' => $objPost->status,
                        "updated_on" => $objPost->updated_on
                            ), array("id" => $id));
                    //////////////
                    $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                    foreach ($languages as $key => $value) {
                        $newsletter_subject[$value["id"]] = filtering($newsletter_subject[$value["id"]],'input','text');
                        $newsletter_content[$value["id"]] = filtering($newsletter_content[$value["id"]],'input','text');
                        $db->update($table, array('newsletter_subject_'.$value["id"]=>$newsletter_subject[$value["id"]],'newsletter_content_'.$value["id"]=>$newsletter_content[$value['id']]), array("id" => $id));
                    }
                    //////////////
                    $activity_array = array("id" => $id, "module" => $module, "activity" => 'edit');
                    add_admin_activity($activity_array);
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'suc', 'var' => 'Newsletter has been updated successfully.'));
                } else {
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'Entered Newsletter already exists!'));
                }
            } else {
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'You are not authorised to perform this action.'));
            }
        } else {
            if (in_array('add', $Permission)) {
                if (getTotalRows($table, "newsletter_name='" . $objPost->newsletter_name . "'", 'id') == 0) {
                    $valArray = array(
                        'newsletter_name' => filtering($newsletter_name,'input','string'),
                        'newsletter_subject'=>filtering($newsletter_subject[$engLangId],'input','string'),
                        'newsletter_content'=>filtering($newsletter_content[$engLangId],'input','string'),
                        "status" => $objPost->status,
                        "added_on" => $objPost->added_on
                    );
                    $id = $db->insert($table, $valArray)->getLastInsertId();

                    //////////////
                    $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
                    foreach ($languages as $key => $value) {
                        $newsletter_subject[$value["id"]] = filtering($newsletter_subject[$value["id"]],'input','text');
                        $newsletter_content[$value["id"]] = filtering($newsletter_content[$value["id"]],'input','text');
                        $db->update($table, array('newsletter_subject_'.$value["id"]=>$newsletter_subject[$value["id"]],'newsletter_content_'.$value["id"]=>$newsletter_content[$value['id']]), array("id" => $id));
                    }
                    //////////////

                    $activity_array = array("id" => $id, "module" => $module, "activity" => 'add');
                    add_admin_activity($activity_array);
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'suc', 'var' => 'Newsletter has been added successfully.'));
                } else {
                    $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'Entered Newsletter already exists!'));
                }
            } else {
                $toastr_message = $_SESSION["toastr_message"] = disMessage(array('type' => 'err', 'var' => 'You are not authorised to perform this action.'));
            }
        }
        redirectPage(SITE_ADM_MOD . $module);
    } else {
        $toastr_message = array('type' => 'err', 'var' => 'Please fill all required fields carefully.');
    }
}

$objNewsletter = new newsletter($module, $id, NULL);
$pageContent = $objNewsletter->getPageContent();
require_once(DIR_ADMIN_TMPL . "parsing-nct.tpl.php");
