<?php
$reqAuth=true;
require_once("../../../includes-nct/config-nct.php");
require_once("class.coupon-code-nct.php");
$module = "coupon-code-nct";
$table = "tbl_coupon_code";
$styles = array(array("data-tables/DT_bootstrap.css",SITE_ADM_PLUGIN),
			array("bootstrap-switch/css/bootstrap-switch.min.css",SITE_ADM_PLUGIN),
			array("select-multiple/bootstrap-select.min.css", SITE_ADM_JS));

$scripts= array("core/datatable.js",
				array("data-tables/jquery.dataTables.js",SITE_ADM_PLUGIN),
				array("data-tables/DT_bootstrap.js",SITE_ADM_PLUGIN),
				array("bootstrap-switch/js/bootstrap-switch.min.js",SITE_ADM_PLUGIN),
    array("select-multiple/bootstrap-select.min.js", SITE_ADM_JS));

chkPermission($module);
$Permission=chkModulePermission($module);
$metaTag = getMetaTags(array("description"=>"Admin Panel",
		"keywords"=>'Admin Panel',
		'author'=>AUTHOR));

$id = isset($_GET["id"]) ? (int)trim($_GET["id"]) : 0;
$postType = isset($_POST["type"])?trim($_POST["type"]):'';
$type = isset($_GET["type"])?trim($_GET["type"]):$postType;

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage').' Coupon Codes';
$winTitle = $headTitle.' - '.SITE_NM;
$breadcrumb = array($headTitle);


if(isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
	extract($_POST);
	$response = array();
    $response['status'] = false;
	$objPost = new stdClass();
	$objPost->codeName     	= isset($codeName) ? filtering($codeName,'input','string') : '';	
	$objPost->code     		= isset($code) ? filtering($code,'input','string') : '';
	$objPost->startDate     = isset($startDate) ? $startDate : '';
	$objPost->endDate     	= isset($endDate) ? $endDate : '';
	$objPost->discount     	= isset($discount) ? strval($discount) : 0;
	$objPost->maxRedeem     = isset($maxRedeem) ? strval($maxRedeem) : 0;
	$objPost->isActive     	= isset($status) ? $status : 'n';
	$objPost->updatedDate 	= date('Y-m-d H:i:s');

	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			if($objPost->codeName != '' && $objPost->code != '' && $objPost->startDate != '' && $objPost->endDate != '' && $objPost->discount != '' && $objPost->maxRedeem != ''  ){
				$db->update($table,(array)$objPost,array('id'=>$id));
				$activity_array = array("id"=>$id,"module"=>$module,"activity"=>'edit');
				add_admin_activity($activity_array);
				$response['status'] = true;
	            $response['success'] =  'Record has been updated successfully.';
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	} else {
		if(in_array('add',$Permission)){
			if($objPost->codeName != '' && $objPost->code != '' && $objPost->startDate != '' && $objPost->endDate != '' && $objPost->discount != '' && $objPost->maxRedeem != ''  ){
				$objPost->createdDate 	= date('Y-m-d H:i:s');
				$db->insert($table,(array)$objPost);
				$activity_array = array("id"=>$id,"module"=>$module,"activity"=>'edit');
				add_admin_activity($activity_array);
				$response['status'] = true;
	            $response['success'] =  'Record has been added successfully.';
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	redirectPage(SITE_ADM_MOD.$module);
}

if(isset($_POST["submitSendCodeForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
	extract($_POST);
	$response = array();
    $response['status'] = false;
	$userId     	= isset($userId) ? $userId : array();

	if($type == 'edit' && $id > 0){
		if(in_array('edit',$Permission)){
			$codeDetails = $db->pdoQuery("SELECT id,codeName,code,startDate,endDate,discount,maxRedeem FROM tbl_coupon_code WHERE id = ? LIMIT 1 ",array($id))->result();
			if(count($userId) > 0 && !empty($codeDetails)){
				foreach ($userId as $key => $value){
					$userData_q = $db->pdoQuery("SELECT u.id,u.userName,u.email
						FROM tbl_users AS u
						WHERE u.id = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($value,'y','y'));
					if($userData_q->affectedRows() > 0){
						$userData = $userData_q->result();
						//insert into code user
						$insertArray = array(
							'userId'		=>$userData['id'],
							'couponId'		=>$codeDetails['id'],
							'maxLimit'		=>$codeDetails['maxRedeem'],
							'remain'		=>$codeDetails['maxRedeem'],
							'ipAddress'		=>get_ip_address(),
							'createdDate'	=>date('Y-m-d H:i:s'),
							'updatedDate'	=>date('Y-m-d H:i:s')
						);
						$db->insert('tbl_coupon_code_users',$insertArray);
						//insert into code user
						$mailarray = array(
		                    'greetings'     	=>filtering($userData['userName']),
		                    'code'       		=>filtering($codeDetails['code']),
		                    'start_date'       	=>convertDate($codeDetails['startDate']),
		                    'end_date'       	=>convertDate($codeDetails['endDate']),
		                    'discount'       	=>$codeDetails['discount'].'%'
		                );
						$array = generateEmailTemplate('coupon_code_send_to_users', $mailarray);
	            		sendEmailAddress($userData['email'], $array['subject'], $array['message']);
					}
				}
				$response['status'] = true;
	            $response['success'] =  "Coupon code has been sent successfully.";
	            echo json_encode($response);
	            exit;
			}
			else{
				$response['status'] = false;
	            $response['error'] =  "Please fill all values properly.";
	            echo json_encode($response);
	            exit;
			}
		}
		else{
			$response['status'] = false;
            $response['error'] =  "You don't have permission to perform this action.";
            echo json_encode($response);
            exit;
		}
	}
	redirectPage(SITE_ADM_MOD.$module);
}

$objCategory = new CouponCode($id);
$pageContent = $objCategory->getPageContent();

require_once(DIR_ADMIN_TMPL."parsing-nct.tpl.php");