<?php

class CouponCode extends Home {
	public $page_name;
	public $page_title;
	public $meta_keyword;
	public $meta_desc;
	public $page_desc;
	public $isActive;
	public $data = array();
	public function __construct($id=0, $searchArray=array(), $type='') {
		$this->data['id'] = $this->id = $id;
		$this->table = 'tbl_coupon_code';
		$this->type = ($this->id > 0 ? 'edit' : 'add');
		$this->searchArray = $searchArray;
		$this->langArray = array();
		parent::__construct();
		if($this->id>0){
			$qrySel = $this->db->select($this->table, array("*"),array("id"=>$id))->result();
			foreach ($qrySel as $k => $v) {
                $this->{$k} = filtering($v);
            }
		}else{
			$fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
		}

		switch($type){
			case 'add' : {
				$this->data['content'] =  (in_array('add',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'edit' : {
				$this->data['content'] =  (in_array('edit',$this->Permission))?$this->getForm():'';
				break;
			}
			case 'view' : {
				$this->data['content'] =  (in_array('view',$this->Permission))?$this->viewForm():'';
				break;
			}
			case 'sendCode' : {
				$this->data['content'] =  (in_array('sendNL',$this->Permission))?$this->sendCodeForm():'';
				break;
			}
			case 'delete' : {
				$this->data['content'] =  (in_array('delete',$this->Permission))?json_encode($this->dataGrid()):'';
				break;
			}

			case 'datagrid' : {
				$this->data['content'] =  (in_array('module',$this->Permission))?json_encode($this->dataGrid()):'';
			}
		}
	}

	public function viewForm(){
		$content = $this->displayBox(array("label"=>"Coupon Code Name&nbsp;:","value"=>$this->codeName)).
				   $this->displayBox(array("label"=>"Coupon Code&nbsp;:","value"=>$this->code)).
				   $this->displayBox(array("label"=>"Start Date&nbsp;:","value"=>convertDate($this->startDate,true))).
				   $this->displayBox(array("label"=>"End Date&nbsp;:","value"=>convertDate($this->endDate,true))).
				   $this->displayBox(array("label"=>"Discount(%)&nbsp;:","value"=>$this->discount)).
				   $this->displayBox(array("label"=>"Max Redeem&nbsp;:","value"=>$this->maxRedeem)).
				   $this->displayBox(array("label"=>"Status&nbsp;:","value"=>($this->isActive == 'y' ? 'Active' : 'Deactive'))).
				   $this->displayBox(array("label"=>"Created date&nbsp;:","value"=>convertDate($this->createdDate,true)));
		return $content;
	}

	public function getForm() {
		$content = '';
        $status_a = ($this->isActive == 'y' ? 'checked' : '');
        $status_d = ($this->isActive != 'y' ? 'checked' : '');

        $replace = array(
            '%CODE_NAME%'=>$this->codeName,
            '%CODE%'=>$this->code,
            '%START_DATE%'=>$this->startDate,
            '%END_DATE%'=>$this->endDate,
            '%DISCOUNR%'=>$this->discount,
            '%MAX_REDEEM%'=>$this->maxRedeem,
            '%STATUS_A%'=>$status_a,
            '%STATUS_D%'=>$status_d,
            '%TYPE%'=>$this->type,
            '%ID%'=>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

	public function sendCodeForm(){
		$content = '';
        $status_a = ($this->isActive == 'y' ? 'checked' : '');
        $status_d = ($this->isActive != 'y' ? 'checked' : '');

        $replace = array(
            '%CODE_NAME%'=>$this->codeName,
            '%CODE%'=>$this->code,
            '%USERS_OPTION%'=>$this->getUserListForSendCode(),
            '%TYPE%'=>$this->type,
            '%ID%'=>$this->id
        );
        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/sendcode-form-nct.tpl.php",$replace);
        return sanitize_output($content);
	}

	public function getUserListForSendCode(){
		$final_result = '';
		$sent_code_q = $this->db->pdoQuery("SELECT GROUP_CONCAT(userId) as users FROM tbl_coupon_code_users WHERE couponId = ? ",array($this->id))->result();
		$sWhere = 'WHERE u.isActive = ? AND u.isEmailVerify = ? ';
		$aWhere = array('y','y');
		$sWhere .= ( (isset($sent_code_q['users']) && $sent_code_q['users'] != '') ? ' AND u.id NOT IN ('.$sent_code_q['users'].') '  :  '' ); 
		$q = $this->db->pdoQuery("SELECT u.id,u.userName
			FROM tbl_users AS u
			$sWhere ORDER BY u.id DESC ",$aWhere);
		if($q->affectedRows() > 0){
			$select_content = new MainTemplater(DIR_ADMIN_TMPL."/option-nct.tpl.php");
        	$select_content = $select_content->parse();
			foreach ($q->results() as $key => $value){
	            $replace = array(
	                '%OPT_VALUE%'=>$value['id'],
	                '%EXTRA%'=>'',
	                '%SELECTED%'=>'',
	                '%OPT_TEXT%'=>$value['userName']
	            );
	            $final_result .= str_replace(array_keys($replace),array_values($replace),$select_content); 
			}
		}
		return $final_result;
	}

	public function dataGrid() {
		$content = $operation = $whereCond = $totalRow = NULL;
        $result = $tmp_rows = $row_data = array();
        extract($this->searchArray);
        $chr = str_replace(array('_','%'), array('\_','\%'), $chr);
        $aWhere = array(1);
        $sWhere = ' WHERE  1 = ?  ';

        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (c.codeName LIKE ? OR c.code LIKE ? OR c.discount LIKE ? OR c.maxRedeem LIKE ?  )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }

        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'c.id DESC';

        $totalRowTmp = $this->db->pdoQuery("SELECT COUNT(c.id) AS nmrows 
                    FROM tbl_coupon_code AS c
                    $sWhere", $aWhere)->result();
        $totalRow = $totalRowTmp['nmrows'];


        $qrySel = $this->db->pdoQuery("SELECT c.*
                    FROM tbl_coupon_code AS c
                    $sWhere ORDER BY $sorting limit $offset , $rows", $aWhere)->results();
        foreach ($qrySel as $fetchRes) {
            $id = $fetchRes['id'];
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status)) : '';

            $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            $operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';

            if(strtotime(date('Y-m-d H:i:s')) < strtotime($fetchRes['endDate'])){
            	$operation .=(in_array('sendNL', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=sendCode&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs green btnEdit", "value" => '<i class="fa fa-envelope"></i>&nbsp;Send Code')) : '';
            }
            $final_array = array(
                $id,
                filtering($fetchRes['codeName'], 'output', 'string'),
                filtering($fetchRes['code'], 'output', 'string'),
                filtering($fetchRes['discount'], 'output', 'string'),
                filtering($fetchRes['maxRedeem'], 'output', 'string'),
               	convertDate($fetchRes['createdDate'])
            );

            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array(
                    $switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array(
                    $operation));
            }

            $row_data[] = $final_array;
        }

        $result["sEcho"] = $sEcho;
        $result["iTotalRecords"] = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"] = $row_data;

        return $result;
	}
	
	public function toggel_switch($text) {
		$text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
		$text['check']    = isset($text['check']) ? $text['check'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
		$fields_replace   = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	 public function textArea($text) {
		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Password Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? "form-control " . $text['class'] : 'form-control';
		$text['extraAtt']  = isset($text['extraAtt']) ? ' ' . $text['extraAtt'] : '';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		if ($text["onlyField"] == true) {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea_onlyfield.tpl.php');
		} else {
			$main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/textarea.tpl.php');
		}
		$main_content   = $main_content->parse();
		$fields         = array("%CLASS%", "%NAME%", "%ID%", "%VALUE%", "%EXTRA%", "%LABEL%");
		$fields_replace = array($text['class'], $text['name'], $text['name'], $text['value'], $text['extraAtt'], $text['label']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function operation($text) {

		$text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
		$text['value']    = isset($text['value']) ? $text['value'] : '';
		$text['name']     = isset($text['name']) ? $text['name'] : '';
		$text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
		$text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
		$main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
		$main_content     = $main_content->parse();
		$fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
		$fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
		return str_replace($fields, $fields_replace, $main_content);
	}
	public function displaybox($text) {

		$text['label']     = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
		$text['value']     = isset($text['value']) ? $text['value'] : '';
		$text['name']      = isset($text['name']) ? $text['name'] : '';
		$text['class']     = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
		$text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
		$text['extraAtt']  = isset($text['extraAtt']) ? $text['extraAtt'] : '';

		$main_content      = new MainTemplater(DIR_ADMIN_FIELDS_HTML. '/displaybox.tpl.php');
		$main_content      = $main_content->parse();
		$fields            = array("%LABEL%", "%CLASS%", "%VALUE%");
		$fields_replace    = array($text['label'], $text['class'], $text['value']);
		return str_replace($fields, $fields_replace, $main_content);
	}

	public function getPageContent(){
		$final_result             = NULL;
		$main_content             = new MainTemplater(DIR_ADMIN_TMPL.$this->module."/".$this->module.".tpl.php");
		$main_content->breadcrumb = $this->getBreadcrumb();
		$main_content->langArray  = $this->langArray;
		$main_content->getForm    = $this->getForm();
		$final_result             = $main_content->parse();
		return $final_result;
	}

}