<?php
$reqAuth = true;
$module  = "category-nct";
require_once "../../../includes-nct/config-nct.php";
require_once "class.category-nct.php";

$module = "category-nct";
$table  = "tbl_categories";

chkPermission($module);
$Permission = chkModulePermission($module);
$styles     = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN),
    array("cropper.min.css", SITE_ADM_CSS));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN),
    array("cropper.min.js", SITE_ADM_JS));

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords"                                 => 'Admin Panel',
    "author"                                   => SITE_NM));
$breadcrumb = array("Manage categories");

$id        = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$postType  = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type      = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;
$ctypeTxt  = isset($_REQUEST["ctype"]) ? trim($_REQUEST["ctype"]) : "f";
$ctype     = $ctypeTxt == 'pages' ? 't' : ($ctypeTxt == 'messages' ? 'm' : 'f');
$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage ') . ' Categories';
$winTitle  = $headTitle . ' - ' . SITE_NM;
if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $insArr = array();
    extract($_POST);
    $response = array();
    $response['status'] = false;

    $cateNameArr    = isset($cateName) ? $cateName : array();
    $descriptionArr = isset($description) ? filtering($description,'input','text') : array();
    $className = isset($className) ? $className : '';
    $isPopular  = isset($isPopular) ? trim($isPopular) : 'n';
    $hiddenImg = ((isset($hiddenImg) && $hiddenImg != '') ? $hiddenImg : '');
    if ($type == 'edit' && $id > 0) {
        if (in_array('edit', $Permission)) {

            //get eng lang id & generate slug from that
            $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));

            $insArr['isActive'] = $status;
            $insArr['isPopular'] = $isPopular;
            $insArr['className'] = $className;
            $insArr['cateName'] =  filtering($cateNameArr[$engLangId],'input','string');
            /*$insArr['description'] =  $descriptionArr[$engLangId];*/

            if(isset($hiddenImg) && $hiddenImg != ''){
                //upoading category image
                $upload_dir = $id . '/';
                $imagename = getTableValue('tbl_subcategories','image',array('id'=>$id));
                $data_array = array('type'=>'category','path'=>$id.'/');
                deletefile($data_array);
                /* Remove old profile pics of particular user */
                uploadImagewithResize($upload_dir,$hiddenImg,'category');
                $data_array = array('type'=>'category','path'=>'temp_dir/');
                deletefile($data_array);
                $insArr['image'] = $hiddenImg;
            }

            $insArr['slug']     = makeSlug($cateNameArr[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);
            $db->update('tbl_categories', $insArr, array('id' => $id));
            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $cateNameArr[$value["id"]] = filtering($cateNameArr[$value["id"]],'input','string');
                $db->update($table, array('cateName_' . $value["id"] => $cateNameArr[$value["id"]]/*, 'description_' . $value["id"] => $description[$value['id']]*/ ), array("id" => $id));

            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been updated successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    } else {
        if (in_array('add', $Permission)) {

            //get eng lang id & generate slug from that
            $engLangId             = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
            $insArr['createdDate'] = date('Y-m-d H:i:s');
            $insArr['cateName'] =  filtering($cateNameArr[$engLangId],'input','string');
            $insArr['className'] = $className;
            $insArr['image'] = $hiddenImg;
            $insArr['isPopular'] = $isPopular;
            /*$insArr['description'] =  $descriptionArr[$engLangId];*/
            $insertedId            = $db->insert('tbl_categories', $insArr)->getLastInsertId();

            if(isset($hiddenImg) && $hiddenImg != ''){
                //upoading category image
                $upload_dir = $insertedId . '/';
                /* Remove old profile pics of particular user */
                uploadImagewithResize($upload_dir,$hiddenImg,'category');
                $data_array = array('type'=>'category','path'=>'temp_dir/');
                deletefile($data_array);
            }

            $slug_update = makeSlug($cateNameArr[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $insertedId);
            $db->update($table, array('slug'=>$slug_update),array('id'=>$insertedId));

            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $cateNameArr[$value["id"]] = filtering($cateNameArr[$value["id"]],'input','string');
                $db->update($table, array('cateName_' . $value["id"] => $cateNameArr[$value["id"]]/*, 'description_' . $value["id"] => $description[$value['id']]*/), array("id" => $insertedId));

            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been added successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    }
}
$CatObj = new Category($module);

$pageContent = $CatObj->getPageContent();
require_once DIR_ADMIN_TMPL . "parsing-nct.tpl.php";
