<?php
class ViewOffer {
	function __construct($contentArray=array()) {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		extract($contentArray);
		$this->module = $module;
		$this->reqSlug = $reqSlug;
		$this->pageNo = issetor($pageNo,1);
		$this->catSlug = issetor($catSlug);

	}
	public function getPageContent() {
		/*$myRequestList = $this->getOfferList();

		$replaceArr = array('%REQUEST_NOTIFICATION_LIST%'=>$myRequestList['data']['html'],'%REQUEST_NOTIFICATION_PAGINATION%'=>$myRequestList['data']['pagination']);*/
		$offerList = $this->getOfferList();

		$replaceArr = array('%OFFER_LIST%'=>$offerList['data']['html'],'%OFFER_PAGINATION%'=>$offerList['data']['pagination'],'%REQ_SLUG%'=>$this->reqSlug);
		$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
		$content = get_view($tplUrl,$replaceArr);
		return $content;
	}

	public function getOfferList(){
		$whrCondition = $content = "";
		$returnResponse = array();
		if($this->catSlug != ""){
			$whrCondition =  " AND c.slug = ?";
			$whrArr[] = $this->catSlug;
		}

		$qry = "SELECT sr.*,r.slug,u.userName,u.profileImage,(SELECT COUNT(id) FROM tbl_seller_request_notification WHERE requestStatusByCustomer = 'a' AND requestId = r.id) AS totalAccepted FROM tbl_seller_request_notification AS sr INNER JOIN tbl_request AS r ON r.id = sr.requestId INNER JOIN tbl_categories AS c ON c.id = r.catId INNER JOIN tbl_users AS u ON u.id = sr.userId WHERE sr.requestStatusByCustomer != 'n' $whrCondition AND r.requStatus = 'a' AND r.isActive = 'y' AND u.isActive = 'y' AND sr.offerAmount > 0 AND r.slug = ? ORDER BY sr.offerDate DESC";

		$whrArr[] = $this->reqSlug;
		$offer = $this->db->pdoQuery($qry,$whrArr);
		$affRows = $offer->affectedRows();


		$pager = getPagerData($affRows, SCROLL_LIMIT, $this->pageNo);

		if($this->sessRequestType == 'app'){
			$pagination['current_page'] = issetor($pager ->page,0);
			$pagination['total_pages'] = issetor($pager ->numPages,0);
			$pagination['total'] = issetor($affRows,0);
		}else{
			$pagination = pagination($pager, $this->pageNo, $affRows);
		}
		$offset = $pager -> offset;
		if ($offset < 0) {
			$offset = 0;
		}

		$limit = $pager -> limit;

		$page = $pager -> page;

		$limit_cond = " LIMIT $offset, $limit";

		$offerQuery = $this->db->pdoQuery($qry.$limit_cond,$whrArr);

		$NoOfrows = $offerQuery->affectedRows();
		if($NoOfrows > 0){
			$offerList = $offerQuery ->results();
			foreach ($offerList as $key => $offerData) {
				$id = filtering($offerData['id']);
				$slug = filtering($offerData['slug']);
				$userId = filtering($offerData['userId']);
				$userName = filtering($offerData['userName']);
				$profileImage = checkImage($offerData['profileImage'],9,$userId);
				$createdDate = convertDate($offerData['createdDate']);
				$offerDate = convertDate($offerData['offerDate']);
				$requestStatusByCustomer = $offerData['requestStatusByCustomer'];
				$offerDesc = $offerData['description'];
				$deliveryDate = $offerData['deliveryDate'];
				$offerAmount = $offerData['offerAmount'];
				$totalAccepted = $offerData['totalAccepted'];
				$buyerPaid = $offerData['buyerPaid'];


				if($this->sessRequestType == 'web'){

					$ofrData = $hiredTpl = "";
					$url = "javascript:void(0);";
					$hired_show_hide = "hide";
					if($requestStatusByCustomer == 'p' && $totalAccepted == 0){
						$arrReplce = array('%OFFER_ID%'=>$id,'%URL%'=>$url);
						$ofrData = get_view(DIR_TMPL . $this->module . "/before-accept-reject-offer-nct.tpl.php",$arrReplce);
					}else if($requestStatusByCustomer == 'a'){
						if($buyerPaid == 'n'){
							$url = SITE_URL."request-pay-now/".$slug."/";
							$arrReplce = array('%OFFER_ID%'=>$id,'%LABEL%'=>PAY,'%EXTRA_CLASS%'=>'btn-primary payNow','%URL%'=>$url);
							$ofrData = get_view(DIR_TMPL . $this->module . "/after-accept-reject-offer-nct.tpl.php",$arrReplce);
						}else{
							$hired_show_hide = "";
							$arrReplce = array('%LABEL%'=>HIRED,'%EXTRA_CLASS%'=>'label-success btn_hired' ,'%EXTRA_ATTR%'=>'');
							$hiredTpl = get_view(DIR_TMPL . $this->module . "/hired-btn-nct.tpl.php",$arrReplce);

						}
					}else if($requestStatusByCustomer == 'r'){
						$arrReplce = array('%OFFER_ID%'=>$id,'%LABEL%'=>ucwords(REJECTED),'%EXTRA_CLASS%'=>'btn_gray','%EXTRA_ATTR%'=>'disabled');

						$ofrData = get_view(DIR_TMPL . $this->module . "/after-accept-reject-offer-nct.tpl.php",$arrReplce);
					}else{
						$ofrData = "";
						/*$arrReplce = array('%OFFER_ID%'=>$id,'%LABEL%'=>ucwords(REJECTED),'%EXTRA_CLASS%'=>'btn_gray','%EXTRA_ATTR%'=>'disabled');
						$ofrData = get_view(DIR_TMPL . $this->module . "/after-accept-reject-offer-nct.tpl.php",$arrReplce);*/
					}
					/*multi currency change*/
		            $offerAmount = exchange($offerAmount,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'o');
		            /*multi currency change*/
					$replaceArr = array(
							'%OFFER_DESC%'=>$offerDesc,
							'%OFFER_DELIVERY_DATE%'=>convertDate($deliveryDate),
							'%OFFER_BUDGET%'=>CURRENCY_SIGN.$offerAmount,
							'%USER_PROFILE_PHOTO%' => $profileImage,
							'%USER_NAME%' => $userName,
							'%OFFER_CREATED_DATE%' => $offerDate,
							'%OFFER_ACTION_DATA%' => $ofrData,
							'%HIRED_SHOW_HIDE%' => $hiredTpl,

						);
					$content .= get_view(DIR_TMPL . $this->module . "/single-offer-nct.tpl.php",$replaceArr);
					$retData['html'] = $content;
					$retData['pagination'] = $pagination;
					$returnResponse = array(
									'status' => true,
									'message'=> '',
									'data'=> $retData,
								);
				}
			}
		}else{
			$retData['html'] = $content;
			if($this->pageNo == 1){
				$retData['html'] =getNoRecordFoundContent();
			}
			$retData['pagination'] = $pagination;
			$returnResponse = array(
									'status' => false,
									'message'=> '',
									'data'=> $retData,
								);
		}
		return $returnResponse;
	}

	public function acceptReject($request=array()){
		extract($request);
		$isActionPerform = $this->db->select('tbl_seller_request_notification',array('requestStatusByCustomer','userId','requestId'),array('id'=>$notiId,'requestStatusByCustomer'=>'p'));
		if($isActionPerform->affectedRows() > 0){
			$offer = $isActionPerform->result();
			$date = date('Y-m-d H:i:s');
			$updArr['acceptRejectDate'] = $date;
			$updArr['requestStatusByCustomer'] = $actionType == "accept" ? 'a' : 'r';
			$this->db->update('tbl_seller_request_notification',$updArr,array('id'=>$notiId));
			$requestId = $offer['requestId'];

			//send notification
			$sellerId = $offer['userId'];
			$notification_type =  $actionType == "accept" ? 'buyer_accept_offer' : 'buyer_reject_offer';
			$data_array = array(
				'receiverId'=>$sellerId,
				'senderId'=>$this->sessUserId,
				'buyerId' => $this->sessUserId,
				'sellerId' => $sellerId,
				'notifyId'=>$notification_type,
				'entityId'=>$notiId//request notification id
			);
			addNewNotificationForUser($notification_type,$data_array);
			//send notification

		}else{
		}
		$msg = $actionType == "accept" ? MSG_OFFER_ACCEPTED_SUC : MSG_OFFER_REJECTED_SUC;
		if($this->sessRequestType == 'web'){
			if($actionType == 'accept'){
				$slug = getTableValue('tbl_request','slug',array('id'=>$requestId));
				$url = SITE_URL."request-pay-now/".$slug."/";

				$arrReplce = array('%OFFER_ID%'=>$notiId,'%LABEL%'=>PAY,'%EXTRA_CLASS%'=>'btn-primary payNow','%URL%'=>$url);
			}else{
				$arrReplce = array('%OFFER_ID%'=>$notiId,'%LABEL%'=>ucwords(REJECTED),'%EXTRA_CLASS%'=>'btn_gray','%EXTRA_ATTR%'=>'disabled');
			}
			$data = get_view(DIR_TMPL . $this->module . "/after-accept-reject-offer-nct.tpl.php",$arrReplce);
		}else{
			$data = array();
		}
		$returnResponse = array(
						'status' => true,
						'message'=> $msg,
						'data'=> $data,
					);
		return $returnResponse;
	}

	public function requestPayNow($request = array())
	{
		extract($request);
		$qry = $this->db->pdoQuery("SELECT r.id,sr.id AS sellerNotiId,sr.userId,sr.offerAmount FROM tbl_seller_request_notification AS sr INNER JOIN tbl_request AS r ON r.id = sr.requestId INNER JOIN tbl_users AS u ON sr.userId = u.id WHERE sr.requestStatusByCustomer = 'a' AND sr.buyerPaid = 'n' AND r.requStatus = 'a' AND r.isActive = 'y' AND u.isActive = 'y' AND r.slug = ? AND r.userId = ? AND sr.id = ?",array($this->reqSlug,$this->sessUserId,$offerId));
		if($qry->affectedRows() > 0){
			$qryResult = $qry->result();

			$amount = strval($qryResult['offerAmount']);
			$adminCommission = ($amount * ADMIN_COMMISSION) / 100;

			$sellerNotiId = strval($qryResult['sellerNotiId']);
			$paymentInsArr['userId'] = $this->sessUserId;
			$paymentInsArr['entityId'] = $qryResult['id'];
			$paymentInsArr['txnTypeId'] = 4; //4 is used for request_payment
			$paymentInsArr['amount'] = $amount;
			$paymentInsArr['adminCommission'] = $adminCommission;
			$paymentInsArr['createdDate'] = date('Y-m-d H:i:s');
			$paymentInsArr['ipAddress'] = get_ip_address();
			$payment_history_id = $this->db->insert('tbl_payment_history', $paymentInsArr)->lastInsertId();

			$en_action_cancel = '/' . base64_encode($payment_history_id);
			$url_paypal       = PAYPAL_URL;
			$url_paypal .= "?business=" . urlencode(PAYPAL_EMAIL);
			$url_paypal .= "&cmd=" . urlencode('_xclick');
			$url_paypal .= "&item_name=Deposit to wallet- " . urlencode(SITE_NM);
			$url_paypal .= "&item_number=" . urlencode($payment_history_id);
			$url_paypal .= "&custom=" . urlencode($payment_history_id . '__' . $this->sessUserId.'__'.$sellerNotiId);
			$url_paypal .= "&amount=" . urlencode($amount);
			$url_paypal .= "&currency_code=" . urlencode(PAYPAL_CURRENCY_CODE);
			$url_paypal .= "&handling=" . urlencode('0');
			$url_paypal .= "&rm=" . urlencode('2');
			$url_paypal .= "&bn=" . urlencode('NCryptedTechnologies_SP_EC');

			if (strpos($_SERVER["SERVER_NAME"], '192.168.100') !== false || $_SERVER["SERVER_NAME"] == 'localhost' || strpos($_SERVER["SERVER_NAME"], 'nct') !== false) {
				$url_paypal .= "&return=" . urlencode(SITE_URL . 'request-notify/');
			} else {
				$url_paypal .= "&return=" . urlencode(SITE_URL . 'request-thankyou/');
			}
			$url_paypal .= "&cancel_return=" . urlencode(SITE_URL . 'request-failed' . $en_action_cancel);
			$url_paypal .= "&notify_url=" . urlencode(SITE_URL . 'request-notify/');


			$returnResponse = array(
						'status' => true,
						'message'=> '',
						'url' => $url_paypal,
						'data'=> array(),
					);
		}else{
			$returnResponse = array(
						'status' => false,
						'message'=> MSG_SOMETHING_WRONG,
						'url' => SITE_URL.'view-request-offer/'.$this->reqSlug,
						'data'=> array(),
					);
		}
		return $returnResponse;
	}
}

?>
