<?php
class ServiceDetails {
	function __construct($module = "", $slug='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->slug = $slug;
	}

	public function getPageContent(){
		$content = array();
		$data = $this->getServiceDetails();
		if($data['status'] == true){
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";
			$userLevel= ($data['data']['userLevel'] == 'b' ? BEGINNER :
				($data['data']['userLevel'] == 'i' ? INTERMEDIATE : EXPERT
				)
			);

			$make_featured_btn = $sendd_custom_offer_btn = '';
			//recent views entry
			if($this->sessUserId > 0 && $this->sessUserId != $data['data']['userId']){
				$this->db->insert('tbl_users_recents_views',array('userId'=>$this->sessUserId,'serviceId'=>$data['data']['id'],'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));

				$sendd_custom_offer_btn = ($data['data']['acceptOffer'] == 'y' ? get_view(DIR_TMPL . $this->module . "/send-custom-request-nct.tpl.php",array('%SERVICE_SLUG%'=>$data['data']['service_slug'])) : '');
			}else if($this->sessUserId > 0 && $this->sessUserId == $data['data']['userId'] && $data['data']['isActive'] == 'y' && $data['data']['status'] == 'a'){
				$make_featured_btn = ($data['data']['isFeatured'] != 'y' ? get_view(DIR_TMPL . $this->module . "/make-service-featured-btn-nct.tpl.php") : '');
			}
			//recent views entry

			//recent block
			$recent_block = '';
			if($this->sessUserId > 0){
				$recent_block = get_view(DIR_TMPL . $this->module . "/recently-view-nct.tpl.php",array());
			}
			//recent block

			//increase service page view code
			if($this->sessUserId > 0 && $this->sessUserId != $data['data']['userId']){
				$check_ip_q = $this->db->pdoQuery("SELECT id,createdDate FROM tbl_service_page_views
					WHERE serviceId = ? AND userId = ? AND ipAddress = ? ORDER BY id DESC LIMIT 1 ",array($data['data']['id'],$this->sessUserId,get_ip_address()));
				if($check_ip_q->affectedRows() > 0){
					$check_ip_data = $check_ip_q->result();
					$date_diff = date_difference($check_ip_data['createdDate'],date('Y-m-d H:i:s'));
					if($date_diff['hours_total'] >= 24 ){
						$this->db->insert('tbl_service_page_views',array('serviceId'=>$data['data']['id'],'userId'=>$this->sessUserId,'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
					}
				}
				else{
					$this->db->insert('tbl_service_page_views',array('serviceId'=>$data['data']['id'],'userId'=>$this->sessUserId,'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
				}
			}
			else if($this->sessUserId == 0){
				$check_ip_q = $this->db->pdoQuery("SELECT id,createdDate FROM tbl_service_page_views
					WHERE serviceId = ? AND ipAddress = ? AND userId IS NULL  ORDER BY id DESC LIMIT 1  ",array($data['data']['id'],get_ip_address()));
				if($check_ip_q->affectedRows() > 0){
					$check_ip_data = $check_ip_q->result();
					$date_diff = date_difference($check_ip_data['createdDate'],date('Y-m-d H:i:s'));
					if($date_diff['hours_total'] >= 24){
						$this->db->insert('tbl_service_page_views',array('serviceId'=>$data['data']['id'],'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
					}
				}
				else{
					$this->db->insert('tbl_service_page_views',array('serviceId'=>$data['data']['id'],'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
				}
			}
			else{
			}
			//increase service page view code

			//packages list
			$packages = $this->getServicePackages(array('slug'=>$this->slug));
			//packages list

			//post review
			$post_review_btn = ($data['data']['is_post_review_btn'] == 'y' ? get_view(DIR_TMPL . $this->module ."/post-review-btn-nct.tpl.php",array('%SLUG%'=>$data['data']['service_slug'])) : '');
			//post review

			//post reply
			$post_reply_btn = ($data['data']['is_post_reply_btn'] == 'y' ? get_view(DIR_TMPL . $this->module ."/post-reply-btn-nct.tpl.php",array('%SLUG%'=>$data['data']['service_slug'])) : '');
			//post reply

			$feature_tag = ($data['data']['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');

			$contact_btn = ($this->sessUserId > 0 && $this->sessUserId != $data['data']['userId']) ? get_view(DIR_TMPL . $this->module . "/contact-user-nct.tpl.php",array('%SLUG%'=>$data['data']['user_slug'])) : '';

			$favClass = ($data['data']['fav_count'] > 0 ? 'icon-liked' : 'icon-like');


			$isSocialVerified =  isSocialVerified($data['data']['userId']);
			$isUserConsultHiveCertified =  isUserConsultHiveCertified($data['data']['userId']);

        	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
			$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');


			$tagList = '';

			$getTagList = $this->db->pdoQuery("SELECT t.tagName FROM tbl_service_tags AS st INNER JOIN tbl_tags AS t ON t.id = st.tagId INNER JOIN tbl_services AS s ON s.id = st.serviceId WHERE s.slug = ?",array($this->slug));
			if($getTagList->affectedRows() > 0){
				$list = $getTagList->results();
				foreach ($list as $key => $value) {

					$tagList .= get_view(DIR_TMPL .$this->module."/tag-name-nct.tpl.php",array('%TAG_NAME%'=>filtering($value['tagName'])));
				}
			}else{
				$tagList = PROFILE_PAGE_LBL_NO_DATA_AVAILABLE;
			}

			$faqList = $this->getFaqList();

			$getRequirement = $this->db->pdoQuery("SELECT sr.* FROM tbl_service_requirement AS sr INNER JOIN tbl_services AS s ON s.id = sr.serviceId WHERE s.slug = ?",array($this->slug))->result();

			if($getRequirement['type'] == 'm'){
				$rtype = ADD_SERVICE_PAGE_OPT_MUL_TYPE;
				$getLiList = $this->db->pdoQuery("SELECT * FROM tbl_service_requirement_list WHERE requirementId = ?",array($getRequirement['id']))->results();
				$liList  = "";
				foreach ($getLiList as $key => $valueLi) {
					$liList  .= get_view(DIR_TMPL .$this->module."/requirement-li-nct.tpl.php",array('%REQUIREMENT_LI%'=>filtering($valueLi['text'])));
				}
				$reqDetail  = get_view(DIR_TMPL .$this->module."/multiple-requirement-nct.tpl.php",array('%LI_LIST_DETAIL%'=>$liList));

			}else if($getRequirement['type'] == 'fr'){
				$rtype = ADD_SERVICE_PAGE_OPT_FREE_TYPE;
				$reqDetail  = get_view(DIR_TMPL .$this->module."/free-response-nct.tpl.php",array('%REQUIREMENT_DTL%'=>$getRequirement['text']));

			}else{
				$rtype = ADD_SERVICE_PAGE_OPT_FILE;
				$reqDetail  = get_view(DIR_TMPL .$this->module."/attach-file-nct.tpl.php",array('%DOWNLOAD_URL%'=>SITE_URL.'download/service-requirement-download/'.base64_encode($getRequirement['id'])));

			}
			$replace = array(
					'%USER_NAME%'				=>$data['data']['userName'],
					'%USER_IMG%'				=>$data['data']['profileImage'],
					'%USER_SLUG%'				=>$data['data']['user_slug'],
					'%USER_LEVEL%'				=>$userLevel,
					'%CONTACT_BTN%'				=>$contact_btn,
					'%MEMBER_SINCE%'			=>$data['data']['createdDate'],
					'%POSITIVE_RATING%'			=>$data['data']['positive_review_percentag'],
					'%RESPONSE_RATE%'			=>$data['data']['response_rate'],
					'%AVG_RESPONSE_TIME%'		=>$data['data']['average_response_time'],
					'%RECENT_DELIVARY%'			=>$data['data']['recent_delivary_time'],
					'%LOCATION%'				=>($data['data']['location'] != '' ? $data['data']['location'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
					'%EDUCATION%'				=>($data['data']['education'] != '' ? $data['data']['education'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
					'%CERTIFICATE%'				=>($data['data']['certification'] != '' ? $data['data']['certification'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
					'%SERVICE_TITLE%'			=>$data['data']['title'],
					'%CAT_SLUG%'				=>$data['data']['cat_slug'],
					'%CATEGORY%'				=>$data['data']['cateName'],
					'%SUB_CAT_SLUG%'			=>$data['data']['sub_cat_slug'],
					'%SUBCATEGORY%'				=>$data['data']['subCategoryName'],
					'%ID%'						=>$data['data']['id'],
					'%FAV_CLASS%'				=>$favClass,
					'%AVG_REVIEW%'				=>$data['data']['avgRating'],
					'%REVIEW_COUNT%'			=>$data['data']['totalRating'],
					'%SERVICE_GALLERY_LIST%'	=>$this->getServiceGallery(array('slug'=>$this->slug)),
					'%DESCRIPTION%'				=>$data['data']['description'],
					'%SHARE_LINK%'				=>SITE_URL.'service-details/'.$this->slug.'/',
					'%SHARE_IMAGE%'				=>$data['data']['service_image'],
					'%RECENT_BLOCK%'			=>$recent_block,
					'%PKG_TITLE_CONTENT%'		=>$packages['title_content'],
					'%PKG_CONTENT%'				=>$packages['pkg_content'],
					'%CUSTOM_OFFER_BTN%'		=>$sendd_custom_offer_btn,
					'%FEATURE_TAG%'				=>$feature_tag,
					'%POST_REVIEW_BTN%'			=>$post_review_btn,
					'%POST_REPLY_BTN%'			=>$post_reply_btn,
					'%CREDENTIALS_VERIFIED%'	=>$credentials_verfiied_tag,
					'%CONSULT_HIVE_CERTIFIED%'	=>$consultHive_certified_tag,
					'%MAKE_SERVICE_FEATURED%'	=>$make_featured_btn,
					'%TAG_LIST%'				=>$tagList,
					'%ADDITIONAL_INFO%'			=>filtering($data['data']['additionalInfo']),
					'%FAQ_LIST%'				=>$faqList['data'],
					'%FAQ_HIDE_BLOCKS%'			=>$faqList['affectedRows'] > 0 ? '' : 'hidden',
					'%REQUIREMENT%'				=>$getRequirement['requirement'],
					'%REQ_TYPE_NAME%'			=>$rtype,
					'%REQUIREMENT_DETAIL%'		=>$reqDetail,

			);
			$content['html'] = get_view($tplUrl,$replace);
			$content['data'] = $data['data'];
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
		return $content;
	}

	public function getFaqList($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;


        $q = $this->db->pdoQuery("SELECT faq.* FROM tbl_service_faq AS faq INNER JOIN tbl_services AS s ON s.id = faq.serviceId WHERE s.slug = ?",array($slug));
			$return['affectedRows'] = $q->affectedRows();

		$html = "";

		if($q->affectedRows() > 0){
			$q_res = $q->results();
			foreach ($q_res as $key => $value) {
				$replace = array(
								'%FAQ_ID%'=>$value['id'],
								'%FAQ_QUESTION%'=>filtering($value['question']),
								'%FAQ_ANS%'=>filtering($value['answer']),
							);
				$html .=  get_view(DIR_TMPL .$this->module."/faq-single-nct.tpl.php",$replace);
			}


			$return['data'] = $html;
			$return['status'] = true;
		}
		else{
			$return['data'] = NRF;

			$return['message'] = SERVICE_DETAILS_PAGE_SERVICE_NOT_FOUND;
			$return['status'] = false;
		}

		return $return;
	}
	public function getServiceDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$sWhere = ' WHERE  s.isActive = ? AND s.slug = ? AND u.isActive = ? AND c.isActive = ? AND sc.isActive = ? ';
		$aWhere = array('y',$slug,'y','y','y');

		if($this->sessUserId > 0){
			$sWhere .= ' AND ( s.status = ? OR ( s.status = ? AND s.userId = ? ) ) ';
			$aWhere[] = 'a';
			$aWhere[] = 'p';
			$aWhere[] = $this->sessUserId;
		}
		else{
			$sWhere .= ' AND s.status = ? ';
			$aWhere[] = 'a';
		}

        $q = $this->db->pdoQuery("SELECT s.id,s.userId,s.categoryId,s.subCategoryId,s.title,s.slug as service_slug,s.description,s.durationType,s.duration,s.additionalInfo,s.status,s.isActive,s.isFeatured,s.ipAddress,s.createdDate,c.slug as cat_slug,c.cateName_$this->lId as cateName,sc.slug as sub_cat_slug,sc.subCategoryName_$this->lId as subCategoryName,u.userName,u.slug as user_slug,u.email,u.aboutMe,u.profileImage,u.education,u.certification,u.portfolio,u.location,u.userLevel,sg.fileName,u.acceptOffer
        	FROM tbl_services AS s
        	INNER JOIN tbl_users AS u ON u.id = s.userId
        	LEFT JOIN tbl_categories AS c ON c.id = s.categoryId
        	LEFT JOIN tbl_subcategories AS sc ON sc.id = s.subCategoryId
        	LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
        	$sWhere LIMIT 1 ",$aWhere);

		if($q->affectedRows() > 0){
			$q_res = $q->result();

			$data_array = array('userId'=>$q_res['userId'],'type'=>'positive_review_percentag');
			$positive_review_percentag =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['userId'],'type'=>'response_rate');
			$response_rate =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['userId'],'type'=>'average_response_time');
			$average_response_time =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['userId'],'type'=>'recent_delivary_time');
			$recent_delivary_time =  getUserStatics($data_array);

			$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$q_res['id'],'userId'=>$this->sessUserId));

			$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
				FROM tbl_orders AS o
				INNER JOIN tbl_reviews AS r ON r.orderId = o.id
				WHERE o.entityId = ? AND o.orderType = ?   AND o.status =  ? ",array($q_res['id'],'s','c'))->result();
			$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
			$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);
			$sImg = checkImage($q_res['fileName'],8,$q_res['id']);

			//checking whether any review is pending from user(buyer)
			$is_post_review_btn = 'n';
			if($this->sessUserId > 0){
				$review_q = $this->db->pdoQuery("SELECT o.id
					FROM tbl_orders AS o
					WHERE o.userId = ? AND ( o.status = ? OR o.status = ? ) AND o.orderType = ? AND o.entityId = ?  ORDER BY o.id DESC ",array($this->sessUserId,'c','l','s',$q_res['id']));
				if($review_q->affectedRows() > 0){
					foreach ($review_q->results() as $key => $value){
						$check = $this->db->pdoQuery("SELECT id FROM tbl_reviews WHERE orderId = ? AND userFrom = ? ",array($value['id'],$this->sessUserId))->affectedRows();
						if($check <= 0){
							$is_post_review_btn = 'y';
							break;
						}
					}
				}
			}
			//checking whether any review is pending from user(buyer)

			//checking whether any reply is pending from user(seller)
			$is_post_reply_btn = 'n';
			if($this->sessUserId > 0){
				$review_q = $this->db->pdoQuery("SELECT r.id
					FROM tbl_reviews AS r
					INNER JOIN tbl_orders AS o ON o.id = r.orderId
					WHERE r.userTo =  ? AND o.orderType = ? AND  o.entityId = ? ",array($this->sessUserId,'s',$q_res['id']));
				if($review_q->affectedRows() > 0){
					foreach ($review_q->results() as $key => $value){
						$check = $this->db->pdoQuery("SELECT id FROM tbl_review_reply WHERE reviewId = ? ",array($value['id']))->affectedRows();
						if($check <= 0){
							$is_post_reply_btn = 'y';
							break;
						}
					}
				}
			}
			//checking whether any reply is pending from user(seller)


			$return['data'] = array(
				'id'							=>$q_res['id'],
				'userId'						=>$q_res['userId'],
				'categoryId'					=>$q_res['categoryId'],
				'subCategoryId'					=>$q_res['subCategoryId'],
				'isFeatured'					=>$q_res['isFeatured'],
				'fav_count'						=>$fav_count,
				'title'							=>filtering($q_res['title']),
				'service_image'					=>$sImg,
				'service_slug'					=>filtering($q_res['service_slug']),
				'description'					=>filtering($q_res['description'],'output','text'),
				'durationType'					=>filtering($q_res['durationType']),
				'duration'						=>filtering($q_res['duration']),
				'additionalInfo'				=>filtering($q_res['additionalInfo'],'output','text'),
				'status'						=>filtering($q_res['status']),
				'isActive'						=>filtering($q_res['isActive']),
				'ipAddress'						=>filtering($q_res['ipAddress']),
				'cateName'						=>filtering($q_res['cateName']),
				'subCategoryName'				=>filtering($q_res['subCategoryName']),
				'userName'						=>filtering($q_res['userName']),
				'user_slug'						=>filtering($q_res['user_slug']),
				'cat_slug'						=>filtering($q_res['cat_slug']),
				'sub_cat_slug'					=>filtering($q_res['sub_cat_slug']),
				'profileImage'					=>checkImage($q_res['profileImage'],9,$q_res['userId']),
				'education'						=>filtering($q_res['education'],'output','text'),
				'certification'					=>filtering($q_res['certification'],'output','text'),
				'portfolio'						=>filtering($q_res['portfolio'],'output','text'),
				'location'						=>filtering($q_res['location']),
				'userLevel'						=>filtering($q_res['userLevel']),
				'acceptOffer'					=>$q_res['acceptOffer'],
				'description'					=>filtering($q_res['description'],'output','text'),
				'createdDate'					=>convertDate($q_res['createdDate']),
				'positive_review_percentag'		=>$positive_review_percentag['positive_review_percentag'],
				'response_rate'					=>$response_rate['response_rate'],
				'average_response_time'			=>$average_response_time['average_response_time'],
				'recent_delivary_time'			=>$recent_delivary_time['recent_delivary_time'],
				'avgRating'						=>$avgRating,
				'totalRating'					=>$totalRating,
				'is_post_review_btn'			=>$is_post_review_btn,
				'is_post_reply_btn'				=>$is_post_reply_btn
			);
			if($this->sessRequestType != 'web'){
				$return['service_gallery'] 		= $this->getServiceGallery(array('slug'=>$this->slug));
				$return['service_review_list'] 	= $this->getServiceReviewsList(array('slug'=>$this->slug));
				$return['other_service_list'] 	= $this->getOtherServicesList(array('slug'=>$this->slug));
				$return['similar_service_list'] = $this->getSimilarServicesList(array('slug'=>$this->slug));
				$return['packages_list'] 		= $this->getServicePackages(array('slug'=>$this->slug));
				if($this->sessUserId > 0){
					$return['recent_services_views'] = $this->getRecentlyViewServicesList(array('slug'=>$this->slug));
				}
			}
			$return['status'] = true;
		}
		else{
			$return['message'] = SERVICE_DETAILS_PAGE_SERVICE_NOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	/*Get Service Packahes List*/
	public function getServicePackages($data=array()){
    	extract($data);
    	$slug = isset($slug) ? $slug : $this->slug;
    	$return = array();
    	$content = array();
    	$content['title_content'] = '';
    	$content['pkg_content'] = '';
        $q = $this->db->pdoQuery("SELECT sp.*,p.name_$this->lId as name,p.id as pid,s.userId
            FROM tbl_service_packages AS sp
            INNER JOIN tbl_services AS s ON s.id = sp.serviceId
            INNER JOIN tbl_packages AS p ON p.id = sp.packageId
            WHERE s.slug = ? ORDER BY p.id ASC ",array($slug));
        if($q->affectedRows() > 0){
        	foreach ($q->results() as $key => $value){
        		$description = filtering($value['description'],'output','text');
        		$name = filtering($value['name'],'output');
        		if($this->sessRequestType == 'web'){

        			/*multi currency change*/
	            	$value['price'] = exchange($value['price'],DEFAULT_CURRENCY_CODE,$this->cCode,$value['serviceId'],'s');
	            	/*multi currency change*/

	            	/*multi currency change*/
	            	$value['extraServicePrice'] = exchange($value['extraServicePrice'],DEFAULT_CURRENCY_CODE,$this->cCode,$value['serviceId'],'s');
	            	/*multi currency change*/

        			$replace = array(
        				'%PID%'			=>$value['pid'],
        				'%PKG_TITLE%'	=>$name,
        				'%ACTIVE_CLASS%'=>($key == 0 ? 'active' : '')
        			);
        			$content['title_content'] .= get_view(DIR_TMPL.$this->module.'/pkg-title-nct.tpl.php',$replace);
        			$order_now_btn = '';
        			$add_to_cart_btn = '';
        			if($this->sessUserId > 0){
        				if($this->sessUserId  == $value['userId']){
        					$add_to_cart_btn = '';
        					$order_now_btn = get_view(DIR_TMPL.$this->module.'/pkg-price-btn-nct.tpl.php',array('%PRICE%'=>($value['price'])));

        				}
        				else{
        					$cart_cehck = $this->db->pdoQuery("SELECT id FROM tbl_cart WHERE userId = ? AND serviceId = ? AND packageId = ? ",array($this->sessUserId,$value['serviceId'],$value['pid']))->affectedRows();
        					$order_now_btn = get_view(DIR_TMPL.$this->module.'/pkg-order-now-btn-nct.tpl.php',
        						array(
        							'%PID%'				=>$value['pid'],
        							'%SLUG%'			=>$this->slug,
        							'%PRICE%'			=>($value['price']),
        							'%ORDER_NOW_CLASS%'	=>($cart_cehck > 0 ? '' : 'order_now'),
        							'%URL%'				=>($cart_cehck > 0 ? SITE_URL.'cart/' : 'javascript:void(0);')
        						)
        					);
        					$add_to_cart_btn = get_view(DIR_TMPL.$this->module.'/pkg-add-cart-btn-nct.tpl.php',
        						array(
        							'%PID%'			=>$value['pid'],
        							'%SLUG%'		=>$this->slug,
        							'%PRICE%'		=>($value['price']),
        							'%CART_CLASS%'	=>($cart_cehck > 0 ? '' : 'add_to_cart'),
        							'%CART_TEXT%'	=>($cart_cehck > 0 ? SERVICE_DETAILS_PAGE_LBL_ADDED_TO_CART : SERVICE_DETAILS_PAGE_LBL_ADD_TO_CART)
        						)
        					);
        				}
        			}
        			else{
        				$order_now_btn = get_view(DIR_TMPL.$this->module.'/pkg-price-btn-nct.tpl.php',array('%PRICE%'=>($value['price'])));
        				$add_to_cart_btn = get_view(DIR_TMPL.$this->module.'/pkg-add-cart-btn-nct.tpl.php',
        						array(
        							'%PID%'			=>$value['pid'],
        							'%SLUG%'		=>$this->slug,
        							'%PRICE%'		=>($value['price']),
        							'%CART_CLASS%'	=>($cart_cehck > 0 ? '' : 'add_to_cart'),
        							'%CART_TEXT%'	=>($cart_cehck > 0 ? SERVICE_DETAILS_PAGE_LBL_ADDED_TO_CART : SERVICE_DETAILS_PAGE_LBL_ADD_TO_CART)
        						)
        					);
        			}

        			$replace = array(
        				'%PID%'			=>$value['pid'],
        				'%PKG_TITLE%'	=>$name,
        				'%ACTIVE_CLASS%'=>($key == 0 ? 'active' : ''),
        				'%DESCRIPTION%'	=>$description,
        				'%PRICE%'		=>($value['price']),
        				'%SLUG%'		=>$this->slug,
        				'%ORDER_NOW_BTN%'=>$order_now_btn,
        				'%ADD_TO_CART%' =>$add_to_cart_btn,
        				'%ADON_SERVICE%'=>filtering($value['extraService']),
        				'%ADON_PRICE%'=>$value['extraServicePrice'],
        			);
        			$content['pkg_content'] .= get_view(DIR_TMPL.$this->module.'/pkg-content-nct.tpl.php',$replace);
        		}
        		else{
        			$return['data'][] = array(
        				'id'=>$value['id'],
        				'packageId'=>$value['id'],
        				'serviceId'=>$value['serviceId'],
        				'description'=>$description,
        				'deliveryDays'=>$value['deliveryDays'],
        				'price'=>($value['price'] ),
        				'extraServicePrice'=>($value['extraServicePrice']),
        				'total_price'=>($value['price'] + $value['extraServicePrice']),
        				'extraService'=>$value['extraService'],
        				'createdDate'=>convertDate($value['id'])
        			);
        		}
        	}
        }
        else{
        	$return['message'] = SERVICE_DETAILS_PAGE_MSG_NO_PKG_FOUND;
			$content['title_content'].=getNoRecordFoundContent(SERVICE_DETAILS_PAGE_MSG_NO_PKG_FOUND);
			$return['status'] = false;
        }
        return getreturnType($return,$content);
    }
	/*Get Service Packahes List*/

	/*Get Service Gallery*/
	public function getServiceGallery($data=array()){
    	extract($data);
    	$slug = isset($slug) ? $slug : $this->slug;
    	$return = array();
    	$content = '';
        $q = $this->db->pdoQuery("SELECT sg.id,sg.serviceId,sg.fileType,sg.fileName,s.title
                FROM tbl_service_gallery AS sg
                INNER JOIN tbl_services AS s ON s.id = sg.serviceId
                WHERE s.slug = ?  ",array($slug));
        if($q->affectedRows() > 0){
        	foreach ($q->results() as $key => $value){
        		$image = '';
        		$image_thumb = '';
        		$video = '';
        		$tplUrl = 'service-image-nct.tpl.php';
        		if($value['fileType'] == 'i'){
        			$image = checkImage($value['fileName'],7,$value['serviceId']);
        			$image_thumb = checkImage($value['fileName'],8,$value['serviceId']);
        		}
        		else{
        			$video = SITE_UPD.'services/'.$value['serviceId'].'/'.$value['fileName'];
        			$tplUrl = 'service-video-nct.tpl.php';
        		}
        		if($this->sessRequestType == 'web'){
        			$replace = array(
	                    '%SERVICE_TITLE%'=>filtering($value['title']),
	                    '%IMAGE%'=>$image,
	                    '%IMAGE_THUMB%'=>$image_thumb,
	                    '%VIDEO%'=>$video,
	                );
	                $content .= get_view(DIR_TMPL.$this->module.'/'.$tplUrl,$replace);
        		}
        		else{
        			$return[] = array(
	        			'id'				=>$value['id'],
	        			'serviceId'			=>filtering($value['serviceId']),
	        			'fileType'			=>$value['fileType'],
	        			'fileName'			=>$value['fileName'],
	        			'image'				=>$image,
	        			'video'				=>$video
	        		);
        		}
        	}
        }
        else{
        	if($this->sessRequestType == 'web'){
        		$replace = array(
                    '%SERVICE_TITLE%'=>'',
                    '%IMAGE%'=>checkImage('',7),
                    '%VIDEO%'=>''
                );
                $content .= get_view(DIR_TMPL.$this->module.'/service-image-nct.tpl.php',$replace);
        	}
        }
        return getreturnType($return,$content);
    }
	/*Get Service Gallery*/

	/*Review List*/
	public function getServiceReviewsList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
		$content['view_more'] = 'n';

 		$sWhere = ' WHERE o.orderType = ? AND s.slug = ? AND uto.isActive = ? AND ufrom.isActive = ? AND r.isActive = ?  ';
		$aWhere = array('s',$this->slug,'y','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' r.id DESC ';

		$totalRowCount = $this->db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
                    INNER JOIN tbl_orders AS o ON (o.id = r.orderId AND o.orderType = 's')
                    INNER JOIN tbl_services AS s ON s.id = o.entityId
					LEFT JOIN tbl_review_reply AS rr ON rr.reviewId = r.id
					INNER JOIN tbl_users AS ufrom ON ufrom.id =r.userFrom
					INNER JOIN tbl_users AS uto ON uto.id =r.userTo
                    $sWhere GROUP BY r.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT r.id,r.orderId,r.userFrom,r.userTo,r.review,r.rating,r.createdDate,ufrom.userName as userFromName,ufrom.profileImage as userFromprofileImage,uto.profileImage as utoprofileImage,ufrom.slug as userFromslug,uto.userName as utoName,uto.slug as utoslug,rr.reply,rr.createdDate as replycreatedDate,rr.id as reply_main_id
			FROM tbl_reviews AS r
			INNER JOIN tbl_orders AS o ON (o.id = r.orderId AND o.orderType = 's')
			INNER JOIN tbl_services AS s ON s.id = o.entityId
			LEFT JOIN tbl_review_reply AS rr ON rr.reviewId = r.id
			INNER JOIN tbl_users AS ufrom ON ufrom.id =r.userFrom
			INNER JOIN tbl_users AS uto ON uto.id =r.userTo
			$sWhere GROUP BY r.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$reply_main_id = $value['reply_main_id'];
				$userFromName = filtering(ucwords($value['userFromName']));
				$userFromslug = filtering($value['userFromslug']);
				$utoName = filtering($value['utoName']);
				$utoslug = filtering($value['utoslug']);
				$review = filtering($value['review'],'output','text');
				$reply = filtering($value['reply'],'output','text');
				$userFromprofileImage = checkImage($value['userFromprofileImage'],9,$value['userFrom']);
				$utoprofileImage = checkImage($value['utoprofileImage'],9,$value['userTo']);

				if($this->sessRequestType == 'web'){
					$reply_content= '';
					if($reply_main_id > 0){
						$replace_reply = array(
							'%TO_USER_URL%'=>SITE_URL.'profile/'.$utoslug,
							'%TO_USER_IMG%'=>$utoprofileImage,
							'%TO_USER_NAME%'=>$utoName,
							'%REVIEW_REPLY%'=>$reply
						);
						$reply_content = get_view(DIR_TMPL . $this->module . "/reply-for-review-nct.tpl.php",$replace_reply);
					}
					$replace = array(
						'%FROM_USER_URL%'=>SITE_URL.'profile/'.$userFromslug,
						'%FROM_USER_NAME%'=>$userFromName,
						'%FROM_USER_IMG%'=>$userFromprofileImage,
						'%RATING%'=>$value['rating'],
						'%REVIEW%'=>$review,
						'%REPLY_CONTENT%'=>$reply_content
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/review-list-nct.tpl.php",$replace);
					/*$content['pagination'] = pagination($pager, $page, $totalRow);*/
					$content['view_more'] = ($pager->page > 0 && ($pager->page < $pager->numPages) ? 'y' : 'n');
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'orderId'			=>$value['orderId'],
						'userFrom'			=>$value['userFrom'],
						'userTo'			=>$value['userTo'],
						'userFromslug'		=>$userFromslug,
						'utoslug'			=>$utoslug,
						'review'			=>$review,
						'reply'				=>$reply,
						'rating'			=>$value['rating'],
						'createdDate'		=>$value['createdDate'],
						'replycreatedDate'	=>$value['replycreatedDate'],
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_NO_REVIEWS_FOUND;
			$content['html'].=getNoRecordFoundContent(PROFILE_PAGE_MSG_NO_REVIEWS_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
	/*Review List*/

	/*Other servvices List*/
	public function getOtherServicesList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$userId = getTableValue('tbl_services','userId',array('slug'=>$slug));
 		$sWhere = ' WHERE s.slug != ? AND s.userId = ?  AND s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,$userId,'a','y','y');

		$sorting = ' (SELECT COUNT(id) FROM tbl_orders WHERE entityId = s.id AND orderType = "s" AND  status = "c" ) DESC,s.title ASC   ';

        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.isFeatured,u.userLevel
			FROM tbl_services AS s
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
			$sWhere GROUP BY s.id  ORDER BY $sorting LIMIT 10", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];

				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.orderType = ? AND o.status = ? ",array($id,'s','c'))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');
				$user_level = ($value['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($value['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
				$user_level_class = ($value['userLevel'] == 'b' ? 'begginer-tag' : ($value['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));

				$isSocialVerified =  isSocialVerified($userId);
				$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);

				if($this->sessRequestType == 'web'){
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

		            $feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');
					$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
					$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag,
						'%USER_LEVEL_CLASS%'	=>$user_level_class,
						'%USER_LEVEL%'			=>$user_level,
						'%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
						'%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/other-service-list-nct.tpl.php",$replace);
				}
				else{
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL.'profile/'.$user_slug.'/',
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SERVICE_DETAILS_PAGE_MSG_NO_OTHER_SERVICE_FOUND;
			$content['html'].=getNoRecordFoundContent(SERVICE_DETAILS_PAGE_MSG_NO_OTHER_SERVICE_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
	/*Other servvices List*/

	/*Similar servvices List*/
	public function getSimilarServicesList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';

 		$data = $this->db->pdoQuery("SELECT categoryId,subCategoryId FROM tbl_services WHERE slug = ? ",array($slug))->result();
 		$sWhere = ' WHERE s.slug != ? AND s.categoryId = ? AND s.subCategoryId = ? AND  s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,$data['categoryId'],$data['subCategoryId'],'a','y','y');

		$sorting = ' (SELECT COUNT(id) FROM tbl_orders WHERE entityId = s.id AND orderType = "s" AND  status = "c" ) DESC,s.title ASC   ';

        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.isFeatured,u.userLevel
			FROM tbl_services AS s
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
			$sWhere GROUP BY s.id  ORDER BY $sorting LIMIT 15 ", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];
				$user_level = ($value['userLevel'] == 'b' ? SEARCH_SERVICES_PAGE_LBL_BEGINEER : ($value['userLevel'] == 'i' ? SEARCH_SERVICES_PAGE_LBL_INTER_MIDIATE : SEARCH_SERVICES_PAGE_LBL_EXPERT));
				$user_level_class = ($value['userLevel'] == 'b' ? 'begginer-tag' : ($value['userLevel'] == 'i' ? 'intermediate-tag' : 'expert-tag'));

				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.orderType = ? AND o.status = ? ",array($id,'s','c'))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$totalSales = $this->db->pdoQuery("SELECT id FROM tbl_orders WHERE entityId = ? AND orderType = ? AND
					status NOT IN (?,?) ",array($value['id'],'s','e','ca'))->affectedRows();

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');

				$isSocialVerified =  isSocialVerified($userId);
				$isUserConsultHiveCertified =  isUserConsultHiveCertified($userId);


				if($this->sessRequestType == 'web'){
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

		            $feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');


		        	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
					$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%TOTAL_SALES%'			=>$totalSales,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag,
						'%USER_LEVEL_CLASS%'	=>$user_level_class,
						'%USER_LEVEL%'			=>$user_level,
						 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
						 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/similar-service-list-nct.tpl.php",$replace);
				}
				else{
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL,
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SERVICE_DETAILS_PAGE_MSG_NO_SIMILAR_SERVICE_FOUND;
			$content['html'].=getNoRecordFoundContent(SERVICE_DETAILS_PAGE_MSG_NO_SIMILAR_SERVICE_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
	/*Similar servvices List*/

	/*Recently Viewd servvices List*/
	public function getRecentlyViewServicesList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug > 0) ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
		$content['view_more'] = 'n';

 		$sWhere = ' WHERE s.slug != ? AND rv.userId = ?  AND s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,$this->sessUserId,'a','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' rv.id DESC ';

		$totalRowCount = $this->db->pdoQuery("SELECT rv.id
			FROM tbl_users_recents_views AS rv
            INNER JOIN tbl_services AS s ON s.id =  rv.serviceId
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
           	$sWhere GROUP BY s.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.description,s.isFeatured
			FROM tbl_users_recents_views AS rv
            INNER JOIN tbl_services AS s ON s.id =  rv.serviceId
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
			$sWhere GROUP BY s.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$description = filtering($value['description'],'output','text');
				$description = myTruncate($description,250);
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];


				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');

				if($this->sessRequestType == 'web'){
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

		            $feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%DESCRIPTION%'			=>$description,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/recently-viewed-service-list-nct.tpl.php",$replace);
					/*$content['pagination'] = pagination($pager, $page, $totalRow);*/
					$content['view_more'] = ($pager->page > 0 && ($pager->page < $pager->numPages) ? 'y' : 'n');
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'description'		=>$description,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL.'profile/'.$user_slug.'/',
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = SERVICE_DETAILS_PAGE_MSG_NO_SERVICES_FOUND;
			$content['html'].=getNoRecordFoundContent(SERVICE_DETAILS_PAGE_MSG_NO_SERVICES_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}
	/*Recently Viewd servvices List*/

	/*Remove servvice from recent view*/
	public function removeServiceFromRecentView($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $id = filtering(issetor($id,0),'input','int');

        if($id > 0){
        	$check = $this->db->pdoQuery("SELECT id FROM tbl_users_recents_views WHERE userId = ? AND serviceId = ?  ",array($this->sessUserId,$id))->affectedRows();
        	if($check > 0){
        		$this->db->delete('tbl_users_recents_views',array('userId'=>$this->sessUserId,'serviceId'=>$id));
        		$return['message'] = SERVICE_DETAILS_PAGE_MSG_REMOVE_FROM_RECENT;
        		$return['status'] = true;
        	}
        	else{
        		$return['message'] = SERVICE_DETAILS_PAGE_MSG_RECORD_NOT_FOUND;
        	}
        }
        else{
        	$return['message'] =  SERVICE_DETAILS_PAGE_MSG_SOMETHING_WENT_WRONG;
        }
        return $return;
	}

	public function removeAllFromRecentView($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $id = filtering(issetor($id,0),'input','int');

        if($this->sessUserId > 0){
        	$check = $this->db->pdoQuery("SELECT id FROM tbl_users_recents_views WHERE userId = ?  ",array($this->sessUserId))->affectedRows();
        	if($check > 0){
        		$this->db->delete('tbl_users_recents_views',array('userId'=>$this->sessUserId));
        		$return['message'] = SERVICE_DETAILS_PAGE_MSG_ALL_SERVICE_REMOVED;
        		$return['status'] = true;
        	}
        	else{
        		$return['message'] = SERVICE_DETAILS_PAGE_MSG_RECORD_NOT_FOUND;
        	}
        }
        else{
        	$return['message'] =  SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
        }
        return $return;
	}
	/*Remove servvice from recent view*/

	/*contact seller popup*/
	public function getContactUserContent(){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';
		$q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug
			FROM tbl_services AS s
			INNER JOIN tbl_users AS u ON u.id = s.userId
			WHERE s.slug = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($this->slug,'y','y'));
		if($q->affectedRows() > 0 && $this->sessUserId > 0){
			$udata = $q->result();
			if($this->sessUserId != $udata['id']){
				$replace = array(
					'%USER_NAME%'=>$udata['userName']
				);
				$return['status'] = true;
				$return['data'] = get_view(DIR_TMPL . $this->module . "/contact-user-popup-nct.tpl.php",$replace);
			}
			else{
				$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
			}
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
		}
		return $return;
	}

	public function sendMessageToUser($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = SITE_URL.'dashboard/';
        $return['message'] = '';
        $return['data'] = array();

        $message 	= filtering(issetor($message,''),'input');

        if($message != ''){
        	$q = $this->db->pdoQuery("SELECT u.id,s.id as service_id
				FROM tbl_services AS s
				INNER JOIN tbl_users AS u ON u.id = s.userId
				WHERE s.slug = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($this->slug,'y','y'))->result();
        	$receiverId = $q['id'];

        	if($this->sessUserId != $receiverId){
        		$lastId = $this->db->insert('tbl_messages',array('entityId'=>$q['service_id'],'senderId'=>$this->sessUserId,'receiverId'=>$receiverId,'message'=>$message,'createdDate'=>date('Y-m-d H:i:s'),'ipAddress'=>get_ip_address()))->getLastInsertId();

        		//send notification
				$notification_type = 'message_sent';
				$data_array = array(
					'receiverId'=>$receiverId,
					'senderId'=>$this->sessUserId,
					'notifyId'=>$notification_type,
					'entityId'=>$lastId,
					'is_email_notification' => 'y',
					'message'=>$message
				);
				addNewNotificationForUser($notification_type,$data_array);
				//send notification
        		$return['message'] = PROFILE_PAGE_MSG_MESSAGE_SEND_SUCCESS;
        		$return['status'] = true;
        	}
        	else{
        		$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}
	/*contact seller popup*/

	/*Order now / Add to cart */
	public function addpackageToCart($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $pid 		= filtering(issetor($pid,0),'input','int');
        $slug 		= filtering(issetor($slug,''),'input');

        if($pid != '' && $slug != '' ){
        	if($this->sessUserId > 0){
        		$check = $this->db->pdoQuery("SELECT sp.id,s.userId,s.id as serviceId,sp.packageId,sp.price,u.vacationMode,
        			(SELECT COUNT(id) FROM tbl_cart WHERE userId = ? AND serviceId = s.id AND packageId = sp.packageId ) as cart_count
        			FROM tbl_service_packages AS sp
        			INNER JOIN tbl_services AS s ON s.id = sp.serviceId
        			INNER JOIN tbl_users AS u ON u.id = s.userId
        			WHERE sp.packageId = ? AND s.slug = ? LIMIT 1 ",array($this->sessUserId,$pid,$slug));
        		if($check->affectedRows() > 0){
        			$check_data = $check->result();
        			if($check_data['userId'] != $this->sessUserId){
        				if($check_data['vacationMode'] == 'n'){
        					if($check_data['cart_count'] <= 0){
	        					$this->db->insert('tbl_cart',array('userId'=>$this->sessUserId,'serviceId'=>$check_data['serviceId'],'packageId'=>$check_data['packageId'],'createdDate'=>date('Y-m-d H:i:s'),'updatedDate'=>date('Y-m-d H:i:s')));
	        					if($this->sessRequestType == 'web'){

	        						/*multi currency change*/
					            	$check_data['price'] = exchange($check_data['price'],DEFAULT_CURRENCY_CODE,$this->cCode,$check_data['serviceId'],'s');
					            	/*multi currency change*/

	        						$return['data']['order_now_btn'] = get_view(DIR_TMPL.$this->module.'/pkg-order-now-btn-nct.tpl.php',
											array(
												'%PID%'				=>$check_data['packageId'],
												'%SLUG%'			=>$this->slug,
												'%PRICE%'			=>($check_data['price']),
												'%ORDER_NOW_CLASS%'	=>'',
												'%URL%'				=>SITE_URL.'cart/'
											)
										);
									$return['data']['add_to_cart_btn'] = get_view(DIR_TMPL.$this->module.'/pkg-add-cart-btn-nct.tpl.php',
										array(
											'%PID%'			=>$check_data['packageId'],
											'%SLUG%'		=>$this->slug,
											'%PRICE%'		=>($check_data['price']),
											'%CART_CLASS%'	=>'',
											'%CART_TEXT%'	=>SERVICE_DETAILS_PAGE_LBL_ADDED_TO_CART
										)
									);
	        					}

	        					$return['message'] = SERVICE_DETAILS_PAGE_MSG_ADDED_TO_CART;
	        					$return['status'] = true;
	        				}
	        				else{
	        					$return['redirectLink'] = SITE_URL.'cart/';
	        					$return['message'] =  SERVICE_DETAILS_PAGE_MSG_SERVICE_ALREADY_IN_CART;
	        				}
        				}
        				else{
        					$return['message'] =  SERVICE_DETAILS_PAGE_MSG_USER_IS_ON_VACATION_MODE;
        				}
        			}
        			else{
        				$return['message'] =  SERVICE_DETAILS_PAGE_MSG_CAN_NOT_ADD_OWN_SERVICE;
        			}
        		}
        		else{
        			$return['message'] =  SERVICE_DETAILS_PAGE_MSG_PKG_DETAIL_FOUND;
        		}
        	}
        	else{
        		$return['redirectLink'] = SITE_URL.'login';

        		$return['message'] =  SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
        		$_SESSION['req_url'] =$_SERVER['REQUEST_URI'];
        		$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED));
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}
	/*Order now / Add to cart */

	/*Post Review Popup*/
	public function getPostReviewForServiceContent($data=array()){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';

		//checking whether any review is pending from user(buyer)
		if($this->sessUserId > 0){
			$order_array = array();
			$review_q = $this->db->pdoQuery("SELECT o.id,o.txnId
				FROM tbl_orders AS o
				INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
				WHERE o.userId = ? AND ( o.status = ? OR o.status = ? ) AND o.orderType = ? AND s.slug = ?  ORDER BY o.id DESC ",
				array($this->sessUserId,'c','l','s',$this->slug));
			if($review_q->affectedRows() > 0){
				foreach ($review_q->results() as $key => $value){
					$check = $this->db->pdoQuery("SELECT id FROM tbl_reviews WHERE orderId = ? AND userFrom = ? ",array($value['id'],$this->sessUserId))->affectedRows();
					if($check <= 0){
						$order_array[] = array('id'=>$value['id'],'txnId'=>$value['txnId']);
					}
				}
			}
			if(count($order_array) > 0){
				$order_list = '';
				$service_title = getTableValue('tbl_services','title',array('slug'=>$this->slug));
				foreach ($order_array as $key => $value) {
					$selected = '';
					$replace = array(
	                    '%OPT_VALUE%'=>$value['id'],
	                    '%EXTRA%'=>'',
	                    '%SELECTED%'=>$selected,
	                    '%OPT_TEXT%'=>$value['txnId']
	                );
	                $order_list .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
				}
				$replace = array(
					'%SERVICE_NAME%'=>filtering($service_title),
					'%ORDER_LIST%'=>$order_list
				);
				$return['data'] = get_view(DIR_TMPL.$this->module."/post-review-popup-nct.tpl.php",$replace);
				$return['status'] = true;
			}
			else{
				$return['message'] =  SERVICE_DETAILS_PAGE_MSG_NO_ORDERS_FOR_REVIEW;
			}
		}
		else{
			$return['message'] =  SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
		}
		//checking whether any review is pending from user(buyer)

		return $return;
	}

	public function postReviewForService($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $orderId 	= filtering(issetor($orderId,0),'input','int');
        $rating 	= filtering(issetor($rating,0),'input','float');
        $review 	= filtering(issetor($review,''),'input','text');

        if($orderId  > 0 && $rating  > 0 && $review != ''){
        	$q = $this->db->pdoQuery("SELECT o.id,o.txnId,s.userId,s.title
				FROM tbl_orders AS o
				INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
				WHERE o.id = ? AND o.userId = ? AND ( o.status = ? OR o.status = ? ) AND o.orderType = ? AND s.slug = ?  LIMIT 1 ",
				array($orderId,$this->sessUserId,'c','l','s',$this->slug));
        	if($q->affectedRows() > 0){
        		$q_res = $q->result();
        		$check = $this->db->pdoQuery("SELECT id FROM tbl_reviews WHERE orderId = ? AND userFrom = ? ",array($q_res['id'],$this->sessUserId))->affectedRows();
        		if($check <= 0){
        			$insertArray = array(
        				'orderId'		=>$orderId,
        				'userFrom'		=>$this->sessUserId,
        				'userTo'		=>$q_res['userId'],
        				'review'		=>$review,
        				'rating'		=>strval($rating),
        				'ipAddress'		=>get_ip_address(),
        				'createdDate'	=>date('Y-m-d H:i:s'),
        				'updatedDate'	=>date('Y-m-d H:i:s')
        			);
        			$rid = $this->db->insert('tbl_reviews',$insertArray)->getLastInsertId();
        			//send notification
					$notification_type = 'review_posted_for_service';
					$data_array = array(
						'receiverId'	=>$q_res['userId'],
						'senderId'		=>$this->sessUserId,
						'notifyId'		=>$notification_type,
						'entityId'		=>$rid,
						'orderId'		=>$orderId,
						'rating'		=>$rating,
						'review'		=>$review,
						'txnId'			=>$q_res['txnId'],
						'service_title'	=>filtering($q_res['title'])
					);
					addNewNotificationForUser($notification_type,$data_array);
					//send notification
					$return['status'] = true;
					$return['message'] =  SERVICE_DETAILS_PAGE_MSG_POST_REVIEW_SUCCESS;
        		}
        		else{
        			$return['message'] =  SERVICE_DETAILS_PAGE_MSG_ALREADY_POST_REVIEW;
        		}
        	}
        	else{
        		$return['message'] =  SERVICE_DETAILS_PAGE_MSG_ORDER_NOT_FOUND_TO_REVIEW;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}
	/*Post Review Popup*/

	/*Post Reply Popup*/
	public function getPostReplyForServiceContent($data=array()){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';

		//checking whether any review is pending from user(buyer)
		if($this->sessUserId > 0){
			$review_array = array();
			$reply_q = $this->db->pdoQuery("SELECT r.id,o.txnId
					FROM tbl_reviews AS r
					INNER JOIN tbl_orders AS o ON o.id = r.orderId
					INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
					WHERE r.userTo =  ? AND o.orderType = ? AND  s.slug = ?  ",array($this->sessUserId,'s',$this->slug));
			if($reply_q->affectedRows() > 0){
				foreach ($reply_q->results() as $key => $value){
					$check = $this->db->pdoQuery("SELECT id FROM tbl_review_reply WHERE reviewId = ? ",array($value['id']))->affectedRows();
					if($check <= 0){
						$review_array[] = array('id'=>$value['id'],'txnId'=>$value['txnId']);
					}
				}
			}
			if(count($review_array) > 0){
				$review_list = '';
				$service_title = getTableValue('tbl_services','title',array('slug'=>$this->slug));
				foreach ($review_array as $key => $value) {
					$selected = '';
					$replace = array(
	                    '%OPT_VALUE%'	=>$value['id'],
	                    '%EXTRA%'		=>'',
	                    '%SELECTED%'	=>$selected,
	                    '%OPT_TEXT%'	=>$value['txnId']
	                );
	                $review_list .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
				}
				$replace = array(
					'%SERVICE_NAME%'=>filtering($service_title),
					'%REVIEW_LIST%'=>$review_list
				);
				$return['data'] = get_view(DIR_TMPL.$this->module."/post-reply-popup-nct.tpl.php",$replace);
				$return['status'] = true;
			}
			else{
				$return['message'] =  SERVICE_DETAILS_PAGE_MSG_ORDER_NOT_FOUND_TO_REPLY;
			}
		}
		else{
			$return['message'] =  SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
		}
		//checking whether any review is pending from user(buyer)

		return $return;
	}

	public function postReplyForService($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $reviewId 	= filtering(issetor($reviewId,0),'input','int');
        $reply 	= filtering(issetor($reply,''),'input','text');

        if($reviewId  > 0 && $reply != ''){
        	$q = $this->db->pdoQuery("SELECT r.id,o.txnId,s.title,o.id as orderId,o.userId
					FROM tbl_reviews AS r
					INNER JOIN tbl_orders AS o ON o.id = r.orderId
					INNER JOIN tbl_services AS s ON (s.id = o.entityId AND o.orderType = 's' )
					WHERE r.id = ? AND r.userTo =  ? AND o.orderType = ? AND  s.slug = ?  ",array($reviewId,$this->sessUserId,'s',$this->slug));
        	if($q->affectedRows() > 0){
        		$q_res = $q->result();
        		$check = $this->db->pdoQuery("SELECT id FROM tbl_review_reply WHERE reviewId = ? ",array($q_res['id']))->affectedRows();
        		if($check <= 0){
        			$insertArray = array(
        				'reviewId'		=>$reviewId,
        				'userId'		=>$this->sessUserId,
        				'reply'			=>$reply,
        				'ipAddress'		=>get_ip_address(),
        				'createdDate'	=>date('Y-m-d H:i:s')
        			);
        			$rid = $this->db->insert('tbl_review_reply',$insertArray)->getLastInsertId();
        			//send notification
					$notification_type = 'reply_posted_for_service';
					$data_array = array(
						'receiverId'	=>$q_res['userId'],
						'senderId'		=>$this->sessUserId,
						'notifyId'		=>$notification_type,
						'entityId'		=>$rid,
						'orderId'		=>$q_res['orderId'],
						'reply'			=>$reply,
						'txnId'			=>$q_res['txnId'],
						'service_title'	=>filtering($q_res['title'])
					);
					addNewNotificationForUser($notification_type,$data_array);
					//send notification
					$return['status'] = true;
					$return['message'] =  SERVICE_DETAILS_PAGE_MSG_POST_REPLY_SUCCESS;
        		}
        		else{
        			$return['message'] =  SERVICE_DETAILS_PAGE_MSG_ALREADY_POST_REPLY;
        		}
        	}
        	else{
        		$return['message'] =  SERVICE_DETAILS_PAGE_MSG_ORDER_NOT_FOUND_TO_REPLY;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}
	/*Post Reply Popup*/

	/*make service featured popup*/
	public function getMakeServiceFeaturedContent(){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';
		$q = $this->db->pdoQuery("SELECT s.userId,s.isFeatured FROM tbl_services AS s WHERE s.slug = ? LIMIT 1 ",array($this->slug));
		if($q->affectedRows() > 0 && $this->sessUserId > 0){
			$udata = $q->result();
			if($udata['userId'] == $this->sessUserId){
				if($udata['isFeatured'] == 'n'){

					$featured_fees_amount = exchange(FEATURED_FEES_AMOUNT,DEFAULT_CURRENCY_CODE,$this->cCode);
					$replace = array('%FEATURED_PRICE%'=>$featured_fees_amount);
					$return['status'] = true;
					$return['data'] = get_view(DIR_TMPL . $this->module . "/make-service-featured-popup-nct.tpl.php",$replace);
				}
				else{
					$return['message'] = SERVICE_DETAILS_PAGE_MSG_SERVICE_ALREADY_FEATURED;
				}
			}else{
				$return['message'] = MSG_PERMISSION_DENIED;
			}
		}
		else{
			$return['message'] = MSG_PERMISSION_DENIED;
		}
		return $return;
	}
	/*make service featured popup*/

	public function payFeaturedFees($data=array()){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';
		if($data['days'] > 0){
			$q = $this->db->pdoQuery("SELECT s.id,s.userId,s.isFeatured FROM tbl_services AS s WHERE s.slug = ? LIMIT 1 ",array($this->slug));
			if($q->affectedRows() > 0 && $this->sessUserId > 0){
				$sdata = $q->result();

				if($sdata['userId'] == $this->sessUserId){
					if($sdata['isFeatured'] == 'n'){
						$days = floor($data['days']);
						$amount = $days*FEATURED_FEES_AMOUNT;

						$date = date('Y-m-d H:i:s');
						$paymentInsArr['userId'] = $this->sessUserId;
						$paymentInsArr['txnTypeId'] = 6; //6 is used for service_feature_payment
						$paymentInsArr['amount'] = strval($amount);
						$paymentInsArr['adminCommission'] = strval(0);
						$paymentInsArr['entityId'] = strval($sdata['id']);
						$paymentInsArr['createdDate'] = $date;
						$paymentInsArr['ipAddress'] = get_ip_address();


						$payment_history_id = $this->db->insert('tbl_payment_history', $paymentInsArr)->lastInsertId();
						$en_action_cancel = '/' . base64_encode($payment_history_id);
						$url_paypal = PAYPAL_URL;
						$url_paypal .= "?business=" . urlencode(PAYPAL_EMAIL);
						$url_paypal .= "&cmd=" . urlencode('_xclick');
						$url_paypal .= "&item_name=Deposit to wallet- " . urlencode(SITE_NM);
						$url_paypal .= "&item_number=" . urlencode($payment_history_id);
						$url_paypal .= "&custom=" . urlencode($payment_history_id .'__'.$days. '__' . $this->sessUserId);
						$url_paypal .= "&amount=" . urlencode($amount);
						$url_paypal .= "&currency_code=" . urlencode(PAYPAL_CURRENCY_CODE);
						$url_paypal .= "&handling=" . urlencode('0');
						$url_paypal .= "&rm=" . urlencode('2');
						$url_paypal .= "&bn=" . urlencode('NCryptedTechnologies_SP_EC');

						if (strpos($_SERVER["SERVER_NAME"], '192.168.100') !== false || $_SERVER["SERVER_NAME"] == 'localhost' || strpos($_SERVER["SERVER_NAME"], 'nct') !== false) {
							$url_paypal .= "&return=" . urlencode(SITE_URL . 'service-feature-notify/');
						} else {
							$url_paypal .= "&return=" . urlencode(SITE_URL . 'service-feature-thankyou/');
						}
						$url_paypal .= "&cancel_return=" . urlencode(SITE_URL . 'service-feature-failed' . $en_action_cancel);
						$url_paypal .= "&notify_url=" . urlencode(SITE_URL . 'service-feature-notify/');

						$return['status'] = true;
						$return['redirectLink'] = $url_paypal;

					}
					else{
						$return['message'] = SERVICE_DETAILS_PAGE_MSG_SERVICE_ALREADY_FEATURED;
					}
				}else{
					$return['message'] = MSG_PERMISSION_DENIED;
				}
			}
			else{
				$return['message'] = MSG_PERMISSION_DENIED;
			}
		}else{
				$return['message'] = SERVICE_DETAILS_PAGE_ERR_ENTER_VALID_DAYS;
		}

		return $return;
	}
}

?>
