<?php
$reqAuth = true;
$module = 'promote-business-nct';
require_once "../../includes-nct/config-nct.php";
require_once "class.promote-business-nct.php";

/* load styles*/
$styles = array(array("bootstrap-datetimepicker/css/datetimepicker.css", SITE_PLUGIN));
/* load styles*/


/*load script*/
$scripts = array(array($module.".js", SITE_JS_MOD),
				array("jQuery-form/js/jquery.form.js", SITE_PLUGIN),
				array("bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js", SITE_PLUGIN));
/*load script*/

/*load js variable*/
$js_variables = "var CUR_DATE ='".date('Y-m-d')."';";
/*load js variable*/

$winTitle = PROMOTE_BUSINESS_PAGE_TITLE.' - ' . SITE_NM;
$headTitle = PROMOTE_BUSINESS_PAGE_TITLE.'' . SITE_NM;

$metaTag = getMetaTags(array("description" => $winTitle, "keywords" => $headTitle, "author" => AUTHOR));
$action = isset($_GET["action"]) ? $_GET["action"] : (isset($_POST["action"]) ? $_POST["action"] : '');

$obj = new PromoteBusiness($module);
try{
	if(isset($_POST["submitPromoteBusinessForm"]) && $_SERVER["REQUEST_METHOD"] == "POST"){
		extract($_POST);
		$response = $obj->submitPromoteBusiness($_POST);
		echo json_encode($response);
		exit;
	}

	if(isset($_POST['action']) && $_POST["action"] == "getEmbededCodeForUser"){
		$response = $obj->getEmbededCodeForUser($_POST);
		echo json_encode($response);
		exit;
	}
}
catch(Exception $e){
	$msgType = $_SESSION["msgType"] = disMessage(array(
		'type' => 'err',
		'var' => $e->getMessage()
	));
	redirectPage(SITE_URL."sign-in");
}

$pageContent = $obj->getPageContent();
require_once DIR_TMPL . "parsing-nct.tpl.php";
?>