<?php
class Profile {
	function __construct($module = "", $slug='') {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
		$this->slug = $slug;
	}
	public function getPageContent(){
		$content = array();
		$data = $this->getUserDetails();
		if($data['status'] == true){
			$tplUrl = DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php";

			$userLevel= ($data['data']['userLevel'] == 'b' ? BEGINNER :
				($data['data']['userLevel'] == 'i' ? INTERMEDIATE : EXPERT
				)
			);

			//increasing pages views
			$report_btn = '';
			if($this->sessUserId > 0 && $this->sessUserId != $data['data']['id']){
				//check same ip and same user
				$check_ip_q = $this->db->pdoQuery("SELECT id,createdDate FROM tbl_users_page_views WHERE profileId = ? AND userId = ? AND ipAddress = ? ORDER BY id DESC LIMIT 1 ",array($data['data']['id'],$this->sessUserId,get_ip_address()));
				if($check_ip_q->affectedRows() > 0){
					$check_ip_data = $check_ip_q->result();
					$date_diff = date_difference($check_ip_data['createdDate'],date('Y-m-d H:i:s'));
					if($date_diff['hours_total'] >= 24 ){
						$this->db->insert('tbl_users_page_views',array('profileId'=>$data['data']['id'],'userId'=>$this->sessUserId,'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
					}
				}
				else{
					$this->db->insert('tbl_users_page_views',array('profileId'=>$data['data']['id'],'userId'=>$this->sessUserId,'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
				}
				//check same ip and same user
				$report_btn = get_view(DIR_TMPL . $this->module . "/report-spam-nct.tpl.php",array());
			}
			else if($this->sessUserId == 0){
				$check_ip_q = $this->db->pdoQuery("SELECT id,createdDate FROM tbl_users_page_views WHERE profileId = ? AND ipAddress = ? AND userId IS NULL  ORDER BY id DESC LIMIT 1 ",array($data['data']['id'],get_ip_address()));
				if($check_ip_q->affectedRows() > 0){
					$check_ip_data = $check_ip_q->result();
					$date_diff = date_difference($check_ip_data['createdDate'],date('Y-m-d H:i:s'));
					if($date_diff['hours_total'] >= 24 ){
						$this->db->insert('tbl_users_page_views',array('profileId'=>$data['data']['id'],'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
					}
				}
				else{
					$this->db->insert('tbl_users_page_views',array('profileId'=>$data['data']['id'],'ipAddress'=>get_ip_address(),'createdDate'=>date('Y-m-d H:i:s')));
				}
			}
			else{

			}
			//increasing pages views

			//vacation mode
			$replace_v = array(
				'%ICON%'=>($data['data']['vacationMode'] == 'y' ? 'fa-times-circle' : 'fa-check-circle'),
				'%TIP%'=>($data['data']['vacationMode'] == 'y' ? PROFILE_PAGE_LBL_USER_ON_VACATION_MODE : PROFILE_PAGE_LBL_USER_NOT_ON_VACATION_MODE)
			);
			$vacation_mode = get_view(DIR_TMPL.$this->module."/vacation-mode-nct.tpl.php",$replace_v);
			//vacation mode

			$contact_btn = ($this->sessUserId > 0 && $this->sessUserId != $data['data']['id']) ? get_view(DIR_TMPL . $this->module . "/contact-user-nct.tpl.php",array('%SLUG%'=>$data['data']['slug'])) : '';
			$videoArr['userId'] = $data['data']['id'];
			$videoArr['video'] = $data['data']['profileVideo'];
			$videoArr['videoStatus'] = $data['data']['profileVideoStatus'];
			$videoHtml = $this->getProfileVideo($videoArr);

			$isSocialVerified =  isSocialVerified($data['data']['id']);
			$isUserConsultHiveCertified =  isUserConsultHiveCertified($data['data']['id']);
        	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
			$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');
			$replace = array(
				'%USER_IMG%'=>$data['data']['profileImage'],
				'%USER_NAME%'=>$data['data']['userName'],
				'%USER_LEVEL%'=>$userLevel,
				'%CONTACT_BTN%'=>$contact_btn,
				'%MEMBER_SINCE%'=>$data['data']['createdDate'],
				'%POSITIVE_RATING%'=>$data['data']['positive_review_percentag'],
				'%RESPONSE_RATE%'=>$data['data']['response_rate'],
				'%AVG_RESPONSE_TIME%'=>$data['data']['average_response_time'],
				'%RECENT_DELIVARY_CLASS%'=>($data['data']['recent_delivary_time'] > 0 ? '' : 'hide1'),
				'%RECENT_DELIVARY%'=>$data['data']['recent_delivary_time'],
				'%LOCATION%'=>($data['data']['location'] != '' ? $data['data']['location'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%EDUCATION%'=>($data['data']['education'] != '' ? $data['data']['education'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%CERTIFICATE%'=>($data['data']['certification'] != '' ? $data['data']['certification'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%LANGUAGES_KNOWN%'=>($this->getUserLanguages(array('userId'=>$data['data']['id'])) != '' ? $this->getUserLanguages(array('userId'=>$data['data']['id'])) : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%DESCRIPTION%'=>($data['data']['aboutMe'] != '' ? $data['data']['aboutMe'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%SKILLS%'=>($this->getUserSkills(array('userId'=>$data['data']['id'])) != '' ? $this->getUserSkills(array('userId'=>$data['data']['id'])) : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%PORTFOLIO%'=>($data['data']['portfolio'] != '' ? $data['data']['portfolio'] : PROFILE_PAGE_LBL_NO_DATA_AVAILABLE),
				'%FB_URL%'=>($data['data']['fbLink'] != '' ? $data['data']['fbLink'] : 'javascript:void(0);'),
				'%GOOGLE_URL%'=>($data['data']['gpLink'] != '' ? $data['data']['gpLink'] : 'javascript:void(0);'),
				'%DRIBBLE_LINK%'=>($data['data']['dribbleLink'] != '' ? $data['data']['dribbleLink'] : 'javascript:void(0);'),
				'%LINKEDIN_URL%'=>($data['data']['linkedinLink'] != '' ? $data['data']['linkedinLink'] : 'javascript:void(0);'),
				'%STACK_LINK%'=>($data['data']['stackLink'] != '' ? $data['data']['stackLink'] : 'javascript:void(0);'),

				'%HIDDEN_FB%'=>($data['data']['fbLink'] != '' ? '' : 'hidden'),
				'%HIDDEN_GP%'=>($data['data']['gpLink'] != '' ? '' : 'hidden'),
				'%HIDDEN_DL%'=>($data['data']['dribbleLink'] != '' ? '' : 'hidden'),
				'%HIDDEN_LN%'=>($data['data']['linkedinLink'] != '' ? '' : 'hidden'),
				'%HIDDEN_SO%'=>($data['data']['stackLink'] != '' ? '' : 'hidden'),

				'%AVG_REVIEW%'=>$data['data']['avgRating'],
				'%REVIEW_COUNT%'=>$data['data']['ratingCount'],
				'%REPORT_BTN%'=>$report_btn,
				'%VACATION_MODE%'=>$vacation_mode,
				'%PROFILE_VIDEO%'=>$videoHtml,
				 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
				 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
			);
			$content['html'] = get_view($tplUrl,$replace);
			$content['data'] = $data['data'];
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
		return $content;
	}
	public function getProfileVideo($videoArr = array())
	{
		extract($videoArr);
		$response="";
		 if($video != "" && file_exists(DIR_UPD.'profile-video/'.$userId.'/'.$video) && $videoStatus == 'a'){
            $videoUrl = SITE_UPD.'profile-video/'.$userId.'/'.$video;
            if($this->sessRequestType == 'web'){
                $replace = array('%VIDEO_URL%'=>$videoUrl);
                $response = get_view(DIR_TMPL . $this->module . "/profile-video-nct.tpl.php",$replace);

            }else{
            }
        }else{
        }
        return $response;
	}
	public function getUserDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$slug = (isset($slug) && $slug != '') ? $slug : $this->slug;

        $q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug,u.email,u.aboutMe,u.profileImage,u.education,u.certification,u.portfolio,u.location,u.locLate,u.locLong,u.userLevel,u.createdDate,u.defLanguage,u.defCurrency,u.fbLink,u.gpLink,u.linkedinLink,u.stackLink,u.dribbleLink,u.vacationMode,u.profileVideo,u.profileVideoStatus,
        	(SELECT COUNT(id) FROM tbl_reviews WHERE userTo = u.id ) as ratingCount
			FROM tbl_users AS u
			WHERE u.slug = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($slug,'y','y'));
		if($q->affectedRows() > 0){
			$q_res = $q->result();

			$data_array = array('userId'=>$q_res['id'],'type'=>'positive_review_percentag');
			$positive_review_percentag =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['id'],'type'=>'response_rate');
			$response_rate =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['id'],'type'=>'average_response_time');
			$average_response_time =  getUserStatics($data_array);

			$data_array = array('userId'=>$q_res['id'],'type'=>'recent_delivary_time');
			$recent_delivary_time =  getUserStatics($data_array);

			$avgRating_q = $this->db->pdoQuery("SELECT AVG(rating) AS avgRating FROM tbl_reviews WHERE userTo = ? ",array($q_res['id']))->result();
			$q_res['avgRating'] = (isset($avgRating_q['avgRating']) && $avgRating_q['avgRating'] > 0) ? $avgRating_q['avgRating'] : 0;
			$return['data'] = array(
				'id'							=>$q_res['id'],
				'userName'						=>filtering($q_res['userName']),
				'aboutMe'						=>filtering($q_res['aboutMe'],'output','text'),
				'slug'							=>filtering($q_res['slug']),
				'email'							=>filtering($q_res['email']),
				'education'						=>filtering($q_res['education'],'output','text'),
				'certification'					=>filtering($q_res['certification'],'output','text'),
				'portfolio'						=>filtering($q_res['portfolio'],'output','text'),
				'location'						=>filtering($q_res['location']),
				'locLate'						=>filtering($q_res['locLate']),
				'locLong'						=>filtering($q_res['locLong']),
				'fbLink'						=>filtering($q_res['fbLink']),
				'gpLink'						=>filtering($q_res['gpLink']),
				'linkedinLink'					=>filtering($q_res['linkedinLink']),
				'stackLink'						=>filtering($q_res['stackLink']),
				'dribbleLink'					=>filtering($q_res['dribbleLink']),
				'profileVideo'					=>filtering($q_res['profileVideo']),
				'profileVideoStatus'			=>filtering($q_res['profileVideoStatus']),
				'userLevel'						=>$q_res['userLevel'],
				'avgRating'						=>$q_res['avgRating'],
				'ratingCount'					=>$q_res['ratingCount'],
				'defLanguage'					=>$q_res['defLanguage'],
				'defCurrency'					=>$q_res['defCurrency'],
				'vacationMode'					=>$q_res['vacationMode'],
				'profileImage'					=>checkImage($q_res['profileImage'],9,$q_res['id']),
				'createdDate'					=>convertDate($q_res['createdDate']),
				'positive_review_percentag'		=>$positive_review_percentag['positive_review_percentag'],
				'response_rate'					=>$response_rate['response_rate'],
				'average_response_time'			=>$average_response_time['average_response_time'],
				'recent_delivary_time'			=>$recent_delivary_time['recent_delivary_time'],
			);
			if($this->sessRequestType != 'web'){
				$return['data']['languages'] = $this->getUserLanguages(array('userId'=>$q_res['id']));
				$return['data']['skills'] = $this->getUserSkills(array('userId'=>$q_res['id']));
				$return['data']['services_list'] = $this->getUsersServiceList(array('userId'=>$q_res['id']));
			}
			$return['status'] = true;
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_USER_DETAILS_NOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	public function getUserLanguages($data=array()){
    	extract($data);
    	$userId = isset($userId) ? $userId : 0;
    	$return = array();
    	$content = '';
        $q = $this->db->pdoQuery("SELECT l.id,l.languageName,l.slug
                FROM tbl_users_languages AS ul
                LEFT JOIN tbl_site_languages AS l ON l.id = ul.langId
                WHERE ul.userId = ? AND l.isActive = ? ",array($userId,'y'));
        if($q->affectedRows() > 0){
        	foreach ($q->results() as $key => $value) {
        		if($this->sessRequestType == 'web'){
        			$replace = array(
	                    '%LANG_NAME%' 	=>filtering($value['languageName']),
	                    '%SLUG%'		=>$value['slug']
	                );
	                $content .= get_view(DIR_TMPL.$this->module."/language-list-nct.tpl.php",$replace);
        		}
        		else{
        			$return[] = array(
	        			'id'			=>$value['id'],
	        			'languageName'	=>filtering($value['languageName']),
	        			'slug'			=>$value['slug']
	        		);
        		}
        	}
        }
        return getreturnType($return,$content);
    }

    public function getUserSkills($data=array()){
        extract($data);
        $userId = isset($userId) ? $userId : 0;
    	$return = array();
    	$content = '';
        $q = $this->db->pdoQuery("SELECT s.id,s.skillName
                FROM tbl_users_skills AS us
                LEFT JOIN tbl_skills AS s ON s.id = us.skillId
                WHERE us.userId = ? ",array($userId));
        if($q->affectedRows() > 0){
        	foreach ($q->results() as $key => $value) {
        		if($this->sessRequestType == 'web'){
        			$replace = array(
	                    '%SKILL_NAME%'=>filtering($value['skillName'])
	                );
	                $content .= get_view(DIR_TMPL.$this->module."/skill-list-nct.tpl.php",$replace);
        		}
        		else{
        			$return[] = array(
	        			'id'			=>$value['id'],
	        			'skillName'		=>filtering($value['skillName'])
	        		);
        		}
        	}
        }
        return getreturnType($return,$content);
    }

    public function getUsersServiceList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug > 0) ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
		$content['view_more'] = 'n';

 		$sWhere = ' WHERE u.slug = ? AND s.status = ?  AND s.isActive = ? AND u.isActive = ?  ';
		$aWhere = array($slug,'a','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT_PROFILE_PAGE;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' s.id DESC ';

		$totalRowCount = $this->db->pdoQuery("SELECT s.id
                    FROM tbl_services AS s
					INNER JOIN tbl_users AS u ON u.id = s.userId
					LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
					INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
                    $sWhere GROUP BY s.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT s.title,s.id,u.userName,u.slug as user_slug,s.slug as service_slug,u.profileImage,sg.fileName,MIN(sp.price) as price,s.userId,s.description,s.isFeatured
			FROM tbl_services AS s
			INNER JOIN tbl_users AS u ON u.id = s.userId
			LEFT JOIN tbl_service_gallery AS sg ON (sg.serviceId = s.id AND sg.fileType = 'i')
			INNER JOIN tbl_service_packages AS sp ON  sp.serviceId = s.id
			$sWhere GROUP BY s.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$title = filtering(ucwords($value['title']));
				$service_slug = filtering($value['service_slug']);
				$description = filtering($value['description'],'output','text');
				$user_slug = filtering($value['user_slug']);
				$userId = filtering($value['userId']);
				$userName = filtering($value['userName']);
				$profileImage = checkImage($value['profileImage'],9,$userId);
				$sImg = checkImage($value['fileName'],8,$id);
				$price = $value['price'];

				$serviceRating = $this->db->pdoQuery("SELECT AVG(r.rating) AS avgRating,COUNT(o.id) AS totalRating
					FROM tbl_orders AS o
					INNER JOIN tbl_reviews AS r ON r.orderId = o.id
					WHERE o.entityId = ? AND o.orderType = 's' AND o.status = 'c'",array($id))->result();
				$avgRating = ($serviceRating['avgRating'] > 0 ? $serviceRating['avgRating'] : 0);
				$totalRating = ($serviceRating['totalRating'] > 0 ? $serviceRating['totalRating'] : 0);

				$totalSales = $this->db->pdoQuery("SELECT id FROM tbl_orders WHERE  entityId = ? AND orderType = ?  AND
					status NOT IN (?,?) ",array($value['id'],'s','e','ca'))->affectedRows();

				$fav_count = getTableValue('tbl_favourites','id',array('serviceId'=>$id,'userId'=>$this->sessUserId));
				$favClass = ($fav_count > 0 ? 'icon-liked' : 'icon-like');

				if($this->sessRequestType == 'web'){
					/*multi currency change*/
		            $price = exchange($price,DEFAULT_CURRENCY_CODE,$this->cCode,$id,'s');
		            /*multi currency change*/

		            $feature_tag = ($value['isFeatured'] == 'y' ? get_view(DIR_TMPL ."/feature-tag-nct.tpl.php",array()) : '');

					$replace = array(
						'%ID%'=>$id,
						'%SERVICE_IMAGE%'		=>$sImg,
						'%STAR_RATTING%'		=>$avgRating,
						'%TOTAL_REVIEW%'		=>$totalRating,
						'%SERVICE_URL%'			=>SITE_URL.'service-details/'.$service_slug.'/',
						'%SERVICE_TITLE%'		=>$title,
						'%SELLER_IMAGE%'		=>$profileImage,
						'%SELLER_URL%'			=>SITE_URL.'profile/'.$user_slug.'/',
						'%SELLER_NAME%'			=>$userName,
						'%DESCRIPTION%'			=>myTruncate($description,100),
						'%TOTAL_SALES%'			=>$totalSales,
						'%SERVICE_PRICE%'		=>$price,
						'%FAV_CLASS%'			=>$favClass,
						'%FEATURE_TAGS%'		=>$feature_tag
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/service-list-nct.tpl.php",$replace);
					/*$content['pagination'] = pagination($pager, $page, $totalRow);*/
					$content['view_more'] = ($pager->page > 0 && ($pager->page < $pager->numPages) ? 'y' : 'n');
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'service_image'		=>$sImg,
						'star_rating'		=>$avgRating,
						'total_review'		=>$totalRating,
						'description'		=>$description,
						'service_url'		=>SITE_URL.'service-details/'.$service_slug.'/',
						'service_title'		=>$title,
						'seller_image'		=>$profileImage,
						'seller_url'		=>SITE_URL.'profile/'.$user_slug.'/',
						'seller_name'		=>$userName,
						'total_sales'		=>$totalSales,
						'service_price'		=>$price,
						'fav_class'			=>$favClass,
						'fav_count'			=>$fav_count
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_NO_SERVICES_FOUND;
			$content['html'].=getNoRecordFoundContent(PROFILE_PAGE_MSG_NO_SERVICES_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function getUsersReviewsList($data=array()){
		extract($data);
		$slug = (isset($slug) && $slug > 0) ? $slug : $this->slug;

		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();
		$return['pagination'] = array();

		$content = array();
		$content['html'] ='';
		$content['status'] = false;
		$content['pagination'] ='';
		$content['view_more'] = 'n';

 		$sWhere = ' WHERE uto.slug = ? AND uto.isActive = ?  AND r.isActive = ? AND r.isActive = ? ';
		$aWhere = array($slug,'y','y','y');

		$page =  isset($page) ? (int) $page : 1;
		$per_page_limit = $rows = (isset($per_page_limit) && $per_page_limit > 0)  ? (int) $per_page_limit : PER_PAGE_LIMIT;

        $offset = ($page != 0) ? (int) ($page - 1) * $rows : 0;
		$sorting = ' r.id DESC ';

		$totalRowCount = $this->db->pdoQuery("SELECT r.id
                    FROM tbl_reviews AS r
					LEFT JOIN tbl_review_reply AS rr ON rr.reviewId = r.id
					INNER JOIN tbl_users AS ufrom ON ufrom.id =r.userFrom
					INNER JOIN tbl_users AS uto ON uto.id =r.userTo
                    $sWhere GROUP BY r.id ", $aWhere);
        $totalRow =  $totalRowCount->affectedRows();

		$pager = getPagerData($totalRow, $per_page_limit, $page);
        $q = $this->db->pdoQuery("SELECT r.id,r.orderId,r.userFrom,r.userTo,r.review,r.rating,r.createdDate,ufrom.userName as userFromName,ufrom.profileImage as userFromprofileImage,uto.profileImage as utoprofileImage,ufrom.slug as userFromslug,uto.userName as utoName,uto.slug as utoslug,rr.reply,rr.createdDate as replycreatedDate,rr.id as reply_main_id
			FROM tbl_reviews AS r
			LEFT JOIN tbl_review_reply AS rr ON rr.reviewId = r.id
			INNER JOIN tbl_users AS ufrom ON ufrom.id =r.userFrom
			INNER JOIN tbl_users AS uto ON uto.id =r.userTo
			$sWhere GROUP BY r.id  ORDER BY $sorting LIMIT  $offset , $rows", $aWhere);

		if($q->affectedRows() > 0){
			foreach ($q->results() as $key => $value){
				$id = $value['id'];
				$reply_main_id = $value['reply_main_id'];
				$userFromName = filtering(ucwords($value['userFromName']));
				$userFromslug = filtering($value['userFromslug']);
				$utoName = filtering($value['utoName']);
				$utoslug = filtering($value['utoslug']);
				$review = filtering($value['review'],'output','text');
				$reply = filtering($value['reply'],'output','text');
				$userFromprofileImage = checkImage($value['userFromprofileImage'],9,$value['userFrom']);
				$utoprofileImage = checkImage($value['utoprofileImage'],9,$value['userTo']);

				if($this->sessRequestType == 'web'){
					$reply_content= '';
					if($reply_main_id > 0){
						$replace_reply = array(
							'%TO_USER_URL%'=>SITE_URL.'profile/'.$utoslug,
							'%TO_USER_IMG%'=>$utoprofileImage,
							'%TO_USER_NAME%'=>$utoName,
							'%REVIEW_REPLY%'=>$reply
						);
						$reply_content = get_view(DIR_TMPL . $this->module . "/reply-for-review-nct.tpl.php",$replace_reply);
					}
					$replace = array(
						'%FROM_USER_URL%'=>SITE_URL.'profile/'.$userFromslug,
						'%FROM_USER_NAME%'=>$userFromName,
						'%FROM_USER_IMG%'=>$userFromprofileImage,
						'%RATING%'=>$value['rating'],
						'%REVIEW%'=>$review,
						'%REPLY_CONTENT%'=>$reply_content
					);
					$content['html'].= get_view(DIR_TMPL . $this->module . "/review-list-nct.tpl.php",$replace);
					/*$content['pagination'] = pagination($pager, $page, $totalRow);*/
					$content['view_more'] = ($pager->page > 0 && ($pager->page < $pager->numPages) ? 'y' : 'n');
				}
				else{
					$return['pagination']['current_page'] = issetor($pager->page,0);
					$return['pagination']['total_pages'] = issetor($pager->numPages,0);
					$return['pagination']['total'] = issetor($totalRow,0);
					$return['data'][] = array(
						'id'				=>$value['id'],
						'orderId'			=>$value['orderId'],
						'userFrom'			=>$value['userFrom'],
						'userTo'			=>$value['userTo'],
						'userFromslug'		=>$userFromslug,
						'utoslug'			=>$utoslug,
						'review'			=>$review,
						'reply'				=>$reply,
						'rating'			=>$value['rating'],
						'createdDate'		=>$value['createdDate'],
						'replycreatedDate'	=>$value['replycreatedDate'],
					);
				}
			}
			$return['status'] = true;
			$content['status'] = true;
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_NO_REVIEWS_FOUND;
			$content['html'].=getNoRecordFoundContent(PROFILE_PAGE_MSG_NO_REVIEWS_FOUND);
			$return['status'] = false;
		}
		return getreturnType($return,$content);
	}

	public function getContactUserContent(){
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = '';
		$q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug
			FROM tbl_users AS u
			WHERE u.slug = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($this->slug,'y','y'));
		if($q->affectedRows() > 0 && $this->sessUserId > 0){
			$udata = $q->result();
			if($this->sessUserId != $udata['id']){
				$replace = array(
					'%USER_NAME%'=>$udata['userName']
				);
				$return['status'] = true;
				$return['data'] = get_view(DIR_TMPL . $this->module . "/contact-user-popup-nct.tpl.php",$replace);
			}
			else{
				$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
			}
		}
		else{
			$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
		}
		return $return;
	}

	public function sendMessageToUser($data=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = SITE_URL.'dashboard/';
        $return['message'] = '';
        $return['data'] = array();

        $message 	= filtering(issetor($message,''),'input');

        if($message != ''){
        	$receiverId = getTableValue('tbl_users','id',array('slug'=>$this->slug));
        	if($this->sessUserId != $receiverId){
        		$lastId = $this->db->insert('tbl_messages',array('senderId'=>$this->sessUserId,'receiverId'=>$receiverId,'message'=>$message,'createdDate'=>date('Y-m-d H:i:s'),'ipAddress'=>get_ip_address()))->getLastInsertId();

        		//send notification
				$notification_type = 'message_sent';
				$data_array = array(
					'receiverId'=>$receiverId,
					'senderId'=>$this->sessUserId,
					'notifyId'=>$notification_type,
					'entityId'=>$lastId,
					'is_email_notification' => 'y',
					'message'=>$message
				);
				addNewNotificationForUser($notification_type,$data_array);
				//send notification
        		$return['message'] = PROFILE_PAGE_MSG_MESSAGE_SEND_SUCCESS;
        		$return['status'] = true;
        	}
        	else{
        		$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SEND_MSG;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}

	public function reportUserAsSpam($data=array()){
		extract($data);
        $return = array();
        $slug = isset($slug) ? $slug : $this->slug;
        $return['status'] = false;
        $return['redirectLink'] = '';
        $return['message'] = '';
        $return['data'] = array();

        $message 	= filtering(issetor($message,''),'input');

        if($slug != ''){
        	if($this->sessUserId > 0){
        		$check = $this->db->pdoQuery("SELECT u.id,
        			(SELECT COUNT(id) FROM tbl_report_user WHERE userId = ? AND ReportedUserId = u.id ) as count
        			FROM tbl_users AS u
        			WHERE u.slug = ? AND u.isActive = ? AND u.isEmailVerify = ?  LIMIT 1 ",array($this->sessUserId,$slug,'y','y'));
	        	if($check->affectedRows() > 0){
	        		$check_data = $check->result();
	        		if($this->sessUserId != $check_data['id']){
	        			if($check_data['count'] <= 0){
	        				$this->db->insert('tbl_report_user',array('userId'=>$this->sessUserId,'ReportedUserId'=>$check_data['id'],'createdDate'=>date('Y-m-d H:i:s'),'ipAddress'=>get_ip_address()));
	        				$return['message'] = PROFILE_PAGE_MSG_SPAM_SUCCESS;
	        				$return['status'] = true;
	        			}
	        			else{
	        				$return['message'] = PROFILE_PAGE_MSG_ALREADY_REPORTED;
	        			}
	        		}
	        		else{
	        			$return['message'] = PROFILE_PAGE_MSG_CAN_NOT_SPAM_OWN;
	        		}
	        	}
	        	else{
	        		$return['message'] = PROFILE_PAGE_MSG_USER_NOT_FOUND;
	        	}
        	}
        	else{
        		$return['message'] = SERVICE_DETAILS_PAGE_MSG_LOGIN_REQUIRED;
        	}
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}

}

?>
