<?php
class EditProfile {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;
		}
		$this->module = $module;
	}

	public function getPageContent(){
		$content = "";
		$userData = $this->getUserProfileDetails();
		if($userData['status'] == true){


			$replace = array(
				'%USER_NAME%'		=>$userData['data']['userName'],
				'%ABOUT_ME%'		=>$userData['data']['aboutMe'],
                '%LOCATION%'        =>$userData['data']['location'],
                '%LOCALATE%'        =>$userData['data']['locLate'],
                '%LOCLONG%'         =>$userData['data']['locLong'],
				'%LANG_LIST%'		=>$this->getUserLanguageSelection($userData['data']['languages']),
				'%EDUCATION%'		=>$userData['data']['education'],
				'%CERTIFICATE%'		=>$userData['data']['certification'],
				'%PORTFOLIO%'		=>$userData['data']['portfolio'],
				'%IMG_SRC%'			=>$userData['data']['profileImage'],
				'%DEST_SITE_URL%'	=>SITE_UPD.'profile/temp_dir/'.$this->sessUserId.'/',
				'%DEST_DIR_URL%'	=>DIR_UPD.'profile/temp_dir/'.$this->sessUserId.'/',
                '%VIDEO_HTML%'      => $this->getProfileVideo($userData['data']['profileVideo']),
                '%VIDEO_FILE_HTML%' => $this->getProfileVideoFileControl($userData['data']['profileVideoStatus']),
			);
			$content .= get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
			return $content;
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $data['message']));
			redirectPage(SITE_URL);
		}
	}
    public function getProfileVideo($video='')
    {
        $response = "";
        if($video != "" && file_exists(DIR_UPD.'profile-video/'.$this->sessUserId.'/'.$video)){
            $videoUrl = SITE_UPD.'profile-video/'.$this->sessUserId.'/'.$video;
            if($this->sessRequestType == 'web'){
                $replace = array('%VIDEO_URL%'=>$videoUrl);
                $response = get_view(DIR_TMPL . $this->module . "/profile-video-nct.tpl.php",$replace);

            }else{
            }
        }else{
        }
        return $response;
    }
    public function getProfileVideoFileControl($videoStatus='')
    {
        $response = "";
        if($videoStatus != 'a'){
            if($this->sessRequestType == 'web'){
                $response = get_view(DIR_TMPL . $this->module . "/profile-video-file-control-nct.tpl.php");

            }else{
            }
        }else{
        }
        return $response;
    }
	public function getUserProfileDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

        $q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug,u.email,u.aboutMe,u.profileImage,u.education,u.certification,u.portfolio,u.location,u.locLate,u.locLong,u.profileVideo,u.profileVideoStatus
        	FROM tbl_users AS u
        	WHERE u.id = ? LIMIT 1 ",array($this->sessUserId));

		if($q->affectedRows() > 0){
			$q_res = $q->result();
			global $js_variables;
			$js_variables .= 'skills = '.$this->getUserSkills(array('return_type'=>'json')).';';
			$return['data'] = array(
				'id'				=>$q_res['id'],
				'userName'			=>filtering($q_res['userName']),
				'slug'				=>$q_res['slug'],
				'email'				=>filtering($q_res['email']),
                'location'          =>filtering($q_res['location'],'output'),
                'locLate'           =>filtering($q_res['locLate'],'output'),
                'locLong'           =>filtering($q_res['locLong'],'output'),
				'languages'			=>$this->getUserLanguages(array('return_type'=>'array')),
				'skills'			=>$this->getUserSkills(array('return_type'=>'array')),
				'aboutMe'			=>filtering($q_res['aboutMe'],'output','text'),
				'profileImage'		=>checkImage($q_res['profileImage'],9,$q_res['id']),
				'education'			=>filtering($q_res['education'],'output','text'),
				'certification'		=>filtering($q_res['certification'],'output','text'),
				'portfolio'			=>filtering($q_res['portfolio'],'output','text'),
				'location'			=>filtering($q_res['location']),
				'locLate'			=>filtering($q_res['locLate']),
                'locLong'           =>filtering($q_res['locLong']),
                'profileVideo'          =>filtering($q_res['profileVideo']),
				'profileVideoStatus'			=>filtering($q_res['profileVideoStatus']),

			);
			$return['status'] = true;
		}
		else{
			$return['message'] = EDIT_PROFILE_PAGE_MSG_DETAILSNOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	public function editUserProfileDetails($data=array(),$file=array()){
		extract($data);
        $return = array();
        $return['status'] = false;
        $return['redirectLink'] = SITE_URL.'dashboard/';
        $return['message'] = '';
        $return['data'] = array();


		$objPost = new stdClass();
        $objPost->userName             	= filtering(issetor($userName,''),'input');
        $objPost->aboutMe               = filtering(issetor($aboutMe,''),'input','text');
        $objPost->location              = filtering(issetor($location,''),'input','text');
        $objPost->locLate               = filtering(issetor($locLate,''),'input','text');
        $objPost->locLong        		= filtering(issetor($locLong,''),'input','text');
        $skills     					= filtering(issetor($skills,''),'input','text');
        $languages     					= (isset($languages) && is_array($languages)) ? $languages : array();
        $objPost->education       		= filtering(issetor($education,''),'input','text');
        $objPost->certification      	= filtering(issetor($certification,''),'input','text');
        $objPost->portfolio          	= filtering(issetor($portfolio,''),'input','text');
        $objPost->updatedDate          	= date('Y-m-d H:i:s');
        if($objPost->userName != '' && $objPost->aboutMe != '' && $objPost->location != ''&& $objPost->locLate != ''&& $objPost->locLong != '' && $objPost->education != '' && $objPost->certification != '' && $objPost->portfolio != '' && $skills != '' && count($languages) > 0){

        	//upload new image and unlink old image
        	if($hiddenImgprofileImage != ''){
                $upload_dir = $this->sessUserId . '/';
                $data_array = array('type'=>'profile','path'=>$this->sessUserId.'/');
                deletefile($data_array);

                uploadImagewithResize($upload_dir,$hiddenImgprofileImage,'profile');

                $data_array = array('type'=>'profile','path'=>'temp_dir/'.$this->sessUserId.'/');
                deletefile($data_array);
                $objPost->profileImage = $hiddenImgprofileImage;
            }
            //upload new image and unlink old image

            //upload video and unlink old video
            if(isset($file['profileVideo']['name']) && $file['profileVideo']['name'] !="")
            {
                $imageName = $file['profileVideo']['name'];
                $ext = '.'.strtolower(getExt($imageName));
                $newName = rand().time().$ext;
                $tmp_name = $file['profileVideo']['tmp_name'];
                $imageType = $file['profileVideo']['type'];
                $imageSize = $file['profileVideo']['size'];
                if($imageType == 'video/mp4' || $imageType == 'video/ogg' || $imageType == 'video/webm')
                {
                    //video upload code
                    $upload_dir = DIR_UPD.'profile-video/'.$this->sessUserId.'/';
                    if(!file_exists($upload_dir)){
                        mkdir($upload_dir,0777);
                    }

                    $oldFile = getTableValue("tbl_users",'profileVideo',array('id'=>$this->sessUserId));
                    @unlink($upload_dir.$oldFile);
                    move_uploaded_file($file["profileVideo"]["tmp_name"],$upload_dir.$newName);
                    $objPost->profileVideo = $newName;
                    $objPost->profileVideoStatus = 'p';

                }
                else
                {
                    $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'suc','var' => EDIT_PROFILE_PAGE_ERR_ONLY_MP4_OR_WEBM_ALLOWED));
                    $return['message'] = EDIT_PROFILE_PAGE_ERR_ONLY_MP4_OR_WEBM_ALLOWED;
                    $return['status'] = false;
                    return $return;
                    exit;

                    //$_SESSION["toastr_message"] = disMessage(array('type'=>'err','var'=>'invalidimage'));
                    //redirectPage(SITE_ADM_MOD.$module);
                }
            }
            //upload video and unlink old video


        	$this->db->update('tbl_users',(array)$objPost,array('id'=>$this->sessUserId));
        	//adding skills for user
            $this->db->delete('tbl_users_skills',array('userId'=>$this->sessUserId));
            if($skills != ''){
                $i = 0;
                $insArray = array();
                foreach (explode(',',$skills) as $key => $value){
                    $value = filtering($value,'input','string');
                    $check = $this->db->pdoQuery("SELECT id FROM tbl_skills WHERE skillName = ? LIMIT 1 ",array($value));
                    $skillId = 0;
                    if($check->affectedRows() > 0){
                        $check_d = $check->result();
                        $skillId = $check_d['id'];
                    }
                    else{
                        $sid = $this->db->insert('tbl_skills',array('skillName'=>$value,'createdDate'=>date('Y-m-d H:i:s')))->getLastInsertId();
                        $skillId = $sid;
                    }
                    $insArray[] = array(
                        'userId'         	=>$this->sessUserId,
                        'skillId'           =>$skillId,
                        'createdDate'       =>date("Y-m-d H:i:s")
                    );
                    if($i == 500){
                        $this->db->insertBatch('tbl_users_skills',$insArray,true);
                        $insArray = array();
                    }
                    $i = ($i == 500 ? 0 : $i);
                    $i++;
                }
                if(!empty($insArray)){
                    $this->db->insertBatch('tbl_users_skills',$insArray,true);
                    $insArray = array();
                }
            }
            //adding skills for user

            //adding languages for user
            $this->db->delete('tbl_users_languages',array('userId'=>$this->sessUserId));

            if(count($languages) > 0){
            	foreach ($languages as $key => $value){
		        	$this->db->insert('tbl_users_languages',array('userId'=>$this->sessUserId,'langId'=>$value,'createdDate'=>date('Y-m-d H:i:s')));
	            }
            }
            //adding languages for user
            $msgType = $_SESSION["msgType"] = disMessage(array('type' => 'suc','var' => EDIT_PROFILE_PAGE_MSG_PROFILE_UPDATE_SUCCESS));
        	$return['message'] = EDIT_PROFILE_PAGE_MSG_PROFILE_UPDATE_SUCCESS;
        	$return['status'] = true;
        }
        else{
        	$return['message'] =  ADD_SERVICE_PAGE_MSG_PLEASE_FILL_ALL_VALUES;
        }
        return $return;
	}

	public function getUserSkills($data=array()){
        extract($data);
        $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(s.skillName) as skills
                FROM tbl_users_skills AS us
                LEFT JOIN tbl_skills AS s ON s.id = us.skillId
                WHERE us.userId = ? ",array($this->sessUserId))->result();
        if(isset($q['skills']) && $q['skills'] != ''){
            if($return_type == 'string'){
                return $q['skills'];
            }
            else if($return_type == 'json'){
                return json_encode(explode(',',$q['skills']));
            }
            else{
                return explode(',',$q['skills']);
            }
        }
        else{
            if($return_type == 'string'){
                return '';
            }
            else if($return_type == 'json'){
                return json_encode(array());
            }
            else{
                return array();
            }
        }
    }

	public function getSkillsSuggestions($data=array()){
        extract($data);
        if(isset($query) && $query != ''){
            $query = str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $query);
            $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(t.skillName) as skills
                    FROM tbl_skills AS t
                    WHERE skillName LIKE '%$query%'  ")->result();
            if(isset($q['skills']) && $q['skills'] != ''){
                if($return_type == 'string'){
                    return $q['skills'];
                }
                else if($return_type == 'json'){
                    return json_encode(explode(',',$q['skills']));
                }
                else{
                    return explode(',',$q['skills']);
                }
            }
            else{
                if($return_type == 'string'){
                    return '';
                }
                else if($return_type == 'json'){
                    return json_encode(array());
                }
                else{
                    return array();
                }
            }
        }
    }

    public function getUserLanguages($data=array()){
    	extract($data);
        $q = $this->db->pdoQuery("SELECT GROUP_CONCAT(l.id) as langs
                FROM tbl_users_languages AS ul
                LEFT JOIN tbl_site_languages AS l ON l.id = ul.langId
                WHERE ul.userId = ? ",array($this->sessUserId))->result();
        if(isset($q['langs']) && $q['langs'] != ''){
            if($return_type == 'string'){
                return $q['langs'];
            }
            else if($return_type == 'json'){
                return json_encode(explode(',',$q['langs']));
            }
            else{
                return explode(',',$q['langs']);
            }
        }
        else{
            if($return_type == 'string'){
                return '';
            }
            else if($return_type == 'json'){
                return json_encode(array());
            }
            else{
                return array();
            }
        }
    }

    public function getUserLanguageSelection($labguageArray=array()){

		$content = '';
		$sWhere = ' WHERE l.isActive = ? ';
		$aWhere = array('y');

        $c_q = $this->db->pdoQuery("SELECT l.id,l.languageName,l.slug
        		FROM tbl_site_languages AS l
        		$sWhere ORDER BY l.languageName ASC ",array('y'));
        if($c_q->affectedRows() > 0){
            foreach ($c_q->results() as $key => $value) {

            	$selected = (in_array($value['id'], $labguageArray)) ?   'selected' : '';

                $replace = array(
                    '%OPT_VALUE%'=>$value['id'],
                    '%EXTRA%'=>'',
                    '%SELECTED%'=>$selected,
                    '%OPT_TEXT%'=>$value['languageName']
                );
                $content .= get_view(DIR_TMPL."/option-nct.tpl.php",$replace);
            }
        }
        return $content;
    }
}

?>
