<?php
class Dashboard {
	function __construct($module = "") {
		foreach ($GLOBALS as $key => $values) {
			$this->$key = $values;

		}
		$this->module = $module;
	}
	public function getPageContent() {
		$content = "";
		$user_data = $this->getUserProfileDetails();
		if($user_data['status'] == true){
			$data = $user_data['data'];
			$userLevel= ($data['userLevel'] == 'b' ? BEGINNER :
							($data['userLevel'] == 'i' ? INTERMEDIATE : EXPERT
							)
						);
			$data_array = array('userId'=>$this->sessUserId,'type'=>'positive_review_percentag');
			$positive_review_percentag =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'average_response_time');
			$average_response_time =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'response_rate');
			$response_rate =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'orders_created');
			$orders_created =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'orders_completed');
			$orders_completed =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'delivered_on_time');
			$delivered_on_time =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'amount_earned_this_month');
			$amount_earned_this_month =  getUserStatics($data_array);

			/*multi currency change*/
			$amount_earned_this_month['amount_earned_this_month_base'] = $amount_earned_this_month['amount_earned_this_month'];
            $amount_earned_this_month['amount_earned_this_month'] = exchange($amount_earned_this_month['amount_earned_this_month'],DEFAULT_CURRENCY_CODE,$this->cCode);
            /*multi currency change*/

			$data_array = array('userId'=>$this->sessUserId,'type'=>'average_selling_price');
			$average_selling_price =  getUserStatics($data_array);

			/*multi currency change*/
			$average_selling_price['average_selling_price_base'] = $average_selling_price['average_selling_price'];
            $average_selling_price['average_selling_price'] = exchange($average_selling_price['average_selling_price'],DEFAULT_CURRENCY_CODE,$this->cCode);
            /*multi currency change*/

			$data_array = array('userId'=>$this->sessUserId,'type'=>'total_positive_ratings');
			$total_positive_ratings =  getUserStatics($data_array);

			$data_array = array('userId'=>$this->sessUserId,'type'=>'no_of_all_reviews');
			$no_of_all_reviews =  getUserStatics($data_array);

			$data['location'] = ($data['location'] != '' ? $data['location'] : DEFAULT_LOCATION);
			$data['location'] = str_replace(' ','+',$data['location']);

			$isSocialVerified =  isSocialVerified($this->sessUserId);
			$isUserConsultHiveCertified =  isUserConsultHiveCertified($this->sessUserId);
        	$credentials_verfiied_tag = ($isSocialVerified == 'y' ? get_view(DIR_TMPL ."/credentials-verified-nct.tpl.php",array()) : '');
			$consultHive_certified_tag = ($isUserConsultHiveCertified == 'y' ? get_view(DIR_TMPL ."/consult-hive-certified-nct.tpl.php",array()) : '');

			$replace = array(
				'%USER_IMAGE%'				=>checkImage($data['profileImage'],9,$data['id']),
				'%USER_NAME%'				=>$data['userName'],
				'%USER_LEVEL%'				=>$userLevel,
				'%LOCLATE%'					=>($data['locLate'] > 0 ? strval($data['locLate']) : DEFAULT_LATITUDE),
				'%LOCLONG%'					=>($data['locLong'] > 0 ? strval($data['locLong']) : DEFAULT_LONGITUDE),
				'%LOCATION%'				=>($data['location'] != '' ? $data['location'] : DEFAULT_LOCATION),
				'%MEMBER_SINCE%'			=>convertDate($data['createdDate']),
				'%POSITIVE_RATING%'			=>$positive_review_percentag['positive_review_percentag'],
				'%AVG_RESPONSE_TIME%'		=>$average_response_time['average_response_time'],
				'%RESPONSE_RATE%'			=>$response_rate['response_rate'],
				'%ORDERS_COMPLETED%'		=>(int)$orders_completed['orders_completed'],
				'%NO_ORDERS_COMPLETED%'		=>(int)$orders_created['orders_created'],
				'%DELIVERED_ON_TIME%'		=>$delivered_on_time['delivered_on_time'],
				'%AMOUNT_EARNED_THIS_MONTH%'=>$amount_earned_this_month['amount_earned_this_month'],
				'%AMOUNT_EARNED_THIS_MONTH_BASE%'=>$amount_earned_this_month['amount_earned_this_month_base'],
				'%AVERAGE_SELLING_PRICE%'	=>$average_selling_price['average_selling_price'],
				'%AVERAGE_SELLING_PRICE_BASE%'	=>$average_selling_price['average_selling_price_base'],
				'%TOTAL_POSITIVE_RATING%'	=>$total_positive_ratings['total_positive_ratings'],
				'%ACTIVE_SERVICES%'			=>$data['active_services'],
				'%PAGE_VIEWS%'				=>$data['page_views'],
				'%SERVICE_SAVED%'			=>$data['saved_services'],
				'%ALL_REVIEWS%'				=>$no_of_all_reviews['no_of_all_reviews'],
				'%PROFILE_VIDEO%'			=> $this->getProfileVideo($data['profileVideo'],$data['profileVideoStatus']),
				 '%CREDENTIALS_VERIFIED%'=> $credentials_verfiied_tag,
				 '%CONSULT_HIVE_CERTIFIED%'=>$consultHive_certified_tag,
			);
			$content .= get_view(DIR_TMPL . $this->module . "/" . $this->module . ".tpl.php",$replace);
			return $content;
		}
		else{
			$msgType = $_SESSION["msgType"] = disMessage(array('type' => 'err','var' => $user_data['message']));
			redirectPage(SITE_URL);
		}
	}
	public function getProfileVideo($video='',$videoStatus='p')
	{

		 if($video != "" && file_exists(DIR_UPD.'profile-video/'.$this->sessUserId.'/'.$video)){
            $videoUrl = SITE_UPD.'profile-video/'.$this->sessUserId.'/'.$video;
            $videoStatus = $videoStatus == 'p' ? PENDING : $videoStatus == 'a' ? ACCEPTED : REJECTED;
            if($this->sessRequestType == 'web'){
                $replace = array('%VIDEO_URL%'=>$videoUrl,'%VIDEO_STATUS%'=>ucwords($videoStatus));
                $response = get_view(DIR_TMPL . $this->module . "/profile-video-nct.tpl.php",$replace);

            }else{
            }
        }else{
        }
        return $response;
	}
	public function welcomePageContent(){
		$content = get_view(DIR_TMPL . $this->module . "/welcome-user-nct.tpl.php",array());
		return $content;
	}

	public function getUserProfileDetails($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		//AND inn_sp.userId > 0
		$q = $this->db->pdoQuery("SELECT u.id,u.userName,u.slug,u.email,u.aboutMe,u.profileImage,u.userLevel,u.createdDate,u.defLanguage,u.defCurrency,u.locLate,u.locLong,u.location,u.profileVideo,u.profileVideoStatus,
			(SELECT COUNT(id) FROM tbl_services WHERE userId = u.id AND status = ? AND isActive = ? ) as active_services,
			(SELECT COUNT(DISTINCT inn_sp.userId)
			FROM tbl_service_page_views AS inn_sp
			INNER JOIN tbl_services AS inn_s ON inn_s.id = inn_sp.serviceId
			WHERE inn_s.userId = u.id  ) as page_views,
			(SELECT COUNT(DISTINCT inn_f.userId)
			FROM tbl_favourites AS inn_f
			INNER JOIN tbl_services AS inn_s ON inn_s.id = inn_f.serviceId
			WHERE inn_s.userId = u.id ) as saved_services
			FROM tbl_users AS u
			WHERE u.id = ? LIMIT 1 ",array('a','y',$this->sessUserId));
		if($q->affectedRows() > 0){
			$user_data = $q->result();
			$return['data'] = array(
				'id'				=>$user_data['id'],
				'userName'			=>filtering($user_data['userName']),
				'slug'				=>$user_data['slug'],
				'locLate'			=>$user_data['locLate'],
				'locLong'			=>$user_data['locLong'],
				'location'			=>$user_data['location'],
				'email'				=>filtering($user_data['email']),
				'aboutMe'			=>filtering($user_data['aboutMe'],'output','text'),
				'profileImage'		=>$user_data['profileImage'],
				'userLevel'			=>$user_data['userLevel'],
				'createdDate'		=>$user_data['createdDate'],
				'defLanguage'		=>$user_data['defLanguage'],
				'defCurrency'		=>$user_data['defCurrency'],
				'active_services'	=>$user_data['active_services'],
				'page_views'		=>$user_data['page_views'],
				'saved_services'	=>$user_data['saved_services'],
				'profileVideo'	=>$user_data['profileVideo'],
				'profileVideoStatus'	=>$user_data['profileVideoStatus'],
			);
			$return['status'] = true;
		}
		else{
			$return['message'] = DASHBOARD_PAGE_DETAILS_NOT_FOUND;
			$return['status'] = false;
		}
		return $return;
	}

	public function getOrdersDashboardChart($data=array()){
		extract($data);
		$return = array();
		$return['status'] = false;
		$return['redirectLink'] = '';
		$return['message'] = '';
		$return['data'] = array();

		if($type == 'new_orders'){
			$q = $this->db->pdoQuery("SELECT COUNT(o.id) as total,DATE_FORMAT(o.createdDate,'%Y-%m-%d') as createdDate
					FROM tbl_orders AS o
                    WHERE o.sellerId = ? AND o.status = ?  GROUP BY DATE_FORMAT(o.createdDate,'%Y-%m-%d') ",array($this->sessUserId,'n'));
            if($q->affectedRows() > 0){
            	foreach ($q->results() as $key => $value) {
            		$return['data'][] = array((strtotime($value['createdDate']) * 1000),(int)$value['total']);
            	}
            }
		}
		else if($type == 'extra_orders'){
			$q = $this->db->pdoQuery("SELECT COUNT(o.id) as total,DATE_FORMAT(o.createdDate,'%Y-%m-%d') as createdDate
					FROM tbl_orders AS o
                    WHERE o.sellerId = ? AND o.extraAmount > ? GROUP BY DATE_FORMAT(o.createdDate,'%Y-%m-%d') ",array($this->sessUserId,0));
            if($q->affectedRows() > 0){
            	foreach ($q->results() as $key => $value) {
            		$return['data'][] = array((strtotime($value['createdDate']) * 1000),(int)$value['total']);
            	}
            }
		}
		else if($type == 'delivered_orders'){
			$q = $this->db->pdoQuery("SELECT COUNT(o.id) as total,DATE_FORMAT(o.createdDate,'%Y-%m-%d') as createdDate
					FROM tbl_orders AS o
                    WHERE o.sellerId = ? AND o.status = ? GROUP BY DATE_FORMAT(o.createdDate,'%Y-%m-%d') ",array($this->sessUserId,'c'));
            if($q->affectedRows() > 0){
            	foreach ($q->results() as $key => $value) {
            		$return['data'][] = array((strtotime($value['createdDate']) * 1000),(int)$value['total']);
            	}
            }
		}
		else if($type == 'rating'){
			$data_array = array('type'=>'no_of_orders_completed','userId'=>$this->sessUserId);
			$no_of_orders_completed = getUserStatics($data_array);

			if($no_of_orders_completed['no_of_orders_completed'] > 0){

				$data_array = array('type'=>'total_positive_ratings','userId'=>$this->sessUserId);
				$total_positive_ratings = getUserStatics($data_array);

				$data_array = array('type'=>'no_of_negative_reviews','userId'=>$this->sessUserId);
				$no_of_negative_reviews = getUserStatics($data_array);

				$data_array = array('type'=>'no_of_orders_not_rated','userId'=>$this->sessUserId);
				$no_of_orders_not_rated = getUserStatics($data_array);

				$data_array = array('type'=>'no_of_all_reviews','userId'=>$this->sessUserId);
				$no_of_all_reviews = getUserStatics($data_array);
				$no_of_all_reviews_count = $no_of_all_reviews['no_of_all_reviews'];

				$no_of_orders_completed_count = $no_of_orders_completed['no_of_orders_completed'];
				$total_positive_ratings_count = $total_positive_ratings['total_positive_ratings'];
				$no_of_negative_reviews_count = $no_of_negative_reviews['no_of_negative_reviews'];
				$no_of_orders_not_rated_count = $no_of_orders_not_rated['no_of_orders_not_rated'];

				$positive_percentage = ($total_positive_ratings_count > 0 ? ((100 * $total_positive_ratings_count) / $no_of_orders_completed_count) : 0);
				$positive_percentage = number_format($positive_percentage,2);

				$negative_percentage = ($no_of_negative_reviews_count > 0 ? ((100 * $no_of_negative_reviews_count) / $no_of_orders_completed_count) : 0);
				$negative_percentage = number_format($negative_percentage,2);


				$not_rated_percentage = ($no_of_orders_not_rated_count > 0 ? ((100 * $no_of_orders_not_rated_count) / $no_of_orders_completed_count) : 0);
				$not_rated_percentage = number_format($not_rated_percentage,2);

				$return['data'] = array(
					array('color'=>'#00bfa5','name'=>DASHBOARD_PAGE_RATING_CHART_POSITIVE_TEXT,'y'=>(float)$positive_percentage),
					array('color'=>'#666666','name'=>DASHBOARD_PAGE_RATING_CHART_NEGATIVE_TEXT,'y'=>(float)$negative_percentage),
					array('color'=>'#6e8fa2','name'=>DASHBOARD_PAGE_RATING_CHART_NOT_RATED_TEXT,'y'=>(float)$not_rated_percentage)
				);
				$return['status'] = true;
			}
			else{
				$return['status'] = false;
			}
		}
		else if($type == 'profile'){
			$data_array = array('type'=>'profile_completed','userId'=>$this->sessUserId);
			$profile_completed = getUserStatics($data_array);

			$return['data'] = $profile_completed['profile_completed'];
		}
		else{
			$return['message'] = '';
			$return['status'] = false;
		}
		return $return;
	}

}

?>
