function getPaginationData(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".other_services_list_div").html(data.html);
			dispRatting();
			loadSlick('other_services_list_div');
			setTimeout(function(){
				equalHeight("other_services_list_div", "service_title");
    			equalHeight("other_services_list_div", "service_block");
			},500);
			hideLoader();
		}
	});
}

function getPaginationDataForSimilarServices(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPaginationSimilarService'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".similar_services_list_div").html(data.html);
			dispRatting();
			loadSlick('similar_services_list_div');
			setTimeout(function(){
				equalHeight("similar_services_list_div", "service_title");
    			equalHeight("similar_services_list_div", "service_block");
			},500);
			hideLoader();
		}
	});
}

function getPaginationDataForReviews(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPaginationReviews',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".review_list_div .inner_loader").remove();
			$(".review_list_div").append(data.html);
			if(data.view_more == 'n'){
				$(".view_more_reviews").remove();
			}
			dispRatting();
			hideLoader();
		}
	});
}

function getPaginationDataForRecentlyViews(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPaginationForRecentlyViews',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".recently_view_services_div .inner_loader").remove();
			$(".recently_view_services_div").append(data.html);
			if(data.view_more == 'n'){
				$(".view_more_recently_service").remove();
			}
			setTimeout(function(){
				equalHeight("seller_block", "seller_listing");
			},500);
			//deleting clear all btn
			var count = 0;
		    $(".recently_view_services_div .service_listing").each(function(){
		        count++;
		    });
		    if(count <=0){
		    	$('.remove_all_from_recently_view').remove();
		    }
		    //deleting clear all btn
			dispRatting();
			hideLoader();
		}
	});
}

function completesubmit(response){
	$(".contact_user_modal_content #ContactUserModal").modal('hide');
}

function completesubmitpostreview(response){
	$(".post_review_modal_content #PostReviewForServiceModal").modal('hide');
	location.reload();
}


function completesubmitpostreply(response){
	$(".post_reply_modal_content #PostReplyForServiceModal").modal('show');
	location.reload();
}

$(document).ready(function($) {
	dispRatting();
	getPaginationData();
	getPaginationDataForSimilarServices();
	getPaginationDataForReviews(1);
	if($('.recently_view_services_div').length > 0){
		getPaginationDataForRecentlyViews(1);
	}
	$(".view_more_details").shorten({
        "showChars" : 200,
        "moreText"  : VIEW_MORE,
        "lessText"  : VIEW_LESS,
    });
    $('[data-toggle="tooltip"]').tooltip();

    $('#lightSlider').lightSlider({
	    gallery: true,
	    item: 1,
	    loop:true,
	    slideMargin: 0,
	    thumbItem: 5
	});
});

$(document).on('click',".contact_user_now",function(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getContactUserContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".contact_user_modal_content").html(data.data);
				$(".contact_user_modal_content #ContactUserModal").modal('show');
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});

$(document).on('submit','#frmContactUser',function(){
	$("#frmContactUser").validate({
		rules:{
			message:{required:true},
		},
		messages:{
			message:{required:lang.PROFILE_PAGE_ERR_ENTER_MSG},
		},
		highlight: function (element, errorClass, validClass) {
		},
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) {
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmContactUser").valid()){
        ajaxFormSubmit("form#frmContactUser","completesubmit");
        return false;
    }else{
        return false;
    }
});

$(document).on("click",".view_more_reviews",function(){
	var count = 0;
    $(".review_list_div .review_listing").each(function(){
        count++;
    });
	var pageNo = (count / PER_PAGE_LIMIT) + 1;
	if(pageNo > 0){
		getPaginationDataForReviews(parseInt(pageNo));
	}
});

$(document).on("click",".view_more_recently_service",function(){
	var count = 0;
    $(".recently_view_services_div .service_listing").each(function(){
        count++;
    });
	var pageNo = (count / PER_PAGE_LIMIT) + 1;
	if(pageNo > 0){
		getPaginationDataForRecentlyViews(parseInt(pageNo));
	}
});

$(document).on("click",".remove_from_recent_view",function(){
	$this = $(this);
	var id = $(this).data('id');
	if(id > 0 && confirm(lang.SERVICE_DETAILS_PAGE_MSG_CONFIRM_REMOVE)){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'removeServiceFromRecentView',
				id:id
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				if(data.status == true){
					$this.closest('.recently_viewd_service').remove();
					toastr['success'](data.message);
					//deleting clear all btn
					var count = 0;
				    $(".recently_view_services_div .service_listing").each(function(){
				        count++;
				    });
				    if(count <=0 && $(".view_more_recently_service").length == 0){
				    	$('.remove_all_from_recently_view').remove();

				    	$.get(currentPageURL+'?action=no_recent_content', function (r) {
	                        $(".recently_view_services_div").html(r);
	                    });
				    }
				    //deleting clear all btn
				}
				else{
					if(data.message != ''){
						toastr['error'](data.message);
					}
				}
				hideLoader();
			}
		});
	}
});

$(document).on("click",".remove_all_from_recently_view",function(){
	$this = $(this);
	if(confirm(lang.SERVICE_DETAILS_PAGE_MSG_CONFIRM_REMOVE_ALL)){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'removeAllFromRecentView'
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				if(data.status == true){
					$this.fadeOut(500,function(){
                        $this.remove();
                    });
					$('.recently_view_services_div .service_listing').remove();
					getPaginationDataForRecentlyViews(1);
				}
				else{
					if(data.message != ''){
						toastr['error'](data.message);
					}
				}
				hideLoader();
			}
		});
	}
});

$(document).on('click','.order_now,.add_to_cart',function(){
	var pid = $(this).data('id');
	var slug = $(this).data('slug');
	var $thisParent = $(this).closest('.center-block');
	var is_order_now = ($(this).hasClass('order_now') ? 'y' : 'n');
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'addpackageToCart',
			pid:pid,
			slug:slug
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				if(data.message != ''){
					toastr['success'](data.message);
				}
				$thisParent.find(".order_now").replaceWith(data.data.order_now_btn);
				$thisParent.find(".add_to_cart").replaceWith(data.data.add_to_cart_btn);
				if(is_order_now == 'y'){
					window.location.href = SITE_URL+'cart/';
				}
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
				if(data.redirectLink && data.redirectLink !== null && data.redirectLink !== undefined && data.redirectLink != ''){
					window.location.href = data.redirectLink;
				}
			}
			hideLoader();
		}
	});
});

$(document).on('click','.post_review_now',function(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getPostReviewForServiceContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".post_review_modal_content").html(data.data);
				$("#orderId").selectpicker();
				$("#rating_div").raty({
			        scoreName: 'star_ratings',
			        score: 0,
			        half: true,
			        starHalf: SITE_PLUGIN+'raty/images/star-half.png',
			        starOff: SITE_PLUGIN+'raty/images/star-off.png',
			        starOn: SITE_PLUGIN+'raty/images/star-on.png',
			        hints: [lang.SERVICE_DETAILS_PAGE_LBL_RATING_BAD,lang.SERVICE_DETAILS_PAGE_LBL_RATING_POOR,lang.SERVICE_DETAILS_PAGE_LBL_RATING_REGULAR, lang.SERVICE_DETAILS_PAGE_LBL_RATING_GOOD, lang.SERVICE_DETAILS_PAGE_LBL_RATING_EXCELLENT],
				  click: function(score, evt){
				  	$("#rating").val(score);
				  	$("#rating").valid();
				  }
			    });
				$(".post_review_modal_content #PostReviewForServiceModal").modal('show');
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});

$(document).on('submit','#frmPostReviewForService',function(){
	$("#frmPostReviewForService").validate({
		ignore : '',
		rules:{
			orderId:{required:true},
			rating:{required:true,min:0.5},
			review:{required:true}
		},
		messages:{
			orderId:{required:lang.SERVICE_DETAILS_PAGE_ERR_ORDER_REQUEIRED},
			rating:{required:lang.SERVICE_DETAILS_PAGE_ERR_SELECT_RATING,min:lang.SERVICE_DETAILS_PAGE_ERR_MIN_RATING},
			review:{required:lang.SERVICE_DETAILS_PAGE_ERR_ENTER_REVIEW}
		},
		highlight: function (element, errorClass, validClass) {
		},
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) {
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmPostReviewForService").valid()){
		if($("#rating").val() > 0){
			ajaxFormSubmit("form#frmPostReviewForService","completesubmitpostreview");
		}
		else{
			toastr["error"](lang.SERVICE_DETAILS_PAGE_ERR_SELECT_RATING);
		}
        return false;
    }else{
        return false;
    }
});

$(document).on('click','.post_reply_now',function(){
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getPostReplyForServiceContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".post_reply_modal_content").html(data.data);
				$("#reviewId").selectpicker();
				$(".post_reply_modal_content #PostReplyForServiceModal").modal('show');
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});

$(document).on('submit','#frmPostReplyForService',function(){
	$("#frmPostReplyForService").validate({
		ignore : '',
		rules:{
			reviewId:{required:true},
			reply:{required:true}
		},
		messages:{
			reviewId:{required:lang.SERVICE_DETAILS_PAGE_ERR_REVIEW_REQUEIRED},
			reply:{required:lang.SERVICE_DETAILS_PAGE_ERR_ENTER_REPLY}
		},
		highlight: function (element, errorClass, validClass) {
		},
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) {
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmPostReplyForService").valid()){
		ajaxFormSubmit("form#frmPostReplyForService","completesubmitpostreply");
        return false;
    }else{
        return false;
    }
});


$(document).on('click', '#makeFeatured', function(event) {
	event.preventDefault();
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'getMakeServiceFeaturedContent'
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			if(data.status == true){
				$(".make_featured_modal_content").html(data.data);
				$(".make_featured_modal_content #MakeFeaturedModal").modal('show');
				$("#frmMakeFeatured").validate({
					ignore : '',
					rules:{
						days:{required:true,digits:true,min:1},
					},
					messages:{
						days:{
							required:lang.SERVICE_DETAILS_PAGE_ERR_DAYS_REQUEIRED,
							digits:lang.SERVICE_DETAILS_PAGE_ERR_ENTER_VALID_DAYS,
							min:lang.SERVICE_DETAILS_PAGE_ERR_ENTER_VALID_DAYS,
						},
					},
					highlight: function (element, errorClass, validClass) {
					},
					unhighlight: function (element, errorClass, validClass) {
					},
					errorPlacement: function (error, element) {
						if (element.attr("data-error-container")){
							error.appendTo(element.attr("data-error-container"));
						} else {
							error.insertAfter(element);
						}
						error.addClass('error');
					}
				});
			}
			else{
				if(data.message != ''){
					toastr['error'](data.message);
				}
			}
			hideLoader();
		}
	});
});


$(document).on('submit','#frmMakeFeatured',function(e){
	e.preventDefault();
	var days = $("#days").val();
	if($("#frmMakeFeatured").valid()){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {
				action: 'payFeaturedFees',
				days:days
			},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(res) {
				if(res.status == true && res.redirectLink != ""){
					window.location.href = res.redirectLink;
				}
				else{
					hideLoader();
					if(res.message != ''){
						toastr['error'](res.message);
					}
				}
			}
		});
        return false;
    }else{
        return false;
    }
});

$(document).on('keyup', '#days', function(event) {
	event.preventDefault();
	var featuredPrice = $("#featuredPrice").val();
	var featuredPriceUSD = $("#featuredPriceUSD").val();
	var days = $("#days").val();
	var defaultCurrencySign = $("#defaultCurrencySign").val();

	if(days.match(/^\d+$/)) {

		if(days > 0 && days <= 30){
			priceCalculation = days*featuredPrice;
			priceCalculation = priceCalculation.toFixed(2);
			priceCalculationUSD = days*featuredPriceUSD;
			priceCalculationUSD = priceCalculationUSD.toFixed(2);

			/*+'('+defaultCurrencySign+priceCalculationUSD+')'*/
			var string = lang.TOTAL_PRICE+' '+defaultCurrencySign+priceCalculationUSD;
			$('#priceCalculation').html(string);
		}else{
			$('#priceCalculation').html('');
		}
	}else{
		$('#priceCalculation').html('');
	}
	/* Act on the event */
});