function getPaginationData(page,url,replacestate,extra){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	url =  ( typeof (url) != "undefined" && url !== null && url != '') ? siteUrl+'search-services/'+url : siteUrl+'search-services/';
	$.ajax({
		url: url,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".search_results_div").html(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			dispRatting();
			scrollToElement(".search_result_page");
			setTimeout(function(){
				equalHeight("search_results_div", "service_title");
    			equalHeight("search_results_div", "service_block");
			},500);
			//creating hostory or replacing url
			// create state object
			var state = createState(data.html, data.title,page, url, extra);

			if ( typeof (replacestate) == "undefined" || replacestate == false) {
				history.pushState(state, state.title, url);
			} else {
				history.replaceState(state, state.title, url);
			}
			//creating hostory or replacing url

			hideLoader();
		}
	});
}

// create a state object from html
function createState($content, title,page, url, extra){
	var state = {
		content : $content,
		url : url,
		title : title,
		page : page,
		extra : extra
	};
	return state;
}

function getredirecturl(){
	var level = $('input[name="seller_level"]:checked').map(function(){
		return this.value;
	}).get().join(',');
	var seller_level = (level != "") ? '&seller_level=' + level : '';

	var lang = $('input[name="seller_language"]:checked').map(function(){
		return this.value;
	}).get().join(',');
	var seller_language = (lang != "") ? '&seller_language=' + lang : '';


	var category = ($('#category').val()!=0 && $('#category').val()!='') ? '?category=' + $('#category').val() : '?';

	var keyword = $('#keyword').val();
	keyword = (keyword != "") ? '&keyword=' + keyword : '';

	var subcategory = ($('#subcategory').val()!=0 && $('#subcategory').val()!=null) ? '&subcategory=' + $('#subcategory').val():'';


	var min_price = ($("#min_price").val() != null && $("#min_price").val() != '') ? '&min_price=' + $("#min_price").val()  : '';

	var max_price = ($("#max_price").val() != null && $("#max_price").val() != '') ? '&max_price=' + $("#max_price").val()  : '';

	var sort_by = ($("#sort_by").val() != '') ? '&sort_by=' + $("#sort_by").val()  : '';

	var consult_hive_certified = $('input[name="consult_hive_certified"]:checked').map(function(){
		return this.value;
	}).get().join(',');
	var consult_hive_certified = (consult_hive_certified != "") ? '&consult_hive_certified=' + consult_hive_certified : '';


	var credential_verified = $('input[name="credential_verified"]:checked').map(function(){
		return this.value;
	}).get().join(',');
	var credential_verified = (credential_verified != "") ? '&credential_verified=' + credential_verified : '';

	var url = category + subcategory + seller_level + seller_language + min_price + max_price + keyword + sort_by + credential_verified + consult_hive_certified;
	return url;
}
$(document).on('change','#category',function(){
	$("#subcategory").html('');
    $("#subcategory").val('');
	var category = $("#category").val();
	if(category != ''){
		$.ajax({
            url: currentPageURL,
            data: {
                action: 'getSubcategory',
                category: category
            },
            dataType: 'json',
            type: 'POST',
            asyc: true,
            success: function (data){
            	if(data.status == true){
            		$("#subcategory").html(data.content);
            		$("#subcategory").selectpicker('refresh');
            	}
            }
        });
	}
	else{
		$("#subcategory").selectpicker('refresh');
	}
	var url = getredirecturl();
	getPaginationData(1,url, true);
});
$(document).ready(function() {
	var url = getredirecturl();
	getPaginationData(1,url, true);
});

$(document).on("click",".list-view",function(){
	$('.box-view').removeClass('active');
	$(this).addClass('active');
	$(".search-right").addClass("list-search");
});
$(document).on("click",".box-view",function(){
	$('.list-view').removeClass('active');
	$(this).addClass('active');
	$(".search-right").removeClass("list-search");
});
$(document).on("click",".buttonPage",function(){
	var pageNo = $(this).data('page');
	var url = getredirecturl();
	getPaginationData(pageNo,url, true);
});
$(document).on('change','#keyword,#sort_by,#subcategory,input[name="seller_level"],input[name="seller_language"],input[name="credential_verified"],input[name="consult_hive_certified"]',function(){
	var url = getredirecturl();
	getPaginationData(1,url, true);
});
$(document).on('click','#filter_price_btn',function(){
	var min_price = $("#min_price").val();
	var max_price = $("#max_price").val();
	if(min_price != '' && parseFloat(min_price) >= 0 && max_price != '' && parseFloat(max_price) > 0){
		if(parseFloat(min_price) > parseFloat(max_price)){
			$("#max_price").val('');
		}
	}
	var url = getredirecturl();
	getPaginationData(1,url, true);
});
$(document).on('keyup','#min_price,#max_price',function(e){
    if (e.keyCode == 13){
    	var min_price = $("#min_price").val();
		var max_price = $("#max_price").val();
		if(min_price != '' && parseFloat(min_price) >= 0 && max_price != '' && parseFloat(max_price) > 0){
			if(parseFloat(min_price) > parseFloat(max_price)){
				$("#max_price").val('');
			}
		}
		var url = getredirecturl();
		getPaginationData(1,url, true);
    }
});
// handle back buttons of browser
window.onpopstate = function(evt) {

	if (evt.state) {
		getPaginationData(evt.state.page,evt.state.url, true,evt.state.extra);
	}

};
