function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".contact-table .inner_loader").remove();
			$(".contact-table .tbody").remove();
			$(".my_services_div").append(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
			}
			else{
				$(".pagination_div").html('');
			}
			scrollToElement(".manage-purchases");
			hideLoader();

		}
	});
}

$(document).ready(function() {
	getPaginationData(1);
});
$(document).on("click",".buttonPage",function(){
	var pageNo = $(this).data('page');
	getPaginationData(pageNo);
});

$(document).on('change', '.chkBox', function(event) {
	var id = $(this).attr('id');
	var data = {action : 'changeStatus'};
	if($("#"+id).prop('checked') == true){
		if(id == 'vacationMode'){
			$("#vacationModeReason").val('');
			$("#vacationFormModal").modal('show');
		}
		data.status = 'y';	
	}
	else{
		data.status = 'n';
	}
	data.name = id;
	if((id == 'vacationMode' && $("#"+id).prop('checked') == false) || id == 'acceptOffer'){
		$(this).closest('.switch').toggleClass('checked');
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: data,
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				hideLoader();
				if(data.status == true){
					if(data.message != ''){
						toastr['success'](data.message);
					}
				}
				else{
					toastr['error'](data.message);
				}
			}
		});
	}
	else{
		$("#vacationMode").prop('checked',false);
	}
});

$(document).on('submit','#frmvacationForm',function(){
	$("#frmvacationForm").validate({
		rules:{
			vacationModeReason:{required:true},
		},
		messages:{
			vacationModeReason:{required:lang.MY_SERVICE_PAGE_ERR_VACATION_REASON_REQUIRE},
		},
		highlight: function (element, errorClass, validClass) {
		},            
		unhighlight: function (element, errorClass, validClass) {
		},
		errorPlacement: function (error, element) { 
			if (element.attr("data-error-container")){
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
			error.addClass('error');
		}
	});
	if($("#frmvacationForm").valid()){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {action:'changeStatus',name:'vacationMode',status:'y',vacationModeReason:$("#vacationModeReason").val()},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				hideLoader();
				if(data.status == true){
					if(data.message != ''){
						toastr['success'](data.message);
					}
					$("#vacationFormModal").modal('hide');
					$("#vacationMode").prop('checked',true);
					$("#vacationMode").closest('.switch').toggleClass('checked');
				}
				else{
					toastr['error'](data.message);
					$("#vacationFormModal").modal('hide');
				}
			}
		});
        return false;
    }else{
        return false;
    }
});

$(document).on('click','.deleteService',function(){
	var slug = $(this).data('slug');
	if(confirm(lang.MY_SERVICE_PAGE_MSG_CONFIRM_DELETE_SERVICE) && slug != '' ){
		$.ajax({
			url: currentPageURL,
			type: "POST",
			cache:false,
			data: {action:'deleteService',slug:slug},
			dataType : 'json',
			beforeSend : function(){
				showLoader();
			},
			success: function(data) {
				hideLoader();
				if(data.status == true){
					if(data.message != ''){
						toastr['success'](data.message);
					}
					getPaginationData(1);
				}
				else{
					toastr['error'](data.message);
				}
			}
		});
	}
});