var ajax_url = SITE_URL + "ajax-form";
$(document).ready(function(e) {
	hideLoader();
	$("#form_request_service").validate({
		rules: {
			service_title: {
				required: true
			},
			budget: {
				required: true
			},
			service_date: {
				required: true
			},
			service_hour: {
				required: true,
				digits: true
			},
			address: {
				required: true
			},
			pincode: {
				required: true
			},
			addressLat: {
				required: true
			},
			addressLng: {
				required: true
			}
		},
		messages: {
			service_title: {
				required: lang.SERVICE_TITLE_REQ
			},
			budget: {
				required: lang.BUDGET_REQ
			},
			service_date: {
				required: lang.SERVICE_DATE_REQ
			},
			service_hour: {
				required: lang.MSG_SERVICE_HOUR_REQ,
				digits: lang.MSG_ONLY_DIGIT
			},
			address: {
				required: lang.ADD_REQ
			},
			pincode: {
				required: lang.PINCODE_REQ
			},
			addressLat: {
				required: " "
			},
			addressLng: {
				required: " "
			},
		},

		highlight: function(element) {
			/* $(element).closest('.form-group').addClass('has-error');*/
			$(element).closest('span').addClass('error-line');
		},
		unhighlight: function(element) {
			/*$(element).closest('.form-group').removeClass('has-error');*/
			$(element).closest('span').removeClass('error-line');
		},
		errorPlacement: function(error, element) {
			if (element.attr("data-error-container")) {
				error.appendTo(element.attr("data-error-container"));
			} else {
				error.insertAfter(element);
			}
		}
	});
});

$(document).on('submit', '#form_request_service', function(e) {
	if ($("#form_request_service").valid()) {
		if (totalLoad >= 99) {
			$("#request_submit").attr("disabled", true);
			return true;
		} else {
			return false;
		}
	} else {
		console.log('false');
		return false;
	}
});

var addressLat = parseFloat(LAT);
var addressLng = parseFloat(LNG);
if (isNaN(addressLat) || isNaN(addressLng)) {
	addressLat = 52.089182700753256;
	addressLng = 5.548095703125;
}
var input = document.getElementById('address');
var address, map, autocomplete, pin = '',
	infowindow = '',
	latitude, longitude, place;

$(function() {
	//$("#service_title").focus();
	/*$('.datepicker').datetimepicker({
		timepicker: false,
		format: 'd-m-Y',
		minDate: 0,
		scrollMonth: false,
		closeOnDateSelect: true
	});*/
	$('.datepicker').datepicker({
		format: 'dd-mm-yyyy',
		startDate: "today",
		todayBtn: 'linked'
	});
	$('.datepicker').on('changeDate', function(ev) {
		$(this).datepicker('hide');
	});
	$('.timepicker').clockpicker({
		autoclose: true
	});

	init();
	getAddress(addressLat, addressLng);
	initAutocomplete();
});

function setPin(lat, lng, map) {

	pin = new google.maps.Marker({
		position: {
			lat: lat,
			lng: lng
		},
		map: map
	});
	pin.setPosition({
		lat: lat,
		lng: lng
	});
	pin.setVisible(true);
}

function getAddress(lat, lng) {
	$("#addressLat").val(lat);
	$("#addressLng").val(lng);
	geocoder = new google.maps.Geocoder();
	var latlng = new google.maps.LatLng(lat, lng);
	geocoder.geocode({
		latLng: latlng,
	}, function(results) {
		displayPostcode(results[0].address_components);
		content = results && results[1] ? results && results[1].formatted_address : 'No Address';
		$("#address").val(content);
		return content;
	});
}

function displayPostcode(address) {
	for (p = address.length - 1; p >= 0; p--) {
		if (address[p].types.indexOf("postal_code") != -1) {
			$("#pincode").val(address[p].long_name);
		}
	}
}

function init() {

	map = new google.maps.Map(document.getElementById('gMapReq'), {
		zoom: 15,
		center: {
			lat: addressLat,
			lng: addressLng
		},
		mapTypeControlOptions: {
			style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
			position: google.maps.ControlPosition.RIGHT_BOTTOM
		},
		zoomControlOptions: {
			position: google.maps.ControlPosition.LEFT_CENTER
		},
		streetViewControl: false,
	});
	input = document.getElementById('address');
	infowindow = new google.maps.InfoWindow();
	infowindowContent = document.getElementById('infowindow-content');
	infowindow.setContent(infowindowContent);

	setPin(addressLat, addressLng, map);
	google.maps.event.addListener(map, 'click', function(event) {
		infowindow.close();
		if (pin != '') {
			pin.setMap(null);
		}
		latitude = event.latLng.lat();
		longitude = event.latLng.lng();
		getAddress(latitude, longitude);
		setPin(latitude, longitude, map);

		var geocoder = new google.maps.Geocoder;
		geocoder.geocode({
			'location': event.latLng
		}, function(results, status) {
			if (status === 'OK') {
				if (results[1]) {
					pin.setPosition(event.latLng);
					pin.setVisible(true);
					tmp = results[1].formatted_address;

					infowindow.setContent(results[1].formatted_address);
					infowindow.open(map, pin);
				} else {
					window.alert('No results found');
				}
			} else {
				window.alert('Geocoder failed due to: ' + status);
			}
		});
	});
}

function initAutocomplete() {
	autocomplete = new google.maps.places.Autocomplete(
		(document.getElementById('address')), {
			types: ['geocode']
		}
	);
	autocomplete.addListener('place_changed', fillInAddress);

}

function fillInAddress() {

	// Get the place details from the autocomplete object.
	var place = autocomplete.getPlace();
	if (!place.geometry) {
		window.alert("Autocomplete's returned place contains no geometry");
		return;
	} else {
		address1 = '';
		address2 = '';
		city1 = '';
		city2 = '';
		state = '';
		country = '';
		postal_code = '';

		formatted_address = place.formatted_address;
		addressLat = latitude = place.geometry.location.lat();
		addressLng = longitude = place.geometry.location.lng();
		var arrAddress = place.address_components;


		$.each(arrAddress, function(i, address_component) {
			if (address_component.types[0] == "route") {
				address1 = address_component.long_name;
			}
			if (address_component.types[0] == "sublocality") {
				address2 = address_component.long_name;
			}

			if (address_component.types[0] == "locality") {
				//alert("city1:"+address_component.long_name);
				city1 = address_component.long_name;
			}
			if (address_component.types[0] == "administrative_area_level_2") {
				city2 = address_component.long_name;
			}

			if (address_component.types[0] == "administrative_area_level_1") {
				state = address_component.long_name;
			}
			if (address_component.types[0] == "country") {
				country = address_component.long_name;
			}
			if (address_component.types[0] == "postal_code") {
				postal_code = address_component.long_name;
			}
		});

		$("#addressLat").val(latitude);
		$("#addressLng").val(longitude);
		$("#pincode").val(postal_code);
		init();
	}
}

var totalLoad = initVal = 0;

$(document).ready(function() {
	stepFunction();
	hideLoader();
});

function progressInc(cur) {
	per = getProgressVal();
	perFinal = cur * per;
	totalLoad = inc = per + perFinal;
	/*test3 = $('.pBar').data('circles');
	test3.moveProgress(inc)*/
}

function progressDec(cur) {
	per = getProgressVal();
	dec = cur * per;
	/* test3 = $('.pBar').data('circles');
	test3.moveProgress(dec);*/
}

function getProgressVal() {
	var cnt = $(".setup-content").length;
	getVal = 100 / cnt;
	per = parseFloat(getVal.toFixed(2));
	return per;
}

function stepFunction() {
	var i = j = 1;
	$(".setup-content").each(function(index) {
		$(this).attr("id", "step-" + i);
		$(this).attr("data-id", i);
		i++;
	});

	$(".step-wiz").each(function(index) {
		$(this).attr("href", "#step-" + j);
		$(this).attr("data-wiz-id", j);
		$(this).addClass("wiz-" + j);
		j++;
	});

}
$(document).ready(function() {
	var navListItems = $('div.setup-panel div a'),
		allWells = $('.setup-content');

	allWells.hide();
	$(".setup-content:first").css("display", "block");
	navListItems.click(function(e) {
		e.preventDefault();
		var $target = $($(this).attr('href')),
			$item = $(this);

		if (!$item.hasClass('disabled')) {
			navListItems.removeClass('btn-primary').addClass('btn-default');
			$item.addClass('btn-primary');
			allWells.hide();
			$target.show();
			//$target.find('input:eq(0)').focus();
		}
	});

	$(document).on('click', '.prevBtn', function(e) {
		var curStep = $(this).closest(".setup-content"),
			curStepBtn = curStep.attr("id"),
			dataId = curStep.attr("data-id"),
			prevStp = parseInt(dataId) - 1;

		$('.child' + prevStp).remove();
		progressDec(prevStp);

		$('#step-' + dataId).css("display", 'none');
		$('#step-' + prevStp).css("display", 'block');
	});

	$(document).on('click', '.nextBtn', function(e) {

		if (!$("#form_request_service").valid()) {
			return false;
		}
		var $this = $(this);
		$this.attr('disabled', 'true');
		var curStep = $(this).closest(".setup-content"),
			curStepBtn = curStep.attr("id"),
			isDependent = $this.attr("data-dep"),
			type = $this.attr('data-type'),
			dataId = curStep.attr("data-id"),
			nxtStp = parseInt(dataId) + 1;
		isValid = true;
		if (isDependent == 'y') {
			var name = curStep.find(".depVal").attr('data-queId');
			if (type == 1) {
				/*radio value*/
				var optVal = arr = $('[data-queId=' + name + ']:checked').val();
			} else if (type == 2) {
				/*select value*/
				var optVal = arr = $('[data-queId=' + name + ']').children('option:selected').val();
			}
			if (arr > 0) {
				showLoader();
				var sid = $("#sid").val();
				$.ajax({
					data: "sid=" + sid + "&action=dependent_que&ansVal=" + optVal + "&curStep=" + dataId,
					method: "post",
					dataType: 'json',
					async: false,
					url: ajax_url,
					success: function(result) {
						if (result.success) {
							curStep.after(result.content);
							$("#panel-div").append(result.step);
							/*animateFun();
							classieFunc();
							$(".js-example-basic-single").select2();*/
							hideLoader();
						}
					}
				});
			}

		}
		stepFunction();

		$this.removeAttr('disabled');

		if (isValid) {
			$('#step-' + dataId).css("display", 'none');
			$('#step-' + nxtStp).css("display", 'block');
			progressInc(dataId);
		}
		init();
	});
	$('div.setup-panel div a.btn-primary').trigger('click');
});