function getPaginationData(page){
	page = (page && page !== null && page !== undefined && page > 0) ? page : 1;
	$.ajax({
		url: currentPageURL,
		type: "POST",
		cache:false,
		data: {
			action: 'ajaxPagination',
			page: page,
		},
		dataType : 'json',
		beforeSend : function(){
			showLoader();
		},
		success: function(data) {
			$(".services_list_div").html(data.html);
			if(data.status == true){
				$(".pagination_div").html(data.pagination);
				$('.total_service_count_span').text(data.totalRow);
			}
			else{
				$(".pagination_div").html('');
			}
			setTimeout(function(){
				equalHeight("services_list_div", "service_title");
    			equalHeight("services_list_div", "service_block");
			},500);
			dispRatting();
			scrollToElement(".featured_services");
			hideLoader();
		}
	});
}

$(document).ready(function($) {
	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		getPaginationData(pageNo);
	});
	$('[data-toggle="tooltip"]').tooltip();
	getPaginationData(1);
});