/*$formSearch = "#formSearch"; {
	$($formSearch).validate({
		rules: {
			keyword: {
				required: true,
			}
		},
		messages: {
			keyword: {
				required: lang.MSG_KEYWORD_REQU
			}
		},
		errorPlacement: function(error, element) {
		    return false;
		},
	});
}*/
var catSlug;
$(document).ready(function() {
	$(document).on('submit', '#formSearch', function(event) {
		event.preventDefault();
		var formData = new FormData(this);
		keyword = $('#keywordSearch').val();
		catSlug = $('select#blogCateId').find(':selected').attr('data-slug');
		$('#slug').val(catSlug);
		$('#keyword').val(keyword);
		$('#pageNo').val('1');
		getBlogList();
	});

	$(document).on('click', '.blogCategory', function(event) {
		event.preventDefault();
		var url = $(this).attr('data-slug');
		$('#slug').val(url);
		$('#pageNo').val('1');
	    getBlogList();

	});
	$(document).on("click",".buttonPage",function(){
		var pageNo = $(this).data('page');
		$('#pageNo').val(pageNo);
	    getBlogList();

	});
});
function getBlogList() {
	var slug = $('#slug').val();
	var keyword = $('#keyword').val();
	var pageNo = $('#pageNo').val();
	dataurl = SITE_URL + 'blogs/?action=getBlogList&' +'slug='+slug+'&keyword='+keyword+'&pageNo='+pageNo;
	 $.ajax({
        url: SITE_URL+'blogs/',
        type: 'POST',
        data: {
			    slug: slug,
			    keyword: keyword,
			    pageNo: pageNo,
			    action: 'getBlogList'
		    },
        dataType: 'json',
        beforeSend: function() {
			showLoader();
		},
		success: function(response) {
			if (typeof (history.pushState) != "undefined") {
		        var obj = { Title: 'search', Url: dataurl };
		        history.pushState(obj, obj.Title, obj.Url);
		    }
			if(response.status){
				$('#blog_content_list').html(response.data.html);
				$('.pagination_div').html(response.data.pagination);
			}
			refreshSelect();
			hideLoader();
		},
		error: function(response) {
			hideLoader();
			$(function() {
				toastr['error'](lang.MSG_SOMETHING_WRONG);
			});
		}
    });
}
