var blogDetailUrl = SITE_URL+'blog_detail';
$(document).ready(function() {
	$.validator.addMethod('customvalidation',function (value, element) {
        if(this.optional(element) || /<\/?[^>]+(>|$)/g.test(value)){
            return false;
        } else {
            return true;
        }
        },lang.INVALID_VALUE_ENTERED
    );
	$(document).on('click', '.replyCount', function(event) {
		$(this).closest('.comment_body_div').find('.replyForm').toggleClass('hide');

	});

	$(document).on('click', '.like_action', function(event) {
		event.preventDefault();
		$like = $(this);
		commentId = $(this).attr('data-id');

		$.ajax({
			url: blogDetailUrl,
			dataType: 'json',
			type: 'post',
			data: {
				action: 'likeAction',
				commentId: commentId,
			},
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				if(response.status){
					$like.closest('.comment_like').find('.like_counter').html(response.likeCount);
					$like.removeClass('like_action').addClass('liked');
					toastr['success'](response.message);

				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	});

	$(document).on('click', '.reply_submit', function(event) {
		$this = $(this);
		parentId = $(this).closest('.replyForm').find('#parentId').val();
		var formId = "#replyForm_"+parentId;

			$(formId).validate({
				rules: {
					blogComment: {
						required: true,
						customvalidation:true
					}
				},
				messages: {
					blogComment: {
						required: lang.MSG_ENTER_YOUR_REPLY
					}
				},
				errorPlacement: function (error, element) {
		            if (element.attr("data-error-container")) {
		              error.appendTo(element.attr("data-error-container"));
		            } else {
		              error.insertAfter(element);
		            }
		        } //<---missing comma here
			});

		if($(formId).valid()){
			var dataString = $(formId).serialize();
			$.ajax({
				url: blogDetailUrl,
				dataType: 'json',
				type: 'post',
				data: dataString,
				beforeSend: function() {
					showLoader();
				},
				success: function(response) {
					if(response.status){
						$this.closest('.comment_body_div').find('.replyForm').toggleClass('hide');
						$this.closest('.comment_body_div').find('.blogReplyDiv').append(response.comment);
						$(formId).siblings('.comment_stats').find('.reply_counter').html(response.replyCount);
						toastr['success'](response.message);
					}else{
						toastr['error'](response.message);
					}
					hideLoader();
				},
				error: function(response) {
					hideLoader();
					$(function() {
						toastr['error'](lang.MSG_SOMETHING_WRONG);
					});
				}
			});

		}
	});
	$commentForm = "#commentForm"; {
		$($commentForm).validate({
			rules: {
				blogComment: {
					required: true,
					customvalidation:true
				}
			},
			messages: {
				blogComment: {
					required: lang.MSG_ENTER_YOUR_COMMENT
				}
			},
			errorPlacement: function (error, element) {
	            if (element.attr("data-error-container")) {
	              error.appendTo(element.attr("data-error-container"));
	            } else {
	              error.insertAfter(element);
	            }
	        }, //<---missing comma here
		});
	}

	$(document).on('submit', '#commentForm', function(event) {
		event.preventDefault();
		$this = $(this);
		var dataString = $("#commentForm").serialize();
		$.ajax({
			url: blogDetailUrl,
			dataType: 'json',
			type: 'post',
			data: dataString,
			beforeSend: function() {
				showLoader();
			},
			success: function(response) {
				if(response.status){
					$("#commentForm")[0].reset();
					$this.siblings('.blog_comment').find('.blog_comment_div').removeClass('hide');
					$this.siblings('.blog_comment').find('.blog_comment_div').prepend(response.comment);
					$("#totalComment").html(response.totalComment);
					toastr['success'](response.message);
				}else{
					toastr['error'](response.message);
				}
				hideLoader();
			},
			error: function(response) {
				hideLoader();
				$(function() {
					toastr['error'](lang.MSG_SOMETHING_WRONG);
				});
			}
		});
	});
});