<script type="text/javascript">
    $(function () {
        OTable = $('#dt_users').dataTable({
            "bProcessing": true,
            "bServerSide": true,
            "sAjaxSource": "ajax.<?php echo $this->module; ?>.php",
            "aaSorting" : [[0,'desc']],
            "fnServerData": function (sSource, aoData, fnCallback) {
                $.ajax({
                    "dataType": 'json',
                    "type": "POST",
                    "url": sSource,
                    "data": aoData,
                    "success": fnCallback
                });
            },
            "aoColumns": [
                { sName: "s.id", sTitle : 'User Id', bVisible: false, bSortable: false, bSearchable: false},
                {sName: "u.userName", 'sTitle': 'First Name'},
                {sName: "u.email", 'sTitle': 'Email Address'},
                { sName: "s.subscribedOn", sTitle : 'Member since'}
                <?php if(in_array('status',$this->Permission)){ ?>
                ,{ "sName": "isActive", 'sTitle' : 'Status' ,bSortable:false,bSearchable:false}
                <?php } ?>
                <?php if(in_array('edit',$this->Permission) || in_array('delete',$this->Permission) || in_array('view',$this->Permission) ){ ?>
                ,{ "sName": "operation", 'sTitle' : 'Operation' ,bSortable:false,bSearchable:false}
                <?php } ?>
            ],
            "fnServerParams": function (aoData) {setTitle(aoData, this)},
            "fnDrawCallback" : function (oSettings) {
                $('.make-switch').bootstrapSwitch();
                $('.make-switch').bootstrapSwitch('setOnClass', 'success');
                $('.make-switch').bootstrapSwitch('setOffClass', 'danger');
            }
        });
        $('.dataTables_filter').css({float: 'right'});
        $('.dataTables_filter input').addClass("form-control input-inline");

        var oTable = $('#dt_users').dataTable();
        $('#userType').on('change', function(e){
            oTable.fnDraw();
        });

        $.validator.addMethod('pagenm', function (value, element) {
            return /^[a-zA-Z0-9][a-zA-Z0-9\_\-]*$/.test(value);
        }, 'Page name is not valid. Only alphanumeric and _ are allowed'
                );
        
    });

    

</script>

<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <?php
        echo $this->breadcrumb;
        ?>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->
<div class="row">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet box blue-dark">
            <div class="portlet-title ">
                <div class="caption"><i class="fa fa-list-alt"></i><?php echo $this->headTitle; ?></div>
                <div class="actions portlet-toggler">
                    <?php
                    if (in_array('add', $this->Permission)) {
                        ?>
                            <!--                	 <a href="ajax.<?php echo $this->module; ?>.php?action=add" class="btn blue btn-add"><i class="fa fa-plus"></i> Add</a>
                        -->                     <?php } ?>
                    <div class="btn-group"></div>
                </div>
            </div>
          
            <div class="portlet-body portlet-toggler">
                <table id="dt_users" class="table table-striped table-bordered table-hover"></table>
            </div>
            <div class="portlet-toggler pageform" style="display:none;"></div>
        </div>
    </div>
</div>     