<div class="cropper_models_div">
</div>

<script type="text/javascript">
	//////cropping/////
	function generateCropperScript(file_name,file_obj,crop_url,call_url,cropperObj){
		file_name = (isset(file_name) && file_name !== null && file_name != '') ? file_name : 'file';
		file_obj = (isset(file_obj) && file_obj !== null && file_obj != '') ? file_obj : 'file';
		cropperObj = (isset(cropperObj) && cropperObj !== null) ? cropperObj : {};
		var aspectRatio = (isset(cropperObj.aspectRatio) && cropperObj.aspectRatio !== null && cropperObj.aspectRatio != '') ? cropperObj.aspectRatio : 1/1;

		var f_id = "#"+file_obj;
		var model_id = "#"+file_name+'-avatar-model';
		var f_contentbox = "#fileCnt"+file_name;
		var f_hiddenimg = "#hiddenImg"+file_name;
		var cropBtnName = "#btnCrop"+file_name;
		var f_form = "#avatar-form-"+file_name;
		
		$.ajax(call_url,{
			type: 'post',
			data: {action:'getCropperModelBoxContent',file_name:file_name},
			dataType: 'json',
			processData: false,
			contentType: false,
			beforeSend: function() {
				$('.loading').fadeIn();
			},
			success: function(data) {
				$(".cropper_models_div").append(data.content);
			},
			complete: function() {
				$('.loading').fadeOut();
			}
		});


		$(document).on('change',f_id, function(event){
			var _this = $(this);
			var value = _this.val();
			var imageAllow = ["jpg", "jpeg", "png"];
			var videoAllow = ["mp4", "ogg", "webm"];
			var allowedFiles = videoAllow.concat(imageAllow);
			var extension = value.split('.').pop().toLowerCase();
			if(value && value!='') {
				if ($.inArray(extension, allowedFiles) < 0) {
					toastr['info']("Please select valid image. (e.g. jpg, jpeg, png, mp4, ogg, webm)");
				} else {
					console.log($.inArray(extension, imageAllow));
					if ($.inArray(extension, imageAllow) >= 0) {
						if (this.files[0].size > 4194304) {
							toastr['info']("Image size must be less then 4MB");
						}else{
							var url = URL.createObjectURL(event.target.files[0]);
							var img = $('<img src="' + url + '">');
							$(model_id+' .avatar-wrapper').empty().html('<img src="' + url + '">');
							$(model_id).modal('show');
						}
					}else if($.inArray(extension, videoAllow) >= 0){
						$(f_contentbox).html('<video width="300" controls style="margin-top: 10px;">> <source src="" id="video_here">    Your browser does not support HTML5 video.</video>')

						var $source = $('#video_here');
						  $source[0].src = URL.createObjectURL(this.files[0]);
						  $source.parent()[0].load();
					}else{
						toastr['info']("Please select valid image. (e.g. jpg, jpeg, png, mp4, ogg, webm)");
					}
				}
			}else {
				event.preventDefault();
			}
		});

		$(document).on('hidden.bs.modal',model_id, function() {
			$(model_id+' .avatar-wrapper img').cropper('destroy');
			$(model_id+' .avatar-wrapper').empty();
		});

		$(document).on('shown.bs.modal',model_id, function() {
			$(model_id+' .avatar-wrapper img').cropper({
				aspectRatio: aspectRatio,
				strict: true,
				responsive : true,
				viewMode : 1,
				zoomable: true,
				zoomOnTouch:true,
				zoomOnWheel:true,
				responsive: true,
				movable: true,
				crop: function(e) {
					var json = [
						'{"x":' + e.x,
						'"y":' + e.y,
						'"height":' + e.height,
						'"width":' + e.width,
						'"rotate":' + e.rotate + '}'
					].join();
					$(model_id+' .avatar-data').val(json);
				}
			});

		});

		$(document).on('click',cropBtnName, function(evn){
			evn.preventDefault();
			var url = crop_url;

			var data =  new FormData();
			var file = $(f_id).files[0];
			data.append('avatar_src', $(model_id+' #avatar_src').val());
			data.append('avatar_data', $(model_id+' #avatar_data').val());
			data.append('width', $(f_id.parent().find('input[name="width"]')).val() );
			data.append('height', $(f_id.parent().find('input[name="height"]')).val()  );
			data.append('file',file);
			$.ajax(url, {
				type: 'post',
				data: data,
				dataType: 'json',
				processData: false,
				contentType: false,
				beforeSend: function() {
					$('.loading').fadeIn();
				},
				success: function(data) {
					if(data.state==200) {
						$(f_contentbox+' img').attr('src',data.source);
						$(f_hiddenimg).val(data.image);
						$(model_id).modal('hide');
					} else {}
				},
				complete: function() {
					$('.loading').fadeOut();
				}
			});
		});
	}
	//////cropping/////
</script>