<?php
class PromoteBusiness extends Home
{

    public $constantValue;
    public $constantName;
    public $data = array();

    public function __construct($module, $id = 0, $searchArray = array(), $type = '')
    {
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;
        $this->table      = 'tbl_promote_business';

        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
             $qry = "SELECT pb.*,s.title,u.userName 
                FROM tbl_promote_business AS pb 
                INNER JOIN tbl_users AS u ON u.id = pb.userId 
                INNER JOIN tbl_services AS s ON s.id = pb.serviceId WHERE pb.id = ?";
            $fetchRes = $this->db->pdoQuery($qry,array($this->id))->result();

            foreach ($fetchRes as $k => $v) {
                if($k != 'embedCode'){
                    $this->{$k} = filtering($v);
                }
                else{
                    $this->{$k} = $v;
                }
            }

        } else {
            $this->data['title'] = $this->title = '';
            $this->data['userName'] = $this->userName = '';
            $this->data['description'] = $this->description = '';
            $this->data['delivaryDays'] = $this->delivaryDays = '';
            $this->data['charge'] = $this->charge = '';
            $this->data['deliveryDays'] = $this->deliveryDays = '';
            $this->data['expiryDate'] = $this->expiryDate = '';
            $this->data['isActive'] = $this->isActive = '';
            $this->data['createdDate'] = $this->createdDate = '';
            $this->data['embedCode'] = $this->embedCode = '';
            $this->data['embedUrlCode'] = $this->embedUrlCode = '';
        }

        switch ($type) {
            case 'add':{
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'delete':{
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }

    }
    public function viewForm(){
        $isActive = $this->isActive == 'y' ? "Active" : "Deactive";
        $content = "";
        $content .= $this->displayBox(array("label" => "Service Name&nbsp;:", "value" => $this->title));
        $content .= $this->displayBox(array("label" => "Username&nbsp;:", "value" => $this->userName));
        $content .= $this->displayBox(array("label" => "Description&nbsp;:", "value" => $this->description));
        $content .= $this->displayBox(array("label" => "Charge&nbsp;:", "value" =>DEFAULT_CURRENCY_SIGN.$this->charge));
        $content .= $this->displayBox(array("label" => "Expiry Date&nbsp;:", "value" => convertDate($this->expiryDate)));
        $content .= $this->displayBox(array("label" => "Est. Delivery Days&nbsp;:", "value" => $this->deliveryDays.' Day(s)'));
        $content .= $this->displayBox(array("label" => "Embed Code&nbsp;:", "value" => $this->embedCode));
        $content .= $this->displayBox(array("label" => "Created Date&nbsp;:", "value" => convertDate($this->createdDate,true)));
        $content .= $this->displayBox(array("label" => "Status&nbsp;:", "value" => $isActive));
        return $content;
    }
    public function getForm(){
    	$reply_html = $content = '';

        $html = null;

        return sanitize_output($content);

    }

    public function dataGrid(){
        $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);
        $langId  = isset($langId) ? $langId : 1;
        $sWhere = ' WHERE 1 ';
        $aWhere = array();
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (s.title LIKE ? OR  u.userName LIKE ? )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }
        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'r.id DESC';

        $qry = "SELECT pb.*,s.title,u.userName FROM tbl_promote_business AS pb INNER JOIN tbl_users AS u ON u.id = pb.userId INNER JOIN tbl_services AS s ON s.id = pb.serviceId $sWhere ";

        $totalRow = $this->db->pdoQuery($qry, $aWhere)->affectedRows();

        $qrySel = $this->db->pdoQuery($qry." ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes){
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";
            $id     = $fetchRes['id'];

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status)) : '';

            $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "","extraAtt"=>"data-modalclass='modal-lg'", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';


            $final_array = array(
                $id,
                stripslashes($fetchRes["title"]),
                stripslashes($fetchRes["userName"]),
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }

            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;

    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function toggel_switch($text)
    {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text)
    {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent()
    {
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $main_content->getForm    = $this->getForm();

        $final_result = $main_content->parse();
        return $final_result;
    }
}
