<?php
class ManageRequest extends Home
{

    public $constantValue;
    public $constantName;
    public $data = array();

    public function __construct($module, $id = 0, $searchArray = array(), $type = '')
    {
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;
        $this->table      = 'tbl_request';

        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;
        parent::__construct();
        if ($this->id > 0) {
             $qry = "SELECT r.*,u.userName,c.cateName_1 AS catName,s.subCategoryName_1 AS subCatName FROM tbl_request AS r
                INNER JOIN tbl_users AS u
                    ON u.id = r.userId
                INNER JOIN tbl_categories AS c
                    ON c.id = r.catId
                INNER JOIN tbl_subcategories AS s
                    ON s.id = r.subCatId
                WHERE r.id = ?";
            $fetchRes = $this->db->pdoQuery($qry,array($this->id))->result();

            /*pri($fetchRes);*/

            foreach ($fetchRes as $k => $v) {
                $this->{$k} = filtering($v);
            }

        } else {
            $this->data['userName'] = $this->userName = '';
            $this->data['description'] = $this->description = '';
            $this->data['budget'] = $this->budget = '';
            $this->data['catName'] = $this->catName = '';
            $this->data['subCatName'] = $this->subCatName = '';
            $this->data['requStatus'] = $this->requStatus = 'p';
            $this->data['catName'] = $this->catName = '';
            $this->data['catName'] = $this->catName = '';
            $this->data['isActive'] = $this->isActive = 'y';
            $this->data['createdDate'] = $this->createdDate = '';
        }

        switch ($type) {
            case 'add':{
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'edit':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'delete':{
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }

    }
    public function viewForm(){
        $isActive = $this->isActive == 'y' ? "Active" : "Deactive";
        $requStatus = ($this->requStatus == 'p' ? "Pending" :($this->requStatus == 'a' ? "Accepted" : "Unapproved"));

        $url = "";

        $durationType = $this->durationType == 'h' ? " Hours" : " Days";

        $estDelivery = $this->duration .$durationType;
        $content = "";

        $content .= $this->displayBox(array("label" => "Username&nbsp;:", "value" => $this->userName));
        $content .= $this->displayBox(array("label" => "Description&nbsp;:", "value" => $this->description));
         if(is_file(DIR_UPD.'request/'.$this->id.'/'.$this->requestDoc)){

            $url = '<a href="'.SITE_UPD.'request/'.$this->id.'/'.$this->requestDoc.'" target="_blank"><i class="fa fa-paperclip" aria-hidden="true"></i> Attach File </a>';

            $content .= $this->displayBox(array("label" => "Attach File&nbsp;:", "value" => $url));
        }
        $content .= $this->displayBox(array("label" => "Category&nbsp;:", "value" => $this->catName));
        $content .= $this->displayBox(array("label" => "Sub Category&nbsp;:", "value" => ($this->subCatName)));
        $content .= $this->displayBox(array("label" => "Est. Delivery of Service&nbsp;:", "value" => $estDelivery));
        $content .= $this->displayBox(array("label" => "Budget&nbsp;:", "value" => CURRENCY_SIGN.$this->budget));
        $content .= $this->displayBox(array("label" => "Request Status&nbsp;:", "value" => $requStatus));

        $content .= $this->displayBox(array("label" => "Created Date&nbsp;:", "value" => convertDate($this->createdDate,true)));
        $content .= $this->displayBox(array("label" => "Status&nbsp;:", "value" => $isActive));



        return $content;
    }
    public function getForm(){
    	$reply_html = $content = '';

        $html = null;
        $reply = $this->db->pdoQuery("SELECT rep.*,u.userName FROM tbl_review_reply AS rep INNER JOIN tbl_users AS u ON u.id = rep.userId WHERE reviewId = ?",array($this->id));
        if($reply->affectedRows()>0){
            $getReply = $reply->result();
            $reply_html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textfield.tpl.php", array(
                '%label%'          => 'Username',
                '%id%'             => $getReply['id'],
                '%fieldName%'      => 'userName',
                '%fieldValue%'     => $getReply['userName']));
            $reply_html .= get_view(DIR_ADMIN_TMPL . $this->module . "/textarea.tpl.php", array(
                '%label%' => 'Reply',
                '%id%' => $getReply['id'],
                '%fieldName%' => 'reply',
                '%fieldValue%' => $getReply['reply']));

        }
        $replace = array(
            "%DESCRIPTION%" => $this->description,
            "%STATUS_A%"     => ($this->isActive == 'y' ? 'checked' : ''),
            "%STATUS_D%"     => ($this->isActive == 'n' ? 'checked' : ''),
            "%TYPE%"         => $this->type,
            "%ID%"           => $this->id,
        );

        $content = get_view(DIR_ADMIN_TMPL . $this->module . "/form-nct.tpl.php", $replace);
        return sanitize_output($content);

    }

    public function dataGrid(){
        $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);
        $langId  = isset($langId) ? $langId : 1;
        $sWhere = ' WHERE 1 ';
        $aWhere = array();
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (u.userName LIKE ?  )";
            $aWhere[] = "%$chr%";
        }
        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'r.id DESC';

        $filter = "";
        if(isset($requStatus) && $requStatus != "")
            $filter = ' AND requStatus = "'.$requStatus.'"';

        $qry = "SELECT r.*,u.userName FROM tbl_request AS r  INNER JOIN tbl_users AS u ON u.id = r.userId $filter $sWhere";

        $totalRow = $this->db->pdoQuery($qry, $aWhere)->affectedRows();

        $qrySel = $this->db->pdoQuery($qry." ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes){
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";
            $id     = $fetchRes['id'];

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module . ".php?id=" . $id . "", "check" => $status)) : '';

            $operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View')) : '';

            $operation .= (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';

            $requStatusbtn="";
            if('p'==filtering($fetchRes['requStatus']))
            {
                $requStatus = "Pending";
                $requStatusbtn.= '<span><a href="ajax.'. $this->module . '.php?action=aprrovalStatus&id='.$id.'&requStatus=a" data-action ="Accepted" class="btn default btn-xs green btn-accept approval"><i class="fa fa-check">
                    </i>&nbsp;Accept</a></span>';
                $requStatusbtn.= '&nbsp;<span> <a href="ajax.'. $this->module . '.php?action=aprrovalStatus&id='.$id.'&requStatus=u" data-action ="Unapproved" class="btn default btn-xs red btn-accept approval"><i class="fa fa-times"></i>&nbsp;Reject</a></span>';
            }
            elseif ('u'==filtering($fetchRes['requStatus'])) {
                $requStatus = "Unapproved";
                $requStatusbtn.= "Unapproved";
            }
            elseif ('a'==filtering($fetchRes['requStatus'])) {
                $requStatus = "Accepted";
                $requStatusbtn.= "Accepted";
            }
            /*echo $request;die;*/
            /*echo $requStatusbtn;die;*/
            $final_array = array(
                $id,
                stripslashes($fetchRes["userName"]),
                $requStatusbtn,
            );
            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }

            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;

    }

    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }

    public function toggel_switch($text)
    {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text)
    {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent()
    {
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module . "/" . $this->module . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $main_content->getForm    = $this->getForm();

        $final_result = $main_content->parse();
        return $final_result;
    }
}
