<?php
$reqAuth = true;
$module  = "blog-nct";
require_once "../../../includes-nct/config-nct.php";
require_once "class.blog_comments-nct.php";

$module1 = "blog_comments-nct";
$table  = "tbl_blog_comments";
chkPermission($module1);
$Permission = chkModulePermission($module1);
$styles     = array(array("data-tables/DT_bootstrap.css", SITE_ADM_PLUGIN),
    array("bootstrap-switch/css/bootstrap-switch.min.css", SITE_ADM_PLUGIN),
    array("cropper.min.css", SITE_ADM_CSS));

$scripts = array("core/datatable.js",
    array("data-tables/jquery.dataTables.js", SITE_ADM_PLUGIN),
    array("data-tables/DT_bootstrap.js", SITE_ADM_PLUGIN),
    array("bootstrap-switch/js/bootstrap-switch.min.js", SITE_ADM_PLUGIN),
    array("cropper.min.js", SITE_ADM_JS));

$metaTag = getMetaTags(array("description" => "Admin Panel",
    "keywords"                                 => 'Admin Panel',
    "author"                                   => SITE_NM));
$breadcrumb = array("Manage Blog Comments");

$id        = isset($_GET["id"]) ? (int) trim($_GET["id"]) : 0;
$blogId        = isset($_GET["blogId"]) ? (int) trim($_GET["blogId"]) : 0;

$postType  = isset($_POST["type"]) ? trim($_POST["type"]) : '';
$type      = isset($_GET["type"]) ? trim($_GET["type"]) : $postType;
$searchArray = array("blogId"=>$blogId);

$headTitle = $type == 'add' ? 'Add' : ($type == 'edit' ? 'Edit' : 'Manage ') . ' Blog Comments';
$winTitle  = $headTitle . ' - ' . SITE_NM;
if (isset($_POST["submitAddForm"]) && $_SERVER["REQUEST_METHOD"] == "POST") {
    $insArr = array();
    extract($_POST);
    $response = array();
    $response['status'] = false;

    $blogCateNameArr    = isset($blogCateName) ? $blogCateName : array();
    $descriptionArr = isset($description) ? $description : array();


    if ($type == 'edit' && $id > 0) {
        if (in_array('edit', $Permission)) {

            //get eng lang id & generate slug from that
            $engLangId = getTableValue('tbl_language', 'id', array('langCode' => 'en'));

            $insArr['isActive'] = $status;
            $insArr['blogCateName'] =  $blogCateNameArr[$engLangId];
            $insArr['slug']     = makeSlug($blogCateNameArr[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $id);


            $db->update('tbl_blog_comments', $insArr, array('id' => $id));
            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $db->update($table, array('blogCateName_' . $value["id"] => $blogCateNameArr[$value["id"]]), array("id" => $id));

            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been updated successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    } else {
        if (in_array('add', $Permission)) {
            //get eng lang id & generate slug from that
            $engLangId              = getTableValue('tbl_language', 'id', array('langCode' => 'en'));
            $insArr['isActive']     = $status;
            $insArr['createdDate']  = date('Y-m-d H:i:s');
            $insArr['blogCateName'] =  $blogCateNameArr[$engLangId];
            $insertedId             = $db->insert('tbl_blog_comments', $insArr)->getLastInsertId();


            $slug_update = makeSlug($blogCateNameArr[$engLangId], $table, $field = 'id', $whereCol = 'slug', $extra = 'url', $insertedId);
            $db->update($table, array('slug'=>$slug_update),array('id'=>$insertedId));

            //////////////
            $languages = $db->select("tbl_language", array("id", "languageName"), array("1" => '1'))->results();
            foreach ($languages as $key => $value) {
                $db->update($table, array('blogCateName_' . $value["id"] => $blogCateNameArr[$value["id"]]), array("id" => $insertedId));

            }
            //////////////
            $response['status'] = true;
            $response['success'] =  'Record has been added successfully.';
            echo json_encode($response);
            exit;

        } else {
            $response['status'] = true;
            $response['success'] = 'You are not authorised to perform this action.';
            echo json_encode($response);
            exit;
        }
    }
}
$CatObj = new BlogComments($module1,$id,$searchArray);

$pageContent = $CatObj->getPageContent();
require_once DIR_ADMIN_TMPL . "parsing-nct.tpl.php";
