<?php
class BlogComments extends Home
{

    public $constantValue;
    public $constantName;
    public $data = array();

    public function __construct($module, $id = 0, $searchArray = array(), $type = '')
    {
        global $db, $fb, $fields, $sessCataId;
        $this->db         = $db;
        $this->data['id'] = $this->id = $id;
        $this->fields     = $fields;
        $this->module     = $module;

        $this->table      = 'tbl_blog_comments';
        $this->type        = ($this->id > 0 ? 'edit' : 'add');
        $this->searchArray = $searchArray;

        parent::__construct();
        if ($this->id > 0) {
            //$fetchRes = $this->db->select('tbl_blog_comments', '*', array('id' => $this->id))->result();
            $blog = $searchArray['blog'];
            $fetchRes = $this->db->pdoQuery("SELECT bc.*,b.title_1 AS title,u.userName FROM tbl_blog_comments AS bc INNER JOIN tbl_blog AS b on b.id= bc.blogId INNER JOIN tbl_users AS u ON u.id = bc.userId WHERE bc.parentId = 0 AND bc.id = ?",array($id))->result();
            foreach ($fetchRes as $k => $v) {
                $this->{$k} = filtering($v);
            }

        } else {

            $fetchRes = $this->db->pdoQuery("SHOW COLUMNS FROM " . $this->table)->results();
            foreach ($fetchRes as $k => $v) {
                $this->{$v["Field"]} = $v["Default"];
            }
        }

        switch ($type) {
            case 'add':{
                    $this->data['content'] = (in_array('add', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'import_excel':{
                    $this->data['content'] = (in_array('import', $this->Permission)) ? $this->getImportCsvForm() : '';
                    break;
                }
            case 'edit':{
                    $this->data['content'] = (in_array('edit', $this->Permission)) ? $this->getForm() : '';
                    break;
                }
            case 'view':{
                     $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewForm() : '';
                    break;
                }
            case 'viewReply':{
                     $this->data['content'] = (in_array('view', $this->Permission)) ? $this->viewReply() : '';
                    break;
                }
            case 'delete':{
                    $this->data['content'] = (in_array('delete', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                    break;
                }
            case 'datagrid':{
                    $this->data['content'] = (in_array('module', $this->Permission)) ? json_encode($this->dataGrid()) : '';
                }
        }

    }
    public function viewForm()
    {
        $isActive = $this->isActive == 'y' ? "Active" : "Deactive";

        $content = $this->displaybox(array("label" => "Blog Name&nbsp;:", "value" => $this->title)) ;
        $content .= $this->displaybox(array("label" => "Username&nbsp;:", "value" => $this->userName)) ;
        $content .= $this->displaybox(array("label" => "Comment&nbsp;:", "value" => $this->blogComment)) ;
        $content .= $this->displaybox(array("label" => "Created Date&nbsp;:", "value" => $this->createdDate));
        $content .= $this->displaybox(array("label" => "Status&nbsp;:", "value" => $isActive));
        $content .= $this->displaybox(array("label" => "Status&nbsp;:", "value" => $isActive));
        return $content;
    }

    public function getForm(){
    }
    public function viewReply(){
        $content ="";
        $isActive = $this->isActive == 'y' ? "Active" : "Deactive";

        $fetchRes = $this->db->pdoQuery("SELECT bc.*,b.title_1 AS title,u.userName FROM tbl_blog_comments AS bc INNER JOIN tbl_blog AS b on b.id= bc.blogId INNER JOIN tbl_users AS u ON u.id = bc.userId WHERE  bc.parentId = ? ORDER BY bc.id ASC",array($this->id));
        $isActive = $this->isActive == 'y' ? "Active" : "Deactive";
        $content .= $this->displaybox(array("label" => "Username&nbsp;:", "value" => $this->userName)) ;
        $content .= $this->displaybox(array("label" => "Comment&nbsp;:", "value" => $this->blogComment)) ;
        $content .= $this->displaybox(array("label" => "Commented Date&nbsp;:", "value" => $this->createdDate)) ;
        $content .= $this->displaybox(array("label" => "Status&nbsp;:", "value" => $isActive));
        if($fetchRes->affectedRows()){
            $content .= "<hr><h3 class='text-center'>Reply List</h3>";
            $fetchRes = $fetchRes->results();
            foreach ($fetchRes as $key => $value) {
                $content .= '<hr>';
                $content .= $this->displaybox(array("label" => "Username&nbsp;:", "value" => $value['userName'])) ;
                $content .= $this->displaybox(array("label" => "Comment&nbsp;:", "value" => $value['blogComment'])) ;
                $content .= $this->displaybox(array("label" => "Commented Date&nbsp;:", "value" => $value['createdDate'])) ;
            }
        }

        return $content;

    }

    public function dataGrid()
    {
        $content = $operation = $whereCond = $whereCond1 = $totalRow = null;
        $result  = $tmp_rows  = $row_data  = array();
        extract($this->searchArray);

        $langId  = isset($langId) ? $langId : 1;
        $blog  = isset($blog) ? $blog : "";
        $sWhere = '';
        $aWhere = array();
        $chr     = isset($chr) ? str_replace(array('_', '%', "'"), array('\_', '\%', "\'"), $chr) : '';
        if (isset($chr) && $chr != '') {
            $sWhere .= " AND (bc.blogComment LIKE ? OR b.title_$langId LIKE ? OR u.userName LIKE ? )";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
            $aWhere[] = "%$chr%";
        }
        if (isset($sort))
            $sorting = $sort . ' ' . $order;
        else
            $sorting = 'id DESC';

        $qry = "SELECT bc.*,b.title_$langId AS title,u.userName FROM tbl_blog_comments AS bc INNER JOIN tbl_blog AS b on b.id= bc.blogId INNER JOIN tbl_users AS u ON u.id = bc.userId WHERE b.slug = '$blog' AND bc.parentId = 0 $sWhere";

        $totalRow = $this->db->pdoQuery( $qry, $aWhere)->affectedRows();



        $qrySel = $this->db->pdoQuery( $qry." ORDER BY $sorting limit $offset , $rows", $aWhere)->results();

        foreach ($qrySel as $fetchRes) {
            $status = ($fetchRes['isActive'] == "y") ? "checked" : "";
            $id     = $fetchRes['id'];

            $switch = (in_array('status', $this->Permission)) ? $this->toggel_switch(array("action" => "ajax." . $this->module1 . ".php?id=" . $id . "", "check" => $status)) : '';

            /*$operation = (in_array('edit', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => SITE_ADM_MOD . $this->module . "/ajax." . $this->module . ".php?action=edit&id=" . $id, "class" => "btn default btn-xs black btnEdit", "value" => '<i class="fa fa-edit"></i>&nbsp;Edit')) : '';

            $operation .= (in_array('delete', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module . ".php?action=delete&id=" . $fetchRes['id'] . "", "class" => "btn default btn-xs red btn-delete", "value" => '<i class="fa fa-trash-o"></i>&nbsp;Delete')) : '';*/

            //$operation =(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module1 . ".php?action=view&id=" . $fetchRes['id'] . "", "class" => "btn default blue btn-xs btn-viewbtn", "value" => '<i class="fa fa-laptop"></i>&nbsp;View Comment')) : '';

            $operation=(in_array('view', $this->Permission)) ? '&nbsp;&nbsp;' . $this->operation(array("href" => "ajax." . $this->module1 . ".php?action=viewReply&id=" . $fetchRes['id'] . "", "class" => "btn default green btn-xs btn-viewbtn", "value" => '<i class="fa  fa-reply"></i>&nbsp;View Reply')) : '';
            $final_array = array($id,stripslashes($fetchRes["title"]),stripcslashes($fetchRes['userName']),$fetchRes['createdDate']);

            if (in_array('status', $this->Permission)) {
                $final_array = array_merge($final_array, array($switch));
            }
            if (in_array('edit', $this->Permission) || in_array('delete', $this->Permission) || in_array('view', $this->Permission)) {
                $final_array = array_merge($final_array, array($operation));
            }

            $row_data[] = $final_array;
        }
        $result["sEcho"]                = $sEcho;
        $result["iTotalRecords"]        = (int) $totalRow;
        $result["iTotalDisplayRecords"] = (int) $totalRow;
        $result["aaData"]               = $row_data;
        return $result;

    }

    public function toggel_switch($text)
    {
        $text['action']   = isset($text['action']) ? $text['action'] : 'Enter Action Here: ';
        $text['check']    = isset($text['check']) ? $text['check'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content   = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/switch-nct.tpl.php');
        $main_content   = $main_content->parse();
        $fields         = array("%NAME%", "%CLASS%", "%ACTION%", "%EXTRA%", "%CHECK%");
        $fields_replace = array($text['name'], $text['class'], $text['action'], $text['extraAtt'], $text['check']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function operation($text)
    {

        $text['href']     = isset($text['href']) ? $text['href'] : 'Enter Link Here: ';
        $text['value']    = isset($text['value']) ? $text['value'] : '';
        $text['name']     = isset($text['name']) ? $text['name'] : '';
        $text['class']    = isset($text['class']) ? '' . trim($text['class']) : '';
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';
        $main_content     = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/operation-nct.tpl.php');
        $main_content     = $main_content->parse();
        $fields           = array("%HREF%", "%CLASS%", "%VALUE%", "%EXTRA%");
        $fields_replace   = array($text['href'], $text['class'], $text['value'], $text['extraAtt']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function displaybox($text) {

        $text['label'] = isset($text['label']) ? $text['label'] : 'Enter Text Here: ';
        $text['value'] = isset($text['value']) ? $text['value'] : '';
        $text['name'] = isset($text['name']) ? $text['name'] : '';
        $text['class'] = isset($text['class']) ? 'form-control-static ' . trim($text['class']) : 'form-control-static';
        $text['onlyField'] = isset($text['onlyField']) ? $text['onlyField'] : false;
        $text['extraAtt'] = isset($text['extraAtt']) ? $text['extraAtt'] : '';

        $main_content = new MainTemplater(DIR_ADMIN_TMPL . $this->module . '/displaybox.tpl.php');
        $main_content = $main_content->parse();
        $fields = array("%LABEL%", "%CLASS%", "%VALUE%");
        $fields_replace = array($text['label'], $text['class'], $text['value']);
        return str_replace($fields, $fields_replace, $main_content);
    }
    public function getPageContent()
    {
        $final_result             = null;
        $main_content             = new MainTemplater(DIR_ADMIN_TMPL . $this->module1 . "/" . $this->module1 . ".tpl.php");
        $main_content->breadcrumb = $this->getBreadcrumb();
        $main_content->getForm    = $this->getForm();

        $final_result = $main_content->parse();
        return $final_result;
    }
}
